/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __ruler_h__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define TYPE_RULER\
  (ruler_get_type())

#define RULER(obj)\
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RULER, Ruler))

#define RULER_CLASS(klass)\
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RULER, RulerClass))

#define IS_RULER(obj)\
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RULER))

#define IS_RULER_CLASS(klass)\
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RULER))

#define RULER_GET_CLASS(obj)\
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RULER, RulerClass))

typedef struct _Ruler	                  Ruler;
typedef struct _RulerClass              RulerClass;
typedef struct _RulerPrivate            RulerPrivate;

struct _Ruler
{
  GtkWidget                             m_widget;
  RulerPrivate*                         m_priv;
};

struct _RulerClass
{
  GtkWidgetClass                        m_parent_class;

  void (*margin_changed)(Ruler*);
};


extern GType 
ruler_get_type();

extern GtkWidget *
ruler_new(
  GtkOrientation const                  i_orientation);

extern gboolean
ruler_motion_notify(
  GtkWidget*                            i_widget,
  GdkEventMotion*                       i_event);

extern void
ruler_set_margin(
  Ruler*const                           i_ruler,
  gdouble const                         i_left_or_top,
  gdouble const                         i_right_or_bottom);

extern void
ruler_get_margin(
  Ruler*const                           i_ruler,
  gdouble*const                         o_left_or_top,
  gdouble*const                         o_right_or_bottom);

extern void
ruler_set_adjustment(
  Ruler*const                           i_ruler,
  gdouble const                         i_adjustment);

extern void
ruler_set_paper_length(
  Ruler*const                           i_ruler,
  gdouble const                         i_length);

extern void
ruler_set_scale(
  Ruler*const                           i_ruler,
  gdouble const                         i_scale);

G_END_DECLS

#define __ruler_h__
#endif 
