/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "orcl.hpp"

int main(void)
{
  struct iwsql_aspect                   l_aspect;
  struct iwsql_attr const*              l_attr;
  unsigned                              l_attr_slots;
  char*                                 l_error= 0;
  int                                   l_exit= 0;
  struct orcl*                          l_handle= 0;
  unsigned                              l_slot;
  int                                   l_eof;

  iwsql_new(&l_handle);
  
  do
  {

    memset(&l_aspect, 0, sizeof(l_aspect));
    strcpy(l_aspect.m_username, "hr");
    // strcpy(l_aspect.m_password, "oracle");
    strcpy(l_aspect.m_dbname, "//127.0.0.1:1521/orcl");

    l_exit= iwsql_connect(&l_error, &l_aspect, l_handle);

    if (l_exit)
    {
      printf("connect: %s\n", l_error);
      break;
    }

    l_exit= iwsql_exec(
      &l_error,
      "select * from employees",
      l_handle);

    if (l_exit)
    {
      printf("prepare: %s\n", l_error);
      break;
    }

    iwsql_result(&l_attr, &l_attr_slots, l_handle);

    for (l_slot= 0; l_attr_slots > l_slot; l_slot++)
    {
      printf("\"%s\",", l_attr[l_slot].m_tag);
    }

    printf("\n");


    do  
    {

      l_exit= iwsql_next(&l_error, &l_eof, l_handle);

      if (l_exit)
      {
        printf("fetch: %s\n", l_error);
        break;
      }

      if (l_eof)
      {
        break;
      }

      for (l_slot= 0; l_attr_slots > l_slot; l_slot++)
      {
        printf("\"%s\", ", l_attr[l_slot].m_value ? l_attr[l_slot].m_value : "");
      }

      printf("\n");

    }while(1);

  }while(0);

  free(l_error);

  iwsql_delete(&l_handle);

  return l_exit;
}
