/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
  CC0 1.0 Universal (CC0 1.0) Public Domain Dedication

  Deriviative works may remove this license dedication and incorporate 
  their own.
 
  GTK composite widget competon template
*/
#include "comp.h"
#include <gdk/gdk.h>

#include <string.h>

struct _CompPrivate
{
  GdkWindow*				                    m_event_window;
  GtkWidget*                            m_widget;
};

G_DEFINE_TYPE_WITH_PRIVATE(Comp, comp, GTK_TYPE_BIN)

static void
comp_realize(
  GtkWidget*                            i_widget)
{
  GtkAllocation                         l_alloc;
  GdkWindowAttr                         l_attr;
  gint                                  l_attr_mask;
  CompPrivate*                          l_priv; 
  GdkWindow*                            l_win;

  l_priv= COMP(i_widget)->m_priv;
  memset(&l_attr, 0, sizeof(l_attr));
  memset(&l_alloc, 0, sizeof(l_alloc));

  GTK_WIDGET_CLASS(comp_parent_class)->realize(i_widget);

  gtk_widget_get_allocation(i_widget, &l_alloc);

  l_attr.x= l_alloc.x;
  l_attr.y= l_alloc.y;
  l_attr.width= l_alloc.width;
  l_attr.height= l_alloc.height;
  l_attr.wclass= GDK_INPUT_ONLY;
  l_attr.window_type= GDK_WINDOW_CHILD;
  l_attr_mask= (GDK_WA_X | GDK_WA_Y);
  l_attr.event_mask= gtk_widget_get_events(i_widget);
  l_attr.event_mask|= GDK_POINTER_MOTION_MASK;

  l_win= gtk_widget_get_parent_window(i_widget),
/*
// (?)
//  gtk_widget_set_window(i_widget, l_win);
//  g_object_ref(l_win);
*/
  (*l_priv).m_event_window= gdk_window_new(l_win, &l_attr, l_attr_mask);
  gtk_widget_register_window(i_widget, (*l_priv).m_event_window);
  gtk_widget_set_realized(i_widget, TRUE);

  gtk_widget_set_parent_window((*l_priv).m_widget, (*l_priv).m_event_window);
  gtk_widget_set_has_window((*l_priv).m_widget, TRUE);

  return;
}

static void
comp_unrealize(
  GtkWidget*                            i_widget)
{
  CompPrivate*                          l_priv; 

  do
  {

    l_priv= COMP(i_widget)->m_priv;

    if (0 ==(*l_priv).m_event_window)
    {
      break;
    }

    gtk_widget_unregister_window(i_widget, (*l_priv).m_event_window);
    gdk_window_destroy((*l_priv).m_event_window);
    (*l_priv).m_event_window= 0;

  }while(0);

  GTK_WIDGET_CLASS(comp_parent_class)->unrealize(i_widget);

  return;
}

extern GtkWidget *
comp_new()
{
  GObject*                              l_object;

  l_object= g_object_new(TYPE_COMP, 0);

  return GTK_WIDGET(l_object);
}

static gboolean
comp_draw(
  GtkWidget*                            i_widget,
  cairo_t*                              io_cr)
{
  CompPrivate*                          l_priv; 
  GtkAllocation                         l_alloc;

  l_priv= COMP(i_widget)->m_priv;

  gtk_widget_get_allocation(i_widget, &l_alloc);

  cairo_set_source_rgb(io_cr, 0.0, 1.0, 0.0);
  cairo_rectangle(io_cr, 0.0, 0.0, l_alloc.width, l_alloc.height);
  cairo_fill(io_cr);

  GTK_WIDGET_CLASS(comp_parent_class)->draw(i_widget, io_cr);

  return 0;
}

static void
comp_map(
  GtkWidget*                            i_widget)
{
  CompPrivate*                          l_priv; 

  l_priv= COMP(i_widget)->m_priv;

  gtk_widget_show((*l_priv).m_widget);
  gtk_widget_map((*l_priv).m_widget);
  GTK_WIDGET_CLASS(comp_parent_class)->map(i_widget);
  gdk_window_show(l_priv->m_event_window);

  return;
}

static void
comp_unmap(
  GtkWidget*                            i_widget)
{
  CompPrivate*                          l_priv; 

  l_priv= COMP(i_widget)->m_priv;

  gdk_window_hide(l_priv->m_event_window);
  GTK_WIDGET_CLASS(comp_parent_class)->unmap(i_widget);
  gtk_widget_unmap((*l_priv).m_widget);

  return;
}

static void
comp_size_allocate(
  GtkWidget*                            i_widget,
  GtkAllocation*                        i_alloc)
{
  CompPrivate*                          l_priv; 
  int                                   l_rc;

  l_priv= COMP(i_widget)->m_priv;

  gtk_widget_set_allocation(i_widget, i_alloc);

  GtkAllocation l_alloc;
  GtkRequisition l_req;
  gtk_widget_get_preferred_size((*l_priv).m_widget, &l_req, 0);

  l_alloc.x= 0;
  l_alloc.y= 0;
  l_alloc.width= l_req.width;
  l_alloc.height= l_req.height;
  gtk_widget_size_allocate((*l_priv).m_widget, &l_alloc);

  do
  {

    l_rc= gtk_widget_get_realized(i_widget);

    if (0 ==l_rc)
    {
      break;
    }

    gdk_window_move_resize (
      (*l_priv).m_event_window,
      (*i_alloc).x, 
      (*i_alloc).y,
      (*i_alloc).width, 
      (*i_alloc).height);

  }while(0);

  return;
}

static gboolean
comp_motion_notify(
  GtkWidget*                            i_widget,
  GdkEventMotion*                       i_event)
{
  printf("%s\n", __FUNCTION__);
  return 1;
}

static void
comp_get_preferred_width(
  GtkWidget*                            i_widget,
  gint*                                 o_minimum_size,
  gint*                                 o_natural_size)
{
  CompPrivate*                          l_priv; 

  l_priv= COMP(i_widget)->m_priv;
  (*o_minimum_size) = 72 * 0.25;
  (*o_natural_size) = (*o_minimum_size);

  return;
}

static void
comp_get_preferred_height(
  GtkWidget *                           i_widget,
  gint *                                o_minimum_size,
  gint *                                o_natural_size)
{
  CompPrivate*                          l_priv; 

  l_priv= COMP(i_widget)->m_priv;
  (*o_minimum_size) = 72 * 0.25;
  (*o_natural_size) = (*o_minimum_size);

  return;
}

static void
comp_forall (GtkContainer *container,
                     gboolean      include_internals,
                     GtkCallback   callback,
                     gpointer      callback_data)
{
  CompPrivate *priv = COMP(container)->m_priv;
  (* callback) (priv->m_widget, callback_data);
  return;
}

comp_add (GtkContainer *container,
                  GtkWidget    *widget)
{
  Comp *comp = COMP (container);

  if (widget == (*comp).m_priv->m_widget)
  {
    printf("adding child widget\n");
  }
  else
  {
    printf("not supported - adding non-child widget\n");
  }

  GTK_CONTAINER_CLASS(comp_parent_class)->add(container, widget);

  gtk_widget_queue_resize (GTK_WIDGET (container));

  return;
}

static void
comp_remove (GtkContainer *container,
                     GtkWidget    *widget)
{
  Comp *comp = COMP (container);

  if (widget != (*comp).m_priv->m_widget)
    GTK_CONTAINER_CLASS (comp_parent_class)->remove (container, widget);

  return;
}

static void
comp_class_init(
  CompClass *                           i_klass)
{
  GtkContainerClass*                    l_container_class;
  GtkWidgetClass*                       l_widget_class;

  l_container_class= (GtkContainerClass *)i_klass;
  l_widget_class= GTK_WIDGET_CLASS(i_klass);

  (*l_widget_class).size_allocate= comp_size_allocate;
  (*l_widget_class).map= comp_map;
  (*l_widget_class).unmap= comp_unmap;
  (*l_widget_class).realize= comp_realize;
  (*l_widget_class).unrealize= comp_unrealize;
  (*l_widget_class).get_preferred_width= comp_get_preferred_width;
  (*l_widget_class).get_preferred_height= comp_get_preferred_height;
  (*l_widget_class).motion_notify_event= comp_motion_notify;
  (*l_widget_class).draw= comp_draw;

  (*l_container_class).forall = comp_forall;
  (*l_container_class).add= comp_add;
  (*l_container_class).remove= comp_remove;

  return;
}

static void
comp_init(
  Comp *                               io_comp)
{
  CompPrivate*                         l_priv; 
  GtkWidget*                           l_widget;

  COMP(io_comp)->m_priv= comp_get_instance_private(io_comp);
  l_priv= COMP(io_comp)->m_priv;
  memset(l_priv, 0, sizeof(*l_priv));

  gtk_widget_set_can_focus(GTK_WIDGET(io_comp), TRUE);
  gtk_widget_set_has_window(GTK_WIDGET(io_comp), FALSE);

  l_widget= gtk_button_new_with_label("Button");

  (*l_priv).m_widget= gtk_fixed_new();
  gtk_fixed_put((*l_priv).m_widget, l_widget, 10,0);
  gtk_widget_set_parent((*l_priv).m_widget, GTK_WIDGET(io_comp));

  gtk_widget_show_all((*l_priv).m_widget);

  return;
}
