/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "copybuf.h"

extern void
copybuf_assign(
  struct copybuf *const                 o_buf)
{

  memset(o_buf, 0, sizeof(*o_buf));

  return;
}

extern void
copybuf_clear(
  struct copybuf *const                 io_buf)
{

  item_clear(&(*io_buf).m_item);
  memset(io_buf, 0, sizeof(*io_buf));

  return;
}

extern void
copybuf_discharge(
  struct copybuf *const                 io_buf)
{

  copybuf_clear(io_buf);

  return;
}

extern void
copybuf_copy_item_selected(
  struct copybuf *const                 io_buf,
  struct item const*const               i_item)
{
  struct item_node *                    l_ditto;
  struct item_node const*               l_node;

  l_node= (*i_item).m_head;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    if ((*l_node).m_selected)
    {
      item_node_new(&l_ditto, &(*io_buf).m_item, (*l_node).m_type);
      (*(*l_ditto).m_method.m_copy)(&(*l_ditto).m_object, &(*l_node).m_object);
    }

    l_node= (*l_node).m_next;
  
  }while(1);

  return;
}

extern void
copybuf_cut_item_selected(
  struct copybuf *const                 io_buf,
  struct item *const                    io_item)
{

  copybuf_copy_item_selected(io_buf, io_item);
  item_selected_remove(io_item);

  return;
}

extern void
copybuf_paste_item_selected(
  struct item *const                    io_item,
  struct copybuf const*const            i_buf)
{
  struct item_node *                    l_ditto;
  struct item_node const*               l_node;

  item_deselect_all(io_item);
  l_node= (*i_buf).m_item.m_head;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    item_node_new(&l_ditto, io_item, (*l_node).m_type);
    (*(*l_ditto).m_method.m_copy)(&(*l_ditto).m_object, &(*l_node).m_object);
    (*l_ditto).m_selected= 1;

    l_node= (*l_node).m_next;
  
  }while(1);

  return;
}
