/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __error_h__

#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#include <stdio.h>
#include <string.h>

enum error_domain
{
  GENERAL                               = 1,    
  GLOBAL                                = 100,
  DRIVER_CONFIG                         = 1000,
  IWSQL_DLL                             = 2000,
  DATABASE_SESSION                      = 3000,
  QUERY_EXEC                            = 4000,
  QUERY                                 = 5000,
  REPORT                                = 6000,
  RW                                    = 7000,
  CSV                                   = 8000,
  REPORT_UTIL                           = 9000,
  LAYOUT                                = 10000,
  DATABASE_ASPECT                       = 11000,
  ITEM                                  = 12000,
  LAYOUT_SPEC                           = 13000,
  LABEL_SPEC                            = 14000,
  EXPORT_SPEC                           = 15000
};

enum error_code
{
  GENERIC                               = -1,
  NONE                                  = 0,
  GLOBAL_DATABASE_CONFIG_NOTFOUND       = GLOBAL|1,
  GLOBAL_DRIVER_CONFIG_NOTFOUND         = GLOBAL|2,
  GLOBAL_GLADE_NOTFOUND                 = GLOBAL|3,
  GLOBAL_XML_INVALID                    = GLOBAL|4,
  DRIVER_CONFIG_NOTFOUND                = DRIVER_CONFIG|1,
  DRIVER_CONFIG_EMPTY                   = DRIVER_CONFIG|2,
  IWSQL_DLL_OPEN                        = IWSQL_DLL|1,
  IWSQL_DLL_LOAD                        = IWSQL_DLL|2,
  IWSQL_DLL_CONNECT                     = IWSQL_DLL|3,
  IWSQL_DLL_EXEC                        = IWSQL_DLL|4,
  IWSQL_DLL_FETCH                       = IWSQL_DLL|5,
  DATABASE_SESSION_FILE_OPEN            = DATABASE_SESSION|1, 
  DATABASE_SESSION_DRIVER_NAME          = DATABASE_SESSION|2,
  DATABASE_SESSION_TABLE_NAME           = DATABASE_SESSION|3,
  DATABASE_SESSION_MODULE               = DATABASE_SESSION|4,
  QUERY_XML_UNKNOWN_ELEMENT             = QUERY|1,
  QUERY_XML_TOO_MANY_STATEMENTS         = QUERY|2,
  QUERY_XML_MISSING_ATTRIBUTE           = QUERY|3,
  QUERY_XML_DUPLICATE                   = QUERY|4,
  QUERY_XML_MISSING_PRIMARY             = QUERY|5,
  REPORT_XML_NOT_IWRITE                 = REPORT|1,
  REPORT_FILE_CREATE                    = REPORT|2,
  REPORT_XML_STYLE_INVALID              = REPORT|3,
  RW_CREATE_SURFACE                     = RW|1,
  CSV_CREATE_FILE                       = CSV|1,
  REPORT_UTIL_FILE_OPEN                 = REPORT_UTIL|1,
  REPORT_UTIL_FILE_INVALID              = REPORT_UTIL|2,
  REPORT_UTIL_LAYOUT_INVALID            = REPORT_UTIL|3,
  DATABASE_APSECT_XML_MISSING_TAG       = DATABASE_ASPECT|1,
  ITEM_XML_MISSING_ATTRIBUTE            = ITEM|1,
  ITEM_XML_UNKNOWN_ITEM                 = ITEM|2,
  LAYOUT_SPEC_XML_UNKNOWN_ELEMENT       = LAYOUT|1,
  LAYOUT_SPEC_XML_UNKNOWN_ATTRIBUTE     = LAYOUT|2,
  LAYOUT_SPEC_XML_MISSING_ATTRIBUTE     = LAYOUT|3,
  LAYOUT_SPEC_XML_DUPLICATE_ASPECT      = LAYOUT|4,
  LAYOUT_SPEC_XML_DUPLICATE_QUERY       = LAYOUT|5,
  LAYOUT_SPEC_XML_DUPLICATE_PAPER       = LAYOUT|6,
  LAYOUT_SPEC_XML_DUPLICATE_DIVISION    = LAYOUT|7,
  LAYOUT_SPEC_XML_DUPLICATE_SECTION     = LAYOUT|8,
  LAYOUT_SPEC_XML_DUPLICATE_GROUP       = LAYOUT|9,
  LABEL_SPEC_XML_DUPLICATE_ASPECT       = LABEL_SPEC|1,
  LABEL_SPEC_XML_DUPLICATE_QUERY        = LABEL_SPEC|2,
  LABEL_SPEC_XML_DUPLICATE_PAPER        = LABEL_SPEC|3,
  LABEL_SPEC_XML_DUPLICATE_SECTION      = LABEL_SPEC|4,
  EXPORT_SPEC_XML_UNKNOWN_ELEMENT       = EXPORT_SPEC|1,
  EXPORT_SPEC_XML_DUPLICATE_ASPECT      = EXPORT_SPEC|2,
  EXPORT_SPEC_XML_DUPLICATE_QUERY       = EXPORT_SPEC|3,
  EXPORT_SPEC_XML_DUPLICATE_CONFIG      = EXPORT_SPEC|4,
  EXPORT_SPEC_XML_DUPLICATE_TAGS        = EXPORT_SPEC|5
};

extern void _error_log(GError*);

#define _error_log(e) fprintf(stderr, "%s.%d: [%d.%d]; %s\n",\
    __func__, __LINE__, (e)->domain, (e)->code, (e)->message)

extern void
_error_display_prompt(
  GError const*const                    i_error);

#define __error_h__
#endif
