/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_common.h"

extern int
item_common_event_inside(
  struct item_in_event const*const      i_ctx,
  double const                          i_pos_x,
  double const                          i_pos_y,
  double const                          i_len_x,
  double const                          i_len_y)
{
  int                                   l_hit;
  double                                l_pos_x;
  double                                l_pos_y;
  double                                l_len_x;
  double                                l_len_y;
  double                                l_pos_x1;
  double                                l_pos_x2;
  double                                l_pos_y1;
  double                                l_pos_y2;

  if (0.0 > i_len_x)
  {
    l_pos_x= i_pos_x + i_len_x;
    l_len_x= -1.0 * i_len_x;
  }
  else
  {
    l_pos_x= i_pos_x;
    l_len_x= i_len_x;
  }

  if (0.0 > i_len_y)
  {
    l_pos_y= i_pos_y + i_len_y;
    l_len_y= -1.0 * i_len_y; 
  }
  else
  {
    l_pos_y= i_pos_y;
    l_len_y= i_len_y;
  }

  l_pos_x1= (*i_ctx).m_scale * l_pos_x;
  l_pos_y1= (*i_ctx).m_scale * l_pos_y;
  l_pos_x2= (*i_ctx).m_scale * (l_pos_x + l_len_x);
  l_pos_y2= (*i_ctx).m_scale * (l_pos_y + l_len_y);

  l_hit= ((*i_ctx).m_event.m_pos_x >= l_pos_x1 && 
    (*i_ctx).m_event.m_pos_x <= l_pos_x2 && 
    (*i_ctx).m_event.m_pos_y >= l_pos_y1 && 
    (*i_ctx).m_event.m_pos_y <= l_pos_y2); 

  return l_hit;
}

extern void
item_common_cairo_dash_set(
  cairo_t *const                        io_cr,
  enum line_style_type const            i_style)
{
  double                                l_dash[1]= {4.0};
  double                                l_dot[1]= {2.0};
  double                                l_dash_dot[3]= {4.0, 2.0, 2.0};

  do
  {

    cairo_set_line_cap(io_cr, CAIRO_LINE_CAP_BUTT);
    cairo_set_line_join(io_cr, CAIRO_LINE_JOIN_MITER);

    switch(i_style)
    {
      case line_style_solid:
        cairo_set_dash(io_cr, 0, 0, 0);
        break;
      case line_style_dash:
        cairo_set_dash(io_cr, l_dash, G_N_ELEMENTS(l_dash), 0);
        break;
      case line_style_dot:
        cairo_set_dash(io_cr, l_dot, G_N_ELEMENTS(l_dot), 0);
        break;
      case line_style_dash_dot:
        cairo_set_dash(io_cr, l_dash_dot, G_N_ELEMENTS(l_dash_dot), 0);
        break;
      default:
        break;
    }

  }while(0);

  return;
}
