/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_common_box_h__

#include "item_common_base.h"

extern void
item_common_box_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  struct geom_rect const*const          i_box,
  struct item_transform const*const     i_transform,
  double const                          i_scale);

extern void
item_common_box_normalize(
  struct geom_rect *const               io_box);

extern void
item_common_box_resize(
  struct geom_rect *const               io_box,
  struct item_resize_event const*const  i_ctx,
  struct item_transform const*const     i_transform);

extern void
item_common_box_draw_grips(
  cairo_t *const                        io_cr,
  struct geom_rect const*const          i_box);

extern void
item_common_box_draw_hightlight(
  cairo_t *const                        io_cr,
  struct geom_rect const*const          i_box,
  double const                          i_width);

extern int
item_common_box_in_event(
  cairo_t*                              io_cr,
  struct geom_rect const*const          i_box,
  struct item_transform const*const     i_transform,
  struct item_in_event const*const      i_ctx);

extern int
item_common_box_in_event_grips(
  enum event_type*const                 o_type,
  struct item_in_event const*const      i_ctx,
  struct geom_rect const*const          i_box);

extern void
item_common_box_move(
  struct geom_rect*const                io_box,
  struct geom_point const*const         i_event);

extern int
item_common_box_read(
  GError**                              o_error,
  struct geom_rect*const                io_box,
  struct xml *const                     i_xml);

extern int
item_common_box_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct geom_rect const*const          i_box);

#define __item_common_box_h__
#endif
