/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_common_circle.h"

extern void
item_common_circle_resize(
  struct geom_ellipse *const            io_circle,
  struct item_resize_event const*const  i_ctx,
  int const                             i_ellipse)
{
  double                                l_adj_x;
  double                                l_adj_y;

  l_adj_x= ((*i_ctx).m_delta_x / 2.0);
  l_adj_y= ((*i_ctx).m_delta_y / 2.0);

  switch((*i_ctx).m_type)
  {
  case event_resize_east:
    (*io_circle).m_len_x+= (*i_ctx).m_delta_x;
    (*io_circle).m_center_x+= l_adj_x;
    if (0 == i_ellipse)
    {
      (*io_circle).m_len_y+= (*i_ctx).m_delta_x;
      (*io_circle).m_center_y+= l_adj_x;
    }
    break;
  case event_resize_north:
    (*io_circle).m_len_y-= (*i_ctx).m_delta_y;
    (*io_circle).m_center_y+= l_adj_y;
    if (0 == i_ellipse)
    {
      (*io_circle).m_len_x-= (*i_ctx).m_delta_y;
      (*io_circle).m_center_x+= l_adj_y;
    }
    break;
  case event_resize_south:
    (*io_circle).m_len_y+= (*i_ctx).m_delta_y;
    (*io_circle).m_center_y+= l_adj_y;
    if (0 == i_ellipse)
    {
      (*io_circle).m_len_x+= (*i_ctx).m_delta_y;
      (*io_circle).m_center_x-= l_adj_y;
    }
    break;
  case event_resize_west:
    (*io_circle).m_len_x-= (*i_ctx).m_delta_x;
    (*io_circle).m_center_x+= l_adj_x;
    if (0 == i_ellipse)
    {
      (*io_circle).m_len_y-= (*i_ctx).m_delta_x;
      (*io_circle).m_center_y+= l_adj_x;
    }
    break;
  default:
    break;
  }

  return;
}

/* _mjo deprecated; see item_selection_draw_grips */
extern void
item_common_circle_draw_grips(
  cairo_t *const                        io_cr,
  struct geom_ellipse const*const       i_circle)
{
  double                                l_radius_x;
  double                                l_radius_y;

  l_radius_x= ((*i_circle).m_len_x / 2);
  l_radius_y= ((*i_circle).m_len_y / 2);

  item_common_cairo_dash_set(io_cr, line_style_solid);
  cairo_set_line_width(io_cr, 1.0);
  cairo_set_source_rgb(io_cr, 0.0, 1.0, 0.0);

  /* top middle */
  cairo_rectangle(
    io_cr,
    (*i_circle).m_center_x - 4.0,
    (*i_circle).m_center_y - l_radius_y - 4.0,
    8.0,
    8.0);

  cairo_fill(io_cr);

  cairo_rectangle(
    io_cr,
    (*i_circle).m_center_x + l_radius_x - 4.0,
    (*i_circle).m_center_y - 4.0,
    8.0,
    8.0);

  cairo_fill(io_cr);

  cairo_rectangle(
    io_cr,
    (*i_circle).m_center_x - 4.0,
    (*i_circle).m_center_y + l_radius_y - 4.0,
    8.0,
    8.0);

  cairo_fill(io_cr);

  cairo_rectangle(
    io_cr,
    (*i_circle).m_center_x - l_radius_x - 4.0,
    (*i_circle).m_center_y - 4.0,
    8.0,
    8.0);

  cairo_fill(io_cr);

  return;
}

/* _mjo deprecated - object should draw their own hightlight */
extern void
item_common_circle_draw_hightlight(
  cairo_t *const                        io_cr,
  struct geom_ellipse const*const       i_circle,
  double const                          i_width)
{
  return;
}

extern int
item_common_circle_in_event(
  struct item_in_event const*const      i_ctx,
  cairo_t*                              io_cr,
  struct geom_ellipse const*const       i_circle)
{
  struct geom_ellipse                   l_ellipse;
  int                                   l_hit;

  l_hit= 0;

  do
  {

    l_ellipse.m_center_x= (*i_ctx).m_scale * (*i_circle).m_center_x;
    l_ellipse.m_center_y= (*i_ctx).m_scale * (*i_circle).m_center_y;
    l_ellipse.m_len_x= (*i_ctx).m_scale * (*i_circle).m_len_x;
    l_ellipse.m_len_y= (*i_ctx).m_scale * (*i_circle).m_len_y;

    l_hit= geom_ellipse_contains_point(
      &l_ellipse,
      (*i_ctx).m_event.m_pos_x,
      (*i_ctx).m_event.m_pos_y);

  }while(0);

  return l_hit;
}

extern void
item_common_circle_move(
  struct geom_ellipse*const             io_circle,
  struct geom_point const*const         i_event)
{

  (*io_circle).m_center_x+= (*i_event).m_pos_x;
  (*io_circle).m_center_y+= (*i_event).m_pos_y;

  return;
}
