/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_date_h__

#include "item_common.h"
#include "item_method.h"

struct item_date
{
  struct geom_rect                      m_box;
  struct item_transform                 m_transform;
  PangoFontDescription*                 m_font; 
  GdkRGBA                               m_color;
  struct item_border               m_border;
  struct item_fill                      m_fill;
  enum date_style_type                  m_date_style;
  enum date_style_type                  m_time_style;
  gchar*                                m_locale;
  gchar*                                m_timezone;  
  time_t                                m_time;
};

extern void
item_date_assign(
  struct item_date*const                o_date,
  struct item_method*const              o_method);

extern void
item_date_copy(
  struct item_date *const               o_date,
  struct item_date const*const          i_date);

extern void
item_date_discharge(
  struct item_date*const                io_date);

extern void
item_date_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  struct item_date const*const          i_date);

extern void
item_date_get_position(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  struct item_date const*const          i_date);

extern void
item_date_get_rotation(
  double*const                          o_rotation,
  struct item_date const*const          i_date);

extern void
item_date_get_size(
  double*const                          o_len_x,
  double*const                          o_len_y,
  struct item_date const*const          i_date);

extern void
item_date_get_shear(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  struct item_date const*const          i_date);

extern int
item_date_in_event(
  struct item_date const*const          i_date,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx);

extern void
item_date_draw(
  struct item_date*const                io_date,
  struct item_draw_context const*const  i_ctx);

extern void
item_date_move(
  struct item_date*const                io_date,
  struct geom_point const*const         i_event);

extern void
item_date_normalize(
  struct item_date*const                io_date);

extern void
item_date_set_position(
  struct item_date*const                io_date,
  double const                          i_pos_x,
  double const                          i_pos_y);

extern void
item_date_set_rotation(
  struct item_date*const                io_date,
  double                                i_rotation);

extern void
item_date_set_size(
  struct item_date*const                io_date,
  double                                i_len_x,
  double                                i_len_y);

extern void
item_date_set_shear(
  struct item_date*const                io_date,
  double const                          i_shear_x,
  double const                          i_shear_y);

extern int
item_date_property(
  struct item_date*const                io_date);

extern int
item_date_read(
  GError**                              o_error,
  struct item_date*const                io_date,
  struct xml *const                     i_element);

extern void
item_date_resize(
  struct item_date*const                io_date,
  struct item_resize_event const*const  i_ctx);

extern void
item_date_rotate(
  struct item_date*const                io_date,
  double const                          i_rotation);
  
extern void
item_date_shear(
  struct item_date*const                io_date,
  double const                          i_delta_x,
  double const                          i_delta_y);

extern int
item_date_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_date const*const          io_date);

#define __item_date_h__
#endif
