/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fsum.h"
#include "item_property.h"

struct sum_dialog
{
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_border_style_comboboxtext;
  GtkSpinButton*                        m_border_thickness_spinbutton;
  GtkEntry*                             m_border_color_entry;
  GtkButton*                            m_border_color_button;
  GtkCheckButton*                       m_fill_color_checkbutton;
  GtkEntry*                             m_fill_color_entry;
  GtkButton*                            m_fill_color_button; 
  GtkComboBoxText*                      m_type_comboboxtext;
  GtkEntry*                             m_pattern_entry;
  GtkEntry*                             m_locale_entry;
  GtkComboBoxText*                      m_group_comboboxtext;
  struct item_table_dialog              m_table;
};

static void
item_fsum_bind(
  struct sum_dialog*const               o_dlg,
  GtkBuilder*const                      i_builder)
{

  memset(o_dlg, 0, sizeof(*o_dlg));

  do
  {

    (*o_dlg).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_dlg).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_dlg).m_color_button,
      "clicked",
      G_CALLBACK(item_property_border_color_button_cb),
      (*o_dlg).m_color_entry);

    (*o_dlg).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_dlg).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_dlg).m_font_button,
      "clicked",
      G_CALLBACK(item_property_font_button_cb),
      (*o_dlg).m_font_entry);

    (*o_dlg).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_dlg).m_border_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "border_style_comboboxtext"));

    (*o_dlg).m_border_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "border_thickness_spinbutton"));

    (*o_dlg).m_border_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "border_color_entry"));

    (*o_dlg).m_border_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "border_color_button"));

    g_signal_connect(
      (*o_dlg).m_border_color_button,
      "clicked",
      G_CALLBACK(item_property_border_color_button_cb),
      (*o_dlg).m_border_color_entry);

    (*o_dlg).m_fill_color_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_checkbutton"));

    (*o_dlg).m_fill_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_button"));

    (*o_dlg).m_fill_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "fill_color_entry"));

    g_signal_connect(
      (*o_dlg).m_fill_color_button,
      "clicked",
      G_CALLBACK(item_property_fill_color_button_cb),
      (*o_dlg).m_fill_color_entry);

    (*o_dlg).m_type_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "type_comboboxtext"));

    (*o_dlg).m_pattern_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "pattern_entry"));

    (*o_dlg).m_locale_entry=                       
      GTK_ENTRY(gtk_builder_get_object(i_builder, "locale_entry"));

    (*o_dlg).m_group_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "group_comboboxtext"));

    item_property_load_group((*o_dlg).m_group_comboboxtext);

    (*o_dlg).m_table.m_query_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "query_comboboxtext"));

    (*o_dlg).m_table.m_column_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "column_comboboxtext"));

    item_property_load_query((*o_dlg).m_table.m_query_comboboxtext);

    g_signal_connect(
      (*o_dlg).m_table.m_query_comboboxtext,
      "changed",
      G_CALLBACK(item_property_comboboxtext_cb),
      &(*o_dlg).m_table);

  }while(0);

  return;
}

static void
item_fsum_set_values(
  struct sum_dialog*const               i_dlg,
  struct item_fsum const*const           i_object)
{
  gchar*                                l_color;
  gchar*                                l_font;

  l_color= gdk_rgba_to_string(&(*i_object).m_color);
  gtk_entry_set_text((*i_dlg).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_object).m_font);
  gtk_entry_set_text((*i_dlg).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_dlg).m_border_checkbutton),
    (*i_object).m_border.m_active);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_dlg).m_border_style_comboboxtext), 
      (*i_object).m_border.m_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_dlg).m_border_thickness_spinbutton),
    (*i_object).m_border.m_thickness);

  l_color= gdk_rgba_to_string(&(*i_object).m_border.m_color);
  gtk_entry_set_text((*i_dlg).m_border_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_dlg).m_fill_color_checkbutton),
    (*i_object).m_fill.m_active);

  l_color= gdk_rgba_to_string(&(*i_object).m_fill.m_color);
  gtk_entry_set_text((*i_dlg).m_fill_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_dlg).m_type_comboboxtext),
      (*i_object).m_type);

  if ((*i_object).m_pattern)
  {
    gtk_entry_set_text((*i_dlg).m_pattern_entry, (*i_object).m_pattern);
  }

  if ((*i_object).m_locale)
  {
    gtk_entry_set_text((*i_dlg).m_locale_entry, (*i_object).m_locale);
  }

  item_property_group_set_active(
    (*i_dlg).m_group_comboboxtext,
    (*i_object).m_group);

  item_property_database_set_active(
    (*i_dlg).m_table.m_query_comboboxtext,
    (*i_dlg).m_table.m_column_comboboxtext,
    &(*i_object).m_table);

  return;
}

static void
item_fsum_copy_values(
  struct item_fsum *const               io_object,
  struct sum_dialog const*const         i_dlg)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_color_entry));
  gdk_rgba_parse(&(*io_object).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_font_entry));
  if ((*io_object).m_font)
  {
    pango_font_description_free((*io_object).m_font);
  }
  (*io_object).m_font= pango_font_description_from_string(l_text);

  (*io_object).m_border.m_active=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_dlg).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_dlg).m_border_style_comboboxtext));

  if ((0 <= l_rc) && (line_style_last > l_rc))
  {
    (*io_object).m_border.m_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_object).m_border.m_style= line_style_solid;
  }

  (*io_object).m_border.m_thickness= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_dlg).m_border_thickness_spinbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_border_color_entry));
  gdk_rgba_parse(&(*io_object).m_border.m_color, l_text);

  (*io_object).m_fill.m_active=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_dlg).m_fill_color_checkbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_fill_color_entry));
  gdk_rgba_parse(&(*io_object).m_fill.m_color, l_text);

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_dlg).m_type_comboboxtext));

  switch((enum number_type)l_rc)
  {
    case number_integer:
      (*io_object).m_type= number_integer;
      break;
    case number_monetary:
      (*io_object).m_type= number_monetary;
      break;
    default:
      (*io_object).m_type= number_float;
      break;
  }

  if ((*io_object).m_pattern)
  {
    g_free((*io_object).m_pattern);
  }

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_pattern_entry));
  (*io_object).m_pattern= g_strdup(l_text);

  if ((*io_object).m_locale)
  {
    g_free((*io_object).m_locale);
  }

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_locale_entry));
  (*io_object).m_locale= g_strdup(l_text);

  g_free((*io_object).m_group);
  (*io_object).m_group= 
    gtk_combo_box_text_get_active_text((*i_dlg).m_group_comboboxtext);

  g_free((*io_object).m_table.m_query);
  (*io_object).m_table.m_query= 
    gtk_combo_box_text_get_active_text((*i_dlg).m_table.m_query_comboboxtext);

  g_free((*io_object).m_table.m_column);
  (*io_object).m_table.m_column= 
    gtk_combo_box_text_get_active_text((*i_dlg).m_table.m_column_comboboxtext);

  return;
}

extern int
item_fsum_property(
  struct item_fsum*const                io_object)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  struct sum_dialog                     l_dlg;
  GError*                               l_error;
  int                                   l_exit;
  GtkGrid*                              l_grid;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "fsum.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "fsum_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'sum_grid'");
      l_exit= -1;
      break;
    }

    item_fsum_bind(&l_dlg, l_builder);

    item_fsum_set_values(&l_dlg, io_object);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Sum Edit",
      get_main_window(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_fsum_copy_values(io_object, &l_dlg);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

