/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mainw.h"
#include "handles.h"
#include "option.h"
#include "goop.h"
#include "report_util.h"
#include "layout_spec.h"
#ifndef WIN32
#include <X11/Xlib.h>
#endif

struct mainw*                           g_mainw= 0;

static int
main_run_gui(
  int                                   i_argc, 
  char *                                i_argv[],
  struct option const*                  i_option)
{
  static struct mainw                   l_mainw;
  GError*                               l_error;
  int                                   l_exit;

  l_error= 0;
  l_exit= 0;
  mainw_assign(&l_mainw);
  g_mainw= &l_mainw;

  do
  {

    if ((*i_option).m_outputfile)
    {
      fprintf(stderr, "Ignoring outputfile option\n");
    }

    l_exit= global_common_create_for_gui(&l_error, i_argc, i_argv);

    if (l_exit)
    {
      break;
    }

    l_exit= mainw_create(&l_mainw);

    if ((*i_option).m_reportfile)
    {
      mainw_open(&l_mainw, (*i_option).m_reportfile);
    }

    if ((*i_option).m_password)
    {
      l_mainw.m_report.m_aspect.m_password= g_strdup((*i_option).m_password);
    }

    gtk_main();

  }while(0);

  g_clear_error(&l_error);
  global_common_destroy();
  mainw_discharge(&l_mainw);

  return l_exit;
}

static int
main_run_report(
  int                                   i_argc, 
  char *                                i_argv[],
  struct option const*                  i_option)
{
  GError*                               l_error;
  int                                   l_exit;
  struct goop                           l_goop;

  l_error= 0;
  l_exit= 0;
  memset(&l_goop, 0, sizeof(l_goop));

  do
  {

    if (0 == (*i_option).m_reportfile)
    {
      fprintf(stderr, "Option 'report' not specified\n");
      l_exit= -1;
      break;
    }

    l_exit= global_common_create_for_console(&l_error, i_argc, i_argv);

    if (l_exit)
    {
      break;
    }

    l_goop.m_outputfile= (*i_option).m_outputfile;
    l_goop.m_prompt= (*i_option).m_prompt;

    l_exit= report_util_run(
      &l_error,
      (*i_option).m_reportfile,
      (*i_option).m_password,
      &l_goop);

  }while(0);

  g_clear_error(&l_error);

  return l_exit;
}

int 
main(
  int                                   i_argc, 
  char *                                i_argv[])
{
  int                                   l_exit;
  int                                   l_has_display;
  struct option                         l_option;

#ifdef G_OS_UNIX
  XInitThreads();
#endif

  option_assign(&l_option);

  do
  {

    l_has_display= gtk_init_check(&i_argc, &i_argv);

    l_exit= option_parse(&l_option, i_argc, i_argv);

    if (l_exit)
    {
      break;
    }

    if (l_option.m_outputfile)
    {
      l_exit= main_run_report(i_argc, i_argv, &l_option);
      break;
    }

    if (0 == l_has_display)
    {
      fprintf(stderr, "Unable to initialize GTK (display) subsystem\n");
      l_exit= -1;
      break;
    }

    handles_new();
    l_exit= main_run_gui(i_argc, i_argv, &l_option);
    handles_delete();

  }while(0);

  option_discharge(&l_option);

  return l_exit;
}
