/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __pixbuf_h__

#include "global_common.h"

struct pixbuf_attribute
{
  GdkColorspace                         m_colorspace;
  guint64                               m_channels;
  guint64                               m_has_alpha;
  guint64                               m_bits_per_sample;
  guint64                               m_width;
  guint64                               m_height;
  guint64                               m_rowstride;
  guint64                               m_byte_length;
};

extern void
pixbuf_get_attributes(
  struct pixbuf_attribute*const         o_attr,
  GdkPixbuf const*const                 i_pixbuf);

extern int
pixbuf_new_from_blob(
  GError**                              o_error,
  GdkPixbuf **                          o_pixbuf,
  void const*                           i_blob,
  size_t const                          i_size);

extern int
pixbuf_read(
  GError**                              o_error,
  GdkPixbuf **                          o_pixbuf,
  struct xml *const                     i_xml);

extern int
pixbuf_write(
  FILE*                                 io_fp,
  GdkPixbuf const*const                 i_pixbuf);

#define __pixbuf_h__
#endif
