/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __rw_h__

#include "global_common.h"
#include "database_session.h"
#include "layout_spec.h"
#include "query_exec.h"
#include "report.h"
#include "sql.h"

struct rw
{
  struct query_exec                     m_exec;
  cairo_surface_t*                      m_surface;
  cairo_t*                              m_cr;
  double                                m_pos_x;
  double                                m_pos_y;
  double                                m_fence_bottom;
  unsigned                              m_page_number;
  time_t                                m_time;
};

extern void
rw_assign(
  struct rw*                            o_rw);

extern void
rw_attr_lookup_by_name(
  struct iwsql_attr const**             o_attr,
  struct query_exec const*const         i_exec,
  char const*                           i_table,
  char const*                           i_field);

extern int
rw_cairo_pdf_surface_create(
  GError**                              o_error,
  struct rw*                            io_rw,
  double const                          i_page_width,
  double const                          i_page_height,
  char const*                           i_outputfile);

extern void
rw_discharge(
  struct rw*                            io_rw);

extern void
rw_item_set_value(
  struct item*const                     io_item,
  struct rw*const                       io_rw);

extern void
rw_layout_clear_accumulator(
  struct layout_spec*const              io_layout);

extern void
rw_level_break_set_value(
  struct layout_spec*const              io_layout,
  struct rw *const                      i_rw);

extern void
rw_layout_group_set_value(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw);

extern void
rw_layout_set_fence(
  struct rw*const                       io_rw,
  struct layout_spec*const              io_layout);

extern void
rw_item_clear_accumulator(
  struct item*const                     io_item,
  char const*                           i_group);

#define __rw_h__
#endif
