/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __sql_h__

#include "query.h"

enum sql_type
{
  sql_type_segment,
  sql_type_input,
  sql_type_parm
};

struct sql_segment
{
  char*                                 m_text;
  unsigned                              m_size;
};

struct sql_input
{
  char*                                 m_prompt;
  char*                                 m_answer;  
  GtkEntry*                             m_entry;
};

struct sql_parm
{
  char*                                 m_tag;
  char*                                 m_field;
  char*                                 m_answer;
};

struct sql_node
{
  enum sql_type                         m_type;
  union
  {
    struct sql_segment                  m_segment;
    struct sql_input                    m_input;
    struct sql_parm                     m_parm;
  }                                     m_object;
  struct sql_node*                      m_next;
  struct sql_node*                      m_prev;
};

struct sql
{
  char                                  m_tag[31+1];
  struct sql_node*                      m_head;
  struct sql_node*                      m_tail;
};

extern void
sql_assign(
  struct sql*const                      o_sql);

extern void
sql_discharge(
  struct sql*const                      io_sql);

extern void
sql_parse(
  struct sql*const                      io_sql,
  struct query_node const*const         i_node);

#define __sql_h__
#endif
