/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.Applet;
import java.awt.Container;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.swing.SwingUtilities;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.AppThreadGroup;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.ServiceUtil;
import sun.awt.SunToolkit;

public class Launcher {
    static final ThreadGroup mainGroup = new ThreadGroup(Translator.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    private boolean exitOnFailure = true;
    private ParserSettings parserSettings = new ParserSettings();
    private Map<String, String[]> extra = null;

    public Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(boolean exitOnFailure) {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
        this.exitOnFailure = exitOnFailure;
    }

    public Launcher(LaunchHandler handler) {
        this(handler, null);
    }

    public Launcher(LaunchHandler handler, UpdatePolicy policy) {
        if (policy == null) {
            policy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = handler;
        this.updatePolicy = policy;
    }

    public void setUpdatePolicy(UpdatePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(Translator.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = policy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean context) {
        this.context = context;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public void setParserSettings(ParserSettings settings) {
        this.parserSettings = settings;
    }

    public void setInformationToMerge(Map<String, String[]> input) {
        this.extra = input;
    }

    public ApplicationInstance launch(JNLPFile file) throws LaunchException {
        return this.launch(file, null);
    }

    public ApplicationInstance launch(JNLPFile file, Container cont) throws LaunchException {
        this.mergeExtraInformation(file, this.extra);
        JNLPRuntime.markNetxRunning();
        if (!file.getInformation().isOfflineAllowed()) {
            try {
                InetAddress.getByName(file.getSourceLocation().getHost());
            }
            catch (UnknownHostException ue) {
                System.err.println("File cannot be launched because offline-allowed tag not specified and system currently offline.");
                return null;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        TgThread tg = file instanceof PluginBridge && cont != null ? new TgThread(file, cont, true) : (cont == null ? new TgThread(file) : new TgThread(file, cont));
        tg.start();
        try {
            tg.join();
        }
        catch (InterruptedException ex) {
            throw this.launchWarning(new LaunchException(file, ex, Translator.R("LSMinor"), Translator.R("LCSystem"), Translator.R("LThreadInterrupted"), Translator.R("LThreadInterruptedInfo")));
        }
        if (tg.getException() != null) {
            throw tg.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tg.getApplication());
        }
        return tg.getApplication();
    }

    public ApplicationInstance launch(URL location) throws LaunchException {
        return this.launch(this.toFile(location));
    }

    public ApplicationInstance launch(URL location, boolean fromSource) throws LaunchException {
        return this.launch(this.fromUrl(location, fromSource));
    }

    private void mergeExtraInformation(JNLPFile file, Map<String, String[]> extra) throws LaunchException {
        String[] parameters;
        String[] arguments;
        if (extra == null) {
            return;
        }
        String[] properties = extra.get("properties");
        if (properties != null) {
            this.addProperties(file, properties);
        }
        if ((arguments = extra.get("arguments")) != null && file.isApplication()) {
            this.addArguments(file, arguments);
        }
        if ((parameters = extra.get("parameters")) != null && file.isApplet()) {
            this.addParameters(file, parameters);
        }
    }

    private void addProperties(JNLPFile file, String[] props) throws LaunchException {
        ResourcesDesc resources = file.getResources();
        for (int i = 0; i < props.length; ++i) {
            int equals = props[i].indexOf("=");
            if (equals == -1) {
                throw this.launchError(new LaunchException(Translator.R("BBadProp", props[i])));
            }
            String key = props[i].substring(0, equals);
            String value = props[i].substring(equals + 1, props[i].length());
            resources.addResource(new PropertyDesc(key, value));
        }
    }

    private void addParameters(JNLPFile file, String[] params) throws LaunchException {
        AppletDesc applet = file.getApplet();
        for (int i = 0; i < params.length; ++i) {
            int equals = params[i].indexOf("=");
            if (equals == -1) {
                throw this.launchError(new LaunchException(Translator.R("BBadParam", params[i])));
            }
            String name = params[i].substring(0, equals);
            String value = params[i].substring(equals + 1, params[i].length());
            applet.addParameter(name, value);
        }
    }

    private void addArguments(JNLPFile file, String[] args) {
        ApplicationDesc app = file.getApplication();
        for (int i = 0; i < args.length; ++i) {
            app.addArgument(args[i]);
        }
    }

    public void launchBackground(JNLPFile file) {
        BgRunner runner = new BgRunner(file, null);
        new Thread(runner).start();
    }

    public void launchBackground(URL location) {
        BgRunner runner = new BgRunner(null, location);
        new Thread(runner).start();
    }

    public void launchExternal(List<String> vmArgs, JNLPFile file, List<String> javawsArgs) throws LaunchException {
        LinkedList<String> updatedArgs = new LinkedList<String>(javawsArgs);
        if (file.getFileLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else if (file.getSourceLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else {
            this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNullLocation"), Translator.R("LNullLocationInfo")));
        }
        this.launchExternal(vmArgs, updatedArgs);
    }

    public void launchExternal(URL url) throws LaunchException {
        LinkedList<String> javawsArgs = new LinkedList<String>();
        javawsArgs.add(url.toString());
        this.launchExternal(new LinkedList<String>(), javawsArgs);
    }

    public void launchExternal(List<String> vmArgs, List<String> javawsArgs) throws LaunchException {
        try {
            LinkedList<String> commands = new LinkedList<String>();
            String pathToWebstartBinary = System.getProperty("icedtea-web.bin.location");
            commands.add(pathToWebstartBinary);
            for (String arg : vmArgs) {
                commands.add("-J" + arg);
            }
            commands.addAll(javawsArgs);
            String[] command = commands.toArray(new String[0]);
            Process p = Runtime.getRuntime().exec(command);
            new StreamEater(p.getErrorStream()).start();
            new StreamEater(p.getInputStream()).start();
            p.getOutputStream().close();
        }
        catch (NullPointerException ex) {
            throw this.launchError(new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNetxJarMissing"), Translator.R("LNetxJarMissingInfo")));
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(null, ex, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile fromUrl(URL location, boolean fromSource) throws LaunchException {
        try {
            JNLPFile file = null;
            file = new JNLPFile(location, this.parserSettings.isStrict());
            if (fromSource && file.getSourceLocation() != null) {
                file = new JNLPFile(file.getSourceLocation(), this.parserSettings.isStrict());
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Translator.R("LSFatal"), Translator.R("LCReadError"), Translator.R("LCantRead"), Translator.R("LCantReadInfo")));
        }
    }

    @Deprecated
    private JNLPFile toFile(URL location) throws LaunchException {
        try {
            JNLPFile file;
            block5: {
                file = null;
                try {
                    file = new JNLPFile(location, null, true, this.updatePolicy);
                }
                catch (ParseException ex) {
                    file = new JNLPFile(location, null, false, this.updatePolicy);
                    LaunchException lex = this.launchWarning(new LaunchException(file, ex, Translator.R("LSMinor"), Translator.R("LCFileFormat"), Translator.R("LNotToSpec"), Translator.R("LNotToSpecInfo")));
                    if (lex == null) break block5;
                    throw lex;
                }
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Translator.R("LSFatal"), Translator.R("LCReadError"), Translator.R("LCantRead"), Translator.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile file) throws LaunchException {
        if (!file.isApplication()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplication"), Translator.R("LNotApplicationInfo")));
        }
        try {
            JARDesc mainJarDesc;
            File f;
            try {
                ServiceUtil.checkExistingSingleInstance(file);
            }
            catch (InstanceExistsException e) {
                return null;
            }
            if (JNLPRuntime.getForksAllowed() && file.needsNewVM()) {
                LinkedList<String> netxArguments = new LinkedList<String>();
                netxArguments.add("-Xnofork");
                netxArguments.addAll(JNLPRuntime.getInitialArguments());
                this.launchExternal(file.getNewVMArgs(), netxArguments);
                return null;
            }
            this.handler.launchInitialized(file);
            ApplicationInstance app = this.createApplication(file);
            app.initialize();
            String mainName = file.getApplication().getMainClass();
            if (mainName == null && (f = CacheUtil.getCacheFile((mainJarDesc = file.getResources().getMainJAR()).getLocation(), null)) != null) {
                JarFile mainJar = new JarFile(f);
                mainName = mainJar.getManifest().getMainAttributes().getValue("Main-Class");
            }
            if (mainName == null) {
                throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo")));
            }
            Class<?> mainClass = app.getClassLoader().loadClass(mainName);
            Method main = mainClass.getMethod("main", String[].class);
            String[] args = file.getApplication().getArguments();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.setContextClassLoaderForAllThreads(app.getThreadGroup(), app.getClassLoader());
            this.handler.launchStarting(app);
            main.setAccessible(true);
            main.invoke(null, new Object[]{args});
            return app;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private void setContextClassLoaderForAllThreads(ThreadGroup tg, ClassLoader classLoader) {
        Thread[] threads;
        int threadCountGuess = tg.activeCount();
        do {
            threads = new Thread[threadCountGuess *= 2];
            tg.enumerate(threads, true);
        } while (threads[threadCountGuess - 1] != null);
        for (Thread thread : threads) {
            if (thread == null) continue;
            if (JNLPRuntime.isDebug()) {
                System.err.println("Setting " + classLoader + " as the classloader for thread " + thread.getName());
            }
            thread.setContextClassLoader(classLoader);
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            applet.getAppletEnvironment().startApplet();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance getApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile file) throws LaunchException {
        throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCNotSupported"), Translator.R("LNoInstallers"), Translator.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase) {
                loader.enableCodeBase();
            } else if (file.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class<?> appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            AppletInstance appletInstance = cont == null ? new AppletInstance(file, group, loader, applet) : new AppletInstance(file, group, loader, applet, cont);
            group.setApplication(appletInstance);
            loader.setApplication(appletInstance);
            this.setContextClassLoaderForAllThreads(appletInstance.getThreadGroup(), appletInstance.getClassLoader());
            return appletInstance;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")));
        }
    }

    protected Applet createAppletObject(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase) {
                loader.enableCodeBase();
            } else if (file.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class<?> appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            return applet;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile file) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            ApplicationInstance app = new ApplicationInstance(file, group, loader);
            group.setApplication(app);
            loader.setApplication(app);
            return app;
        }
        catch (Exception ex) {
            throw new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplication"), Translator.R("LInitApplicationInfo"));
        }
    }

    protected AppThreadGroup createThreadGroup(JNLPFile file) {
        AppThreadGroup appThreadGroup = null;
        appThreadGroup = file instanceof PluginBridge ? (AppThreadGroup)Thread.currentThread().getThreadGroup() : new AppThreadGroup(mainGroup, file.getTitle());
        return appThreadGroup;
    }

    private LaunchException launchError(LaunchException ex) {
        if (this.handler != null) {
            this.handler.launchError(ex);
        }
        return ex;
    }

    private LaunchException launchWarning(LaunchException ex) {
        if (this.handler != null && !this.handler.launchWarning(ex)) {
            return ex;
        }
        return null;
    }

    private static void doPerApplicationAppContextHacks() {
        new ParserDelegator();
    }

    private class BgRunner
    implements Runnable {
        private JNLPFile file;
        private URL location;

        BgRunner(JNLPFile file, URL location) {
            this.file = file;
            this.location = location;
        }

        @Override
        public void run() {
            try {
                if (this.file != null) {
                    Launcher.this.launch(this.file);
                }
                if (this.location != null) {
                    Launcher.this.launch(this.location);
                }
            }
            catch (LaunchException launchException) {
                // empty catch block
            }
        }
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;
        private Container cont;
        private boolean isPlugin;

        TgThread(JNLPFile file) {
            this(file, null);
        }

        TgThread(JNLPFile file, Container cont) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
        }

        TgThread(JNLPFile file, Container cont, boolean isPlugin) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
            this.isPlugin = isPlugin;
        }

        @Override
        public void run() {
            block7: {
                try {
                    if (Launcher.this.context && !this.isPlugin) {
                        SunToolkit.createNewAppContext();
                    }
                    Launcher.doPerApplicationAppContextHacks();
                    if (this.isPlugin) {
                        JNLPRuntime.setDefaultDownloadIndicator(null);
                        this.application = Launcher.this.getApplet(this.file, ((PluginBridge)this.file).codeBaseLookup(), this.cont);
                        break block7;
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block7;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true, this.cont);
                        break block7;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block7;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotLaunchable"), Translator.R("LNotLaunchableInfo")));
                }
                catch (LaunchException ex) {
                    ex.printStackTrace();
                    this.exception = ex;
                    if (!Launcher.this.exitOnFailure) break block7;
                    System.exit(1);
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

