/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.CacheViewer;
import net.sourceforge.jnlp.controlpanel.ComboItem;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;

public class TemporaryInternetFilesPanel
extends NamedBorderPanel
implements ChangeListener {
    private DeploymentConfiguration config;
    private int minSize = -1;
    private int maxSize = 1000;
    public static String[] properties = new String[]{"deployment.javapi.cache.enabled", "deployment.user.cachedir", "deployment.cache.max.size", "deployment.cache.jarcompression"};
    private JComponent defaultFocusComponent = null;
    JSpinner spCacheSize;
    JSlider slCacheSize;

    public TemporaryInternetFilesPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadTempInternetFiles"));
        this.config = config;
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    private void addComponents() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JLabel description = new JLabel("<html>" + Translator.R("CPTempInternetFilesDescription") + "<hr /></html>");
        JCheckBox enableCaching = new JCheckBox(Translator.R("TIFPEnableCache"), !Boolean.parseBoolean(this.config.getProperty(properties[0])));
        enableCaching.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TemporaryInternetFilesPanel.this.config.setProperty(properties[0], String.valueOf(e.getStateChange() != 1));
            }
        });
        NamedBorderPanel locationPanel = new NamedBorderPanel(Translator.R("TIFPLocation"), new GridBagLayout());
        JLabel locationDescription = new JLabel(Translator.R("TIFPLocationLabel") + ":");
        final JTextField location = new JTextField(this.config.getProperty(properties[1]));
        location.setEditable(false);
        JButton bLocation = new JButton(Translator.R("TIFPChange") + "...");
        bLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                if (fileChooser.showOpenDialog(null) == 0) {
                    String result = fileChooser.getSelectedFile().getAbsolutePath();
                    location.setText(result);
                    TemporaryInternetFilesPanel.this.config.setProperty(properties[1], result);
                }
            }
        });
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 0;
        locationPanel.add((Component)locationDescription, c);
        c.gridwidth = 1;
        c.gridy = 1;
        locationPanel.add((Component)location, c);
        c.gridx = 1;
        c.weightx = 0.0;
        locationPanel.add((Component)bLocation, c);
        NamedBorderPanel diskSpacePanel = new NamedBorderPanel(Translator.R("TIFPDiskSpace"), new GridBagLayout());
        JLabel lCompression = new JLabel(Translator.R("TIFPCompressionLevel"));
        ComboItem[] compressionOptions = new ComboItem[]{new ComboItem(Translator.R("TIFPNone"), "0"), new ComboItem("1", "1"), new ComboItem("2", "2"), new ComboItem("3", "3"), new ComboItem("4", "4"), new ComboItem("5", "5"), new ComboItem("6", "6"), new ComboItem("7", "7"), new ComboItem("8", "8"), new ComboItem(Translator.R("TIFPMax"), "9")};
        JComboBox<ComboItem> cbCompression = new JComboBox<ComboItem>(compressionOptions);
        cbCompression.setSelectedIndex(Integer.parseInt(this.config.getProperty(properties[3])));
        cbCompression.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TemporaryInternetFilesPanel.this.config.setProperty(properties[3], ((ComboItem)e.getItem()).getValue());
            }
        });
        JLabel lCacheSize = new JLabel(Translator.R("TIFPCacheSize") + ":");
        this.slCacheSize = new JSlider(this.minSize, this.maxSize, Integer.parseInt(this.config.getProperty(properties[2])));
        this.slCacheSize.setMinorTickSpacing(50);
        this.slCacheSize.setPaintTicks(true);
        SpinnerNumberModel snmCacheSize = new SpinnerNumberModel(Integer.parseInt(this.config.getProperty(properties[2])), this.minSize, this.maxSize, 1);
        this.spCacheSize = new JSpinner(snmCacheSize);
        this.slCacheSize.addChangeListener(this);
        this.spCacheSize.addChangeListener(this);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        diskSpacePanel.add((Component)lCompression, c);
        c.gridx = 1;
        c.weightx = 0.0;
        diskSpacePanel.add(cbCompression, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        diskSpacePanel.add((Component)lCacheSize, c);
        c.gridwidth = 1;
        c.gridy = 2;
        diskSpacePanel.add((Component)this.slCacheSize, c);
        c.gridx = 1;
        diskSpacePanel.add((Component)this.spCacheSize, c);
        JPanel buttonDeleteRestore = new JPanel(new FlowLayout(4));
        JButton bViewFiles = new JButton(Translator.R("TIFPViewFiles"));
        bViewFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CacheViewer.showCacheDialog(TemporaryInternetFilesPanel.this.config);
            }
        });
        buttonDeleteRestore.add(bViewFiles);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        topPanel.add((Component)enableCaching, c);
        c.gridy = 1;
        topPanel.add((Component)locationPanel, c);
        c.gridy = 2;
        topPanel.add((Component)diskSpacePanel, c);
        c.weighty = 1.0;
        c.gridy = 3;
        topPanel.add((Component)buttonDeleteRestore, c);
        this.add((Component)description, "North");
        this.add((Component)topPanel, "Center");
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o instanceof JSlider) {
            this.spCacheSize.setValue(((JSlider)o).getValue());
        } else if (o instanceof JSpinner) {
            this.slCacheSize.setValue((Integer)((JSpinner)o).getValue());
        }
        this.config.setProperty(properties[2], this.spCacheSize.getValue().toString());
    }
}

