#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:trim2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L trim2.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }
$ echo -ne '\''A\f'\''|json -b 1
A
$ echo -ne '\''A\f'\''|json -b 2
A
$ echo -ne '\''A\f'\''|json -b 3
A
$ echo -ne '\''\xc2\x80\f'\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80\f'\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80\f'\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80\f'\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\f
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 6
$ echo -ne '\''A\n'\''|json -b 1
A
$ echo -ne '\''A\n'\''|json -b 2
A
$ echo -ne '\''A\n'\''|json -b 3
A
$ echo -ne '\''\xc2\x80\n'\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80\n'\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80\n'\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80\n'\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 6
$ echo -ne '\''A\r'\''|json -b 1
A
$ echo -ne '\''A\r'\''|json -b 2
A
$ echo -ne '\''A\r'\''|json -b 3
A
$ echo -ne '\''\xc2\x80\r'\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80\r'\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80\r'\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80\r'\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\r
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 6
$ echo -ne '\''A\t'\''|json -b 1
A
$ echo -ne '\''A\t'\''|json -b 2
A
$ echo -ne '\''A\t'\''|json -b 3
A
$ echo -ne '\''\xc2\x80\t'\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80\t'\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80\t'\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80\t'\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\t
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 6
$ echo -ne '\''A\v'\''|json -b 1
A
$ echo -ne '\''A\v'\''|json -b 2
A
$ echo -ne '\''A\v'\''|json -b 3
A
$ echo -ne '\''\xc2\x80\v'\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80\v'\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80\v'\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80\v'\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80\v
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 6
$ echo -ne '\''A '\''|json -b 1
A
$ echo -ne '\''A '\''|json -b 2
A
$ echo -ne '\''A '\''|json -b 3
A
$ echo -ne '\''\xc2\x80 '\''|json -b 1
\u0080
$ echo -ne '\''\xc2\x80 '\''|json -b 2
\u0080
$ echo -ne '\''\xc2\x80 '\''|json -b 3
\u0080
$ echo -ne '\''\xc2\x80 '\''|json -b 4
\u0080
$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 1
\u0800
$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 2
\u0800
$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 3
\u0800
$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 4
\u0800
$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 5
\u0800
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 1
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 1
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 2
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 2
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 3
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 3
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 4
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 4
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 5
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 5
$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 6
json: error: <stdin>:1:1: non-BMP utf-8 encoding
json: error: <stdin>:1:1: \xf0\x90\x80\x80 
json: error: <stdin>:1:1: ^
command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 6'
) -L trim2.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'

echo '$ echo -ne '\''A\f'\''|json -b 1'
echo -ne 'A\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A\f'\''|json -b 1'

echo '$ echo -ne '\''A\f'\''|json -b 2'
echo -ne 'A\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A\f'\''|json -b 2'

echo '$ echo -ne '\''A\f'\''|json -b 3'
echo -ne 'A\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A\f'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\f'\''|json -b 1'
echo -ne '\xc2\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80\f'\''|json -b 2'
echo -ne '\xc2\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80\f'\''|json -b 3'
echo -ne '\xc2\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\f'\''|json -b 4'
echo -ne '\xc2\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 1'
echo -ne '\xe0\xa0\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 2'
echo -ne '\xe0\xa0\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 3'
echo -ne '\xe0\xa0\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 4'
echo -ne '\xe0\xa0\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\f'\''|json -b 5'
echo -ne '\xe0\xa0\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 1'
echo -ne '\xf0\x90\x80\x80\f'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 2'
echo -ne '\xf0\x90\x80\x80\f'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 3'
echo -ne '\xf0\x90\x80\x80\f'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 4'
echo -ne '\xf0\x90\x80\x80\f'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 5'
echo -ne '\xf0\x90\x80\x80\f'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 6'
echo -ne '\xf0\x90\x80\x80\f'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\f'\''|json -b 6'

echo '$ echo -ne '\''A\n'\''|json -b 1'
echo -ne 'A\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A\n'\''|json -b 1'

echo '$ echo -ne '\''A\n'\''|json -b 2'
echo -ne 'A\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A\n'\''|json -b 2'

echo '$ echo -ne '\''A\n'\''|json -b 3'
echo -ne 'A\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A\n'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\n'\''|json -b 1'
echo -ne '\xc2\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80\n'\''|json -b 2'
echo -ne '\xc2\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80\n'\''|json -b 3'
echo -ne '\xc2\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\n'\''|json -b 4'
echo -ne '\xc2\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 1'
echo -ne '\xe0\xa0\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 2'
echo -ne '\xe0\xa0\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 3'
echo -ne '\xe0\xa0\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 4'
echo -ne '\xe0\xa0\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\n'\''|json -b 5'
echo -ne '\xe0\xa0\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 1'
echo -ne '\xf0\x90\x80\x80\n'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 2'
echo -ne '\xf0\x90\x80\x80\n'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 3'
echo -ne '\xf0\x90\x80\x80\n'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 4'
echo -ne '\xf0\x90\x80\x80\n'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 5'
echo -ne '\xf0\x90\x80\x80\n'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 6'
echo -ne '\xf0\x90\x80\x80\n'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\n'\''|json -b 6'

echo '$ echo -ne '\''A\r'\''|json -b 1'
echo -ne 'A\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A\r'\''|json -b 1'

echo '$ echo -ne '\''A\r'\''|json -b 2'
echo -ne 'A\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A\r'\''|json -b 2'

echo '$ echo -ne '\''A\r'\''|json -b 3'
echo -ne 'A\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A\r'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\r'\''|json -b 1'
echo -ne '\xc2\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80\r'\''|json -b 2'
echo -ne '\xc2\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80\r'\''|json -b 3'
echo -ne '\xc2\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\r'\''|json -b 4'
echo -ne '\xc2\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 1'
echo -ne '\xe0\xa0\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 2'
echo -ne '\xe0\xa0\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 3'
echo -ne '\xe0\xa0\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 4'
echo -ne '\xe0\xa0\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\r'\''|json -b 5'
echo -ne '\xe0\xa0\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 1'
echo -ne '\xf0\x90\x80\x80\r'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 2'
echo -ne '\xf0\x90\x80\x80\r'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 3'
echo -ne '\xf0\x90\x80\x80\r'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 4'
echo -ne '\xf0\x90\x80\x80\r'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 5'
echo -ne '\xf0\x90\x80\x80\r'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 6'
echo -ne '\xf0\x90\x80\x80\r'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\r'\''|json -b 6'

echo '$ echo -ne '\''A\t'\''|json -b 1'
echo -ne 'A\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A\t'\''|json -b 1'

echo '$ echo -ne '\''A\t'\''|json -b 2'
echo -ne 'A\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A\t'\''|json -b 2'

echo '$ echo -ne '\''A\t'\''|json -b 3'
echo -ne 'A\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A\t'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\t'\''|json -b 1'
echo -ne '\xc2\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80\t'\''|json -b 2'
echo -ne '\xc2\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80\t'\''|json -b 3'
echo -ne '\xc2\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\t'\''|json -b 4'
echo -ne '\xc2\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 1'
echo -ne '\xe0\xa0\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 2'
echo -ne '\xe0\xa0\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 3'
echo -ne '\xe0\xa0\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 4'
echo -ne '\xe0\xa0\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\t'\''|json -b 5'
echo -ne '\xe0\xa0\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 1'
echo -ne '\xf0\x90\x80\x80\t'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 2'
echo -ne '\xf0\x90\x80\x80\t'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 3'
echo -ne '\xf0\x90\x80\x80\t'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 4'
echo -ne '\xf0\x90\x80\x80\t'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 5'
echo -ne '\xf0\x90\x80\x80\t'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 6'
echo -ne '\xf0\x90\x80\x80\t'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\t'\''|json -b 6'

echo '$ echo -ne '\''A\v'\''|json -b 1'
echo -ne 'A\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A\v'\''|json -b 1'

echo '$ echo -ne '\''A\v'\''|json -b 2'
echo -ne 'A\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A\v'\''|json -b 2'

echo '$ echo -ne '\''A\v'\''|json -b 3'
echo -ne 'A\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A\v'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\v'\''|json -b 1'
echo -ne '\xc2\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80\v'\''|json -b 2'
echo -ne '\xc2\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80\v'\''|json -b 3'
echo -ne '\xc2\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80\v'\''|json -b 4'
echo -ne '\xc2\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 1'
echo -ne '\xe0\xa0\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 2'
echo -ne '\xe0\xa0\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 3'
echo -ne '\xe0\xa0\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 4'
echo -ne '\xe0\xa0\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80\v'\''|json -b 5'
echo -ne '\xe0\xa0\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 1'
echo -ne '\xf0\x90\x80\x80\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 2'
echo -ne '\xf0\x90\x80\x80\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 3'
echo -ne '\xf0\x90\x80\x80\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 4'
echo -ne '\xf0\x90\x80\x80\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 5'
echo -ne '\xf0\x90\x80\x80\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 6'
echo -ne '\xf0\x90\x80\x80\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80\v'\''|json -b 6'

echo '$ echo -ne '\''A '\''|json -b 1'
echo -ne 'A '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''A '\''|json -b 1'

echo '$ echo -ne '\''A '\''|json -b 2'
echo -ne 'A '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''A '\''|json -b 2'

echo '$ echo -ne '\''A '\''|json -b 3'
echo -ne 'A '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''A '\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80 '\''|json -b 1'
echo -ne '\xc2\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80 '\''|json -b 1'

echo '$ echo -ne '\''\xc2\x80 '\''|json -b 2'
echo -ne '\xc2\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80 '\''|json -b 2'

echo '$ echo -ne '\''\xc2\x80 '\''|json -b 3'
echo -ne '\xc2\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80 '\''|json -b 3'

echo '$ echo -ne '\''\xc2\x80 '\''|json -b 4'
echo -ne '\xc2\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x80 '\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 1'
echo -ne '\xe0\xa0\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80 '\''|json -b 1'

echo '$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 2'
echo -ne '\xe0\xa0\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80 '\''|json -b 2'

echo '$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 3'
echo -ne '\xe0\xa0\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80 '\''|json -b 3'

echo '$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 4'
echo -ne '\xe0\xa0\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80 '\''|json -b 4'

echo '$ echo -ne '\''\xe0\xa0\x80 '\''|json -b 5'
echo -ne '\xe0\xa0\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x80 '\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 1'
echo -ne '\xf0\x90\x80\x80 '|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 1'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 2'
echo -ne '\xf0\x90\x80\x80 '|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 2'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 3'
echo -ne '\xf0\x90\x80\x80 '|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 3'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 4'
echo -ne '\xf0\x90\x80\x80 '|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 4'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 5'
echo -ne '\xf0\x90\x80\x80 '|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 5'

echo '$ echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 6'
echo -ne '\xf0\x90\x80\x80 '|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80 '\''|json -b 6'
)

