#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-esc3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-esc3.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo '\''"\@"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\@"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\@"'\''|json -b 1
$ echo '\''"\@"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\@"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\@"'\''|json -b 2
$ echo '\''"\@"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\@"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\@"'\''|json -b 3
$ echo '\''"\@"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\@"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\@"'\''|json -b 4
$ echo '\''"\@"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\@"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\@"'\''|json -b 5
$ echo '\''"\A"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\A"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\A"'\''|json -b 1
$ echo '\''"\A"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\A"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\A"'\''|json -b 2
$ echo '\''"\A"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\A"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\A"'\''|json -b 3
$ echo '\''"\A"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\A"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\A"'\''|json -b 4
$ echo '\''"\A"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\A"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\A"'\''|json -b 5
$ echo '\''"\B"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\B"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\B"'\''|json -b 1
$ echo '\''"\B"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\B"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\B"'\''|json -b 2
$ echo '\''"\B"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\B"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\B"'\''|json -b 3
$ echo '\''"\B"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\B"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\B"'\''|json -b 4
$ echo '\''"\B"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\B"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\B"'\''|json -b 5
$ echo '\''"\C"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\C"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\C"'\''|json -b 1
$ echo '\''"\C"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\C"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\C"'\''|json -b 2
$ echo '\''"\C"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\C"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\C"'\''|json -b 3
$ echo '\''"\C"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\C"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\C"'\''|json -b 4
$ echo '\''"\C"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\C"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\C"'\''|json -b 5
$ echo '\''"\D"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\D"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\D"'\''|json -b 1
$ echo '\''"\D"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\D"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\D"'\''|json -b 2
$ echo '\''"\D"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\D"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\D"'\''|json -b 3
$ echo '\''"\D"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\D"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\D"'\''|json -b 4
$ echo '\''"\D"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\D"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\D"'\''|json -b 5
$ echo '\''"\E"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\E"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\E"'\''|json -b 1
$ echo '\''"\E"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\E"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\E"'\''|json -b 2
$ echo '\''"\E"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\E"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\E"'\''|json -b 3
$ echo '\''"\E"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\E"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\E"'\''|json -b 4
$ echo '\''"\E"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\E"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\E"'\''|json -b 5
$ echo '\''"\F"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\F"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\F"'\''|json -b 1
$ echo '\''"\F"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\F"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\F"'\''|json -b 2
$ echo '\''"\F"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\F"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\F"'\''|json -b 3
$ echo '\''"\F"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\F"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\F"'\''|json -b 4
$ echo '\''"\F"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\F"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\F"'\''|json -b 5
$ echo '\''"\G"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\G"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\G"'\''|json -b 1
$ echo '\''"\G"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\G"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\G"'\''|json -b 2
$ echo '\''"\G"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\G"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\G"'\''|json -b 3
$ echo '\''"\G"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\G"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\G"'\''|json -b 4
$ echo '\''"\G"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\G"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\G"'\''|json -b 5
$ echo '\''"\H"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\H"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\H"'\''|json -b 1
$ echo '\''"\H"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\H"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\H"'\''|json -b 2
$ echo '\''"\H"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\H"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\H"'\''|json -b 3
$ echo '\''"\H"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\H"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\H"'\''|json -b 4
$ echo '\''"\H"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\H"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\H"'\''|json -b 5
$ echo '\''"\I"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\I"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\I"'\''|json -b 1
$ echo '\''"\I"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\I"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\I"'\''|json -b 2
$ echo '\''"\I"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\I"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\I"'\''|json -b 3
$ echo '\''"\I"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\I"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\I"'\''|json -b 4
$ echo '\''"\I"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\I"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\I"'\''|json -b 5
$ echo '\''"\J"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\J"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\J"'\''|json -b 1
$ echo '\''"\J"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\J"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\J"'\''|json -b 2
$ echo '\''"\J"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\J"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\J"'\''|json -b 3
$ echo '\''"\J"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\J"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\J"'\''|json -b 4
$ echo '\''"\J"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\J"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\J"'\''|json -b 5
$ echo '\''"\K"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\K"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\K"'\''|json -b 1
$ echo '\''"\K"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\K"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\K"'\''|json -b 2
$ echo '\''"\K"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\K"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\K"'\''|json -b 3
$ echo '\''"\K"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\K"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\K"'\''|json -b 4
$ echo '\''"\K"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\K"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\K"'\''|json -b 5
$ echo '\''"\L"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\L"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\L"'\''|json -b 1
$ echo '\''"\L"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\L"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\L"'\''|json -b 2
$ echo '\''"\L"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\L"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\L"'\''|json -b 3
$ echo '\''"\L"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\L"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\L"'\''|json -b 4
$ echo '\''"\L"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\L"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\L"'\''|json -b 5
$ echo '\''"\M"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\M"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\M"'\''|json -b 1
$ echo '\''"\M"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\M"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\M"'\''|json -b 2
$ echo '\''"\M"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\M"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\M"'\''|json -b 3
$ echo '\''"\M"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\M"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\M"'\''|json -b 4
$ echo '\''"\M"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\M"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\M"'\''|json -b 5
$ echo '\''"\N"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\N"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\N"'\''|json -b 1
$ echo '\''"\N"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\N"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\N"'\''|json -b 2
$ echo '\''"\N"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\N"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\N"'\''|json -b 3
$ echo '\''"\N"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\N"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\N"'\''|json -b 4
$ echo '\''"\N"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\N"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\N"'\''|json -b 5
$ echo '\''"\O"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\O"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\O"'\''|json -b 1
$ echo '\''"\O"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\O"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\O"'\''|json -b 2
$ echo '\''"\O"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\O"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\O"'\''|json -b 3
$ echo '\''"\O"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\O"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\O"'\''|json -b 4
$ echo '\''"\O"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\O"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\O"'\''|json -b 5
$ echo '\''"\P"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\P"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\P"'\''|json -b 1
$ echo '\''"\P"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\P"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\P"'\''|json -b 2
$ echo '\''"\P"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\P"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\P"'\''|json -b 3
$ echo '\''"\P"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\P"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\P"'\''|json -b 4
$ echo '\''"\P"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\P"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\P"'\''|json -b 5
$ echo '\''"\Q"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Q"'\''|json -b 1
$ echo '\''"\Q"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Q"'\''|json -b 2
$ echo '\''"\Q"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Q"'\''|json -b 3
$ echo '\''"\Q"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Q"'\''|json -b 4
$ echo '\''"\Q"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Q"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Q"'\''|json -b 5
$ echo '\''"\R"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\R"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\R"'\''|json -b 1
$ echo '\''"\R"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\R"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\R"'\''|json -b 2
$ echo '\''"\R"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\R"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\R"'\''|json -b 3
$ echo '\''"\R"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\R"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\R"'\''|json -b 4
$ echo '\''"\R"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\R"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\R"'\''|json -b 5
$ echo '\''"\S"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\S"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\S"'\''|json -b 1
$ echo '\''"\S"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\S"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\S"'\''|json -b 2
$ echo '\''"\S"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\S"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\S"'\''|json -b 3
$ echo '\''"\S"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\S"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\S"'\''|json -b 4
$ echo '\''"\S"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\S"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\S"'\''|json -b 5
$ echo '\''"\T"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\T"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\T"'\''|json -b 1
$ echo '\''"\T"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\T"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\T"'\''|json -b 2
$ echo '\''"\T"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\T"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\T"'\''|json -b 3
$ echo '\''"\T"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\T"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\T"'\''|json -b 4
$ echo '\''"\T"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\T"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\T"'\''|json -b 5
$ echo '\''"\U"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\U"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\U"'\''|json -b 1
$ echo '\''"\U"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\U"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\U"'\''|json -b 2
$ echo '\''"\U"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\U"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\U"'\''|json -b 3
$ echo '\''"\U"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\U"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\U"'\''|json -b 4
$ echo '\''"\U"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\U"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\U"'\''|json -b 5
$ echo '\''"\V"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\V"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\V"'\''|json -b 1
$ echo '\''"\V"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\V"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\V"'\''|json -b 2
$ echo '\''"\V"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\V"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\V"'\''|json -b 3
$ echo '\''"\V"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\V"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\V"'\''|json -b 4
$ echo '\''"\V"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\V"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\V"'\''|json -b 5
$ echo '\''"\W"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\W"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\W"'\''|json -b 1
$ echo '\''"\W"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\W"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\W"'\''|json -b 2
$ echo '\''"\W"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\W"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\W"'\''|json -b 3
$ echo '\''"\W"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\W"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\W"'\''|json -b 4
$ echo '\''"\W"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\W"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\W"'\''|json -b 5
$ echo '\''"\X"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\X"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\X"'\''|json -b 1
$ echo '\''"\X"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\X"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\X"'\''|json -b 2
$ echo '\''"\X"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\X"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\X"'\''|json -b 3
$ echo '\''"\X"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\X"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\X"'\''|json -b 4
$ echo '\''"\X"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\X"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\X"'\''|json -b 5
$ echo '\''"\Y"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Y"'\''|json -b 1
$ echo '\''"\Y"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Y"'\''|json -b 2
$ echo '\''"\Y"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Y"'\''|json -b 3
$ echo '\''"\Y"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Y"'\''|json -b 4
$ echo '\''"\Y"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Y"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Y"'\''|json -b 5
$ echo '\''"\Z"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Z"'\''|json -b 1
$ echo '\''"\Z"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Z"'\''|json -b 2
$ echo '\''"\Z"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Z"'\''|json -b 3
$ echo '\''"\Z"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Z"'\''|json -b 4
$ echo '\''"\Z"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\Z"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\Z"'\''|json -b 5
$ echo '\''"\["'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\["
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\["'\''|json -b 1
$ echo '\''"\["'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\["
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\["'\''|json -b 2
$ echo '\''"\["'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\["
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\["'\''|json -b 3
$ echo '\''"\["'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\["
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\["'\''|json -b 4
$ echo '\''"\["'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\["
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\["'\''|json -b 5
$ echo '\''"\\"'\''|json -b 1
"\\"
$ echo '\''"\\"'\''|json -b 2
"\\"
$ echo '\''"\\"'\''|json -b 3
"\\"
$ echo '\''"\\"'\''|json -b 4
"\\"
$ echo '\''"\\"'\''|json -b 5
"\\"
$ echo '\''"\]"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\]"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\]"'\''|json -b 1
$ echo '\''"\]"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\]"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\]"'\''|json -b 2
$ echo '\''"\]"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\]"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\]"'\''|json -b 3
$ echo '\''"\]"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\]"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\]"'\''|json -b 4
$ echo '\''"\]"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\]"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\]"'\''|json -b 5
$ echo '\''"\^"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\^"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\^"'\''|json -b 1
$ echo '\''"\^"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\^"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\^"'\''|json -b 2
$ echo '\''"\^"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\^"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\^"'\''|json -b 3
$ echo '\''"\^"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\^"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\^"'\''|json -b 4
$ echo '\''"\^"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\^"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\^"'\''|json -b 5
$ echo '\''"\_"'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\_"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\_"'\''|json -b 1
$ echo '\''"\_"'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\_"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\_"'\''|json -b 2
$ echo '\''"\_"'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\_"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\_"'\''|json -b 3
$ echo '\''"\_"'\''|json -b 4
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\_"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\_"'\''|json -b 4
$ echo '\''"\_"'\''|json -b 5
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\_"
json: error: <stdin>:1:3:    ^
command failed: echo '\''"\_"'\''|json -b 5'
) -L string-esc3.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''"\@"'\''|json -b 1'
echo '"\@"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\@"'\''|json -b 1'

echo '$ echo '\''"\@"'\''|json -b 2'
echo '"\@"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\@"'\''|json -b 2'

echo '$ echo '\''"\@"'\''|json -b 3'
echo '"\@"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\@"'\''|json -b 3'

echo '$ echo '\''"\@"'\''|json -b 4'
echo '"\@"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\@"'\''|json -b 4'

echo '$ echo '\''"\@"'\''|json -b 5'
echo '"\@"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\@"'\''|json -b 5'

echo '$ echo '\''"\A"'\''|json -b 1'
echo '"\A"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\A"'\''|json -b 1'

echo '$ echo '\''"\A"'\''|json -b 2'
echo '"\A"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\A"'\''|json -b 2'

echo '$ echo '\''"\A"'\''|json -b 3'
echo '"\A"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\A"'\''|json -b 3'

echo '$ echo '\''"\A"'\''|json -b 4'
echo '"\A"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\A"'\''|json -b 4'

echo '$ echo '\''"\A"'\''|json -b 5'
echo '"\A"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\A"'\''|json -b 5'

echo '$ echo '\''"\B"'\''|json -b 1'
echo '"\B"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\B"'\''|json -b 1'

echo '$ echo '\''"\B"'\''|json -b 2'
echo '"\B"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\B"'\''|json -b 2'

echo '$ echo '\''"\B"'\''|json -b 3'
echo '"\B"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\B"'\''|json -b 3'

echo '$ echo '\''"\B"'\''|json -b 4'
echo '"\B"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\B"'\''|json -b 4'

echo '$ echo '\''"\B"'\''|json -b 5'
echo '"\B"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\B"'\''|json -b 5'

echo '$ echo '\''"\C"'\''|json -b 1'
echo '"\C"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\C"'\''|json -b 1'

echo '$ echo '\''"\C"'\''|json -b 2'
echo '"\C"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\C"'\''|json -b 2'

echo '$ echo '\''"\C"'\''|json -b 3'
echo '"\C"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\C"'\''|json -b 3'

echo '$ echo '\''"\C"'\''|json -b 4'
echo '"\C"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\C"'\''|json -b 4'

echo '$ echo '\''"\C"'\''|json -b 5'
echo '"\C"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\C"'\''|json -b 5'

echo '$ echo '\''"\D"'\''|json -b 1'
echo '"\D"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\D"'\''|json -b 1'

echo '$ echo '\''"\D"'\''|json -b 2'
echo '"\D"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\D"'\''|json -b 2'

echo '$ echo '\''"\D"'\''|json -b 3'
echo '"\D"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\D"'\''|json -b 3'

echo '$ echo '\''"\D"'\''|json -b 4'
echo '"\D"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\D"'\''|json -b 4'

echo '$ echo '\''"\D"'\''|json -b 5'
echo '"\D"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\D"'\''|json -b 5'

echo '$ echo '\''"\E"'\''|json -b 1'
echo '"\E"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\E"'\''|json -b 1'

echo '$ echo '\''"\E"'\''|json -b 2'
echo '"\E"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\E"'\''|json -b 2'

echo '$ echo '\''"\E"'\''|json -b 3'
echo '"\E"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\E"'\''|json -b 3'

echo '$ echo '\''"\E"'\''|json -b 4'
echo '"\E"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\E"'\''|json -b 4'

echo '$ echo '\''"\E"'\''|json -b 5'
echo '"\E"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\E"'\''|json -b 5'

echo '$ echo '\''"\F"'\''|json -b 1'
echo '"\F"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\F"'\''|json -b 1'

echo '$ echo '\''"\F"'\''|json -b 2'
echo '"\F"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\F"'\''|json -b 2'

echo '$ echo '\''"\F"'\''|json -b 3'
echo '"\F"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\F"'\''|json -b 3'

echo '$ echo '\''"\F"'\''|json -b 4'
echo '"\F"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\F"'\''|json -b 4'

echo '$ echo '\''"\F"'\''|json -b 5'
echo '"\F"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\F"'\''|json -b 5'

echo '$ echo '\''"\G"'\''|json -b 1'
echo '"\G"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\G"'\''|json -b 1'

echo '$ echo '\''"\G"'\''|json -b 2'
echo '"\G"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\G"'\''|json -b 2'

echo '$ echo '\''"\G"'\''|json -b 3'
echo '"\G"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\G"'\''|json -b 3'

echo '$ echo '\''"\G"'\''|json -b 4'
echo '"\G"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\G"'\''|json -b 4'

echo '$ echo '\''"\G"'\''|json -b 5'
echo '"\G"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\G"'\''|json -b 5'

echo '$ echo '\''"\H"'\''|json -b 1'
echo '"\H"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\H"'\''|json -b 1'

echo '$ echo '\''"\H"'\''|json -b 2'
echo '"\H"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\H"'\''|json -b 2'

echo '$ echo '\''"\H"'\''|json -b 3'
echo '"\H"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\H"'\''|json -b 3'

echo '$ echo '\''"\H"'\''|json -b 4'
echo '"\H"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\H"'\''|json -b 4'

echo '$ echo '\''"\H"'\''|json -b 5'
echo '"\H"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\H"'\''|json -b 5'

echo '$ echo '\''"\I"'\''|json -b 1'
echo '"\I"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\I"'\''|json -b 1'

echo '$ echo '\''"\I"'\''|json -b 2'
echo '"\I"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\I"'\''|json -b 2'

echo '$ echo '\''"\I"'\''|json -b 3'
echo '"\I"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\I"'\''|json -b 3'

echo '$ echo '\''"\I"'\''|json -b 4'
echo '"\I"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\I"'\''|json -b 4'

echo '$ echo '\''"\I"'\''|json -b 5'
echo '"\I"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\I"'\''|json -b 5'

echo '$ echo '\''"\J"'\''|json -b 1'
echo '"\J"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\J"'\''|json -b 1'

echo '$ echo '\''"\J"'\''|json -b 2'
echo '"\J"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\J"'\''|json -b 2'

echo '$ echo '\''"\J"'\''|json -b 3'
echo '"\J"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\J"'\''|json -b 3'

echo '$ echo '\''"\J"'\''|json -b 4'
echo '"\J"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\J"'\''|json -b 4'

echo '$ echo '\''"\J"'\''|json -b 5'
echo '"\J"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\J"'\''|json -b 5'

echo '$ echo '\''"\K"'\''|json -b 1'
echo '"\K"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\K"'\''|json -b 1'

echo '$ echo '\''"\K"'\''|json -b 2'
echo '"\K"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\K"'\''|json -b 2'

echo '$ echo '\''"\K"'\''|json -b 3'
echo '"\K"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\K"'\''|json -b 3'

echo '$ echo '\''"\K"'\''|json -b 4'
echo '"\K"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\K"'\''|json -b 4'

echo '$ echo '\''"\K"'\''|json -b 5'
echo '"\K"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\K"'\''|json -b 5'

echo '$ echo '\''"\L"'\''|json -b 1'
echo '"\L"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\L"'\''|json -b 1'

echo '$ echo '\''"\L"'\''|json -b 2'
echo '"\L"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\L"'\''|json -b 2'

echo '$ echo '\''"\L"'\''|json -b 3'
echo '"\L"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\L"'\''|json -b 3'

echo '$ echo '\''"\L"'\''|json -b 4'
echo '"\L"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\L"'\''|json -b 4'

echo '$ echo '\''"\L"'\''|json -b 5'
echo '"\L"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\L"'\''|json -b 5'

echo '$ echo '\''"\M"'\''|json -b 1'
echo '"\M"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\M"'\''|json -b 1'

echo '$ echo '\''"\M"'\''|json -b 2'
echo '"\M"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\M"'\''|json -b 2'

echo '$ echo '\''"\M"'\''|json -b 3'
echo '"\M"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\M"'\''|json -b 3'

echo '$ echo '\''"\M"'\''|json -b 4'
echo '"\M"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\M"'\''|json -b 4'

echo '$ echo '\''"\M"'\''|json -b 5'
echo '"\M"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\M"'\''|json -b 5'

echo '$ echo '\''"\N"'\''|json -b 1'
echo '"\N"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\N"'\''|json -b 1'

echo '$ echo '\''"\N"'\''|json -b 2'
echo '"\N"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\N"'\''|json -b 2'

echo '$ echo '\''"\N"'\''|json -b 3'
echo '"\N"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\N"'\''|json -b 3'

echo '$ echo '\''"\N"'\''|json -b 4'
echo '"\N"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\N"'\''|json -b 4'

echo '$ echo '\''"\N"'\''|json -b 5'
echo '"\N"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\N"'\''|json -b 5'

echo '$ echo '\''"\O"'\''|json -b 1'
echo '"\O"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\O"'\''|json -b 1'

echo '$ echo '\''"\O"'\''|json -b 2'
echo '"\O"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\O"'\''|json -b 2'

echo '$ echo '\''"\O"'\''|json -b 3'
echo '"\O"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\O"'\''|json -b 3'

echo '$ echo '\''"\O"'\''|json -b 4'
echo '"\O"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\O"'\''|json -b 4'

echo '$ echo '\''"\O"'\''|json -b 5'
echo '"\O"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\O"'\''|json -b 5'

echo '$ echo '\''"\P"'\''|json -b 1'
echo '"\P"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\P"'\''|json -b 1'

echo '$ echo '\''"\P"'\''|json -b 2'
echo '"\P"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\P"'\''|json -b 2'

echo '$ echo '\''"\P"'\''|json -b 3'
echo '"\P"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\P"'\''|json -b 3'

echo '$ echo '\''"\P"'\''|json -b 4'
echo '"\P"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\P"'\''|json -b 4'

echo '$ echo '\''"\P"'\''|json -b 5'
echo '"\P"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\P"'\''|json -b 5'

echo '$ echo '\''"\Q"'\''|json -b 1'
echo '"\Q"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\Q"'\''|json -b 1'

echo '$ echo '\''"\Q"'\''|json -b 2'
echo '"\Q"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\Q"'\''|json -b 2'

echo '$ echo '\''"\Q"'\''|json -b 3'
echo '"\Q"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\Q"'\''|json -b 3'

echo '$ echo '\''"\Q"'\''|json -b 4'
echo '"\Q"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\Q"'\''|json -b 4'

echo '$ echo '\''"\Q"'\''|json -b 5'
echo '"\Q"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\Q"'\''|json -b 5'

echo '$ echo '\''"\R"'\''|json -b 1'
echo '"\R"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\R"'\''|json -b 1'

echo '$ echo '\''"\R"'\''|json -b 2'
echo '"\R"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\R"'\''|json -b 2'

echo '$ echo '\''"\R"'\''|json -b 3'
echo '"\R"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\R"'\''|json -b 3'

echo '$ echo '\''"\R"'\''|json -b 4'
echo '"\R"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\R"'\''|json -b 4'

echo '$ echo '\''"\R"'\''|json -b 5'
echo '"\R"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\R"'\''|json -b 5'

echo '$ echo '\''"\S"'\''|json -b 1'
echo '"\S"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\S"'\''|json -b 1'

echo '$ echo '\''"\S"'\''|json -b 2'
echo '"\S"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\S"'\''|json -b 2'

echo '$ echo '\''"\S"'\''|json -b 3'
echo '"\S"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\S"'\''|json -b 3'

echo '$ echo '\''"\S"'\''|json -b 4'
echo '"\S"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\S"'\''|json -b 4'

echo '$ echo '\''"\S"'\''|json -b 5'
echo '"\S"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\S"'\''|json -b 5'

echo '$ echo '\''"\T"'\''|json -b 1'
echo '"\T"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\T"'\''|json -b 1'

echo '$ echo '\''"\T"'\''|json -b 2'
echo '"\T"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\T"'\''|json -b 2'

echo '$ echo '\''"\T"'\''|json -b 3'
echo '"\T"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\T"'\''|json -b 3'

echo '$ echo '\''"\T"'\''|json -b 4'
echo '"\T"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\T"'\''|json -b 4'

echo '$ echo '\''"\T"'\''|json -b 5'
echo '"\T"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\T"'\''|json -b 5'

echo '$ echo '\''"\U"'\''|json -b 1'
echo '"\U"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\U"'\''|json -b 1'

echo '$ echo '\''"\U"'\''|json -b 2'
echo '"\U"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\U"'\''|json -b 2'

echo '$ echo '\''"\U"'\''|json -b 3'
echo '"\U"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\U"'\''|json -b 3'

echo '$ echo '\''"\U"'\''|json -b 4'
echo '"\U"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\U"'\''|json -b 4'

echo '$ echo '\''"\U"'\''|json -b 5'
echo '"\U"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\U"'\''|json -b 5'

echo '$ echo '\''"\V"'\''|json -b 1'
echo '"\V"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\V"'\''|json -b 1'

echo '$ echo '\''"\V"'\''|json -b 2'
echo '"\V"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\V"'\''|json -b 2'

echo '$ echo '\''"\V"'\''|json -b 3'
echo '"\V"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\V"'\''|json -b 3'

echo '$ echo '\''"\V"'\''|json -b 4'
echo '"\V"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\V"'\''|json -b 4'

echo '$ echo '\''"\V"'\''|json -b 5'
echo '"\V"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\V"'\''|json -b 5'

echo '$ echo '\''"\W"'\''|json -b 1'
echo '"\W"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\W"'\''|json -b 1'

echo '$ echo '\''"\W"'\''|json -b 2'
echo '"\W"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\W"'\''|json -b 2'

echo '$ echo '\''"\W"'\''|json -b 3'
echo '"\W"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\W"'\''|json -b 3'

echo '$ echo '\''"\W"'\''|json -b 4'
echo '"\W"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\W"'\''|json -b 4'

echo '$ echo '\''"\W"'\''|json -b 5'
echo '"\W"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\W"'\''|json -b 5'

echo '$ echo '\''"\X"'\''|json -b 1'
echo '"\X"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\X"'\''|json -b 1'

echo '$ echo '\''"\X"'\''|json -b 2'
echo '"\X"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\X"'\''|json -b 2'

echo '$ echo '\''"\X"'\''|json -b 3'
echo '"\X"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\X"'\''|json -b 3'

echo '$ echo '\''"\X"'\''|json -b 4'
echo '"\X"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\X"'\''|json -b 4'

echo '$ echo '\''"\X"'\''|json -b 5'
echo '"\X"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\X"'\''|json -b 5'

echo '$ echo '\''"\Y"'\''|json -b 1'
echo '"\Y"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\Y"'\''|json -b 1'

echo '$ echo '\''"\Y"'\''|json -b 2'
echo '"\Y"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\Y"'\''|json -b 2'

echo '$ echo '\''"\Y"'\''|json -b 3'
echo '"\Y"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\Y"'\''|json -b 3'

echo '$ echo '\''"\Y"'\''|json -b 4'
echo '"\Y"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\Y"'\''|json -b 4'

echo '$ echo '\''"\Y"'\''|json -b 5'
echo '"\Y"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\Y"'\''|json -b 5'

echo '$ echo '\''"\Z"'\''|json -b 1'
echo '"\Z"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\Z"'\''|json -b 1'

echo '$ echo '\''"\Z"'\''|json -b 2'
echo '"\Z"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\Z"'\''|json -b 2'

echo '$ echo '\''"\Z"'\''|json -b 3'
echo '"\Z"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\Z"'\''|json -b 3'

echo '$ echo '\''"\Z"'\''|json -b 4'
echo '"\Z"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\Z"'\''|json -b 4'

echo '$ echo '\''"\Z"'\''|json -b 5'
echo '"\Z"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\Z"'\''|json -b 5'

echo '$ echo '\''"\["'\''|json -b 1'
echo '"\["'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\["'\''|json -b 1'

echo '$ echo '\''"\["'\''|json -b 2'
echo '"\["'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\["'\''|json -b 2'

echo '$ echo '\''"\["'\''|json -b 3'
echo '"\["'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\["'\''|json -b 3'

echo '$ echo '\''"\["'\''|json -b 4'
echo '"\["'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\["'\''|json -b 4'

echo '$ echo '\''"\["'\''|json -b 5'
echo '"\["'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\["'\''|json -b 5'

echo '$ echo '\''"\\"'\''|json -b 1'
echo '"\\"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\\"'\''|json -b 1'

echo '$ echo '\''"\\"'\''|json -b 2'
echo '"\\"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\\"'\''|json -b 2'

echo '$ echo '\''"\\"'\''|json -b 3'
echo '"\\"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\\"'\''|json -b 3'

echo '$ echo '\''"\\"'\''|json -b 4'
echo '"\\"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\\"'\''|json -b 4'

echo '$ echo '\''"\\"'\''|json -b 5'
echo '"\\"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\\"'\''|json -b 5'

echo '$ echo '\''"\]"'\''|json -b 1'
echo '"\]"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\]"'\''|json -b 1'

echo '$ echo '\''"\]"'\''|json -b 2'
echo '"\]"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\]"'\''|json -b 2'

echo '$ echo '\''"\]"'\''|json -b 3'
echo '"\]"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\]"'\''|json -b 3'

echo '$ echo '\''"\]"'\''|json -b 4'
echo '"\]"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\]"'\''|json -b 4'

echo '$ echo '\''"\]"'\''|json -b 5'
echo '"\]"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\]"'\''|json -b 5'

echo '$ echo '\''"\^"'\''|json -b 1'
echo '"\^"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\^"'\''|json -b 1'

echo '$ echo '\''"\^"'\''|json -b 2'
echo '"\^"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\^"'\''|json -b 2'

echo '$ echo '\''"\^"'\''|json -b 3'
echo '"\^"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\^"'\''|json -b 3'

echo '$ echo '\''"\^"'\''|json -b 4'
echo '"\^"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\^"'\''|json -b 4'

echo '$ echo '\''"\^"'\''|json -b 5'
echo '"\^"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\^"'\''|json -b 5'

echo '$ echo '\''"\_"'\''|json -b 1'
echo '"\_"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\_"'\''|json -b 1'

echo '$ echo '\''"\_"'\''|json -b 2'
echo '"\_"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\_"'\''|json -b 2'

echo '$ echo '\''"\_"'\''|json -b 3'
echo '"\_"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\_"'\''|json -b 3'

echo '$ echo '\''"\_"'\''|json -b 4'
echo '"\_"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\_"'\''|json -b 4'

echo '$ echo '\''"\_"'\''|json -b 5'
echo '"\_"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\_"'\''|json -b 5'
)

