#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-keys
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-keys.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }
$ json '\''a a'\''
100
$ json '\''a ~a'\''
000
$ json '\''a b'\''
000
$ json '\''a ~b'\''
100
$ json '\''a c'\''
000
$ json '\''a ~c'\''
100
$ json '\''~a a'\''
000
$ json '\''~a ~a'\''
011
$ json '\''~a b'\''
010
$ json '\''~a ~b'\''
001
$ json '\''~a c'\''
001
$ json '\''~a ~c'\''
010
$ json '\''b a'\''
000
$ json '\''b ~a'\''
010
$ json '\''b b'\''
010
$ json '\''b ~b'\''
000
$ json '\''b c'\''
000
$ json '\''b ~c'\''
010
$ json '\''~b a'\''
100
$ json '\''~b ~a'\''
001
$ json '\''~b b'\''
000
$ json '\''~b ~b'\''
101
$ json '\''~b c'\''
001
$ json '\''~b ~c'\''
100
$ json '\''c a'\''
000
$ json '\''c ~a'\''
001
$ json '\''c b'\''
000
$ json '\''c ~b'\''
001
$ json '\''c c'\''
001
$ json '\''c ~c'\''
000
$ json '\''~c a'\''
100
$ json '\''~c ~a'\''
010
$ json '\''~c b'\''
010
$ json '\''~c ~b'\''
100
$ json '\''~c c'\''
000
$ json '\''~c ~c'\''
110
$ json '\''a&a'\''
100
$ json '\''a&~a'\''
000
$ json '\''a&b'\''
000
$ json '\''a&~b'\''
100
$ json '\''a&c'\''
000
$ json '\''a&~c'\''
100
$ json '\''~a&a'\''
000
$ json '\''~a&~a'\''
011
$ json '\''~a&b'\''
010
$ json '\''~a&~b'\''
001
$ json '\''~a&c'\''
001
$ json '\''~a&~c'\''
010
$ json '\''b&a'\''
000
$ json '\''b&~a'\''
010
$ json '\''b&b'\''
010
$ json '\''b&~b'\''
000
$ json '\''b&c'\''
000
$ json '\''b&~c'\''
010
$ json '\''~b&a'\''
100
$ json '\''~b&~a'\''
001
$ json '\''~b&b'\''
000
$ json '\''~b&~b'\''
101
$ json '\''~b&c'\''
001
$ json '\''~b&~c'\''
100
$ json '\''c&a'\''
000
$ json '\''c&~a'\''
001
$ json '\''c&b'\''
000
$ json '\''c&~b'\''
001
$ json '\''c&c'\''
001
$ json '\''c&~c'\''
000
$ json '\''~c&a'\''
100
$ json '\''~c&~a'\''
010
$ json '\''~c&b'\''
010
$ json '\''~c&~b'\''
100
$ json '\''~c&c'\''
000
$ json '\''~c&~c'\''
110
$ json '\''a|a'\''
100
$ json '\''a|~a'\''
111
$ json '\''a|b'\''
110
$ json '\''a|~b'\''
101
$ json '\''a|c'\''
101
$ json '\''a|~c'\''
110
$ json '\''~a|a'\''
111
$ json '\''~a|~a'\''
011
$ json '\''~a|b'\''
011
$ json '\''~a|~b'\''
111
$ json '\''~a|c'\''
011
$ json '\''~a|~c'\''
111
$ json '\''b|a'\''
110
$ json '\''b|~a'\''
011
$ json '\''b|b'\''
010
$ json '\''b|~b'\''
111
$ json '\''b|c'\''
011
$ json '\''b|~c'\''
110
$ json '\''~b|a'\''
101
$ json '\''~b|~a'\''
111
$ json '\''~b|b'\''
111
$ json '\''~b|~b'\''
101
$ json '\''~b|c'\''
101
$ json '\''~b|~c'\''
111
$ json '\''c|a'\''
101
$ json '\''c|~a'\''
011
$ json '\''c|b'\''
011
$ json '\''c|~b'\''
101
$ json '\''c|c'\''
001
$ json '\''c|~c'\''
111
$ json '\''~c|a'\''
110
$ json '\''~c|~a'\''
111
$ json '\''~c|b'\''
110
$ json '\''~c|~b'\''
111
$ json '\''~c|c'\''
111
$ json '\''~c|~c'\''
110
$ json '\''a||a'\''
100
100
$ json '\''a||~a'\''
100
011
$ json '\''a||b'\''
100
010
$ json '\''a||~b'\''
100
101
$ json '\''a||c'\''
100
001
$ json '\''a||~c'\''
100
110
$ json '\''~a||a'\''
011
100
$ json '\''~a||~a'\''
011
011
$ json '\''~a||b'\''
011
010
$ json '\''~a||~b'\''
011
101
$ json '\''~a||c'\''
011
001
$ json '\''~a||~c'\''
011
110
$ json '\''b||a'\''
010
100
$ json '\''b||~a'\''
010
011
$ json '\''b||b'\''
010
010
$ json '\''b||~b'\''
010
101
$ json '\''b||c'\''
010
001
$ json '\''b||~c'\''
010
110
$ json '\''~b||a'\''
101
100
$ json '\''~b||~a'\''
101
011
$ json '\''~b||b'\''
101
010
$ json '\''~b||~b'\''
101
101
$ json '\''~b||c'\''
101
001
$ json '\''~b||~c'\''
101
110
$ json '\''c||a'\''
001
100
$ json '\''c||~a'\''
001
011
$ json '\''c||b'\''
001
010
$ json '\''c||~b'\''
001
101
$ json '\''c||c'\''
001
001
$ json '\''c||~c'\''
001
110
$ json '\''~c||a'\''
110
100
$ json '\''~c||~a'\''
110
011
$ json '\''~c||b'\''
110
010
$ json '\''~c||~b'\''
110
101
$ json '\''~c||c'\''
110
001
$ json '\''~c||~c'\''
110
110'
) -L dict-expr-keys.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr 's|^/attr/expr/bits=||p'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''|LD_LIBRARY_PATH=../lib ../src/json -J --no-error|sed -nr '\''s|^/attr/expr/bits=||p'\''; }'

echo '$ json '\''a a'\'''
json 'a a' 2>&1 ||
echo 'command failed: json '\''a a'\'''

echo '$ json '\''a ~a'\'''
json 'a ~a' 2>&1 ||
echo 'command failed: json '\''a ~a'\'''

echo '$ json '\''a b'\'''
json 'a b' 2>&1 ||
echo 'command failed: json '\''a b'\'''

echo '$ json '\''a ~b'\'''
json 'a ~b' 2>&1 ||
echo 'command failed: json '\''a ~b'\'''

echo '$ json '\''a c'\'''
json 'a c' 2>&1 ||
echo 'command failed: json '\''a c'\'''

echo '$ json '\''a ~c'\'''
json 'a ~c' 2>&1 ||
echo 'command failed: json '\''a ~c'\'''

echo '$ json '\''~a a'\'''
json '~a a' 2>&1 ||
echo 'command failed: json '\''~a a'\'''

echo '$ json '\''~a ~a'\'''
json '~a ~a' 2>&1 ||
echo 'command failed: json '\''~a ~a'\'''

echo '$ json '\''~a b'\'''
json '~a b' 2>&1 ||
echo 'command failed: json '\''~a b'\'''

echo '$ json '\''~a ~b'\'''
json '~a ~b' 2>&1 ||
echo 'command failed: json '\''~a ~b'\'''

echo '$ json '\''~a c'\'''
json '~a c' 2>&1 ||
echo 'command failed: json '\''~a c'\'''

echo '$ json '\''~a ~c'\'''
json '~a ~c' 2>&1 ||
echo 'command failed: json '\''~a ~c'\'''

echo '$ json '\''b a'\'''
json 'b a' 2>&1 ||
echo 'command failed: json '\''b a'\'''

echo '$ json '\''b ~a'\'''
json 'b ~a' 2>&1 ||
echo 'command failed: json '\''b ~a'\'''

echo '$ json '\''b b'\'''
json 'b b' 2>&1 ||
echo 'command failed: json '\''b b'\'''

echo '$ json '\''b ~b'\'''
json 'b ~b' 2>&1 ||
echo 'command failed: json '\''b ~b'\'''

echo '$ json '\''b c'\'''
json 'b c' 2>&1 ||
echo 'command failed: json '\''b c'\'''

echo '$ json '\''b ~c'\'''
json 'b ~c' 2>&1 ||
echo 'command failed: json '\''b ~c'\'''

echo '$ json '\''~b a'\'''
json '~b a' 2>&1 ||
echo 'command failed: json '\''~b a'\'''

echo '$ json '\''~b ~a'\'''
json '~b ~a' 2>&1 ||
echo 'command failed: json '\''~b ~a'\'''

echo '$ json '\''~b b'\'''
json '~b b' 2>&1 ||
echo 'command failed: json '\''~b b'\'''

echo '$ json '\''~b ~b'\'''
json '~b ~b' 2>&1 ||
echo 'command failed: json '\''~b ~b'\'''

echo '$ json '\''~b c'\'''
json '~b c' 2>&1 ||
echo 'command failed: json '\''~b c'\'''

echo '$ json '\''~b ~c'\'''
json '~b ~c' 2>&1 ||
echo 'command failed: json '\''~b ~c'\'''

echo '$ json '\''c a'\'''
json 'c a' 2>&1 ||
echo 'command failed: json '\''c a'\'''

echo '$ json '\''c ~a'\'''
json 'c ~a' 2>&1 ||
echo 'command failed: json '\''c ~a'\'''

echo '$ json '\''c b'\'''
json 'c b' 2>&1 ||
echo 'command failed: json '\''c b'\'''

echo '$ json '\''c ~b'\'''
json 'c ~b' 2>&1 ||
echo 'command failed: json '\''c ~b'\'''

echo '$ json '\''c c'\'''
json 'c c' 2>&1 ||
echo 'command failed: json '\''c c'\'''

echo '$ json '\''c ~c'\'''
json 'c ~c' 2>&1 ||
echo 'command failed: json '\''c ~c'\'''

echo '$ json '\''~c a'\'''
json '~c a' 2>&1 ||
echo 'command failed: json '\''~c a'\'''

echo '$ json '\''~c ~a'\'''
json '~c ~a' 2>&1 ||
echo 'command failed: json '\''~c ~a'\'''

echo '$ json '\''~c b'\'''
json '~c b' 2>&1 ||
echo 'command failed: json '\''~c b'\'''

echo '$ json '\''~c ~b'\'''
json '~c ~b' 2>&1 ||
echo 'command failed: json '\''~c ~b'\'''

echo '$ json '\''~c c'\'''
json '~c c' 2>&1 ||
echo 'command failed: json '\''~c c'\'''

echo '$ json '\''~c ~c'\'''
json '~c ~c' 2>&1 ||
echo 'command failed: json '\''~c ~c'\'''

echo '$ json '\''a&a'\'''
json 'a&a' 2>&1 ||
echo 'command failed: json '\''a&a'\'''

echo '$ json '\''a&~a'\'''
json 'a&~a' 2>&1 ||
echo 'command failed: json '\''a&~a'\'''

echo '$ json '\''a&b'\'''
json 'a&b' 2>&1 ||
echo 'command failed: json '\''a&b'\'''

echo '$ json '\''a&~b'\'''
json 'a&~b' 2>&1 ||
echo 'command failed: json '\''a&~b'\'''

echo '$ json '\''a&c'\'''
json 'a&c' 2>&1 ||
echo 'command failed: json '\''a&c'\'''

echo '$ json '\''a&~c'\'''
json 'a&~c' 2>&1 ||
echo 'command failed: json '\''a&~c'\'''

echo '$ json '\''~a&a'\'''
json '~a&a' 2>&1 ||
echo 'command failed: json '\''~a&a'\'''

echo '$ json '\''~a&~a'\'''
json '~a&~a' 2>&1 ||
echo 'command failed: json '\''~a&~a'\'''

echo '$ json '\''~a&b'\'''
json '~a&b' 2>&1 ||
echo 'command failed: json '\''~a&b'\'''

echo '$ json '\''~a&~b'\'''
json '~a&~b' 2>&1 ||
echo 'command failed: json '\''~a&~b'\'''

echo '$ json '\''~a&c'\'''
json '~a&c' 2>&1 ||
echo 'command failed: json '\''~a&c'\'''

echo '$ json '\''~a&~c'\'''
json '~a&~c' 2>&1 ||
echo 'command failed: json '\''~a&~c'\'''

echo '$ json '\''b&a'\'''
json 'b&a' 2>&1 ||
echo 'command failed: json '\''b&a'\'''

echo '$ json '\''b&~a'\'''
json 'b&~a' 2>&1 ||
echo 'command failed: json '\''b&~a'\'''

echo '$ json '\''b&b'\'''
json 'b&b' 2>&1 ||
echo 'command failed: json '\''b&b'\'''

echo '$ json '\''b&~b'\'''
json 'b&~b' 2>&1 ||
echo 'command failed: json '\''b&~b'\'''

echo '$ json '\''b&c'\'''
json 'b&c' 2>&1 ||
echo 'command failed: json '\''b&c'\'''

echo '$ json '\''b&~c'\'''
json 'b&~c' 2>&1 ||
echo 'command failed: json '\''b&~c'\'''

echo '$ json '\''~b&a'\'''
json '~b&a' 2>&1 ||
echo 'command failed: json '\''~b&a'\'''

echo '$ json '\''~b&~a'\'''
json '~b&~a' 2>&1 ||
echo 'command failed: json '\''~b&~a'\'''

echo '$ json '\''~b&b'\'''
json '~b&b' 2>&1 ||
echo 'command failed: json '\''~b&b'\'''

echo '$ json '\''~b&~b'\'''
json '~b&~b' 2>&1 ||
echo 'command failed: json '\''~b&~b'\'''

echo '$ json '\''~b&c'\'''
json '~b&c' 2>&1 ||
echo 'command failed: json '\''~b&c'\'''

echo '$ json '\''~b&~c'\'''
json '~b&~c' 2>&1 ||
echo 'command failed: json '\''~b&~c'\'''

echo '$ json '\''c&a'\'''
json 'c&a' 2>&1 ||
echo 'command failed: json '\''c&a'\'''

echo '$ json '\''c&~a'\'''
json 'c&~a' 2>&1 ||
echo 'command failed: json '\''c&~a'\'''

echo '$ json '\''c&b'\'''
json 'c&b' 2>&1 ||
echo 'command failed: json '\''c&b'\'''

echo '$ json '\''c&~b'\'''
json 'c&~b' 2>&1 ||
echo 'command failed: json '\''c&~b'\'''

echo '$ json '\''c&c'\'''
json 'c&c' 2>&1 ||
echo 'command failed: json '\''c&c'\'''

echo '$ json '\''c&~c'\'''
json 'c&~c' 2>&1 ||
echo 'command failed: json '\''c&~c'\'''

echo '$ json '\''~c&a'\'''
json '~c&a' 2>&1 ||
echo 'command failed: json '\''~c&a'\'''

echo '$ json '\''~c&~a'\'''
json '~c&~a' 2>&1 ||
echo 'command failed: json '\''~c&~a'\'''

echo '$ json '\''~c&b'\'''
json '~c&b' 2>&1 ||
echo 'command failed: json '\''~c&b'\'''

echo '$ json '\''~c&~b'\'''
json '~c&~b' 2>&1 ||
echo 'command failed: json '\''~c&~b'\'''

echo '$ json '\''~c&c'\'''
json '~c&c' 2>&1 ||
echo 'command failed: json '\''~c&c'\'''

echo '$ json '\''~c&~c'\'''
json '~c&~c' 2>&1 ||
echo 'command failed: json '\''~c&~c'\'''

echo '$ json '\''a|a'\'''
json 'a|a' 2>&1 ||
echo 'command failed: json '\''a|a'\'''

echo '$ json '\''a|~a'\'''
json 'a|~a' 2>&1 ||
echo 'command failed: json '\''a|~a'\'''

echo '$ json '\''a|b'\'''
json 'a|b' 2>&1 ||
echo 'command failed: json '\''a|b'\'''

echo '$ json '\''a|~b'\'''
json 'a|~b' 2>&1 ||
echo 'command failed: json '\''a|~b'\'''

echo '$ json '\''a|c'\'''
json 'a|c' 2>&1 ||
echo 'command failed: json '\''a|c'\'''

echo '$ json '\''a|~c'\'''
json 'a|~c' 2>&1 ||
echo 'command failed: json '\''a|~c'\'''

echo '$ json '\''~a|a'\'''
json '~a|a' 2>&1 ||
echo 'command failed: json '\''~a|a'\'''

echo '$ json '\''~a|~a'\'''
json '~a|~a' 2>&1 ||
echo 'command failed: json '\''~a|~a'\'''

echo '$ json '\''~a|b'\'''
json '~a|b' 2>&1 ||
echo 'command failed: json '\''~a|b'\'''

echo '$ json '\''~a|~b'\'''
json '~a|~b' 2>&1 ||
echo 'command failed: json '\''~a|~b'\'''

echo '$ json '\''~a|c'\'''
json '~a|c' 2>&1 ||
echo 'command failed: json '\''~a|c'\'''

echo '$ json '\''~a|~c'\'''
json '~a|~c' 2>&1 ||
echo 'command failed: json '\''~a|~c'\'''

echo '$ json '\''b|a'\'''
json 'b|a' 2>&1 ||
echo 'command failed: json '\''b|a'\'''

echo '$ json '\''b|~a'\'''
json 'b|~a' 2>&1 ||
echo 'command failed: json '\''b|~a'\'''

echo '$ json '\''b|b'\'''
json 'b|b' 2>&1 ||
echo 'command failed: json '\''b|b'\'''

echo '$ json '\''b|~b'\'''
json 'b|~b' 2>&1 ||
echo 'command failed: json '\''b|~b'\'''

echo '$ json '\''b|c'\'''
json 'b|c' 2>&1 ||
echo 'command failed: json '\''b|c'\'''

echo '$ json '\''b|~c'\'''
json 'b|~c' 2>&1 ||
echo 'command failed: json '\''b|~c'\'''

echo '$ json '\''~b|a'\'''
json '~b|a' 2>&1 ||
echo 'command failed: json '\''~b|a'\'''

echo '$ json '\''~b|~a'\'''
json '~b|~a' 2>&1 ||
echo 'command failed: json '\''~b|~a'\'''

echo '$ json '\''~b|b'\'''
json '~b|b' 2>&1 ||
echo 'command failed: json '\''~b|b'\'''

echo '$ json '\''~b|~b'\'''
json '~b|~b' 2>&1 ||
echo 'command failed: json '\''~b|~b'\'''

echo '$ json '\''~b|c'\'''
json '~b|c' 2>&1 ||
echo 'command failed: json '\''~b|c'\'''

echo '$ json '\''~b|~c'\'''
json '~b|~c' 2>&1 ||
echo 'command failed: json '\''~b|~c'\'''

echo '$ json '\''c|a'\'''
json 'c|a' 2>&1 ||
echo 'command failed: json '\''c|a'\'''

echo '$ json '\''c|~a'\'''
json 'c|~a' 2>&1 ||
echo 'command failed: json '\''c|~a'\'''

echo '$ json '\''c|b'\'''
json 'c|b' 2>&1 ||
echo 'command failed: json '\''c|b'\'''

echo '$ json '\''c|~b'\'''
json 'c|~b' 2>&1 ||
echo 'command failed: json '\''c|~b'\'''

echo '$ json '\''c|c'\'''
json 'c|c' 2>&1 ||
echo 'command failed: json '\''c|c'\'''

echo '$ json '\''c|~c'\'''
json 'c|~c' 2>&1 ||
echo 'command failed: json '\''c|~c'\'''

echo '$ json '\''~c|a'\'''
json '~c|a' 2>&1 ||
echo 'command failed: json '\''~c|a'\'''

echo '$ json '\''~c|~a'\'''
json '~c|~a' 2>&1 ||
echo 'command failed: json '\''~c|~a'\'''

echo '$ json '\''~c|b'\'''
json '~c|b' 2>&1 ||
echo 'command failed: json '\''~c|b'\'''

echo '$ json '\''~c|~b'\'''
json '~c|~b' 2>&1 ||
echo 'command failed: json '\''~c|~b'\'''

echo '$ json '\''~c|c'\'''
json '~c|c' 2>&1 ||
echo 'command failed: json '\''~c|c'\'''

echo '$ json '\''~c|~c'\'''
json '~c|~c' 2>&1 ||
echo 'command failed: json '\''~c|~c'\'''

echo '$ json '\''a||a'\'''
json 'a||a' 2>&1 ||
echo 'command failed: json '\''a||a'\'''

echo '$ json '\''a||~a'\'''
json 'a||~a' 2>&1 ||
echo 'command failed: json '\''a||~a'\'''

echo '$ json '\''a||b'\'''
json 'a||b' 2>&1 ||
echo 'command failed: json '\''a||b'\'''

echo '$ json '\''a||~b'\'''
json 'a||~b' 2>&1 ||
echo 'command failed: json '\''a||~b'\'''

echo '$ json '\''a||c'\'''
json 'a||c' 2>&1 ||
echo 'command failed: json '\''a||c'\'''

echo '$ json '\''a||~c'\'''
json 'a||~c' 2>&1 ||
echo 'command failed: json '\''a||~c'\'''

echo '$ json '\''~a||a'\'''
json '~a||a' 2>&1 ||
echo 'command failed: json '\''~a||a'\'''

echo '$ json '\''~a||~a'\'''
json '~a||~a' 2>&1 ||
echo 'command failed: json '\''~a||~a'\'''

echo '$ json '\''~a||b'\'''
json '~a||b' 2>&1 ||
echo 'command failed: json '\''~a||b'\'''

echo '$ json '\''~a||~b'\'''
json '~a||~b' 2>&1 ||
echo 'command failed: json '\''~a||~b'\'''

echo '$ json '\''~a||c'\'''
json '~a||c' 2>&1 ||
echo 'command failed: json '\''~a||c'\'''

echo '$ json '\''~a||~c'\'''
json '~a||~c' 2>&1 ||
echo 'command failed: json '\''~a||~c'\'''

echo '$ json '\''b||a'\'''
json 'b||a' 2>&1 ||
echo 'command failed: json '\''b||a'\'''

echo '$ json '\''b||~a'\'''
json 'b||~a' 2>&1 ||
echo 'command failed: json '\''b||~a'\'''

echo '$ json '\''b||b'\'''
json 'b||b' 2>&1 ||
echo 'command failed: json '\''b||b'\'''

echo '$ json '\''b||~b'\'''
json 'b||~b' 2>&1 ||
echo 'command failed: json '\''b||~b'\'''

echo '$ json '\''b||c'\'''
json 'b||c' 2>&1 ||
echo 'command failed: json '\''b||c'\'''

echo '$ json '\''b||~c'\'''
json 'b||~c' 2>&1 ||
echo 'command failed: json '\''b||~c'\'''

echo '$ json '\''~b||a'\'''
json '~b||a' 2>&1 ||
echo 'command failed: json '\''~b||a'\'''

echo '$ json '\''~b||~a'\'''
json '~b||~a' 2>&1 ||
echo 'command failed: json '\''~b||~a'\'''

echo '$ json '\''~b||b'\'''
json '~b||b' 2>&1 ||
echo 'command failed: json '\''~b||b'\'''

echo '$ json '\''~b||~b'\'''
json '~b||~b' 2>&1 ||
echo 'command failed: json '\''~b||~b'\'''

echo '$ json '\''~b||c'\'''
json '~b||c' 2>&1 ||
echo 'command failed: json '\''~b||c'\'''

echo '$ json '\''~b||~c'\'''
json '~b||~c' 2>&1 ||
echo 'command failed: json '\''~b||~c'\'''

echo '$ json '\''c||a'\'''
json 'c||a' 2>&1 ||
echo 'command failed: json '\''c||a'\'''

echo '$ json '\''c||~a'\'''
json 'c||~a' 2>&1 ||
echo 'command failed: json '\''c||~a'\'''

echo '$ json '\''c||b'\'''
json 'c||b' 2>&1 ||
echo 'command failed: json '\''c||b'\'''

echo '$ json '\''c||~b'\'''
json 'c||~b' 2>&1 ||
echo 'command failed: json '\''c||~b'\'''

echo '$ json '\''c||c'\'''
json 'c||c' 2>&1 ||
echo 'command failed: json '\''c||c'\'''

echo '$ json '\''c||~c'\'''
json 'c||~c' 2>&1 ||
echo 'command failed: json '\''c||~c'\'''

echo '$ json '\''~c||a'\'''
json '~c||a' 2>&1 ||
echo 'command failed: json '\''~c||a'\'''

echo '$ json '\''~c||~a'\'''
json '~c||~a' 2>&1 ||
echo 'command failed: json '\''~c||~a'\'''

echo '$ json '\''~c||b'\'''
json '~c||b' 2>&1 ||
echo 'command failed: json '\''~c||b'\'''

echo '$ json '\''~c||~b'\'''
json '~c||~b' 2>&1 ||
echo 'command failed: json '\''~c||~b'\'''

echo '$ json '\''~c||c'\'''
json '~c||c' 2>&1 ||
echo 'command failed: json '\''~c||c'\'''

echo '$ json '\''~c||~c'\'''
json '~c||~c' 2>&1 ||
echo 'command failed: json '\''~c||~c'\'''
)

