#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-utf8-escape
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-utf8-escape.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --pretty-print --no-validate-utf8 --escape-utf8 "$@"; }
$ echo -e '\''"\xc2\x41\x42"'\''|json
"\ufffdAB"
$ echo -e '\''"\xf0\x80\x80"'\''|json
"\ufffd\ufffd\ufffd"
$ echo -e '\''"\xf0\x80\x80\x41"'\''|json
"\ufffd\ufffd\ufffdA"
$ echo -e '\''"\x41\xe0\x9f\x80\x41"'\''|json
"A\ufffd\ufffd\ufffdA"
$ echo -e '\''"\x41\xc0\xaf\x41\xf4\x80\x80\x41"'\''|json
"A\ufffd\ufffdA\ufffdA"
$ echo -e '\''"\x61\xf1\x80\x80\xe1\x80\xc2\x62\x80\x63\x80\xbf\x64"'\''|json
"a\ufffd\ufffd\ufffdb\ufffdc\ufffd\ufffdd"'
) -L string-utf8-escape.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --pretty-print --no-validate-utf8 --escape-utf8 "$@"; }'
json() { json0 --literal-value --pretty-print --no-validate-utf8 --escape-utf8 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --pretty-print --no-validate-utf8 --escape-utf8 "$@"; }'

echo '$ echo -e '\''"\xc2\x41\x42"'\''|json'
echo -e '"\xc2\x41\x42"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xc2\x41\x42"'\''|json'

echo '$ echo -e '\''"\xf0\x80\x80"'\''|json'
echo -e '"\xf0\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf0\x80\x80\x41"'\''|json'
echo -e '"\xf0\x80\x80\x41"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x80\x80\x41"'\''|json'

echo '$ echo -e '\''"\x41\xe0\x9f\x80\x41"'\''|json'
echo -e '"\x41\xe0\x9f\x80\x41"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x41\xe0\x9f\x80\x41"'\''|json'

echo '$ echo -e '\''"\x41\xc0\xaf\x41\xf4\x80\x80\x41"'\''|json'
echo -e '"\x41\xc0\xaf\x41\xf4\x80\x80\x41"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x41\xc0\xaf\x41\xf4\x80\x80\x41"'\''|json'

echo '$ echo -e '\''"\x61\xf1\x80\x80\xe1\x80\xc2\x62\x80\x63\x80\xbf\x64"'\''|json'
echo -e '"\x61\xf1\x80\x80\xe1\x80\xc2\x62\x80\x63\x80\xbf\x64"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\x61\xf1\x80\x80\xe1\x80\xc2\x62\x80\x63\x80\xbf\x64"'\''|json'
)

