#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:obj-type-first-key
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L obj-type-first-key.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"n":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"n":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"n":0}'\''
$ json <<< '\''{"n?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"n?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"n?":0}'\''
$ json <<< '\''{"na":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"na":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"na":0}'\''
$ json <<< '\''{"na?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"na?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"na?":0}'\''
$ json <<< '\''{"nam":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"nam":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"nam":0}'\''
$ json <<< '\''{"nam?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"nam?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"nam?":0}'\''
$ json <<< '\''{"name":0}'\''
json: error: <stdin>:1:1: meta error: invalid "name" object: arguments not of size two
json: error: <stdin>:1:1: {"name":0}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":0}'\''
$ json <<< '\''{"name?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"name?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"name?":0}'\''
$ json <<< '\''{"p":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"p":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"p":0}'\''
$ json <<< '\''{"p?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"p?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"p?":0}'\''
$ json <<< '\''{"pl":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"pl":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"pl":0}'\''
$ json <<< '\''{"pl?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"pl?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"pl?":0}'\''
$ json <<< '\''{"pla":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"pla":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"pla":0}'\''
$ json <<< '\''{"pla?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"pla?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"pla?":0}'\''
$ json <<< '\''{"plai":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"plai":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"plai":0}'\''
$ json <<< '\''{"plai?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"plai?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"plai?":0}'\''
$ json <<< '\''{"plain":0}'\''
{
    "plain": 0
}
$ json <<< '\''{"plain?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"plain?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"plain?":0}'\''
$ json <<< '\''{"t":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"t":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"t":0}'\''
$ json <<< '\''{"t?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"t?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"t?":0}'\''
$ json <<< '\''{"ty":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"ty":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"ty":0}'\''
$ json <<< '\''{"ty?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"ty?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"ty?":0}'\''
$ json <<< '\''{"typ":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"typ":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"typ":0}'\''
$ json <<< '\''{"typ?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"typ?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"typ?":0}'\''
$ json <<< '\''{"type":0}'\''
json: error: <stdin>:1:9: meta error: invalid "type" object: type not "object", "array", "list" or "dict"
json: error: <stdin>:1:9: {"type":0}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"type":0}'\''
$ json <<< '\''{"type?":0}'\''
json: error: <stdin>:1:2: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:2: {"type?":0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{"type?":0}'\'''
) -L obj-type-first-key.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"n":0}'\'''
json <<< '{"n":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"n":0}'\'''

echo '$ json <<< '\''{"n?":0}'\'''
json <<< '{"n?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"n?":0}'\'''

echo '$ json <<< '\''{"na":0}'\'''
json <<< '{"na":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"na":0}'\'''

echo '$ json <<< '\''{"na?":0}'\'''
json <<< '{"na?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"na?":0}'\'''

echo '$ json <<< '\''{"nam":0}'\'''
json <<< '{"nam":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"nam":0}'\'''

echo '$ json <<< '\''{"nam?":0}'\'''
json <<< '{"nam?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"nam?":0}'\'''

echo '$ json <<< '\''{"name":0}'\'''
json <<< '{"name":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":0}'\'''

echo '$ json <<< '\''{"name?":0}'\'''
json <<< '{"name?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"name?":0}'\'''

echo '$ json <<< '\''{"p":0}'\'''
json <<< '{"p":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"p":0}'\'''

echo '$ json <<< '\''{"p?":0}'\'''
json <<< '{"p?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"p?":0}'\'''

echo '$ json <<< '\''{"pl":0}'\'''
json <<< '{"pl":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"pl":0}'\'''

echo '$ json <<< '\''{"pl?":0}'\'''
json <<< '{"pl?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"pl?":0}'\'''

echo '$ json <<< '\''{"pla":0}'\'''
json <<< '{"pla":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"pla":0}'\'''

echo '$ json <<< '\''{"pla?":0}'\'''
json <<< '{"pla?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"pla?":0}'\'''

echo '$ json <<< '\''{"plai":0}'\'''
json <<< '{"plai":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"plai":0}'\'''

echo '$ json <<< '\''{"plai?":0}'\'''
json <<< '{"plai?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"plai?":0}'\'''

echo '$ json <<< '\''{"plain":0}'\'''
json <<< '{"plain":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain":0}'\'''

echo '$ json <<< '\''{"plain?":0}'\'''
json <<< '{"plain?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"plain?":0}'\'''

echo '$ json <<< '\''{"t":0}'\'''
json <<< '{"t":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"t":0}'\'''

echo '$ json <<< '\''{"t?":0}'\'''
json <<< '{"t?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"t?":0}'\'''

echo '$ json <<< '\''{"ty":0}'\'''
json <<< '{"ty":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"ty":0}'\'''

echo '$ json <<< '\''{"ty?":0}'\'''
json <<< '{"ty?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"ty?":0}'\'''

echo '$ json <<< '\''{"typ":0}'\'''
json <<< '{"typ":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"typ":0}'\'''

echo '$ json <<< '\''{"typ?":0}'\'''
json <<< '{"typ?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"typ?":0}'\'''

echo '$ json <<< '\''{"type":0}'\'''
json <<< '{"type":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":0}'\'''

echo '$ json <<< '\''{"type?":0}'\'''
json <<< '{"type?":0}' 2>&1 ||
echo 'command failed: json <<< '\''{"type?":0}'\'''
)

