#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:27
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 27.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"array",...}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[null'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\'', `"number"'\'' or `"string"'\'' or, otherwise, no value at all
json: error: <stdin>:1:2: [null
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0]'\''
[0]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[""]'\''
json: error: <stdin>:1:4: type check error: too few arguments
json: error: <stdin>:1:4: [""]
json: error: <stdin>:1:4:    ^
[""
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[""]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `"boolean"'\'' or `"number"'\''
json: error: <stdin>:1:5: ["",null]
json: error: <stdin>:1:5:     ^
["",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false]'\''
json: error: <stdin>:1:10: type check error: too few arguments
json: error: <stdin>:1:10: ["",false]
json: error: <stdin>:1:10:          ^
["",false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false,true,false]'\''
[false,true,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0,1,2]'\''
[0,1,2]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\''
["",false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,null]'\''
json: error: <stdin>:1:11: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:11: ["",false,null]
json: error: <stdin>:1:11:           ^
["",false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:7: ["",0,null]
json: error: <stdin>:1:7:       ^
["",0,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\''
["",false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1]'\''
["",0,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true,null]'\''
json: error: <stdin>:1:15: type check error: too many arguments
json: error: <stdin>:1:15: ["",false,true,null]
json: error: <stdin>:1:15:               ^
["",false,true
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1,null]'\''
json: error: <stdin>:1:8: type check error: too many arguments
json: error: <stdin>:1:8: ["",0,1,null]
json: error: <stdin>:1:8:        ^
["",0,1
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1,null]'\'''
) -L 27.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[null'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[0]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[""]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[""]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false,true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[false,true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[false,true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0,1,2]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '[0,1,2]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''[0,1,2]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",0,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",0,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",false,true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",false,true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}' <<< '["",0,1,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"boolean"},{"type":"array","args":"number"},{"type":"array","args":["string","boolean","boolean"]},{"type":"array","args":["string","number","number"]}]}'\'' <<< '\''["",0,1,null]'\'''
)

