#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:88
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 88.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }
$ json -d '\''"boolean"'\'' -Nfoo
json: error: <text>: type lib error: library error: type name '\''foo'\'' not available
command failed: json -d '\''"boolean"'\'' -Nfoo
$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -Nbar
json: error: <text>: type lib error: library error: type def '\''bar'\'' not found
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -Nbar
$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -N
json: error: <text>: type lib error: library error: type name not specified
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -N
$ json -d '\''[{"name":"foo","type":"boolean"}]'\''
json: error: <text>: type lib error: library error: type name not specified
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'''
) -L 88.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< ''; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }'

echo '$ json -d '\''"boolean"'\'' -Nfoo'
json -d '"boolean"' -Nfoo 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' -Nfoo'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -Nbar'
json -d '[{"name":"foo","type":"boolean"}]' -Nbar 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -Nbar'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -N'
json -d '[{"name":"foo","type":"boolean"}]' -N 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -N'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'''
json -d '[{"name":"foo","type":"boolean"}]' 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'''
)

