#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-open-array-basic-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-open-array-basic-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,null]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,false]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,true]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,123]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,{}]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,[]]'\''
json: error: <text>:1:80: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,null]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,false]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,true]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,123]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,{}]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,[]]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,null]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,false]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,true]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,123]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,{}]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,[]]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",null]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",false]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",true]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",123]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},null]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},false]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},true]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},123]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},{}]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},[]]'\''
json: error: <text>:1:82: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array ambiguity (the other defined at 1:24)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],[]]'\'''
) -L list-closed-array-basic-open-array-basic-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":"array"}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"type"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"number"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"string"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"object"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":"array"}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"type"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"null"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"number"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"string"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"object"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":"array"}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"type"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"null"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"string"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"object"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":"array"}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"type"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"null"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"number"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"object"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":"array"}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"type"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"null"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"number"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"string"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":"array"}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"type"}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"null"}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"number"}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"string"}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":"object"}]}'\'' <<< '\''[[],[]]'\'''
)

