#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-list4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-list4.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null","array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean","array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number","array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","object"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string","array"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","null"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","number"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","string"]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object","array"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","null"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","boolean"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","number"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","string"]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array","object"]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}'
) -L object-list4.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object","array"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","type"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","null"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","boolean"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","number"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","string"]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array","object"]}}]}'\'' <<< '\''{"foo":[]}'\'''
)

