#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:invalid-utf8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L invalid-utf8.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@"; }
$ json() { set -o pipefail && json0 --no-validate-utf8 --escape-json --quote-text|json0 --validate-utf8 --pretty-print --literal-value; }
$ echo -ne '\''\xc0'\''|json
json: error: <stdin>:1:2: lex error: invalid utf-8 encoding
json: error: <stdin>:1:2: "\xc0"
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\''\xc0'\''|json
$ echo -ne '\''\xc1'\''|json
json: error: <stdin>:1:2: lex error: invalid utf-8 encoding
json: error: <stdin>:1:2: "\xc1"
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\''\xc1'\''|json
$ echo -ne '\''\xc2'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xc2"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xc2'\''|json
$ echo -ne '\''\xdf'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xdf"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xdf'\''|json
$ echo -ne '\''\xc2\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xc2\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xc2\x7f'\''|json
$ echo -ne '\''\xdf\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xdf\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xdf\x7f'\''|json
$ echo -ne '\''\xc2\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xc2\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xc2\xc0'\''|json
$ echo -ne '\''\xdf\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xdf\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xdf\xc0'\''|json
$ echo -ne '\''\xe0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xe0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe0'\''|json
$ echo -ne '\''\xe0\x9f'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xe0\x9f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe0\x9f'\''|json
$ echo -ne '\''\xe0\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xe0\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe0\xc0'\''|json
$ echo -ne '\''\xe0\xa0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe0\xa0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xa0'\''|json
$ echo -ne '\''\xe0\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe0\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xbf'\''|json
$ echo -ne '\''\xe0\xa0\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xe0\xa0\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xa0\x7f'\''|json
$ echo -ne '\''\xe0\xbf\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xe0\xbf\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xbf\x7f'\''|json
$ echo -ne '\''\xe0\xa0\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe0\xa0\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xa0\xc0'\''|json
$ echo -ne '\''\xe0\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe0\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe0\xbf\xc0'\''|json
$ echo -ne '\''\xe1'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xe1"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe1'\''|json
$ echo -ne '\''\xe1\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xe1\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe1\x7f'\''|json
$ echo -ne '\''\xe1\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xe1\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xe1\xc0'\''|json
$ echo -ne '\''\xe1\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe1\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\x80'\''|json
$ echo -ne '\''\xe1\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe1\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\xbf'\''|json
$ echo -ne '\''\xe1\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xe1\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\x80\x7f'\''|json
$ echo -ne '\''\xe1\xbf\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xe1\xbf\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\xbf\x7f'\''|json
$ echo -ne '\''\xe1\x80\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe1\x80\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\x80\xc0'\''|json
$ echo -ne '\''\xe1\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xe1\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xe1\xbf\xc0'\''|json
$ echo -ne '\''\xec'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xec"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xec'\''|json
$ echo -ne '\''\xec\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xec\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xec\x7f'\''|json
$ echo -ne '\''\xec\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xec\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xec\xc0'\''|json
$ echo -ne '\''\xec\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xec\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\x80'\''|json
$ echo -ne '\''\xec\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xec\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\xbf'\''|json
$ echo -ne '\''\xec\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xec\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\x80\x7f'\''|json
$ echo -ne '\''\xec\xbf\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xec\xbf\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\xbf\x7f'\''|json
$ echo -ne '\''\xec\x80\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xec\x80\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\x80\xc0'\''|json
$ echo -ne '\''\xec\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xec\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xec\xbf\xc0'\''|json
$ echo -ne '\''\xed'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xed"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xed'\''|json
$ echo -ne '\''\xed\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xed\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xed\x7f'\''|json
$ echo -ne '\''\xed\xa0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xed\xa0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xed\xa0'\''|json
$ echo -ne '\''\xed\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xed\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x80'\''|json
$ echo -ne '\''\xed\x9f'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xed\x9f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x9f'\''|json
$ echo -ne '\''\xed\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xed\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x80\x7f'\''|json
$ echo -ne '\''\xed\x9f\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xed\x9f\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x9f\x7f'\''|json
$ echo -ne '\''\xed\x80\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xed\x80\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x80\xc0'\''|json
$ echo -ne '\''\xed\x9f\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xed\x9f\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xed\x9f\xc0'\''|json
$ echo -ne '\''\xee'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xee"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xee'\''|json
$ echo -ne '\''\xee\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xee\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xee\x7f'\''|json
$ echo -ne '\''\xee\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xee\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xee\xc0'\''|json
$ echo -ne '\''\xee\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xee\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\x80'\''|json
$ echo -ne '\''\xee\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xee\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\xbf'\''|json
$ echo -ne '\''\xee\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xee\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\x80\x7f'\''|json
$ echo -ne '\''\xee\xbf\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xee\xbf\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\xbf\x7f'\''|json
$ echo -ne '\''\xee\x80\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xee\x80\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\x80\xc0'\''|json
$ echo -ne '\''\xee\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xee\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xee\xbf\xc0'\''|json
$ echo -ne '\''\xef'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xef"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xef'\''|json
$ echo -ne '\''\xef\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xef\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xef\x7f'\''|json
$ echo -ne '\''\xef\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xef\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xef\xc0'\''|json
$ echo -ne '\''\xef\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xef\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\x80'\''|json
$ echo -ne '\''\xef\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xef\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\xbf'\''|json
$ echo -ne '\''\xef\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xef\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\x80\x7f'\''|json
$ echo -ne '\''\xef\xbf\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xef\xbf\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\xbf\x7f'\''|json
$ echo -ne '\''\xef\x80\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xef\x80\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\x80\xc0'\''|json
$ echo -ne '\''\xef\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xef\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xef\xbf\xc0'\''|json
$ echo -ne '\''\xf0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf0'\''|json
$ echo -ne '\''\xf0\x8f'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf0\x8f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf0\x8f'\''|json
$ echo -ne '\''\xf0\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf0\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf0\xc0'\''|json
$ echo -ne '\''\xf0\x90'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf0\x90"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf0\x90'\''|json
$ echo -ne '\''\xf0\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf0\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf0\xbf'\''|json
$ echo -ne '\''\xf0\x90\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xf0\x90\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf0\x90\x7f'\''|json
$ echo -ne '\''\xf0\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf0\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf0\xbf\xc0'\''|json
$ echo -ne '\''\xf0\x90\x80'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf0\x90\x80"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf0\x90\x80'\''|json
$ echo -ne '\''\xf0\xbf\xbf'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf0\xbf\xbf"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf0\xbf\xbf'\''|json
$ echo -ne '\''\xf0\x90\x80\x7f'\''|json
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\xf0\x90\x80\x7f"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json
$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf0\xbf\xbf\xc0"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json
$ echo -ne '\''\xf1'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf1"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf1'\''|json
$ echo -ne '\''\xf1\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xf1\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf1\x7f'\''|json
$ echo -ne '\''\xf1\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf1\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf1\xc0'\''|json
$ echo -ne '\''\xf1\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf1\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf1\x80'\''|json
$ echo -ne '\''\xf1\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf1\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf1\xbf'\''|json
$ echo -ne '\''\xf1\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xf1\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf1\x80\x7f'\''|json
$ echo -ne '\''\xf1\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf1\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf1\xbf\xc0'\''|json
$ echo -ne '\''\xf1\x80\x80'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf1\x80\x80"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf1\x80\x80'\''|json
$ echo -ne '\''\xf1\xbf\xbf'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf1\xbf\xbf"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf1\xbf\xbf'\''|json
$ echo -ne '\''\xf1\x80\x80\x7f'\''|json
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\xf1\x80\x80\x7f"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json
$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf1\xbf\xbf\xc0"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json
$ echo -ne '\''\xf3'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf3"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf3'\''|json
$ echo -ne '\''\xf3\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xf3\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf3\x7f'\''|json
$ echo -ne '\''\xf3\xc0'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf3\xc0"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf3\xc0'\''|json
$ echo -ne '\''\xf3\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf3\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf3\x80'\''|json
$ echo -ne '\''\xf3\xbf'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf3\xbf"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf3\xbf'\''|json
$ echo -ne '\''\xf3\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xf3\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf3\x80\x7f'\''|json
$ echo -ne '\''\xf3\xbf\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf3\xbf\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf3\xbf\xc0'\''|json
$ echo -ne '\''\xf3\x80\x80'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf3\x80\x80"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf3\x80\x80'\''|json
$ echo -ne '\''\xf3\xbf\xbf'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf3\xbf\xbf"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf3\xbf\xbf'\''|json
$ echo -ne '\''\xf3\x80\x80\x7f'\''|json
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\xf3\x80\x80\x7f"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json
$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf3\xbf\xbf\xc0"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json
$ echo -ne '\''\xf4'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf4"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf4'\''|json
$ echo -ne '\''\xf4\x7f'\''|json
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\xf4\x7f"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf4\x7f'\''|json
$ echo -ne '\''\xf4\x90'\''|json
json: error: <stdin>:1:3: lex error: invalid utf-8 encoding
json: error: <stdin>:1:3: "\xf4\x90"
json: error: <stdin>:1:3:      ^
command failed: echo -ne '\''\xf4\x90'\''|json
$ echo -ne '\''\xf4\x80'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf4\x80"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf4\x80'\''|json
$ echo -ne '\''\xf4\x8f'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf4\x8f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf4\x8f'\''|json
$ echo -ne '\''\xf4\x80\x7f'\''|json
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\xf4\x80\x7f"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf4\x80\x7f'\''|json
$ echo -ne '\''\xf4\x8f\xc0'\''|json
json: error: <stdin>:1:4: lex error: invalid utf-8 encoding
json: error: <stdin>:1:4: "\xf4\x8f\xc0"
json: error: <stdin>:1:4:          ^
command failed: echo -ne '\''\xf4\x8f\xc0'\''|json
$ echo -ne '\''\xf4\x80\x80'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf4\x80\x80"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf4\x80\x80'\''|json
$ echo -ne '\''\xf4\x8f\xbf'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf4\x8f\xbf"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf4\x8f\xbf'\''|json
$ echo -ne '\''\xf4\x80\x80\x7f'\''|json
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\xf4\x80\x80\x7f"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json
$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json
json: error: <stdin>:1:5: lex error: invalid utf-8 encoding
json: error: <stdin>:1:5: "\xf4\x8f\xbf\xc0"
json: error: <stdin>:1:5:              ^
command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json
$ echo -ne '\''\xf5'\''|json
json: error: <stdin>:1:2: lex error: invalid utf-8 encoding
json: error: <stdin>:1:2: "\xf5"
json: error: <stdin>:1:2:  ^
command failed: echo -ne '\''\xf5'\''|json
$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json
"A≢Α."'
) -L invalid-utf8.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@"; }'

echo '$ json() { set -o pipefail && json0 --no-validate-utf8 --escape-json --quote-text|json0 --validate-utf8 --pretty-print --literal-value; }'
json() { set -o pipefail && json0 --no-validate-utf8 --escape-json --quote-text|json0 --validate-utf8 --pretty-print --literal-value; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && json0 --no-validate-utf8 --escape-json --quote-text|json0 --validate-utf8 --pretty-print --literal-value; }'

echo '$ echo -ne '\''\xc0'\''|json'
echo -ne '\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xc0'\''|json'

echo '$ echo -ne '\''\xc1'\''|json'
echo -ne '\xc1'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xc1'\''|json'

echo '$ echo -ne '\''\xc2'\''|json'
echo -ne '\xc2'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xc2'\''|json'

echo '$ echo -ne '\''\xdf'\''|json'
echo -ne '\xdf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xdf'\''|json'

echo '$ echo -ne '\''\xc2\x7f'\''|json'
echo -ne '\xc2\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\x7f'\''|json'

echo '$ echo -ne '\''\xdf\x7f'\''|json'
echo -ne '\xdf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\x7f'\''|json'

echo '$ echo -ne '\''\xc2\xc0'\''|json'
echo -ne '\xc2\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xc2\xc0'\''|json'

echo '$ echo -ne '\''\xdf\xc0'\''|json'
echo -ne '\xdf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xdf\xc0'\''|json'

echo '$ echo -ne '\''\xe0'\''|json'
echo -ne '\xe0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0'\''|json'

echo '$ echo -ne '\''\xe0\x9f'\''|json'
echo -ne '\xe0\x9f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\x9f'\''|json'

echo '$ echo -ne '\''\xe0\xc0'\''|json'
echo -ne '\xe0\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xc0'\''|json'

echo '$ echo -ne '\''\xe0\xa0'\''|json'
echo -ne '\xe0\xa0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0'\''|json'

echo '$ echo -ne '\''\xe0\xbf'\''|json'
echo -ne '\xe0\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf'\''|json'

echo '$ echo -ne '\''\xe0\xa0\x7f'\''|json'
echo -ne '\xe0\xa0\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\x7f'\''|json'

echo '$ echo -ne '\''\xe0\xbf\x7f'\''|json'
echo -ne '\xe0\xbf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\x7f'\''|json'

echo '$ echo -ne '\''\xe0\xa0\xc0'\''|json'
echo -ne '\xe0\xa0\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xa0\xc0'\''|json'

echo '$ echo -ne '\''\xe0\xbf\xc0'\''|json'
echo -ne '\xe0\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe0\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xe1'\''|json'
echo -ne '\xe1'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1'\''|json'

echo '$ echo -ne '\''\xe1\x7f'\''|json'
echo -ne '\xe1\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x7f'\''|json'

echo '$ echo -ne '\''\xe1\xc0'\''|json'
echo -ne '\xe1\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xc0'\''|json'

echo '$ echo -ne '\''\xe1\x80'\''|json'
echo -ne '\xe1\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80'\''|json'

echo '$ echo -ne '\''\xe1\xbf'\''|json'
echo -ne '\xe1\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf'\''|json'

echo '$ echo -ne '\''\xe1\x80\x7f'\''|json'
echo -ne '\xe1\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\x7f'\''|json'

echo '$ echo -ne '\''\xe1\xbf\x7f'\''|json'
echo -ne '\xe1\xbf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\x7f'\''|json'

echo '$ echo -ne '\''\xe1\x80\xc0'\''|json'
echo -ne '\xe1\x80\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\x80\xc0'\''|json'

echo '$ echo -ne '\''\xe1\xbf\xc0'\''|json'
echo -ne '\xe1\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xe1\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xec'\''|json'
echo -ne '\xec'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec'\''|json'

echo '$ echo -ne '\''\xec\x7f'\''|json'
echo -ne '\xec\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x7f'\''|json'

echo '$ echo -ne '\''\xec\xc0'\''|json'
echo -ne '\xec\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xc0'\''|json'

echo '$ echo -ne '\''\xec\x80'\''|json'
echo -ne '\xec\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80'\''|json'

echo '$ echo -ne '\''\xec\xbf'\''|json'
echo -ne '\xec\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf'\''|json'

echo '$ echo -ne '\''\xec\x80\x7f'\''|json'
echo -ne '\xec\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\x7f'\''|json'

echo '$ echo -ne '\''\xec\xbf\x7f'\''|json'
echo -ne '\xec\xbf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\x7f'\''|json'

echo '$ echo -ne '\''\xec\x80\xc0'\''|json'
echo -ne '\xec\x80\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\x80\xc0'\''|json'

echo '$ echo -ne '\''\xec\xbf\xc0'\''|json'
echo -ne '\xec\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xec\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xed'\''|json'
echo -ne '\xed'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed'\''|json'

echo '$ echo -ne '\''\xed\x7f'\''|json'
echo -ne '\xed\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x7f'\''|json'

echo '$ echo -ne '\''\xed\xa0'\''|json'
echo -ne '\xed\xa0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\xa0'\''|json'

echo '$ echo -ne '\''\xed\x80'\''|json'
echo -ne '\xed\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80'\''|json'

echo '$ echo -ne '\''\xed\x9f'\''|json'
echo -ne '\xed\x9f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f'\''|json'

echo '$ echo -ne '\''\xed\x80\x7f'\''|json'
echo -ne '\xed\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\x7f'\''|json'

echo '$ echo -ne '\''\xed\x9f\x7f'\''|json'
echo -ne '\xed\x9f\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\x7f'\''|json'

echo '$ echo -ne '\''\xed\x80\xc0'\''|json'
echo -ne '\xed\x80\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x80\xc0'\''|json'

echo '$ echo -ne '\''\xed\x9f\xc0'\''|json'
echo -ne '\xed\x9f\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xed\x9f\xc0'\''|json'

echo '$ echo -ne '\''\xee'\''|json'
echo -ne '\xee'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee'\''|json'

echo '$ echo -ne '\''\xee\x7f'\''|json'
echo -ne '\xee\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x7f'\''|json'

echo '$ echo -ne '\''\xee\xc0'\''|json'
echo -ne '\xee\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xc0'\''|json'

echo '$ echo -ne '\''\xee\x80'\''|json'
echo -ne '\xee\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80'\''|json'

echo '$ echo -ne '\''\xee\xbf'\''|json'
echo -ne '\xee\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf'\''|json'

echo '$ echo -ne '\''\xee\x80\x7f'\''|json'
echo -ne '\xee\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\x7f'\''|json'

echo '$ echo -ne '\''\xee\xbf\x7f'\''|json'
echo -ne '\xee\xbf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\x7f'\''|json'

echo '$ echo -ne '\''\xee\x80\xc0'\''|json'
echo -ne '\xee\x80\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\x80\xc0'\''|json'

echo '$ echo -ne '\''\xee\xbf\xc0'\''|json'
echo -ne '\xee\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xee\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xef'\''|json'
echo -ne '\xef'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef'\''|json'

echo '$ echo -ne '\''\xef\x7f'\''|json'
echo -ne '\xef\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x7f'\''|json'

echo '$ echo -ne '\''\xef\xc0'\''|json'
echo -ne '\xef\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xc0'\''|json'

echo '$ echo -ne '\''\xef\x80'\''|json'
echo -ne '\xef\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80'\''|json'

echo '$ echo -ne '\''\xef\xbf'\''|json'
echo -ne '\xef\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf'\''|json'

echo '$ echo -ne '\''\xef\x80\x7f'\''|json'
echo -ne '\xef\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\x7f'\''|json'

echo '$ echo -ne '\''\xef\xbf\x7f'\''|json'
echo -ne '\xef\xbf\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\x7f'\''|json'

echo '$ echo -ne '\''\xef\x80\xc0'\''|json'
echo -ne '\xef\x80\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\x80\xc0'\''|json'

echo '$ echo -ne '\''\xef\xbf\xc0'\''|json'
echo -ne '\xef\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xef\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf0'\''|json'
echo -ne '\xf0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0'\''|json'

echo '$ echo -ne '\''\xf0\x8f'\''|json'
echo -ne '\xf0\x8f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x8f'\''|json'

echo '$ echo -ne '\''\xf0\xc0'\''|json'
echo -ne '\xf0\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xc0'\''|json'

echo '$ echo -ne '\''\xf0\x90'\''|json'
echo -ne '\xf0\x90'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90'\''|json'

echo '$ echo -ne '\''\xf0\xbf'\''|json'
echo -ne '\xf0\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf'\''|json'

echo '$ echo -ne '\''\xf0\x90\x7f'\''|json'
echo -ne '\xf0\x90\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x7f'\''|json'

echo '$ echo -ne '\''\xf0\xbf\xc0'\''|json'
echo -ne '\xf0\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf0\x90\x80'\''|json'
echo -ne '\xf0\x90\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80'\''|json'

echo '$ echo -ne '\''\xf0\xbf\xbf'\''|json'
echo -ne '\xf0\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf0\x90\x80\x7f'\''|json'
echo -ne '\xf0\x90\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf0\xbf\xbf\xc0'\''|json'
echo -ne '\xf0\xbf\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf1'\''|json'
echo -ne '\xf1'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1'\''|json'

echo '$ echo -ne '\''\xf1\x7f'\''|json'
echo -ne '\xf1\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x7f'\''|json'

echo '$ echo -ne '\''\xf1\xc0'\''|json'
echo -ne '\xf1\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xc0'\''|json'

echo '$ echo -ne '\''\xf1\x80'\''|json'
echo -ne '\xf1\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80'\''|json'

echo '$ echo -ne '\''\xf1\xbf'\''|json'
echo -ne '\xf1\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf'\''|json'

echo '$ echo -ne '\''\xf1\x80\x7f'\''|json'
echo -ne '\xf1\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf1\xbf\xc0'\''|json'
echo -ne '\xf1\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf1\x80\x80'\''|json'
echo -ne '\xf1\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80'\''|json'

echo '$ echo -ne '\''\xf1\xbf\xbf'\''|json'
echo -ne '\xf1\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf1\x80\x80\x7f'\''|json'
echo -ne '\xf1\x80\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf1\xbf\xbf\xc0'\''|json'
echo -ne '\xf1\xbf\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf3'\''|json'
echo -ne '\xf3'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3'\''|json'

echo '$ echo -ne '\''\xf3\x7f'\''|json'
echo -ne '\xf3\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x7f'\''|json'

echo '$ echo -ne '\''\xf3\xc0'\''|json'
echo -ne '\xf3\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xc0'\''|json'

echo '$ echo -ne '\''\xf3\x80'\''|json'
echo -ne '\xf3\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80'\''|json'

echo '$ echo -ne '\''\xf3\xbf'\''|json'
echo -ne '\xf3\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf'\''|json'

echo '$ echo -ne '\''\xf3\x80\x7f'\''|json'
echo -ne '\xf3\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf3\xbf\xc0'\''|json'
echo -ne '\xf3\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf3\x80\x80'\''|json'
echo -ne '\xf3\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80'\''|json'

echo '$ echo -ne '\''\xf3\xbf\xbf'\''|json'
echo -ne '\xf3\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf3\x80\x80\x7f'\''|json'
echo -ne '\xf3\x80\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf3\xbf\xbf\xc0'\''|json'
echo -ne '\xf3\xbf\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf4'\''|json'
echo -ne '\xf4'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4'\''|json'

echo '$ echo -ne '\''\xf4\x7f'\''|json'
echo -ne '\xf4\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x7f'\''|json'

echo '$ echo -ne '\''\xf4\x90'\''|json'
echo -ne '\xf4\x90'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x90'\''|json'

echo '$ echo -ne '\''\xf4\x80'\''|json'
echo -ne '\xf4\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80'\''|json'

echo '$ echo -ne '\''\xf4\x8f'\''|json'
echo -ne '\xf4\x8f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f'\''|json'

echo '$ echo -ne '\''\xf4\x80\x7f'\''|json'
echo -ne '\xf4\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xc0'\''|json'
echo -ne '\xf4\x8f\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xc0'\''|json'

echo '$ echo -ne '\''\xf4\x80\x80'\''|json'
echo -ne '\xf4\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xbf'\''|json'
echo -ne '\xf4\x8f\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x80\x80\x7f'\''|json'
echo -ne '\xf4\x80\x80\x7f'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x7f'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xbf\xc0'\''|json'
echo -ne '\xf4\x8f\xbf\xc0'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xc0'\''|json'

echo '$ echo -ne '\''\xf5'\''|json'
echo -ne '\xf5'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf5'\''|json'

echo '$ echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json'
echo -ne '\x41\xe2\x89\xa2\xce\x91\x2e'|json 2>&1 ||
echo 'command failed: echo -ne '\''\x41\xe2\x89\xa2\xce\x91\x2e'\''|json'
)

