#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:shuf
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L shuf.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ test-trie() { shuf|../lib/test-trie -T|sed -r '\''1{s/^(trie=).*$/\1{...}/;b};/^node=\{"val":"[^"]+","lo":null,"hi":null\}$/b;s/^(node=\{).*(\})$/\1...\2/'\''; }
$ print a b|test-trie
trie={...}
node={...}
char='\''a'\''
char='\''b'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
$ print a b c|test-trie
trie={...}
node={...}
char='\''a'\''
char='\''b'\''
char='\''c'\''
node={"val":"a","lo":null,"hi":null}
char='\''\0'\''
node={"val":"b","lo":null,"hi":null}
char='\''\0'\''
node={"val":"c","lo":null,"hi":null}
char='\''\0'\''
$ print z ax abc abd aef aeg|test-trie
trie={...}
node={...}
char='\''a'\''
char='\''z'\''
node={...}
char='\''b'\''
char='\''e'\''
char='\''x'\''
node={"val":"z","lo":null,"hi":null}
char='\''\0'\''
node={...}
char='\''c'\''
char='\''d'\''
node={...}
char='\''f'\''
char='\''g'\''
node={"val":"ax","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abc","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abd","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aef","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aeg","lo":null,"hi":null}
char='\''\0'\''
$ print aef ae abg a abc ab abd|test-trie
trie={...}
node={...}
char='\''a'\''
node={...}
char='\''\0'\''
char='\''b'\''
char='\''e'\''
node={...}
char='\''\0'\''
char='\''c'\''
char='\''d'\''
char='\''g'\''
node={...}
char='\''\0'\''
char='\''f'\''
node={"val":"abc","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abd","lo":null,"hi":null}
char='\''\0'\''
node={"val":"abg","lo":null,"hi":null}
char='\''\0'\''
node={"val":"aef","lo":null,"hi":null}
char='\''\0'\'''
) -L shuf.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ test-trie() { shuf|../lib/test-trie -T|sed -r '\''1{s/^(trie=).*$/\1{...}/;b};/^node=\{"val":"[^"]+","lo":null,"hi":null\}$/b;s/^(node=\{).*(\})$/\1...\2/'\''; }'
test-trie() { shuf|../lib/test-trie -T|sed -r '1{s/^(trie=).*$/\1{...}/;b};/^node=\{"val":"[^"]+","lo":null,"hi":null\}$/b;s/^(node=\{).*(\})$/\1...\2/'; } 2>&1 ||
echo 'command failed: test-trie() { shuf|../lib/test-trie -T|sed -r '\''1{s/^(trie=).*$/\1{...}/;b};/^node=\{"val":"[^"]+","lo":null,"hi":null\}$/b;s/^(node=\{).*(\})$/\1...\2/'\''; }'

echo '$ print a b|test-trie'
print a b|test-trie 2>&1 ||
echo 'command failed: print a b|test-trie'

echo '$ print a b c|test-trie'
print a b c|test-trie 2>&1 ||
echo 'command failed: print a b c|test-trie'

echo '$ print z ax abc abd aef aeg|test-trie'
print z ax abc abd aef aeg|test-trie 2>&1 ||
echo 'command failed: print z ax abc abd aef aeg|test-trie'

echo '$ print aef ae abg a abc ab abd|test-trie'
print aef ae abg a abc ab abd|test-trie 2>&1 ||
echo 'command failed: print aef ae abg a abc ab abd|test-trie'
)

