#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:15
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 15.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false,false]'\''
[false,false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null,null]'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: [false,null,null]
json: error: <stdin>:1:12:            ^
[false,null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null,null]'\'''
) -L 15.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}' <<< '[false,false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}' <<< '[false,null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean","null"]},{"type":"array","args":"boolean"}]}'\'' <<< '\''[false,null,null]'\'''
)

