#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C gen-def-gcc:basic9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic9.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ set -o pipefail
$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }
$ json-litex -d '\''{"baz":[{"bar":"`foo`"}]}'\''
\#include "json-litex.h"
static const struct json_litex_object_node_arg_t __12[];
static const struct json_litex_node_t __13;
static const struct json_litex_node_t __9;
static const struct json_litex_object_node_arg_t __5[];
static const struct json_litex_node_t __6;
static const struct json_litex_expr_node_t __0[] = {
    match_str("foo")
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 1
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`foo`"
    },
    .attr.string = &__1,
    .path = __5 + 0,
    .parent = &__6
};
static inline bool equal(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == *q;
}
static const struct json_litex_node_t* __3(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "bar"))
        return &__2;
    return NULL;
}
static const struct json_litex_object_attr_t __4 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __3
};
static const struct json_litex_object_node_arg_t __5[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar"
        },
        .val = &__2
    }
};
static const struct json_litex_node_t __6 = {
    .type = json_litex_object_node_type,
    .attr.object = &__4,
    .node.object = {
        .args = __5,
        .size = 1
    },
    .parent = &__9
};
static const struct json_litex_array_attr_t __7 = {
    .object = &__6
};
static const struct json_litex_node_t* __8[] = {
    &__6,
    NULL
};
static const struct json_litex_node_t __9 = {
    .type = json_litex_array_node_type,
    .attr.array = &__7,
    .node.array = {
        .args = __8,
        .size = 1
    },
    .path = __12 + 0,
    .parent = &__13
};
static const struct json_litex_node_t* __10(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "baz"))
        return &__9;
    return NULL;
}
static const struct json_litex_object_attr_t __11 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __10
};
static const struct json_litex_object_node_arg_t __12[] = {
    {
        .key = {
            .val = (const uchar_t*) "baz"
        },
        .val = &__9
    }
};
static const struct json_litex_node_t __13 = {
    .type = json_litex_object_node_type,
    .attr.object = &__11,
    .node.object = {
        .args = __12,
        .size = 1
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__13
};
$ json-litex -d '\''{"baz":[{"bar":"/foo/"}]}'\''
\#include "json-litex.h"
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_object_node_arg_t __15[];
static const struct json_litex_node_t __16;
static const struct json_litex_node_t __12;
static const struct json_litex_object_node_arg_t __8[];
static const struct json_litex_node_t __9;
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/foo/"
    },
    .attr.string = &__4,
    .path = __8 + 0,
    .parent = &__9
};
static inline bool equal(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == *q;
}
static const struct json_litex_node_t* __6(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "bar"))
        return &__5;
    return NULL;
}
static const struct json_litex_object_attr_t __7 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __6
};
static const struct json_litex_object_node_arg_t __8[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar"
        },
        .val = &__5
    }
};
static const struct json_litex_node_t __9 = {
    .type = json_litex_object_node_type,
    .attr.object = &__7,
    .node.object = {
        .args = __8,
        .size = 1
    },
    .parent = &__12
};
static const struct json_litex_array_attr_t __10 = {
    .object = &__9
};
static const struct json_litex_node_t* __11[] = {
    &__9,
    NULL
};
static const struct json_litex_node_t __12 = {
    .type = json_litex_array_node_type,
    .attr.array = &__10,
    .node.array = {
        .args = __11,
        .size = 1
    },
    .path = __15 + 0,
    .parent = &__16
};
static const struct json_litex_node_t* __13(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "baz"))
        return &__12;
    return NULL;
}
static const struct json_litex_object_attr_t __14 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __13
};
static const struct json_litex_object_node_arg_t __15[] = {
    {
        .key = {
            .val = (const uchar_t*) "baz"
        },
        .val = &__12
    }
};
static const struct json_litex_node_t __16 = {
    .type = json_litex_object_node_type,
    .attr.object = &__14,
    .node.object = {
        .args = __15,
        .size = 1
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__16
};
$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}]}'\''
\#include "json-litex.h"
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_object_node_arg_t __15[];
static const struct json_litex_node_t __16;
static const struct json_litex_node_t __12;
static const struct json_litex_object_node_arg_t __8[];
static const struct json_litex_node_t __9;
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "'\''foo'\''"
    },
    .attr.string = &__4,
    .path = __8 + 0,
    .parent = &__9
};
static inline bool equal(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == *q;
}
static const struct json_litex_node_t* __6(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "bar"))
        return &__5;
    return NULL;
}
static const struct json_litex_object_attr_t __7 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __6
};
static const struct json_litex_object_node_arg_t __8[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar"
        },
        .val = &__5
    }
};
static const struct json_litex_node_t __9 = {
    .type = json_litex_object_node_type,
    .attr.object = &__7,
    .node.object = {
        .args = __8,
        .size = 1
    },
    .parent = &__12
};
static const struct json_litex_array_attr_t __10 = {
    .object = &__9
};
static const struct json_litex_node_t* __11[] = {
    &__9,
    NULL
};
static const struct json_litex_node_t __12 = {
    .type = json_litex_array_node_type,
    .attr.array = &__10,
    .node.array = {
        .args = __11,
        .size = 1
    },
    .path = __15 + 0,
    .parent = &__16
};
static const struct json_litex_node_t* __13(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (equal(p, "baz"))
        return &__12;
    return NULL;
}
static const struct json_litex_object_attr_t __14 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __13
};
static const struct json_litex_object_node_arg_t __15[] = {
    {
        .key = {
            .val = (const uchar_t*) "baz"
        },
        .val = &__12
    }
};
static const struct json_litex_node_t __16 = {
    .type = json_litex_object_node_type,
    .attr.object = &__14,
    .node.object = {
        .args = __15,
        .size = 1
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__16
};'
) -L basic9.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }'
json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'1i\\\\\\#include "json-litex.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee >(sed -r '/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'$'};\n''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/' >&2)|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='__attribute__((unused))' -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r $'\''1i\\\\\\#include "json-litex.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee >(sed -r '\''/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\'' >&2)|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -DJSON_LITEX_MODULE -DUNUSED='\''__attribute__((unused))'\'' -I ../lib -xc -c - -o /dev/null; }'

echo '$ json-litex -d '\''{"baz":[{"bar":"`foo`"}]}'\'''
json-litex -d '{"baz":[{"bar":"`foo`"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"`foo`"}]}'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"/foo/"}]}'\'''
json-litex -d '{"baz":[{"bar":"/foo/"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"/foo/"}]}'\'''

echo '$ json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}]}'\'''
json-litex -d '{"baz":[{"bar":"'\''foo'\''"}]}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"baz":[{"bar":"'\''\'\'''\''foo'\''\'\'''\''"}]}'\'''
)

