#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict9
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict9.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1}'\''
{"bar":1}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1}'\''
{"foo":false,"bar":1}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false}'\''
{"bar":1,"foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":""}'\''
{"foo":false,"bar":1,"baz":""}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1}'\''
{"baz":"","foo":false,"bar":1}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false}'\''
{"bar":1,"baz":"","foo":false}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{}}'\''
{"foo":false,"bar":1,"baz":"","faa":{}}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":""}'\''
{"faa":{},"foo":false,"bar":1,"baz":""}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1}'\''
{"baz":"","faa":{},"foo":false,"bar":1}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false}'\''
{"bar":1,"baz":"","faa":{},"foo":false}'
) -L dict9.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}' <<< '{"bar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}' <<< '{"foo":false,"bar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}' <<< '{"bar":1,"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":""}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"foo":false,"bar":1,"baz":""}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":""}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"baz":"","foo":false,"bar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"bar":1,"baz":"","foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"foo":false,"bar":1,"baz":"","faa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":""}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"faa":{},"foo":false,"bar":1,"baz":""}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":""}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"baz":"","faa":{},"foo":false,"bar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"bar":1,"baz":"","faa":{},"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false}'\'''
)

