#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:name4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L name4.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"name":null,"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":null,"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":null,"type":"type"}'\''
$ json <<< '\''{"name":false,"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":false,"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":false,"type":"type"}'\''
$ json <<< '\''{"name":true,"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":true,"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":true,"type":"type"}'\''
$ json <<< '\''{"name":123,"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":123,"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":123,"type":"type"}'\''
$ json <<< '\''{"name":"foo","type":"type"}'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: {"name":"foo","type":"type"}
json: error: <stdin>:1:1: ^
command failed: json <<< '\''{"name":"foo","type":"type"}'\''
$ json <<< '\''{"name":{},"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":{},"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":{},"type":"type"}'\''
$ json <<< '\''{"name":[],"type":"type"}'\''
json: error: <stdin>:1:9: meta error: invalid "name" object: value of "name" must be a string
json: error: <stdin>:1:9: {"name":[],"type":"type"}
json: error: <stdin>:1:9:         ^
command failed: json <<< '\''{"name":[],"type":"type"}'\'''
) -L name4.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"name":null,"type":"type"}'\'''
json <<< '{"name":null,"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":null,"type":"type"}'\'''

echo '$ json <<< '\''{"name":false,"type":"type"}'\'''
json <<< '{"name":false,"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":false,"type":"type"}'\'''

echo '$ json <<< '\''{"name":true,"type":"type"}'\'''
json <<< '{"name":true,"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":true,"type":"type"}'\'''

echo '$ json <<< '\''{"name":123,"type":"type"}'\'''
json <<< '{"name":123,"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":123,"type":"type"}'\'''

echo '$ json <<< '\''{"name":"foo","type":"type"}'\'''
json <<< '{"name":"foo","type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":"foo","type":"type"}'\'''

echo '$ json <<< '\''{"name":{},"type":"type"}'\'''
json <<< '{"name":{},"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":{},"type":"type"}'\'''

echo '$ json <<< '\''{"name":[],"type":"type"}'\'''
json <<< '{"name":[],"type":"type"}' 2>&1 ||
echo 'command failed: json <<< '\''{"name":[],"type":"type"}'\'''
)

