#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:op14
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op14.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr '\''!((a >= b) != c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) != c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= b) != C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) != C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) != c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) != c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) != C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) != C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) != c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) != c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) != C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) != C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) != c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) != c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) != C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) != C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= b) != c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) != c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= b) != C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) != C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) != c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) != c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) != C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) != C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) != c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) != c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) != C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) != C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) != c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) != c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) != C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) != C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= b) && c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a >= b) && c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a >= b) && C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) && C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) && c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a >= B) && c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a >= B) && C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) && C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) && c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A >= b) && c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A >= b) && C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) && C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) && c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A >= B) && c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A >= B) && C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) && C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a != b) && c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a != b) && c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a != b) && C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) && C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) && c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a != B) && c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a != B) && C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) && C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) && c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A != b) && c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A != b) && C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) && C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) && c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A != B) && c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A != B) && C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) && C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''a >= !((b != c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b != c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b != C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b != C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B != c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B != c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B != C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B != C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b != c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b != c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b != C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b != C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B != c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B != c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B != C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B != C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b != c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b != c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b != C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b != C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B != c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B != c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B != C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B != C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b != c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b != c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b != C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b != C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B != c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B != c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B != C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B != C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b && c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''a >= !((b && c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b && C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b && C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B && c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''a >= !((B && c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B && C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B && C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b && c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''A >= !((b && c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b && C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b && C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B && c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''A >= !((B && c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B && C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B && C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a != !((b && c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''a != !((b && c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b && C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b && C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B && c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''a != !((B && c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B && C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B && C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b && c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''A != !((b && c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b && C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b && C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B && c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''A != !((B && c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B && C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B && C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false*(5)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!(a >= (b != c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b != c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (b != C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b != C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B != c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B != c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B != C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B != C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b != c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b != c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b != C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b != C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B != c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B != c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B != C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B != C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (b != c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b != c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (b != C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b != C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B != c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B != c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B != C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B != C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b != c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b != c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b != C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b != C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B != c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B != c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B != C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B != C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ne)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (b && c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a >= (b && c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(a >= (b && C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b && C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B && c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a >= (B && c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(a >= (B && C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B && C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b && c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A >= (b && c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(A >= (b && C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b && C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B && c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A >= (B && c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(A >= (B && C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B && C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (b && c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a != (b && c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(a != (b && C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b && C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B && c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a != (B && c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(a != (B && C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B && C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b && c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A != (b && c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(A != (b && C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b && C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B && c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A != (B && c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!(A != (B && C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B && C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= b) != (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= b) != (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) != (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= b) != (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) != (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= B) != (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) != (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= B) != (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) != (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= b) != (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) != (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= b) != (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) != (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= B) != (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) != (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= B) != (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) != (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= b) != (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) != (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= b) != (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) != (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= B) != (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) != (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a >= B) != (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) != (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= b) != (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) != (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= b) != (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) != (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= B) != (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) != (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A >= B) != (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= b) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= b) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= b) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= B) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= B) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= B) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= B) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= b) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= b) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= b) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= b) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= B) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= B) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= B) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= B) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != b) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != b) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != b) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != b) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != B) && (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != B) && (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != B) && (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != B) && (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != b) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != b) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != b) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != b) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != B) && (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != B) && (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != B) && (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != B) && (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''a >= !(b != (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b != (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b != (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b != (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B != (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B != (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B != (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B != (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b != (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b != (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b != (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b != (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B != (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B != (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B != (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B != (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b != (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b != (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b != (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b != (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B != (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B != (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B != (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B != (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b != (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b != (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b != (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b != (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B != (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B != (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B != (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B != (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b && (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b && (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b && (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b && (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B && (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B && (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b && (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b && (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B && (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B && (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a != !(b && (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b && (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b && (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b && (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B && (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B && (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b && (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b && (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B && (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(7)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B && (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!((a >= b) && c) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a >= b) && c) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a >= b) && C) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a >= b) && C) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a >= B) && c) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a >= B) && c) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a >= B) && C) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a >= B) && C) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A >= b) && c) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A >= b) && c) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A >= b) && C) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A >= b) && C) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A >= B) && c) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A >= B) && c) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A >= B) && C) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A >= B) && C) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a >= b) || c) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a >= b) || c) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a >= b) || C) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a >= b) || C) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a >= B) || c) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a >= B) || c) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a >= B) || C) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a >= B) || C) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A >= b) || c) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A >= b) || c) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A >= b) || C) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A >= b) || C) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A >= B) || c) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A >= B) || c) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A >= B) || C) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A >= B) || C) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a >= b) || c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a >= b) || c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a >= b) || C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= b) || C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a >= B) || c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a >= B) || c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a >= B) || C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a >= B) || C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= b) || c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A >= b) || c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A >= b) || C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= b) || C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A >= B) || c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A >= B) || c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A >= B) || C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A >= B) || C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != b) || c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a != b) || c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a != b) || C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) || C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) || c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a != B) || c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a != B) || C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) || C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) || c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A != b) || c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A != b) || C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) || C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) || c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A != B) || c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A != B) || C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) || C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''a >= !((b && c) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b && c) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b && C) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b && C) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B && c) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B && c) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B && C) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B && C) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b && c) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b && c) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b && C) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b && C) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B && c) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B && c) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B && C) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B && C) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b || c) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b || c) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b || C) != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b || C) != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B || c) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B || c) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B || C) != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B || C) != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b || c) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b || c) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b || C) != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b || C) != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B || c) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B || c) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B || C) != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B || C) != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((b || c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''a >= !((b || c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b || C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((b || C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !((B || c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''a >= !((B || c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B || C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !((B || C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((b || c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''A >= !((b || c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b || C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((b || C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !((B || c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ge)
$ test-expr '\''A >= !((B || c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B || C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !((B || C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a != !((b || c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''a != !((b || c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b || C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b || C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B || c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''a != !((B || c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B || C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B || C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b || c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''A != !((b || c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b || C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b || C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B || c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
9 cmp_op(ne)
$ test-expr '\''A != !((B || c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(7)
6 call_builtin(D)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B || C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B || C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true*(5)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!(a >= (b && c)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a >= (b && c)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a >= (b && C)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= (b && C)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= (B && c)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a >= (B && c)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a >= (B && C)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= (B && C)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= (b && c)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A >= (b && c)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A >= (b && C)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= (b && C)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= (B && c)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A >= (B && c)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A >= (B && C)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= (B && C)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= (b || c)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a >= (b || c)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a >= (b || C)) != d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= (b || C)) != D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= (B || c)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a >= (B || c)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a >= (B || C)) != d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= (B || C)) != D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= (b || c)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A >= (b || c)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A >= (b || C)) != d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= (b || C)) != D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= (B || c)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A >= (B || c)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A >= (B || C)) != d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= (B || C)) != D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= (b || c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a >= (b || c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(a >= (b || C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (b || C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= (B || c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a >= (B || c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(a >= (B || C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= (B || C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (b || c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A >= (b || c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(A >= (b || C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (b || C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= (B || c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A >= (B || c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(A >= (B || C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= (B || C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (b || c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a != (b || c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(a != (b || C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b || C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B || c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(a != (B || c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(a != (B || C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B || C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b || c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A != (b || c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(A != (b || C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b || C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B || c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!(A != (B || c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!(A != (B || C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B || C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= b) && (c != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) && (c != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) && (C != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) && (C != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) && (c != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) && (c != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) && (C != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) && (C != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) && (c != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) && (c != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) && (C != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) && (C != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) && (c != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) && (c != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) && (C != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) && (C != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) || (c != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) || (c != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) || (C != d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) || (C != D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) || (c != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) || (c != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) || (C != d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a >= B) || (C != D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) || (c != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) || (c != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) || (C != d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= b) || (C != D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) || (c != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) || (c != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) || (C != d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A >= B) || (C != D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a >= b) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= b) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= b) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= b) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= B) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= B) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a >= B) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a >= B) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= b) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= b) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= b) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= b) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= B) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= B) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A >= B) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A >= B) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ge)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != b) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != b) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != b) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != b) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != B) || (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != B) || (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != B) || (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != B) || (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != b) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != b) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != b) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != b) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != B) || (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != B) || (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != B) || (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != B) || (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''a >= !(b && (c != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b && (c != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b && (C != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b && (C != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (c != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (c != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (C != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B && (C != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (c != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (c != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (C != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b && (C != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (c != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (c != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (C != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B && (C != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (c != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (c != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (C != d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (C != D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (c != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (c != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (C != d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (C != D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (c != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (c != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (C != d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (C != D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (c != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (c != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (C != d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (C != D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b || (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(b || (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(b || (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B || (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a >= !(B || (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''a >= !(B || (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b || (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(b || (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(b || (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B || (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''A >= !(B || (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ge)
$ test-expr '\''A >= !(B || (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ge)
$ test-expr '\''a != !(b || (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b || (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b || (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b || (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B || (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B || (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b || (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b || (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B || (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(7)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B || (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''!((a != b) >= c) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) >= c) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != b) >= C) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) >= C) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) >= c) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) >= c) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) >= C) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) >= C) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) >= c) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) >= c) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) >= C) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) >= C) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) >= c) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) >= c) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) >= C) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) >= C) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a != b) >= c) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) >= c) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a != b) >= C) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != b) >= C) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) >= c) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) >= c) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a != B) >= C) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a != B) >= C) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) >= c) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) >= c) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != b) >= C) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != b) >= C) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) >= c) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) >= c) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A != B) >= C) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A != B) >= C) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a && b) >= c) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a && b) >= c) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a && b) >= C) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a && b) >= C) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a && B) >= c) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a && B) >= c) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a && B) >= C) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a && B) >= C) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A && b) >= c) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A && b) >= c) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A && b) >= C) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A && b) >= C) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A && B) >= c) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A && B) >= c) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A && B) >= C) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A && B) >= C) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a && b) != c) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a && b) != c) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a && b) != C) || d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a && b) != C) || D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((a && B) != c) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a && B) != c) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((a && B) != C) || d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a && B) != C) || D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A && b) != c) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A && b) != c) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A && b) != C) || d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A && b) != C) || D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_true(eos)
8 call_builtin(D)
$ test-expr '\''!((A && B) != c) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A && B) != c) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!((A && B) != C) || d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A && B) != C) || D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''a != !((b >= c) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b >= c) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b >= C) && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b >= C) && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B >= c) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B >= c) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B >= C) && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B >= C) && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b >= c) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b >= c) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b >= C) && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b >= C) && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B >= c) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B >= c) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B >= C) && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B >= C) && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_false(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b >= c) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b >= c) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b >= C) || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b >= C) || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B >= c) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B >= c) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B >= C) || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B >= C) || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b >= c) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b >= c) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b >= C) || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b >= C) || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B >= c) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B >= c) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B >= C) || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B >= C) || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 jump_true(6)
5 call_builtin(D)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a && !((b >= c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((b >= c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((b >= C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((b >= C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((B >= c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((B >= c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((B >= C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((B >= C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((b >= c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((b >= c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((b >= C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((b >= C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((B >= c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((B >= c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((B >= C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((B >= C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((b != c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((b != c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((b != C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((b != C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((B != c) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((B != c) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a && !((B != C) || d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a && !((B != C) || D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((b != c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((b != c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((b != C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((b != C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((B != c) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((B != c) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A && !((B != C) || d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A && !((B != C) || D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_true(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''!(a != (b >= c)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b >= c)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (b >= C)) && d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b >= C)) && D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B >= c)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B >= c)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B >= C)) && d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B >= C)) && D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b >= c)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b >= c)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b >= C)) && d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b >= C)) && D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B >= c)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B >= c)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B >= C)) && d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B >= C)) && D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (b >= c)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b >= c)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (b >= C)) || d'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (b >= C)) || D'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B >= c)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B >= c)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != (B >= C)) || d'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a != (B >= C)) || D'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b >= c)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b >= c)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (b >= C)) || d'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (b >= C)) || D'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B >= c)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B >= c)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A != (B >= C)) || d'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A != (B >= C)) || D'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 cmp_op(ge)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (b >= c)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (b >= c)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (b >= C)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (b >= C)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (B >= c)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (B >= c)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (B >= C)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (B >= C)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (b >= c)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (b >= c)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (b >= C)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (b >= C)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (B >= c)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (B >= c)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (B >= C)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (B >= C)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (b != c)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (b != c)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (b != C)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (b != C)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (B != c)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (B != c)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a && (B != C)) || d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a && (B != C)) || D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (b != c)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (b != c)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (b != C)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (b != C)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (B != c)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (B != c)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(A && (B != C)) || d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A && (B != C)) || D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_true(eos)
7 call_builtin(D)
$ test-expr '\''!(a != b) >= (c && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != b) >= (c && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) >= (C && d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != b) >= (C && D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) >= (c && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != B) >= (c && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) >= (C && d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != B) >= (C && D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) >= (c && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != b) >= (c && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) >= (C && d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != b) >= (C && D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) >= (c && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != B) >= (c && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) >= (C && d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != B) >= (C && D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) >= (c || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != b) >= (c || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) >= (C || d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != b) >= (C || D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) >= (c || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != B) >= (c || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) >= (C || d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a != B) >= (C || D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) >= (c || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != b) >= (c || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) >= (C || d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != b) >= (C || D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) >= (c || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != B) >= (c || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) >= (C || d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A != B) >= (C || D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && b) >= (c || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(a && b) >= (c || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && b) >= (C || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(a && b) >= (C || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && B) >= (c || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a && B) >= (c || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && B) >= (C || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a && B) >= (C || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && b) >= (c || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(A && b) >= (c || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && b) >= (C || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(A && b) >= (C || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && B) >= (c || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A && B) >= (c || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && B) >= (C || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A && B) >= (C || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && b) != (c || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(a && b) != (c || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && b) != (C || d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(a && b) != (C || D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && B) != (c || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a && B) != (c || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && B) != (C || d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a && B) != (C || D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && b) != (c || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(A && b) != (c || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && b) != (C || d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(A && b) != (C || D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_true(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && B) != (c || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A && B) != (c || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && B) != (C || d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A && B) != (C || D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_true(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a != !(b >= (c && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b >= (c && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b >= (C && d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b >= (C && D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B >= (c && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B >= (c && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B >= (C && d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B >= (C && D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b >= (c && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b >= (c && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b >= (C && d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b >= (C && D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B >= (c && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B >= (c && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B >= (C && d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B >= (C && D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_false(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b >= (c || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b >= (c || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b >= (C || d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(b >= (C || D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B >= (c || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B >= (c || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B >= (C || d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !(B >= (C || D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b >= (c || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b >= (c || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b >= (C || d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(b >= (C || D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B >= (c || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B >= (c || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(c)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B >= (C || d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(6)
4 call_builtin(d)
5 make_bool()
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !(B >= (C || D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 call_builtin(C)
3 jump_true(5)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a && !(b >= (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !(b >= (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b >= (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !(b >= (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !(B >= (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !(B >= (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !(b >= (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !(b >= (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !(B >= (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !(B >= (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b != (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !(b != (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b != (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !(b != (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (c || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !(B != (c || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (C || d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !(B != (C || D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !(b != (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !(b != (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (c || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !(B != (c || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (C || d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !(B != (C || D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_true(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''!((a != b) && c) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a != b) && c) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a != b) && C) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a != b) && C) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a != B) && c) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a != B) && c) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a != B) && C) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a != B) && C) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A != b) && c) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A != b) && c) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A != b) && C) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A != b) && C) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A != B) && c) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A != B) && c) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A != B) && C) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A != B) && C) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a != b) || c) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a != b) || c) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a != b) || C) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a != b) || C) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a != B) || c) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a != B) || c) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a != B) || C) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a != B) || C) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A != b) || c) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A != b) || c) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A != b) || C) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A != b) || C) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A != B) || c) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A != B) || c) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A != B) || C) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A != B) || C) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a && b) || c) >= d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ge)
$ test-expr '\''!((a && b) || c) >= D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ge)
$ test-expr '\''!((a && b) || C) >= d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a && b) || C) >= D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a && B) || c) >= d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a && B) || c) >= D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a && B) || C) >= d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a && B) || C) >= D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A && b) || c) >= d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ge)
$ test-expr '\''!((A && b) || c) >= D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ge)
$ test-expr '\''!((A && b) || C) >= d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A && b) || C) >= D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A && B) || c) >= d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A && B) || c) >= D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A && B) || C) >= d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A && B) || C) >= D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a && b) || c) != d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ne)
$ test-expr '\''!((a && b) || c) != D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ne)
$ test-expr '\''!((a && b) || C) != d'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a && b) || C) != D'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a && B) || c) != d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a && B) || c) != D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a && B) || C) != d'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a && B) || C) != D'\''
0 call_builtin(a)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A && b) || c) != d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ne)
$ test-expr '\''!((A && b) || c) != D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ne)
$ test-expr '\''!((A && b) || C) != d'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A && b) || C) != D'\''
0 call_builtin(A)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A && B) || c) != d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A && B) || c) != D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A && B) || C) != d'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A && B) || C) != D'\''
0 call_builtin(A)
1 jump_false*(4)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a != !((b && c) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b && c) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b && C) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b && C) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B && c) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B && c) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B && C) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B && C) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b && c) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b && c) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b && C) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b && C) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B && c) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B && c) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B && C) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B && C) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b || c) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b || c) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((b || C) >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((b || C) >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B || c) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B || c) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''a != !((B || C) >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !((B || C) >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b || c) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b || c) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((b || C) >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((b || C) >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B || c) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B || c) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
8 cmp_op(ne)
$ test-expr '\''A != !((B || C) >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !((B || C) >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a && !((b || c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !((b || c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !((b || C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((b || C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B || c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !((B || c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a && !((B || C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B || C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b || c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !((b || c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !((b || C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b || C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B || c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !((B || c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A && !((B || C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B || C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((b || c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !((b || c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !((b || C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((b || C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B || c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !((B || c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a && !((B || C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B || C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b || c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !((b || c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !((b || C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b || C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B || c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !((B || c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A && !((B || C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B || C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''!(a != (b && c)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a != (b && c)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a != (b && C)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != (b && C)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != (B && c)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a != (B && c)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a != (B && C)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != (B && C)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != (b && c)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A != (b && c)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A != (b && C)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != (b && C)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != (B && c)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A != (B && c)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A != (B && C)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != (B && C)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != (b || c)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a != (b || c)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a != (b || C)) >= d'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != (b || C)) >= D'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != (B || c)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a != (B || c)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a != (B || C)) >= d'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != (B || C)) >= D'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != (b || c)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A != (b || c)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A != (b || C)) >= d'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != (b || C)) >= D'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != (B || c)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A != (B || c)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A != (B || C)) >= d'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != (B || C)) >= D'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(4)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (b || c)) >= d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a && (b || c)) >= D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && (b || C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (b || C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (B || c)) >= d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a && (B || c)) >= D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && (B || C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (B || C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (b || c)) >= d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A && (b || c)) >= D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && (b || C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (b || C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (B || c)) >= d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A && (B || c)) >= D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && (B || C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (B || C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (b || c)) != d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a && (b || c)) != D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && (b || C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (b || C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && (B || c)) != d'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a && (B || c)) != D'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && (B || C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (B || C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (b || c)) != d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A && (b || c)) != D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && (b || C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (b || C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (B || c)) != d'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A && (B || c)) != D'\''
0 call_builtin(A)
1 jump_false(6)
2 call_builtin(B)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && (B || C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (B || C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 jump_true(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a != b) && (c >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != b) && (c >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) && (C >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != b) && (C >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) && (c >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != B) && (c >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) && (C >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != B) && (C >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) && (c >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != b) && (c >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) && (C >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != b) && (C >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) && (c >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != B) && (c >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) && (C >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != B) && (C >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) || (c >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != b) || (c >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != b) || (C >= d)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != b) || (C >= D)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) || (c >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != B) || (c >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a != B) || (C >= d)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a != B) || (C >= D)'\''
0 call_builtin(a)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) || (c >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != b) || (c >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != b) || (C >= d)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != b) || (C >= D)'\''
0 call_builtin(A)
1 call_builtin(b)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) || (c >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != B) || (c >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A != B) || (C >= d)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A != B) || (C >= D)'\''
0 call_builtin(A)
1 call_builtin(B)
2 cmp_op(ne)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && b) || (c >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a && b) || (c >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && b) || (C >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a && b) || (C >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a && B) || (c >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && B) || (c >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && B) || (C >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && B) || (C >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && b) || (c >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A && b) || (c >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && b) || (C >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A && b) || (C >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A && B) || (c >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && B) || (c >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && B) || (C >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && B) || (C >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && b) || (c != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a && b) || (c != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && b) || (C != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a && b) || (C != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a && B) || (c != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && B) || (c != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && B) || (C != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && B) || (C != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && b) || (c != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A && b) || (c != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && b) || (C != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A && b) || (C != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_true(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A && B) || (c != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && B) || (c != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && B) || (C != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && B) || (C != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 jump_true(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a != !(b && (c >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b && (c >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b && (C >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b && (C >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (c >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (c >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (C >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B && (C >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (c >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (c >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (C >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b && (C >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (c >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (c >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (C >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B && (C >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_false(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b || (c >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b || (c >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b || (C >= d))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(b || (C >= D))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (c >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (c >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (C >= d))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a != !(B || (C >= D))'\''
0 call_builtin(a)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (c >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (c >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (C >= d))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(b || (C >= D))'\''
0 call_builtin(A)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (c >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (c >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (C >= d))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''A != !(B || (C >= D))'\''
0 call_builtin(A)
1 call_builtin(B)
2 jump_true(6)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 not_op()
7 cmp_op(ne)
$ test-expr '\''a && !(b || (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b || (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b || (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b || (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B || (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B || (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B || (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B || (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b || (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b || (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b || (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b || (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B || (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B || (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B || (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B || (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b || (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b || (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b || (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b || (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B || (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B || (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B || (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B || (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b || (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b || (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b || (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b || (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B || (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B || (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B || (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B || (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 jump_true(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''!((a && b) >= c) != d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a && b) >= c) != D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a && b) >= C) != d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a && b) >= C) != D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a && B) >= c) != d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a && B) >= c) != D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a && B) >= C) != d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a && B) >= C) != D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A && b) >= c) != d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A && b) >= c) != D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A && b) >= C) != d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A && b) >= C) != D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A && B) >= c) != d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A && B) >= c) != D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A && B) >= C) != d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A && B) >= C) != D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a || b) >= c) != d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a || b) >= c) != D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a || b) >= C) != d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a || b) >= C) != D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a || B) >= c) != d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a || B) >= c) != D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a || B) >= C) != d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a || B) >= C) != D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A || b) >= c) != d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A || b) >= c) != D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A || b) >= C) != d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A || b) >= C) != D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A || B) >= c) != d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A || B) >= c) != D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A || B) >= C) != d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A || B) >= C) != D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((a || b) >= c) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a || b) >= c) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a || b) >= C) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a || b) >= C) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a || B) >= c) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a || B) >= c) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a || B) >= C) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a || B) >= C) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A || b) >= c) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A || b) >= c) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A || b) >= C) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A || b) >= C) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ge)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A || B) >= c) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A || B) >= c) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A || B) >= C) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A || B) >= C) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a || b) != c) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a || b) != c) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a || b) != C) && d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((a || b) != C) && D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((a || B) != c) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a || B) != c) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((a || B) != C) && d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((a || B) != C) && D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A || b) != c) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A || b) != c) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A || b) != C) && d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(d)
9 make_bool()
$ test-expr '\''!((A || b) != C) && D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 jump_false(eos)
8 call_builtin(D)
$ test-expr '\''!((A || B) != c) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A || B) != c) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!((A || B) != C) && d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!((A || B) != C) && D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''a && !((b >= c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((b >= c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((b >= C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((b >= C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B >= c) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B >= c) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B >= C) != d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !((B >= C) != D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b >= c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b >= c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b >= C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((b >= C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B >= c) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B >= c) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B >= C) != d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !((B >= C) != D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b >= c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b >= c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b >= C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b >= C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B >= c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B >= c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B >= C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B >= C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b >= c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b >= c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b >= C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b >= C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B >= c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B >= c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B >= C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B >= C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b >= c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((b >= c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((b >= C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((b >= C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((B >= c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((B >= c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((B >= C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((B >= C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((b >= c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((b >= c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((b >= C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((b >= C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((B >= c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((B >= c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((B >= C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((B >= C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((b != c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((b != c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((b != C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((b != C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((B != c) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((B != c) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''a || !((B != C) && d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''a || !((B != C) && D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((b != c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((b != c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((b != C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((b != C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((B != c) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((B != c) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''A || !((B != C) && d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 not_op()
$ test-expr '\''A || !((B != C) && D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 jump_false(7)
6 call_builtin(D)
7 not_op()
$ test-expr '\''!(a && (b >= c)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (b >= c)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && (b >= C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (b >= C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && (B >= c)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (B >= c)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && (B >= C)) != d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a && (B >= C)) != D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (b >= c)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (b >= c)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (b >= C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (b >= C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (B >= c)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (B >= c)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A && (B >= C)) != d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A && (B >= C)) != D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (b >= c)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (b >= c)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (b >= C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (b >= C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (B >= c)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (B >= c)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (B >= C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (B >= C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (b >= c)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (b >= c)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (b >= C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (b >= C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (B >= c)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (B >= c)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (B >= C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (B >= C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (b >= c)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (b >= c)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (b >= C)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (b >= C)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (B >= c)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (B >= c)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (B >= C)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (B >= C)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (b >= c)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (b >= c)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (b >= C)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (b >= C)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (B >= c)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (B >= c)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (B >= C)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (B >= C)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ge)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (b != c)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (b != c)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (b != C)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (b != C)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (B != c)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (B != c)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a || (B != C)) && d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(a || (B != C)) && D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (b != c)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (b != c)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (b != C)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (b != C)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (B != c)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (B != c)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(A || (B != C)) && d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(d)
8 make_bool()
$ test-expr '\''!(A || (B != C)) && D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 jump_false(eos)
7 call_builtin(D)
$ test-expr '\''!(a && b) >= (c != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a && b) >= (c != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a && b) >= (C != d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a && b) >= (C != D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a && B) >= (c != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a && B) >= (c != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a && B) >= (C != d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a && B) >= (C != D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A && b) >= (c != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A && b) >= (c != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A && b) >= (C != d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A && b) >= (C != D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A && B) >= (c != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A && B) >= (c != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A && B) >= (C != d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A && B) >= (C != D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a || b) >= (c != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a || b) >= (c != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a || b) >= (C != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a || b) >= (C != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(a || B) >= (c != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a || B) >= (c != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a || B) >= (C != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a || B) >= (C != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A || b) >= (c != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A || b) >= (c != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A || b) >= (C != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A || b) >= (C != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
8 cmp_op(ge)
$ test-expr '\''!(A || B) >= (c != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A || B) >= (c != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A || B) >= (C != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(A || B) >= (C != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 cmp_op(ge)
$ test-expr '\''!(a || b) >= (c && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(a || b) >= (c && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || b) >= (C && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(a || b) >= (C && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || B) >= (c && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a || B) >= (c && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || B) >= (C && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(a || B) >= (C && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || b) >= (c && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(A || b) >= (c && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || b) >= (C && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''!(A || b) >= (C && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || B) >= (c && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A || B) >= (c && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || B) >= (C && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ge)
$ test-expr '\''!(A || B) >= (C && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || b) != (c && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(a || b) != (c && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || b) != (C && d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(a || b) != (C && D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || B) != (c && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a || B) != (c && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || B) != (C && d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(a || B) != (C && D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || b) != (c && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(A || b) != (c && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || b) != (C && d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(9)
7 call_builtin(d)
8 make_bool()
9 cmp_op(ne)
$ test-expr '\''!(A || b) != (C && D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 jump_false(8)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || B) != (c && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A || B) != (c && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || B) != (C && d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 cmp_op(ne)
$ test-expr '\''!(A || B) != (C && D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 jump_false(7)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a && !(b >= (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b >= (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b >= (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(b >= (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (c != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (c != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (C != d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !(B >= (C != D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(b >= (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (c != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (c != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (C != d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !(B >= (C != D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ne)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !(b >= (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b >= (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !(b >= (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !(B >= (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B >= (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !(B >= (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !(b >= (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b >= (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !(b >= (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !(B >= (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B >= (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !(B >= (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b != (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !(b != (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b != (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !(b != (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (c && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !(B != (c && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (C && d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !(B != (C && D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !(b != (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !(b != (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (c && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !(B != (c && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (C && d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !(B != (C && D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 jump_false(6)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''!((a && b) != c) >= d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a && b) != c) >= D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a && b) != C) >= d'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a && b) != C) >= D'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a && B) != c) >= d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a && B) != c) >= D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a && B) != C) >= d'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a && B) != C) >= D'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A && b) != c) >= d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A && b) != c) >= D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A && b) != C) >= d'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A && b) != C) >= D'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A && B) != c) >= d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A && B) != c) >= D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A && B) != C) >= d'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A && B) != C) >= D'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a || b) != c) >= d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a || b) != c) >= D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a || b) != C) >= d'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a || b) != C) >= D'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a || B) != c) >= d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a || B) != c) >= D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a || B) != C) >= d'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a || B) != C) >= D'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A || b) != c) >= d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A || b) != c) >= D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A || b) != C) >= d'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A || b) != C) >= D'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(C)
5 cmp_op(ne)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A || B) != c) >= d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A || B) != c) >= D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A || B) != C) >= d'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A || B) != C) >= D'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a || b) && c) >= d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ge)
$ test-expr '\''!((a || b) && c) >= D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ge)
$ test-expr '\''!((a || b) && C) >= d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a || b) && C) >= D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a || B) && c) >= d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((a || B) && c) >= D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((a || B) && C) >= d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((a || B) && C) >= D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((A || b) && c) >= d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ge)
$ test-expr '\''!((A || b) && c) >= D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ge)
$ test-expr '\''!((A || b) && C) >= d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A || b) && C) >= D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A || B) && c) >= d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!((A || B) && c) >= D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!((A || B) && C) >= d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!((A || B) && C) >= D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!((a || b) && c) != d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ne)
$ test-expr '\''!((a || b) && c) != D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ne)
$ test-expr '\''!((a || b) && C) != d'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a || b) && C) != D'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a || B) && c) != d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((a || B) && c) != D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((a || B) && C) != d'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((a || B) && C) != D'\''
0 call_builtin(a)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!((A || b) && c) != d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(d)
9 cmp_op(ne)
$ test-expr '\''!((A || b) && c) != D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(7)
5 call_builtin(c)
6 make_bool()
7 not_op()
8 call_builtin(D)
9 cmp_op(ne)
$ test-expr '\''!((A || b) && C) != d'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A || b) && C) != D'\''
0 call_builtin(A)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(6)
5 call_builtin(C)
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A || B) && c) != d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!((A || B) && c) != D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!((A || B) && C) != d'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!((A || B) && C) != D'\''
0 call_builtin(A)
1 jump_true*(4)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a && !((b != c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((b != c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((b != C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((b != C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B != c) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B != c) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B != C) >= d)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a && !((B != C) >= D)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b != c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b != c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b != C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((b != C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B != c) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B != c) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B != C) >= d)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A && !((B != C) >= D)'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b != c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b != c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b != C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b != C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B != c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B != c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B != C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B != C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b != c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b != c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b != C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b != C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B != c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B != c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B != C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B != C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b && c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !((b && c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !((b && C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b && C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B && c) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !((B && c) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''a || !((B && C) >= d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((B && C) >= D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b && c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !((b && c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !((b && C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((b && C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B && c) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !((B && c) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ge)
8 not_op()
$ test-expr '\''A || !((B && C) >= d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !((B && C) >= D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !((b && c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !((b && c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !((b && C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((b && C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B && c) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !((B && c) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''a || !((B && C) != d)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !((B && C) != D)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b && c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !((b && c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !((b && C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((b && C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B && c) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !((B && c) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(D)
7 cmp_op(ne)
8 not_op()
$ test-expr '\''A || !((B && C) != d)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !((B && C) != D)'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''!(a && (b != c)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (b != c)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (b != C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (b != C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (B != c)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (B != c)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a && (B != C)) >= d'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a && (B != C)) >= D'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (b != c)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (b != c)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (b != C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (b != C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (B != c)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (B != c)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A && (B != C)) >= d'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A && (B != C)) >= D'\''
0 call_builtin(A)
1 jump_false(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (b != c)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (b != c)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (b != C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (b != C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (B != c)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (B != c)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (B != C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (B != C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (b != c)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (b != c)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (b != C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (b != C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (B != c)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (B != c)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(c)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (B != C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (B != C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 call_builtin(C)
4 cmp_op(ne)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (b && c)) >= d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a || (b && c)) >= D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || (b && C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (b && C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (B && c)) >= d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a || (B && c)) >= D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || (B && C)) >= d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || (B && C)) >= D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (b && c)) >= d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A || (b && c)) >= D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || (b && C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (b && C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || (B && c)) >= d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A || (B && c)) >= D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || (B && C)) >= d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || (B && C)) >= D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || (b && c)) != d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a || (b && c)) != D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || (b && C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (b && C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || (B && c)) != d'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a || (B && c)) != D'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || (B && C)) != d'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || (B && C)) != D'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (b && c)) != d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A || (b && c)) != D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || (b && C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (b && C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(b)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || (B && c)) != d'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A || (B && c)) != D'\''
0 call_builtin(A)
1 jump_true(6)
2 call_builtin(B)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 not_op()
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || (B && C)) != d'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || (B && C)) != D'\''
0 call_builtin(A)
1 jump_true(5)
2 call_builtin(B)
3 jump_false(5)
4 call_builtin(C)
5 not_op()
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a && b) != (c >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a && b) != (c >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a && b) != (C >= d)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a && b) != (C >= D)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a && B) != (c >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a && B) != (c >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a && B) != (C >= d)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a && B) != (C >= D)'\''
0 call_builtin(a)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A && b) != (c >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A && b) != (c >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A && b) != (C >= d)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A && b) != (C >= D)'\''
0 call_builtin(A)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A && B) != (c >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A && B) != (c >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A && B) != (C >= d)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A && B) != (C >= D)'\''
0 call_builtin(A)
1 jump_false(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a || b) != (c >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a || b) != (c >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a || b) != (C >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a || b) != (C >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(a || B) != (c >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a || B) != (c >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a || B) != (C >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a || B) != (C >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A || b) != (c >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A || b) != (c >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A || b) != (C >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A || b) != (C >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
8 cmp_op(ne)
$ test-expr '\''!(A || B) != (c >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A || B) != (c >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A || B) != (C >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(A || B) != (C >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 cmp_op(ne)
$ test-expr '\''!(a || b) && (c >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a || b) && (c >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || b) && (C >= d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(a || b) && (C >= D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(a || B) && (c >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || B) && (c >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || B) && (C >= d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(a || B) && (C >= D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || b) && (c >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A || b) && (c >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || b) && (C >= d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ge)
$ test-expr '\''!(A || b) && (C >= D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ge)
$ test-expr '\''!(A || B) && (c >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || B) && (c >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(A || B) && (C >= d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ge)
$ test-expr '\''!(A || B) && (C >= D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ge)
$ test-expr '\''!(a || b) && (c != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a || b) && (c != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || b) && (C != d)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(a || b) && (C != D)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(a || B) && (c != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || B) && (c != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(a || B) && (C != d)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(a || B) && (C != D)'\''
0 call_builtin(a)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || b) && (c != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A || b) && (c != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(c)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || b) && (C != d)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(d)
8 cmp_op(ne)
$ test-expr '\''!(A || b) && (C != D)'\''
0 call_builtin(A)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 not_op()
5 jump_false(eos)
6 call_builtin(C)
7 call_builtin(D)
8 cmp_op(ne)
$ test-expr '\''!(A || B) && (c != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || B) && (c != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''!(A || B) && (C != d)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(d)
7 cmp_op(ne)
$ test-expr '\''!(A || B) && (C != D)'\''
0 call_builtin(A)
1 jump_true(3)
2 call_builtin(B)
3 not_op()
4 jump_false(eos)
5 call_builtin(C)
6 call_builtin(D)
7 cmp_op(ne)
$ test-expr '\''a && !(b != (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b != (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b != (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(b != (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (c >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (c >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (C >= d))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a && !(B != (C >= D))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(b != (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (c >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (c >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (C >= d))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A && !(B != (C >= D))'\''
0 call_builtin(A)
1 jump_false(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b != (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b != (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b != (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b != (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B != (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b != (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(c)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B != (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 call_builtin(C)
4 call_builtin(D)
5 cmp_op(ge)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b && (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b && (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b && (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b && (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B && (c >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B && (c >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B && (C >= d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(B && (C >= D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b && (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b && (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b && (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(b && (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B && (c >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B && (c >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B && (C >= d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''A || !(B && (C >= D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ge)
7 not_op()
$ test-expr '\''a || !(b && (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b && (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b && (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(b && (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B && (c != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B && (c != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B && (C != d))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''a || !(B && (C != D))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b && (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b && (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b && (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(b && (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B && (c != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B && (c != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B && (C != d))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(d)
6 cmp_op(ne)
7 not_op()
$ test-expr '\''A || !(B && (C != D))'\''
0 call_builtin(A)
1 jump_true(eos)
2 call_builtin(B)
3 jump_false(7)
4 call_builtin(C)
5 call_builtin(D)
6 cmp_op(ne)
7 not_op()'
) -L op14.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr '\''!((a >= b) != c) && d'\'''
test-expr '!((a >= b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != c) && d'\'''

echo '$ test-expr '\''!((a >= b) != c) && D'\'''
test-expr '!((a >= b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != c) && D'\'''

echo '$ test-expr '\''!((a >= b) != C) && d'\'''
test-expr '!((a >= b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != C) && d'\'''

echo '$ test-expr '\''!((a >= b) != C) && D'\'''
test-expr '!((a >= b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != C) && D'\'''

echo '$ test-expr '\''!((a >= B) != c) && d'\'''
test-expr '!((a >= B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != c) && d'\'''

echo '$ test-expr '\''!((a >= B) != c) && D'\'''
test-expr '!((a >= B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != c) && D'\'''

echo '$ test-expr '\''!((a >= B) != C) && d'\'''
test-expr '!((a >= B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != C) && d'\'''

echo '$ test-expr '\''!((a >= B) != C) && D'\'''
test-expr '!((a >= B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != C) && D'\'''

echo '$ test-expr '\''!((A >= b) != c) && d'\'''
test-expr '!((A >= b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != c) && d'\'''

echo '$ test-expr '\''!((A >= b) != c) && D'\'''
test-expr '!((A >= b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != c) && D'\'''

echo '$ test-expr '\''!((A >= b) != C) && d'\'''
test-expr '!((A >= b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != C) && d'\'''

echo '$ test-expr '\''!((A >= b) != C) && D'\'''
test-expr '!((A >= b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != C) && D'\'''

echo '$ test-expr '\''!((A >= B) != c) && d'\'''
test-expr '!((A >= B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != c) && d'\'''

echo '$ test-expr '\''!((A >= B) != c) && D'\'''
test-expr '!((A >= B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != c) && D'\'''

echo '$ test-expr '\''!((A >= B) != C) && d'\'''
test-expr '!((A >= B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != C) && d'\'''

echo '$ test-expr '\''!((A >= B) != C) && D'\'''
test-expr '!((A >= B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != C) && D'\'''

echo '$ test-expr '\''!((a >= b) != c) || d'\'''
test-expr '!((a >= b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != c) || d'\'''

echo '$ test-expr '\''!((a >= b) != c) || D'\'''
test-expr '!((a >= b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != c) || D'\'''

echo '$ test-expr '\''!((a >= b) != C) || d'\'''
test-expr '!((a >= b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != C) || d'\'''

echo '$ test-expr '\''!((a >= b) != C) || D'\'''
test-expr '!((a >= b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) != C) || D'\'''

echo '$ test-expr '\''!((a >= B) != c) || d'\'''
test-expr '!((a >= B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != c) || d'\'''

echo '$ test-expr '\''!((a >= B) != c) || D'\'''
test-expr '!((a >= B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != c) || D'\'''

echo '$ test-expr '\''!((a >= B) != C) || d'\'''
test-expr '!((a >= B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != C) || d'\'''

echo '$ test-expr '\''!((a >= B) != C) || D'\'''
test-expr '!((a >= B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) != C) || D'\'''

echo '$ test-expr '\''!((A >= b) != c) || d'\'''
test-expr '!((A >= b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != c) || d'\'''

echo '$ test-expr '\''!((A >= b) != c) || D'\'''
test-expr '!((A >= b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != c) || D'\'''

echo '$ test-expr '\''!((A >= b) != C) || d'\'''
test-expr '!((A >= b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != C) || d'\'''

echo '$ test-expr '\''!((A >= b) != C) || D'\'''
test-expr '!((A >= b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) != C) || D'\'''

echo '$ test-expr '\''!((A >= B) != c) || d'\'''
test-expr '!((A >= B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != c) || d'\'''

echo '$ test-expr '\''!((A >= B) != c) || D'\'''
test-expr '!((A >= B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != c) || D'\'''

echo '$ test-expr '\''!((A >= B) != C) || d'\'''
test-expr '!((A >= B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != C) || d'\'''

echo '$ test-expr '\''!((A >= B) != C) || D'\'''
test-expr '!((A >= B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) != C) || D'\'''

echo '$ test-expr '\''!((a >= b) && c) || d'\'''
test-expr '!((a >= b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && c) || d'\'''

echo '$ test-expr '\''!((a >= b) && c) || D'\'''
test-expr '!((a >= b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && c) || D'\'''

echo '$ test-expr '\''!((a >= b) && C) || d'\'''
test-expr '!((a >= b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && C) || d'\'''

echo '$ test-expr '\''!((a >= b) && C) || D'\'''
test-expr '!((a >= b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && C) || D'\'''

echo '$ test-expr '\''!((a >= B) && c) || d'\'''
test-expr '!((a >= B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && c) || d'\'''

echo '$ test-expr '\''!((a >= B) && c) || D'\'''
test-expr '!((a >= B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && c) || D'\'''

echo '$ test-expr '\''!((a >= B) && C) || d'\'''
test-expr '!((a >= B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && C) || d'\'''

echo '$ test-expr '\''!((a >= B) && C) || D'\'''
test-expr '!((a >= B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && C) || D'\'''

echo '$ test-expr '\''!((A >= b) && c) || d'\'''
test-expr '!((A >= b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && c) || d'\'''

echo '$ test-expr '\''!((A >= b) && c) || D'\'''
test-expr '!((A >= b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && c) || D'\'''

echo '$ test-expr '\''!((A >= b) && C) || d'\'''
test-expr '!((A >= b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && C) || d'\'''

echo '$ test-expr '\''!((A >= b) && C) || D'\'''
test-expr '!((A >= b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && C) || D'\'''

echo '$ test-expr '\''!((A >= B) && c) || d'\'''
test-expr '!((A >= B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && c) || d'\'''

echo '$ test-expr '\''!((A >= B) && c) || D'\'''
test-expr '!((A >= B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && c) || D'\'''

echo '$ test-expr '\''!((A >= B) && C) || d'\'''
test-expr '!((A >= B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && C) || d'\'''

echo '$ test-expr '\''!((A >= B) && C) || D'\'''
test-expr '!((A >= B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && C) || D'\'''

echo '$ test-expr '\''!((a != b) && c) || d'\'''
test-expr '!((a != b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && c) || d'\'''

echo '$ test-expr '\''!((a != b) && c) || D'\'''
test-expr '!((a != b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && c) || D'\'''

echo '$ test-expr '\''!((a != b) && C) || d'\'''
test-expr '!((a != b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && C) || d'\'''

echo '$ test-expr '\''!((a != b) && C) || D'\'''
test-expr '!((a != b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && C) || D'\'''

echo '$ test-expr '\''!((a != B) && c) || d'\'''
test-expr '!((a != B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && c) || d'\'''

echo '$ test-expr '\''!((a != B) && c) || D'\'''
test-expr '!((a != B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && c) || D'\'''

echo '$ test-expr '\''!((a != B) && C) || d'\'''
test-expr '!((a != B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && C) || d'\'''

echo '$ test-expr '\''!((a != B) && C) || D'\'''
test-expr '!((a != B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && C) || D'\'''

echo '$ test-expr '\''!((A != b) && c) || d'\'''
test-expr '!((A != b) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && c) || d'\'''

echo '$ test-expr '\''!((A != b) && c) || D'\'''
test-expr '!((A != b) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && c) || D'\'''

echo '$ test-expr '\''!((A != b) && C) || d'\'''
test-expr '!((A != b) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && C) || d'\'''

echo '$ test-expr '\''!((A != b) && C) || D'\'''
test-expr '!((A != b) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && C) || D'\'''

echo '$ test-expr '\''!((A != B) && c) || d'\'''
test-expr '!((A != B) && c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && c) || d'\'''

echo '$ test-expr '\''!((A != B) && c) || D'\'''
test-expr '!((A != B) && c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && c) || D'\'''

echo '$ test-expr '\''!((A != B) && C) || d'\'''
test-expr '!((A != B) && C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && C) || d'\'''

echo '$ test-expr '\''!((A != B) && C) || D'\'''
test-expr '!((A != B) && C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && C) || D'\'''

echo '$ test-expr '\''a >= !((b != c) && d)'\'''
test-expr 'a >= !((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != c) && d)'\'''

echo '$ test-expr '\''a >= !((b != c) && D)'\'''
test-expr 'a >= !((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != c) && D)'\'''

echo '$ test-expr '\''a >= !((b != C) && d)'\'''
test-expr 'a >= !((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != C) && d)'\'''

echo '$ test-expr '\''a >= !((b != C) && D)'\'''
test-expr 'a >= !((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != C) && D)'\'''

echo '$ test-expr '\''a >= !((B != c) && d)'\'''
test-expr 'a >= !((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != c) && d)'\'''

echo '$ test-expr '\''a >= !((B != c) && D)'\'''
test-expr 'a >= !((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != c) && D)'\'''

echo '$ test-expr '\''a >= !((B != C) && d)'\'''
test-expr 'a >= !((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != C) && d)'\'''

echo '$ test-expr '\''a >= !((B != C) && D)'\'''
test-expr 'a >= !((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != C) && D)'\'''

echo '$ test-expr '\''A >= !((b != c) && d)'\'''
test-expr 'A >= !((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != c) && d)'\'''

echo '$ test-expr '\''A >= !((b != c) && D)'\'''
test-expr 'A >= !((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != c) && D)'\'''

echo '$ test-expr '\''A >= !((b != C) && d)'\'''
test-expr 'A >= !((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != C) && d)'\'''

echo '$ test-expr '\''A >= !((b != C) && D)'\'''
test-expr 'A >= !((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != C) && D)'\'''

echo '$ test-expr '\''A >= !((B != c) && d)'\'''
test-expr 'A >= !((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != c) && d)'\'''

echo '$ test-expr '\''A >= !((B != c) && D)'\'''
test-expr 'A >= !((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != c) && D)'\'''

echo '$ test-expr '\''A >= !((B != C) && d)'\'''
test-expr 'A >= !((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != C) && d)'\'''

echo '$ test-expr '\''A >= !((B != C) && D)'\'''
test-expr 'A >= !((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != C) && D)'\'''

echo '$ test-expr '\''a >= !((b != c) || d)'\'''
test-expr 'a >= !((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != c) || d)'\'''

echo '$ test-expr '\''a >= !((b != c) || D)'\'''
test-expr 'a >= !((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != c) || D)'\'''

echo '$ test-expr '\''a >= !((b != C) || d)'\'''
test-expr 'a >= !((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != C) || d)'\'''

echo '$ test-expr '\''a >= !((b != C) || D)'\'''
test-expr 'a >= !((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b != C) || D)'\'''

echo '$ test-expr '\''a >= !((B != c) || d)'\'''
test-expr 'a >= !((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != c) || d)'\'''

echo '$ test-expr '\''a >= !((B != c) || D)'\'''
test-expr 'a >= !((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != c) || D)'\'''

echo '$ test-expr '\''a >= !((B != C) || d)'\'''
test-expr 'a >= !((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != C) || d)'\'''

echo '$ test-expr '\''a >= !((B != C) || D)'\'''
test-expr 'a >= !((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B != C) || D)'\'''

echo '$ test-expr '\''A >= !((b != c) || d)'\'''
test-expr 'A >= !((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != c) || d)'\'''

echo '$ test-expr '\''A >= !((b != c) || D)'\'''
test-expr 'A >= !((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != c) || D)'\'''

echo '$ test-expr '\''A >= !((b != C) || d)'\'''
test-expr 'A >= !((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != C) || d)'\'''

echo '$ test-expr '\''A >= !((b != C) || D)'\'''
test-expr 'A >= !((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b != C) || D)'\'''

echo '$ test-expr '\''A >= !((B != c) || d)'\'''
test-expr 'A >= !((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != c) || d)'\'''

echo '$ test-expr '\''A >= !((B != c) || D)'\'''
test-expr 'A >= !((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != c) || D)'\'''

echo '$ test-expr '\''A >= !((B != C) || d)'\'''
test-expr 'A >= !((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != C) || d)'\'''

echo '$ test-expr '\''A >= !((B != C) || D)'\'''
test-expr 'A >= !((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B != C) || D)'\'''

echo '$ test-expr '\''a >= !((b && c) || d)'\'''
test-expr 'a >= !((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && c) || d)'\'''

echo '$ test-expr '\''a >= !((b && c) || D)'\'''
test-expr 'a >= !((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && c) || D)'\'''

echo '$ test-expr '\''a >= !((b && C) || d)'\'''
test-expr 'a >= !((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && C) || d)'\'''

echo '$ test-expr '\''a >= !((b && C) || D)'\'''
test-expr 'a >= !((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && C) || D)'\'''

echo '$ test-expr '\''a >= !((B && c) || d)'\'''
test-expr 'a >= !((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && c) || d)'\'''

echo '$ test-expr '\''a >= !((B && c) || D)'\'''
test-expr 'a >= !((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && c) || D)'\'''

echo '$ test-expr '\''a >= !((B && C) || d)'\'''
test-expr 'a >= !((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && C) || d)'\'''

echo '$ test-expr '\''a >= !((B && C) || D)'\'''
test-expr 'a >= !((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && C) || D)'\'''

echo '$ test-expr '\''A >= !((b && c) || d)'\'''
test-expr 'A >= !((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && c) || d)'\'''

echo '$ test-expr '\''A >= !((b && c) || D)'\'''
test-expr 'A >= !((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && c) || D)'\'''

echo '$ test-expr '\''A >= !((b && C) || d)'\'''
test-expr 'A >= !((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && C) || d)'\'''

echo '$ test-expr '\''A >= !((b && C) || D)'\'''
test-expr 'A >= !((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && C) || D)'\'''

echo '$ test-expr '\''A >= !((B && c) || d)'\'''
test-expr 'A >= !((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && c) || d)'\'''

echo '$ test-expr '\''A >= !((B && c) || D)'\'''
test-expr 'A >= !((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && c) || D)'\'''

echo '$ test-expr '\''A >= !((B && C) || d)'\'''
test-expr 'A >= !((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && C) || d)'\'''

echo '$ test-expr '\''A >= !((B && C) || D)'\'''
test-expr 'A >= !((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && C) || D)'\'''

echo '$ test-expr '\''a != !((b && c) || d)'\'''
test-expr 'a != !((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && c) || d)'\'''

echo '$ test-expr '\''a != !((b && c) || D)'\'''
test-expr 'a != !((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && c) || D)'\'''

echo '$ test-expr '\''a != !((b && C) || d)'\'''
test-expr 'a != !((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && C) || d)'\'''

echo '$ test-expr '\''a != !((b && C) || D)'\'''
test-expr 'a != !((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && C) || D)'\'''

echo '$ test-expr '\''a != !((B && c) || d)'\'''
test-expr 'a != !((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && c) || d)'\'''

echo '$ test-expr '\''a != !((B && c) || D)'\'''
test-expr 'a != !((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && c) || D)'\'''

echo '$ test-expr '\''a != !((B && C) || d)'\'''
test-expr 'a != !((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && C) || d)'\'''

echo '$ test-expr '\''a != !((B && C) || D)'\'''
test-expr 'a != !((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && C) || D)'\'''

echo '$ test-expr '\''A != !((b && c) || d)'\'''
test-expr 'A != !((b && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && c) || d)'\'''

echo '$ test-expr '\''A != !((b && c) || D)'\'''
test-expr 'A != !((b && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && c) || D)'\'''

echo '$ test-expr '\''A != !((b && C) || d)'\'''
test-expr 'A != !((b && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && C) || d)'\'''

echo '$ test-expr '\''A != !((b && C) || D)'\'''
test-expr 'A != !((b && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && C) || D)'\'''

echo '$ test-expr '\''A != !((B && c) || d)'\'''
test-expr 'A != !((B && c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && c) || d)'\'''

echo '$ test-expr '\''A != !((B && c) || D)'\'''
test-expr 'A != !((B && c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && c) || D)'\'''

echo '$ test-expr '\''A != !((B && C) || d)'\'''
test-expr 'A != !((B && C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && C) || d)'\'''

echo '$ test-expr '\''A != !((B && C) || D)'\'''
test-expr 'A != !((B && C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && C) || D)'\'''

echo '$ test-expr '\''!(a >= (b != c)) && d'\'''
test-expr '!(a >= (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != c)) && d'\'''

echo '$ test-expr '\''!(a >= (b != c)) && D'\'''
test-expr '!(a >= (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != c)) && D'\'''

echo '$ test-expr '\''!(a >= (b != C)) && d'\'''
test-expr '!(a >= (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != C)) && d'\'''

echo '$ test-expr '\''!(a >= (b != C)) && D'\'''
test-expr '!(a >= (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != C)) && D'\'''

echo '$ test-expr '\''!(a >= (B != c)) && d'\'''
test-expr '!(a >= (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != c)) && d'\'''

echo '$ test-expr '\''!(a >= (B != c)) && D'\'''
test-expr '!(a >= (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != c)) && D'\'''

echo '$ test-expr '\''!(a >= (B != C)) && d'\'''
test-expr '!(a >= (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != C)) && d'\'''

echo '$ test-expr '\''!(a >= (B != C)) && D'\'''
test-expr '!(a >= (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != C)) && D'\'''

echo '$ test-expr '\''!(A >= (b != c)) && d'\'''
test-expr '!(A >= (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != c)) && d'\'''

echo '$ test-expr '\''!(A >= (b != c)) && D'\'''
test-expr '!(A >= (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != c)) && D'\'''

echo '$ test-expr '\''!(A >= (b != C)) && d'\'''
test-expr '!(A >= (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != C)) && d'\'''

echo '$ test-expr '\''!(A >= (b != C)) && D'\'''
test-expr '!(A >= (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != C)) && D'\'''

echo '$ test-expr '\''!(A >= (B != c)) && d'\'''
test-expr '!(A >= (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != c)) && d'\'''

echo '$ test-expr '\''!(A >= (B != c)) && D'\'''
test-expr '!(A >= (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != c)) && D'\'''

echo '$ test-expr '\''!(A >= (B != C)) && d'\'''
test-expr '!(A >= (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != C)) && d'\'''

echo '$ test-expr '\''!(A >= (B != C)) && D'\'''
test-expr '!(A >= (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != C)) && D'\'''

echo '$ test-expr '\''!(a >= (b != c)) || d'\'''
test-expr '!(a >= (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != c)) || d'\'''

echo '$ test-expr '\''!(a >= (b != c)) || D'\'''
test-expr '!(a >= (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != c)) || D'\'''

echo '$ test-expr '\''!(a >= (b != C)) || d'\'''
test-expr '!(a >= (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != C)) || d'\'''

echo '$ test-expr '\''!(a >= (b != C)) || D'\'''
test-expr '!(a >= (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b != C)) || D'\'''

echo '$ test-expr '\''!(a >= (B != c)) || d'\'''
test-expr '!(a >= (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != c)) || d'\'''

echo '$ test-expr '\''!(a >= (B != c)) || D'\'''
test-expr '!(a >= (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != c)) || D'\'''

echo '$ test-expr '\''!(a >= (B != C)) || d'\'''
test-expr '!(a >= (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != C)) || d'\'''

echo '$ test-expr '\''!(a >= (B != C)) || D'\'''
test-expr '!(a >= (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B != C)) || D'\'''

echo '$ test-expr '\''!(A >= (b != c)) || d'\'''
test-expr '!(A >= (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != c)) || d'\'''

echo '$ test-expr '\''!(A >= (b != c)) || D'\'''
test-expr '!(A >= (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != c)) || D'\'''

echo '$ test-expr '\''!(A >= (b != C)) || d'\'''
test-expr '!(A >= (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != C)) || d'\'''

echo '$ test-expr '\''!(A >= (b != C)) || D'\'''
test-expr '!(A >= (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b != C)) || D'\'''

echo '$ test-expr '\''!(A >= (B != c)) || d'\'''
test-expr '!(A >= (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != c)) || d'\'''

echo '$ test-expr '\''!(A >= (B != c)) || D'\'''
test-expr '!(A >= (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != c)) || D'\'''

echo '$ test-expr '\''!(A >= (B != C)) || d'\'''
test-expr '!(A >= (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != C)) || d'\'''

echo '$ test-expr '\''!(A >= (B != C)) || D'\'''
test-expr '!(A >= (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B != C)) || D'\'''

echo '$ test-expr '\''!(a >= (b && c)) || d'\'''
test-expr '!(a >= (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && c)) || d'\'''

echo '$ test-expr '\''!(a >= (b && c)) || D'\'''
test-expr '!(a >= (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && c)) || D'\'''

echo '$ test-expr '\''!(a >= (b && C)) || d'\'''
test-expr '!(a >= (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && C)) || d'\'''

echo '$ test-expr '\''!(a >= (b && C)) || D'\'''
test-expr '!(a >= (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && C)) || D'\'''

echo '$ test-expr '\''!(a >= (B && c)) || d'\'''
test-expr '!(a >= (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && c)) || d'\'''

echo '$ test-expr '\''!(a >= (B && c)) || D'\'''
test-expr '!(a >= (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && c)) || D'\'''

echo '$ test-expr '\''!(a >= (B && C)) || d'\'''
test-expr '!(a >= (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && C)) || d'\'''

echo '$ test-expr '\''!(a >= (B && C)) || D'\'''
test-expr '!(a >= (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && C)) || D'\'''

echo '$ test-expr '\''!(A >= (b && c)) || d'\'''
test-expr '!(A >= (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && c)) || d'\'''

echo '$ test-expr '\''!(A >= (b && c)) || D'\'''
test-expr '!(A >= (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && c)) || D'\'''

echo '$ test-expr '\''!(A >= (b && C)) || d'\'''
test-expr '!(A >= (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && C)) || d'\'''

echo '$ test-expr '\''!(A >= (b && C)) || D'\'''
test-expr '!(A >= (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && C)) || D'\'''

echo '$ test-expr '\''!(A >= (B && c)) || d'\'''
test-expr '!(A >= (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && c)) || d'\'''

echo '$ test-expr '\''!(A >= (B && c)) || D'\'''
test-expr '!(A >= (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && c)) || D'\'''

echo '$ test-expr '\''!(A >= (B && C)) || d'\'''
test-expr '!(A >= (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && C)) || d'\'''

echo '$ test-expr '\''!(A >= (B && C)) || D'\'''
test-expr '!(A >= (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && C)) || D'\'''

echo '$ test-expr '\''!(a != (b && c)) || d'\'''
test-expr '!(a != (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && c)) || d'\'''

echo '$ test-expr '\''!(a != (b && c)) || D'\'''
test-expr '!(a != (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && c)) || D'\'''

echo '$ test-expr '\''!(a != (b && C)) || d'\'''
test-expr '!(a != (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && C)) || d'\'''

echo '$ test-expr '\''!(a != (b && C)) || D'\'''
test-expr '!(a != (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && C)) || D'\'''

echo '$ test-expr '\''!(a != (B && c)) || d'\'''
test-expr '!(a != (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && c)) || d'\'''

echo '$ test-expr '\''!(a != (B && c)) || D'\'''
test-expr '!(a != (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && c)) || D'\'''

echo '$ test-expr '\''!(a != (B && C)) || d'\'''
test-expr '!(a != (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && C)) || d'\'''

echo '$ test-expr '\''!(a != (B && C)) || D'\'''
test-expr '!(a != (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && C)) || D'\'''

echo '$ test-expr '\''!(A != (b && c)) || d'\'''
test-expr '!(A != (b && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && c)) || d'\'''

echo '$ test-expr '\''!(A != (b && c)) || D'\'''
test-expr '!(A != (b && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && c)) || D'\'''

echo '$ test-expr '\''!(A != (b && C)) || d'\'''
test-expr '!(A != (b && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && C)) || d'\'''

echo '$ test-expr '\''!(A != (b && C)) || D'\'''
test-expr '!(A != (b && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && C)) || D'\'''

echo '$ test-expr '\''!(A != (B && c)) || d'\'''
test-expr '!(A != (B && c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && c)) || d'\'''

echo '$ test-expr '\''!(A != (B && c)) || D'\'''
test-expr '!(A != (B && c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && c)) || D'\'''

echo '$ test-expr '\''!(A != (B && C)) || d'\'''
test-expr '!(A != (B && C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && C)) || d'\'''

echo '$ test-expr '\''!(A != (B && C)) || D'\'''
test-expr '!(A != (B && C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && C)) || D'\'''

echo '$ test-expr '\''!(a >= b) != (c && d)'\'''
test-expr '!(a >= b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (c && d)'\'''

echo '$ test-expr '\''!(a >= b) != (c && D)'\'''
test-expr '!(a >= b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (c && D)'\'''

echo '$ test-expr '\''!(a >= b) != (C && d)'\'''
test-expr '!(a >= b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (C && d)'\'''

echo '$ test-expr '\''!(a >= b) != (C && D)'\'''
test-expr '!(a >= b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (C && D)'\'''

echo '$ test-expr '\''!(a >= B) != (c && d)'\'''
test-expr '!(a >= B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (c && d)'\'''

echo '$ test-expr '\''!(a >= B) != (c && D)'\'''
test-expr '!(a >= B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (c && D)'\'''

echo '$ test-expr '\''!(a >= B) != (C && d)'\'''
test-expr '!(a >= B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (C && d)'\'''

echo '$ test-expr '\''!(a >= B) != (C && D)'\'''
test-expr '!(a >= B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (C && D)'\'''

echo '$ test-expr '\''!(A >= b) != (c && d)'\'''
test-expr '!(A >= b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (c && d)'\'''

echo '$ test-expr '\''!(A >= b) != (c && D)'\'''
test-expr '!(A >= b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (c && D)'\'''

echo '$ test-expr '\''!(A >= b) != (C && d)'\'''
test-expr '!(A >= b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (C && d)'\'''

echo '$ test-expr '\''!(A >= b) != (C && D)'\'''
test-expr '!(A >= b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (C && D)'\'''

echo '$ test-expr '\''!(A >= B) != (c && d)'\'''
test-expr '!(A >= B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (c && d)'\'''

echo '$ test-expr '\''!(A >= B) != (c && D)'\'''
test-expr '!(A >= B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (c && D)'\'''

echo '$ test-expr '\''!(A >= B) != (C && d)'\'''
test-expr '!(A >= B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (C && d)'\'''

echo '$ test-expr '\''!(A >= B) != (C && D)'\'''
test-expr '!(A >= B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (C && D)'\'''

echo '$ test-expr '\''!(a >= b) != (c || d)'\'''
test-expr '!(a >= b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (c || d)'\'''

echo '$ test-expr '\''!(a >= b) != (c || D)'\'''
test-expr '!(a >= b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (c || D)'\'''

echo '$ test-expr '\''!(a >= b) != (C || d)'\'''
test-expr '!(a >= b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (C || d)'\'''

echo '$ test-expr '\''!(a >= b) != (C || D)'\'''
test-expr '!(a >= b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) != (C || D)'\'''

echo '$ test-expr '\''!(a >= B) != (c || d)'\'''
test-expr '!(a >= B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (c || d)'\'''

echo '$ test-expr '\''!(a >= B) != (c || D)'\'''
test-expr '!(a >= B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (c || D)'\'''

echo '$ test-expr '\''!(a >= B) != (C || d)'\'''
test-expr '!(a >= B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (C || d)'\'''

echo '$ test-expr '\''!(a >= B) != (C || D)'\'''
test-expr '!(a >= B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) != (C || D)'\'''

echo '$ test-expr '\''!(A >= b) != (c || d)'\'''
test-expr '!(A >= b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (c || d)'\'''

echo '$ test-expr '\''!(A >= b) != (c || D)'\'''
test-expr '!(A >= b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (c || D)'\'''

echo '$ test-expr '\''!(A >= b) != (C || d)'\'''
test-expr '!(A >= b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (C || d)'\'''

echo '$ test-expr '\''!(A >= b) != (C || D)'\'''
test-expr '!(A >= b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) != (C || D)'\'''

echo '$ test-expr '\''!(A >= B) != (c || d)'\'''
test-expr '!(A >= B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (c || d)'\'''

echo '$ test-expr '\''!(A >= B) != (c || D)'\'''
test-expr '!(A >= B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (c || D)'\'''

echo '$ test-expr '\''!(A >= B) != (C || d)'\'''
test-expr '!(A >= B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (C || d)'\'''

echo '$ test-expr '\''!(A >= B) != (C || D)'\'''
test-expr '!(A >= B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) != (C || D)'\'''

echo '$ test-expr '\''!(a >= b) && (c || d)'\'''
test-expr '!(a >= b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (c || d)'\'''

echo '$ test-expr '\''!(a >= b) && (c || D)'\'''
test-expr '!(a >= b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (c || D)'\'''

echo '$ test-expr '\''!(a >= b) && (C || d)'\'''
test-expr '!(a >= b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (C || d)'\'''

echo '$ test-expr '\''!(a >= b) && (C || D)'\'''
test-expr '!(a >= b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (C || D)'\'''

echo '$ test-expr '\''!(a >= B) && (c || d)'\'''
test-expr '!(a >= B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (c || d)'\'''

echo '$ test-expr '\''!(a >= B) && (c || D)'\'''
test-expr '!(a >= B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (c || D)'\'''

echo '$ test-expr '\''!(a >= B) && (C || d)'\'''
test-expr '!(a >= B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (C || d)'\'''

echo '$ test-expr '\''!(a >= B) && (C || D)'\'''
test-expr '!(a >= B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (C || D)'\'''

echo '$ test-expr '\''!(A >= b) && (c || d)'\'''
test-expr '!(A >= b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (c || d)'\'''

echo '$ test-expr '\''!(A >= b) && (c || D)'\'''
test-expr '!(A >= b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (c || D)'\'''

echo '$ test-expr '\''!(A >= b) && (C || d)'\'''
test-expr '!(A >= b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (C || d)'\'''

echo '$ test-expr '\''!(A >= b) && (C || D)'\'''
test-expr '!(A >= b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (C || D)'\'''

echo '$ test-expr '\''!(A >= B) && (c || d)'\'''
test-expr '!(A >= B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (c || d)'\'''

echo '$ test-expr '\''!(A >= B) && (c || D)'\'''
test-expr '!(A >= B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (c || D)'\'''

echo '$ test-expr '\''!(A >= B) && (C || d)'\'''
test-expr '!(A >= B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (C || d)'\'''

echo '$ test-expr '\''!(A >= B) && (C || D)'\'''
test-expr '!(A >= B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (C || D)'\'''

echo '$ test-expr '\''!(a != b) && (c || d)'\'''
test-expr '!(a != b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (c || d)'\'''

echo '$ test-expr '\''!(a != b) && (c || D)'\'''
test-expr '!(a != b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (c || D)'\'''

echo '$ test-expr '\''!(a != b) && (C || d)'\'''
test-expr '!(a != b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (C || d)'\'''

echo '$ test-expr '\''!(a != b) && (C || D)'\'''
test-expr '!(a != b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (C || D)'\'''

echo '$ test-expr '\''!(a != B) && (c || d)'\'''
test-expr '!(a != B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (c || d)'\'''

echo '$ test-expr '\''!(a != B) && (c || D)'\'''
test-expr '!(a != B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (c || D)'\'''

echo '$ test-expr '\''!(a != B) && (C || d)'\'''
test-expr '!(a != B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (C || d)'\'''

echo '$ test-expr '\''!(a != B) && (C || D)'\'''
test-expr '!(a != B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (C || D)'\'''

echo '$ test-expr '\''!(A != b) && (c || d)'\'''
test-expr '!(A != b) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (c || d)'\'''

echo '$ test-expr '\''!(A != b) && (c || D)'\'''
test-expr '!(A != b) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (c || D)'\'''

echo '$ test-expr '\''!(A != b) && (C || d)'\'''
test-expr '!(A != b) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (C || d)'\'''

echo '$ test-expr '\''!(A != b) && (C || D)'\'''
test-expr '!(A != b) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (C || D)'\'''

echo '$ test-expr '\''!(A != B) && (c || d)'\'''
test-expr '!(A != B) && (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (c || d)'\'''

echo '$ test-expr '\''!(A != B) && (c || D)'\'''
test-expr '!(A != B) && (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (c || D)'\'''

echo '$ test-expr '\''!(A != B) && (C || d)'\'''
test-expr '!(A != B) && (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (C || d)'\'''

echo '$ test-expr '\''!(A != B) && (C || D)'\'''
test-expr '!(A != B) && (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (C || D)'\'''

echo '$ test-expr '\''a >= !(b != (c && d))'\'''
test-expr 'a >= !(b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (c && d))'\'''

echo '$ test-expr '\''a >= !(b != (c && D))'\'''
test-expr 'a >= !(b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (c && D))'\'''

echo '$ test-expr '\''a >= !(b != (C && d))'\'''
test-expr 'a >= !(b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (C && d))'\'''

echo '$ test-expr '\''a >= !(b != (C && D))'\'''
test-expr 'a >= !(b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (C && D))'\'''

echo '$ test-expr '\''a >= !(B != (c && d))'\'''
test-expr 'a >= !(B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (c && d))'\'''

echo '$ test-expr '\''a >= !(B != (c && D))'\'''
test-expr 'a >= !(B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (c && D))'\'''

echo '$ test-expr '\''a >= !(B != (C && d))'\'''
test-expr 'a >= !(B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (C && d))'\'''

echo '$ test-expr '\''a >= !(B != (C && D))'\'''
test-expr 'a >= !(B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (C && D))'\'''

echo '$ test-expr '\''A >= !(b != (c && d))'\'''
test-expr 'A >= !(b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (c && d))'\'''

echo '$ test-expr '\''A >= !(b != (c && D))'\'''
test-expr 'A >= !(b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (c && D))'\'''

echo '$ test-expr '\''A >= !(b != (C && d))'\'''
test-expr 'A >= !(b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (C && d))'\'''

echo '$ test-expr '\''A >= !(b != (C && D))'\'''
test-expr 'A >= !(b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (C && D))'\'''

echo '$ test-expr '\''A >= !(B != (c && d))'\'''
test-expr 'A >= !(B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (c && d))'\'''

echo '$ test-expr '\''A >= !(B != (c && D))'\'''
test-expr 'A >= !(B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (c && D))'\'''

echo '$ test-expr '\''A >= !(B != (C && d))'\'''
test-expr 'A >= !(B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (C && d))'\'''

echo '$ test-expr '\''A >= !(B != (C && D))'\'''
test-expr 'A >= !(B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (C && D))'\'''

echo '$ test-expr '\''a >= !(b != (c || d))'\'''
test-expr 'a >= !(b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (c || d))'\'''

echo '$ test-expr '\''a >= !(b != (c || D))'\'''
test-expr 'a >= !(b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (c || D))'\'''

echo '$ test-expr '\''a >= !(b != (C || d))'\'''
test-expr 'a >= !(b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (C || d))'\'''

echo '$ test-expr '\''a >= !(b != (C || D))'\'''
test-expr 'a >= !(b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b != (C || D))'\'''

echo '$ test-expr '\''a >= !(B != (c || d))'\'''
test-expr 'a >= !(B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (c || d))'\'''

echo '$ test-expr '\''a >= !(B != (c || D))'\'''
test-expr 'a >= !(B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (c || D))'\'''

echo '$ test-expr '\''a >= !(B != (C || d))'\'''
test-expr 'a >= !(B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (C || d))'\'''

echo '$ test-expr '\''a >= !(B != (C || D))'\'''
test-expr 'a >= !(B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B != (C || D))'\'''

echo '$ test-expr '\''A >= !(b != (c || d))'\'''
test-expr 'A >= !(b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (c || d))'\'''

echo '$ test-expr '\''A >= !(b != (c || D))'\'''
test-expr 'A >= !(b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (c || D))'\'''

echo '$ test-expr '\''A >= !(b != (C || d))'\'''
test-expr 'A >= !(b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (C || d))'\'''

echo '$ test-expr '\''A >= !(b != (C || D))'\'''
test-expr 'A >= !(b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b != (C || D))'\'''

echo '$ test-expr '\''A >= !(B != (c || d))'\'''
test-expr 'A >= !(B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (c || d))'\'''

echo '$ test-expr '\''A >= !(B != (c || D))'\'''
test-expr 'A >= !(B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (c || D))'\'''

echo '$ test-expr '\''A >= !(B != (C || d))'\'''
test-expr 'A >= !(B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (C || d))'\'''

echo '$ test-expr '\''A >= !(B != (C || D))'\'''
test-expr 'A >= !(B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B != (C || D))'\'''

echo '$ test-expr '\''a >= !(b && (c || d))'\'''
test-expr 'a >= !(b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (c || d))'\'''

echo '$ test-expr '\''a >= !(b && (c || D))'\'''
test-expr 'a >= !(b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (c || D))'\'''

echo '$ test-expr '\''a >= !(b && (C || d))'\'''
test-expr 'a >= !(b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (C || d))'\'''

echo '$ test-expr '\''a >= !(b && (C || D))'\'''
test-expr 'a >= !(b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (C || D))'\'''

echo '$ test-expr '\''a >= !(B && (c || d))'\'''
test-expr 'a >= !(B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (c || d))'\'''

echo '$ test-expr '\''a >= !(B && (c || D))'\'''
test-expr 'a >= !(B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (c || D))'\'''

echo '$ test-expr '\''a >= !(B && (C || d))'\'''
test-expr 'a >= !(B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (C || d))'\'''

echo '$ test-expr '\''a >= !(B && (C || D))'\'''
test-expr 'a >= !(B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (C || D))'\'''

echo '$ test-expr '\''A >= !(b && (c || d))'\'''
test-expr 'A >= !(b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (c || d))'\'''

echo '$ test-expr '\''A >= !(b && (c || D))'\'''
test-expr 'A >= !(b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (c || D))'\'''

echo '$ test-expr '\''A >= !(b && (C || d))'\'''
test-expr 'A >= !(b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (C || d))'\'''

echo '$ test-expr '\''A >= !(b && (C || D))'\'''
test-expr 'A >= !(b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (C || D))'\'''

echo '$ test-expr '\''A >= !(B && (c || d))'\'''
test-expr 'A >= !(B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (c || d))'\'''

echo '$ test-expr '\''A >= !(B && (c || D))'\'''
test-expr 'A >= !(B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (c || D))'\'''

echo '$ test-expr '\''A >= !(B && (C || d))'\'''
test-expr 'A >= !(B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (C || d))'\'''

echo '$ test-expr '\''A >= !(B && (C || D))'\'''
test-expr 'A >= !(B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (C || D))'\'''

echo '$ test-expr '\''a != !(b && (c || d))'\'''
test-expr 'a != !(b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (c || d))'\'''

echo '$ test-expr '\''a != !(b && (c || D))'\'''
test-expr 'a != !(b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (c || D))'\'''

echo '$ test-expr '\''a != !(b && (C || d))'\'''
test-expr 'a != !(b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (C || d))'\'''

echo '$ test-expr '\''a != !(b && (C || D))'\'''
test-expr 'a != !(b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (C || D))'\'''

echo '$ test-expr '\''a != !(B && (c || d))'\'''
test-expr 'a != !(B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (c || d))'\'''

echo '$ test-expr '\''a != !(B && (c || D))'\'''
test-expr 'a != !(B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (c || D))'\'''

echo '$ test-expr '\''a != !(B && (C || d))'\'''
test-expr 'a != !(B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (C || d))'\'''

echo '$ test-expr '\''a != !(B && (C || D))'\'''
test-expr 'a != !(B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (C || D))'\'''

echo '$ test-expr '\''A != !(b && (c || d))'\'''
test-expr 'A != !(b && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (c || d))'\'''

echo '$ test-expr '\''A != !(b && (c || D))'\'''
test-expr 'A != !(b && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (c || D))'\'''

echo '$ test-expr '\''A != !(b && (C || d))'\'''
test-expr 'A != !(b && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (C || d))'\'''

echo '$ test-expr '\''A != !(b && (C || D))'\'''
test-expr 'A != !(b && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (C || D))'\'''

echo '$ test-expr '\''A != !(B && (c || d))'\'''
test-expr 'A != !(B && (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (c || d))'\'''

echo '$ test-expr '\''A != !(B && (c || D))'\'''
test-expr 'A != !(B && (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (c || D))'\'''

echo '$ test-expr '\''A != !(B && (C || d))'\'''
test-expr 'A != !(B && (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (C || d))'\'''

echo '$ test-expr '\''A != !(B && (C || D))'\'''
test-expr 'A != !(B && (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (C || D))'\'''

echo '$ test-expr '\''!((a >= b) && c) != d'\'''
test-expr '!((a >= b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && c) != d'\'''

echo '$ test-expr '\''!((a >= b) && c) != D'\'''
test-expr '!((a >= b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && c) != D'\'''

echo '$ test-expr '\''!((a >= b) && C) != d'\'''
test-expr '!((a >= b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && C) != d'\'''

echo '$ test-expr '\''!((a >= b) && C) != D'\'''
test-expr '!((a >= b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) && C) != D'\'''

echo '$ test-expr '\''!((a >= B) && c) != d'\'''
test-expr '!((a >= B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && c) != d'\'''

echo '$ test-expr '\''!((a >= B) && c) != D'\'''
test-expr '!((a >= B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && c) != D'\'''

echo '$ test-expr '\''!((a >= B) && C) != d'\'''
test-expr '!((a >= B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && C) != d'\'''

echo '$ test-expr '\''!((a >= B) && C) != D'\'''
test-expr '!((a >= B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) && C) != D'\'''

echo '$ test-expr '\''!((A >= b) && c) != d'\'''
test-expr '!((A >= b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && c) != d'\'''

echo '$ test-expr '\''!((A >= b) && c) != D'\'''
test-expr '!((A >= b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && c) != D'\'''

echo '$ test-expr '\''!((A >= b) && C) != d'\'''
test-expr '!((A >= b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && C) != d'\'''

echo '$ test-expr '\''!((A >= b) && C) != D'\'''
test-expr '!((A >= b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) && C) != D'\'''

echo '$ test-expr '\''!((A >= B) && c) != d'\'''
test-expr '!((A >= B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && c) != d'\'''

echo '$ test-expr '\''!((A >= B) && c) != D'\'''
test-expr '!((A >= B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && c) != D'\'''

echo '$ test-expr '\''!((A >= B) && C) != d'\'''
test-expr '!((A >= B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && C) != d'\'''

echo '$ test-expr '\''!((A >= B) && C) != D'\'''
test-expr '!((A >= B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) && C) != D'\'''

echo '$ test-expr '\''!((a >= b) || c) != d'\'''
test-expr '!((a >= b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || c) != d'\'''

echo '$ test-expr '\''!((a >= b) || c) != D'\'''
test-expr '!((a >= b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || c) != D'\'''

echo '$ test-expr '\''!((a >= b) || C) != d'\'''
test-expr '!((a >= b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || C) != d'\'''

echo '$ test-expr '\''!((a >= b) || C) != D'\'''
test-expr '!((a >= b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || C) != D'\'''

echo '$ test-expr '\''!((a >= B) || c) != d'\'''
test-expr '!((a >= B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || c) != d'\'''

echo '$ test-expr '\''!((a >= B) || c) != D'\'''
test-expr '!((a >= B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || c) != D'\'''

echo '$ test-expr '\''!((a >= B) || C) != d'\'''
test-expr '!((a >= B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || C) != d'\'''

echo '$ test-expr '\''!((a >= B) || C) != D'\'''
test-expr '!((a >= B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || C) != D'\'''

echo '$ test-expr '\''!((A >= b) || c) != d'\'''
test-expr '!((A >= b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || c) != d'\'''

echo '$ test-expr '\''!((A >= b) || c) != D'\'''
test-expr '!((A >= b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || c) != D'\'''

echo '$ test-expr '\''!((A >= b) || C) != d'\'''
test-expr '!((A >= b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || C) != d'\'''

echo '$ test-expr '\''!((A >= b) || C) != D'\'''
test-expr '!((A >= b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || C) != D'\'''

echo '$ test-expr '\''!((A >= B) || c) != d'\'''
test-expr '!((A >= B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || c) != d'\'''

echo '$ test-expr '\''!((A >= B) || c) != D'\'''
test-expr '!((A >= B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || c) != D'\'''

echo '$ test-expr '\''!((A >= B) || C) != d'\'''
test-expr '!((A >= B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || C) != d'\'''

echo '$ test-expr '\''!((A >= B) || C) != D'\'''
test-expr '!((A >= B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || C) != D'\'''

echo '$ test-expr '\''!((a >= b) || c) && d'\'''
test-expr '!((a >= b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || c) && d'\'''

echo '$ test-expr '\''!((a >= b) || c) && D'\'''
test-expr '!((a >= b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || c) && D'\'''

echo '$ test-expr '\''!((a >= b) || C) && d'\'''
test-expr '!((a >= b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || C) && d'\'''

echo '$ test-expr '\''!((a >= b) || C) && D'\'''
test-expr '!((a >= b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= b) || C) && D'\'''

echo '$ test-expr '\''!((a >= B) || c) && d'\'''
test-expr '!((a >= B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || c) && d'\'''

echo '$ test-expr '\''!((a >= B) || c) && D'\'''
test-expr '!((a >= B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || c) && D'\'''

echo '$ test-expr '\''!((a >= B) || C) && d'\'''
test-expr '!((a >= B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || C) && d'\'''

echo '$ test-expr '\''!((a >= B) || C) && D'\'''
test-expr '!((a >= B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a >= B) || C) && D'\'''

echo '$ test-expr '\''!((A >= b) || c) && d'\'''
test-expr '!((A >= b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || c) && d'\'''

echo '$ test-expr '\''!((A >= b) || c) && D'\'''
test-expr '!((A >= b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || c) && D'\'''

echo '$ test-expr '\''!((A >= b) || C) && d'\'''
test-expr '!((A >= b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || C) && d'\'''

echo '$ test-expr '\''!((A >= b) || C) && D'\'''
test-expr '!((A >= b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= b) || C) && D'\'''

echo '$ test-expr '\''!((A >= B) || c) && d'\'''
test-expr '!((A >= B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || c) && d'\'''

echo '$ test-expr '\''!((A >= B) || c) && D'\'''
test-expr '!((A >= B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || c) && D'\'''

echo '$ test-expr '\''!((A >= B) || C) && d'\'''
test-expr '!((A >= B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || C) && d'\'''

echo '$ test-expr '\''!((A >= B) || C) && D'\'''
test-expr '!((A >= B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A >= B) || C) && D'\'''

echo '$ test-expr '\''!((a != b) || c) && d'\'''
test-expr '!((a != b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || c) && d'\'''

echo '$ test-expr '\''!((a != b) || c) && D'\'''
test-expr '!((a != b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || c) && D'\'''

echo '$ test-expr '\''!((a != b) || C) && d'\'''
test-expr '!((a != b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || C) && d'\'''

echo '$ test-expr '\''!((a != b) || C) && D'\'''
test-expr '!((a != b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || C) && D'\'''

echo '$ test-expr '\''!((a != B) || c) && d'\'''
test-expr '!((a != B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || c) && d'\'''

echo '$ test-expr '\''!((a != B) || c) && D'\'''
test-expr '!((a != B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || c) && D'\'''

echo '$ test-expr '\''!((a != B) || C) && d'\'''
test-expr '!((a != B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || C) && d'\'''

echo '$ test-expr '\''!((a != B) || C) && D'\'''
test-expr '!((a != B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || C) && D'\'''

echo '$ test-expr '\''!((A != b) || c) && d'\'''
test-expr '!((A != b) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || c) && d'\'''

echo '$ test-expr '\''!((A != b) || c) && D'\'''
test-expr '!((A != b) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || c) && D'\'''

echo '$ test-expr '\''!((A != b) || C) && d'\'''
test-expr '!((A != b) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || C) && d'\'''

echo '$ test-expr '\''!((A != b) || C) && D'\'''
test-expr '!((A != b) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || C) && D'\'''

echo '$ test-expr '\''!((A != B) || c) && d'\'''
test-expr '!((A != B) || c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || c) && d'\'''

echo '$ test-expr '\''!((A != B) || c) && D'\'''
test-expr '!((A != B) || c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || c) && D'\'''

echo '$ test-expr '\''!((A != B) || C) && d'\'''
test-expr '!((A != B) || C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || C) && d'\'''

echo '$ test-expr '\''!((A != B) || C) && D'\'''
test-expr '!((A != B) || C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || C) && D'\'''

echo '$ test-expr '\''a >= !((b && c) != d)'\'''
test-expr 'a >= !((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && c) != d)'\'''

echo '$ test-expr '\''a >= !((b && c) != D)'\'''
test-expr 'a >= !((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && c) != D)'\'''

echo '$ test-expr '\''a >= !((b && C) != d)'\'''
test-expr 'a >= !((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && C) != d)'\'''

echo '$ test-expr '\''a >= !((b && C) != D)'\'''
test-expr 'a >= !((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b && C) != D)'\'''

echo '$ test-expr '\''a >= !((B && c) != d)'\'''
test-expr 'a >= !((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && c) != d)'\'''

echo '$ test-expr '\''a >= !((B && c) != D)'\'''
test-expr 'a >= !((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && c) != D)'\'''

echo '$ test-expr '\''a >= !((B && C) != d)'\'''
test-expr 'a >= !((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && C) != d)'\'''

echo '$ test-expr '\''a >= !((B && C) != D)'\'''
test-expr 'a >= !((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B && C) != D)'\'''

echo '$ test-expr '\''A >= !((b && c) != d)'\'''
test-expr 'A >= !((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && c) != d)'\'''

echo '$ test-expr '\''A >= !((b && c) != D)'\'''
test-expr 'A >= !((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && c) != D)'\'''

echo '$ test-expr '\''A >= !((b && C) != d)'\'''
test-expr 'A >= !((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && C) != d)'\'''

echo '$ test-expr '\''A >= !((b && C) != D)'\'''
test-expr 'A >= !((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b && C) != D)'\'''

echo '$ test-expr '\''A >= !((B && c) != d)'\'''
test-expr 'A >= !((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && c) != d)'\'''

echo '$ test-expr '\''A >= !((B && c) != D)'\'''
test-expr 'A >= !((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && c) != D)'\'''

echo '$ test-expr '\''A >= !((B && C) != d)'\'''
test-expr 'A >= !((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && C) != d)'\'''

echo '$ test-expr '\''A >= !((B && C) != D)'\'''
test-expr 'A >= !((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B && C) != D)'\'''

echo '$ test-expr '\''a >= !((b || c) != d)'\'''
test-expr 'a >= !((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || c) != d)'\'''

echo '$ test-expr '\''a >= !((b || c) != D)'\'''
test-expr 'a >= !((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || c) != D)'\'''

echo '$ test-expr '\''a >= !((b || C) != d)'\'''
test-expr 'a >= !((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || C) != d)'\'''

echo '$ test-expr '\''a >= !((b || C) != D)'\'''
test-expr 'a >= !((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || C) != D)'\'''

echo '$ test-expr '\''a >= !((B || c) != d)'\'''
test-expr 'a >= !((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || c) != d)'\'''

echo '$ test-expr '\''a >= !((B || c) != D)'\'''
test-expr 'a >= !((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || c) != D)'\'''

echo '$ test-expr '\''a >= !((B || C) != d)'\'''
test-expr 'a >= !((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || C) != d)'\'''

echo '$ test-expr '\''a >= !((B || C) != D)'\'''
test-expr 'a >= !((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || C) != D)'\'''

echo '$ test-expr '\''A >= !((b || c) != d)'\'''
test-expr 'A >= !((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || c) != d)'\'''

echo '$ test-expr '\''A >= !((b || c) != D)'\'''
test-expr 'A >= !((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || c) != D)'\'''

echo '$ test-expr '\''A >= !((b || C) != d)'\'''
test-expr 'A >= !((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || C) != d)'\'''

echo '$ test-expr '\''A >= !((b || C) != D)'\'''
test-expr 'A >= !((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || C) != D)'\'''

echo '$ test-expr '\''A >= !((B || c) != d)'\'''
test-expr 'A >= !((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || c) != d)'\'''

echo '$ test-expr '\''A >= !((B || c) != D)'\'''
test-expr 'A >= !((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || c) != D)'\'''

echo '$ test-expr '\''A >= !((B || C) != d)'\'''
test-expr 'A >= !((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || C) != d)'\'''

echo '$ test-expr '\''A >= !((B || C) != D)'\'''
test-expr 'A >= !((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || C) != D)'\'''

echo '$ test-expr '\''a >= !((b || c) && d)'\'''
test-expr 'a >= !((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || c) && d)'\'''

echo '$ test-expr '\''a >= !((b || c) && D)'\'''
test-expr 'a >= !((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || c) && D)'\'''

echo '$ test-expr '\''a >= !((b || C) && d)'\'''
test-expr 'a >= !((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || C) && d)'\'''

echo '$ test-expr '\''a >= !((b || C) && D)'\'''
test-expr 'a >= !((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((b || C) && D)'\'''

echo '$ test-expr '\''a >= !((B || c) && d)'\'''
test-expr 'a >= !((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || c) && d)'\'''

echo '$ test-expr '\''a >= !((B || c) && D)'\'''
test-expr 'a >= !((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || c) && D)'\'''

echo '$ test-expr '\''a >= !((B || C) && d)'\'''
test-expr 'a >= !((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || C) && d)'\'''

echo '$ test-expr '\''a >= !((B || C) && D)'\'''
test-expr 'a >= !((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a >= !((B || C) && D)'\'''

echo '$ test-expr '\''A >= !((b || c) && d)'\'''
test-expr 'A >= !((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || c) && d)'\'''

echo '$ test-expr '\''A >= !((b || c) && D)'\'''
test-expr 'A >= !((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || c) && D)'\'''

echo '$ test-expr '\''A >= !((b || C) && d)'\'''
test-expr 'A >= !((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || C) && d)'\'''

echo '$ test-expr '\''A >= !((b || C) && D)'\'''
test-expr 'A >= !((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((b || C) && D)'\'''

echo '$ test-expr '\''A >= !((B || c) && d)'\'''
test-expr 'A >= !((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || c) && d)'\'''

echo '$ test-expr '\''A >= !((B || c) && D)'\'''
test-expr 'A >= !((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || c) && D)'\'''

echo '$ test-expr '\''A >= !((B || C) && d)'\'''
test-expr 'A >= !((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || C) && d)'\'''

echo '$ test-expr '\''A >= !((B || C) && D)'\'''
test-expr 'A >= !((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A >= !((B || C) && D)'\'''

echo '$ test-expr '\''a != !((b || c) && d)'\'''
test-expr 'a != !((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || c) && d)'\'''

echo '$ test-expr '\''a != !((b || c) && D)'\'''
test-expr 'a != !((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || c) && D)'\'''

echo '$ test-expr '\''a != !((b || C) && d)'\'''
test-expr 'a != !((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || C) && d)'\'''

echo '$ test-expr '\''a != !((b || C) && D)'\'''
test-expr 'a != !((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || C) && D)'\'''

echo '$ test-expr '\''a != !((B || c) && d)'\'''
test-expr 'a != !((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || c) && d)'\'''

echo '$ test-expr '\''a != !((B || c) && D)'\'''
test-expr 'a != !((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || c) && D)'\'''

echo '$ test-expr '\''a != !((B || C) && d)'\'''
test-expr 'a != !((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || C) && d)'\'''

echo '$ test-expr '\''a != !((B || C) && D)'\'''
test-expr 'a != !((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || C) && D)'\'''

echo '$ test-expr '\''A != !((b || c) && d)'\'''
test-expr 'A != !((b || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || c) && d)'\'''

echo '$ test-expr '\''A != !((b || c) && D)'\'''
test-expr 'A != !((b || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || c) && D)'\'''

echo '$ test-expr '\''A != !((b || C) && d)'\'''
test-expr 'A != !((b || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || C) && d)'\'''

echo '$ test-expr '\''A != !((b || C) && D)'\'''
test-expr 'A != !((b || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || C) && D)'\'''

echo '$ test-expr '\''A != !((B || c) && d)'\'''
test-expr 'A != !((B || c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || c) && d)'\'''

echo '$ test-expr '\''A != !((B || c) && D)'\'''
test-expr 'A != !((B || c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || c) && D)'\'''

echo '$ test-expr '\''A != !((B || C) && d)'\'''
test-expr 'A != !((B || C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || C) && d)'\'''

echo '$ test-expr '\''A != !((B || C) && D)'\'''
test-expr 'A != !((B || C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || C) && D)'\'''

echo '$ test-expr '\''!(a >= (b && c)) != d'\'''
test-expr '!(a >= (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && c)) != d'\'''

echo '$ test-expr '\''!(a >= (b && c)) != D'\'''
test-expr '!(a >= (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && c)) != D'\'''

echo '$ test-expr '\''!(a >= (b && C)) != d'\'''
test-expr '!(a >= (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && C)) != d'\'''

echo '$ test-expr '\''!(a >= (b && C)) != D'\'''
test-expr '!(a >= (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b && C)) != D'\'''

echo '$ test-expr '\''!(a >= (B && c)) != d'\'''
test-expr '!(a >= (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && c)) != d'\'''

echo '$ test-expr '\''!(a >= (B && c)) != D'\'''
test-expr '!(a >= (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && c)) != D'\'''

echo '$ test-expr '\''!(a >= (B && C)) != d'\'''
test-expr '!(a >= (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && C)) != d'\'''

echo '$ test-expr '\''!(a >= (B && C)) != D'\'''
test-expr '!(a >= (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B && C)) != D'\'''

echo '$ test-expr '\''!(A >= (b && c)) != d'\'''
test-expr '!(A >= (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && c)) != d'\'''

echo '$ test-expr '\''!(A >= (b && c)) != D'\'''
test-expr '!(A >= (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && c)) != D'\'''

echo '$ test-expr '\''!(A >= (b && C)) != d'\'''
test-expr '!(A >= (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && C)) != d'\'''

echo '$ test-expr '\''!(A >= (b && C)) != D'\'''
test-expr '!(A >= (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b && C)) != D'\'''

echo '$ test-expr '\''!(A >= (B && c)) != d'\'''
test-expr '!(A >= (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && c)) != d'\'''

echo '$ test-expr '\''!(A >= (B && c)) != D'\'''
test-expr '!(A >= (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && c)) != D'\'''

echo '$ test-expr '\''!(A >= (B && C)) != d'\'''
test-expr '!(A >= (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && C)) != d'\'''

echo '$ test-expr '\''!(A >= (B && C)) != D'\'''
test-expr '!(A >= (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B && C)) != D'\'''

echo '$ test-expr '\''!(a >= (b || c)) != d'\'''
test-expr '!(a >= (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || c)) != d'\'''

echo '$ test-expr '\''!(a >= (b || c)) != D'\'''
test-expr '!(a >= (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || c)) != D'\'''

echo '$ test-expr '\''!(a >= (b || C)) != d'\'''
test-expr '!(a >= (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || C)) != d'\'''

echo '$ test-expr '\''!(a >= (b || C)) != D'\'''
test-expr '!(a >= (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || C)) != D'\'''

echo '$ test-expr '\''!(a >= (B || c)) != d'\'''
test-expr '!(a >= (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || c)) != d'\'''

echo '$ test-expr '\''!(a >= (B || c)) != D'\'''
test-expr '!(a >= (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || c)) != D'\'''

echo '$ test-expr '\''!(a >= (B || C)) != d'\'''
test-expr '!(a >= (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || C)) != d'\'''

echo '$ test-expr '\''!(a >= (B || C)) != D'\'''
test-expr '!(a >= (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || C)) != D'\'''

echo '$ test-expr '\''!(A >= (b || c)) != d'\'''
test-expr '!(A >= (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || c)) != d'\'''

echo '$ test-expr '\''!(A >= (b || c)) != D'\'''
test-expr '!(A >= (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || c)) != D'\'''

echo '$ test-expr '\''!(A >= (b || C)) != d'\'''
test-expr '!(A >= (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || C)) != d'\'''

echo '$ test-expr '\''!(A >= (b || C)) != D'\'''
test-expr '!(A >= (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || C)) != D'\'''

echo '$ test-expr '\''!(A >= (B || c)) != d'\'''
test-expr '!(A >= (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || c)) != d'\'''

echo '$ test-expr '\''!(A >= (B || c)) != D'\'''
test-expr '!(A >= (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || c)) != D'\'''

echo '$ test-expr '\''!(A >= (B || C)) != d'\'''
test-expr '!(A >= (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || C)) != d'\'''

echo '$ test-expr '\''!(A >= (B || C)) != D'\'''
test-expr '!(A >= (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || C)) != D'\'''

echo '$ test-expr '\''!(a >= (b || c)) && d'\'''
test-expr '!(a >= (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || c)) && d'\'''

echo '$ test-expr '\''!(a >= (b || c)) && D'\'''
test-expr '!(a >= (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || c)) && D'\'''

echo '$ test-expr '\''!(a >= (b || C)) && d'\'''
test-expr '!(a >= (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || C)) && d'\'''

echo '$ test-expr '\''!(a >= (b || C)) && D'\'''
test-expr '!(a >= (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (b || C)) && D'\'''

echo '$ test-expr '\''!(a >= (B || c)) && d'\'''
test-expr '!(a >= (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || c)) && d'\'''

echo '$ test-expr '\''!(a >= (B || c)) && D'\'''
test-expr '!(a >= (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || c)) && D'\'''

echo '$ test-expr '\''!(a >= (B || C)) && d'\'''
test-expr '!(a >= (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || C)) && d'\'''

echo '$ test-expr '\''!(a >= (B || C)) && D'\'''
test-expr '!(a >= (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= (B || C)) && D'\'''

echo '$ test-expr '\''!(A >= (b || c)) && d'\'''
test-expr '!(A >= (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || c)) && d'\'''

echo '$ test-expr '\''!(A >= (b || c)) && D'\'''
test-expr '!(A >= (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || c)) && D'\'''

echo '$ test-expr '\''!(A >= (b || C)) && d'\'''
test-expr '!(A >= (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || C)) && d'\'''

echo '$ test-expr '\''!(A >= (b || C)) && D'\'''
test-expr '!(A >= (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (b || C)) && D'\'''

echo '$ test-expr '\''!(A >= (B || c)) && d'\'''
test-expr '!(A >= (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || c)) && d'\'''

echo '$ test-expr '\''!(A >= (B || c)) && D'\'''
test-expr '!(A >= (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || c)) && D'\'''

echo '$ test-expr '\''!(A >= (B || C)) && d'\'''
test-expr '!(A >= (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || C)) && d'\'''

echo '$ test-expr '\''!(A >= (B || C)) && D'\'''
test-expr '!(A >= (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= (B || C)) && D'\'''

echo '$ test-expr '\''!(a != (b || c)) && d'\'''
test-expr '!(a != (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || c)) && d'\'''

echo '$ test-expr '\''!(a != (b || c)) && D'\'''
test-expr '!(a != (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || c)) && D'\'''

echo '$ test-expr '\''!(a != (b || C)) && d'\'''
test-expr '!(a != (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || C)) && d'\'''

echo '$ test-expr '\''!(a != (b || C)) && D'\'''
test-expr '!(a != (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || C)) && D'\'''

echo '$ test-expr '\''!(a != (B || c)) && d'\'''
test-expr '!(a != (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || c)) && d'\'''

echo '$ test-expr '\''!(a != (B || c)) && D'\'''
test-expr '!(a != (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || c)) && D'\'''

echo '$ test-expr '\''!(a != (B || C)) && d'\'''
test-expr '!(a != (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || C)) && d'\'''

echo '$ test-expr '\''!(a != (B || C)) && D'\'''
test-expr '!(a != (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || C)) && D'\'''

echo '$ test-expr '\''!(A != (b || c)) && d'\'''
test-expr '!(A != (b || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || c)) && d'\'''

echo '$ test-expr '\''!(A != (b || c)) && D'\'''
test-expr '!(A != (b || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || c)) && D'\'''

echo '$ test-expr '\''!(A != (b || C)) && d'\'''
test-expr '!(A != (b || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || C)) && d'\'''

echo '$ test-expr '\''!(A != (b || C)) && D'\'''
test-expr '!(A != (b || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || C)) && D'\'''

echo '$ test-expr '\''!(A != (B || c)) && d'\'''
test-expr '!(A != (B || c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || c)) && d'\'''

echo '$ test-expr '\''!(A != (B || c)) && D'\'''
test-expr '!(A != (B || c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || c)) && D'\'''

echo '$ test-expr '\''!(A != (B || C)) && d'\'''
test-expr '!(A != (B || C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || C)) && d'\'''

echo '$ test-expr '\''!(A != (B || C)) && D'\'''
test-expr '!(A != (B || C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || C)) && D'\'''

echo '$ test-expr '\''!(a >= b) && (c != d)'\'''
test-expr '!(a >= b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (c != d)'\'''

echo '$ test-expr '\''!(a >= b) && (c != D)'\'''
test-expr '!(a >= b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (c != D)'\'''

echo '$ test-expr '\''!(a >= b) && (C != d)'\'''
test-expr '!(a >= b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (C != d)'\'''

echo '$ test-expr '\''!(a >= b) && (C != D)'\'''
test-expr '!(a >= b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) && (C != D)'\'''

echo '$ test-expr '\''!(a >= B) && (c != d)'\'''
test-expr '!(a >= B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (c != d)'\'''

echo '$ test-expr '\''!(a >= B) && (c != D)'\'''
test-expr '!(a >= B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (c != D)'\'''

echo '$ test-expr '\''!(a >= B) && (C != d)'\'''
test-expr '!(a >= B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (C != d)'\'''

echo '$ test-expr '\''!(a >= B) && (C != D)'\'''
test-expr '!(a >= B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) && (C != D)'\'''

echo '$ test-expr '\''!(A >= b) && (c != d)'\'''
test-expr '!(A >= b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (c != d)'\'''

echo '$ test-expr '\''!(A >= b) && (c != D)'\'''
test-expr '!(A >= b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (c != D)'\'''

echo '$ test-expr '\''!(A >= b) && (C != d)'\'''
test-expr '!(A >= b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (C != d)'\'''

echo '$ test-expr '\''!(A >= b) && (C != D)'\'''
test-expr '!(A >= b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) && (C != D)'\'''

echo '$ test-expr '\''!(A >= B) && (c != d)'\'''
test-expr '!(A >= B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (c != d)'\'''

echo '$ test-expr '\''!(A >= B) && (c != D)'\'''
test-expr '!(A >= B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (c != D)'\'''

echo '$ test-expr '\''!(A >= B) && (C != d)'\'''
test-expr '!(A >= B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (C != d)'\'''

echo '$ test-expr '\''!(A >= B) && (C != D)'\'''
test-expr '!(A >= B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) && (C != D)'\'''

echo '$ test-expr '\''!(a >= b) || (c != d)'\'''
test-expr '!(a >= b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (c != d)'\'''

echo '$ test-expr '\''!(a >= b) || (c != D)'\'''
test-expr '!(a >= b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (c != D)'\'''

echo '$ test-expr '\''!(a >= b) || (C != d)'\'''
test-expr '!(a >= b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (C != d)'\'''

echo '$ test-expr '\''!(a >= b) || (C != D)'\'''
test-expr '!(a >= b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (C != D)'\'''

echo '$ test-expr '\''!(a >= B) || (c != d)'\'''
test-expr '!(a >= B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (c != d)'\'''

echo '$ test-expr '\''!(a >= B) || (c != D)'\'''
test-expr '!(a >= B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (c != D)'\'''

echo '$ test-expr '\''!(a >= B) || (C != d)'\'''
test-expr '!(a >= B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (C != d)'\'''

echo '$ test-expr '\''!(a >= B) || (C != D)'\'''
test-expr '!(a >= B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (C != D)'\'''

echo '$ test-expr '\''!(A >= b) || (c != d)'\'''
test-expr '!(A >= b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (c != d)'\'''

echo '$ test-expr '\''!(A >= b) || (c != D)'\'''
test-expr '!(A >= b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (c != D)'\'''

echo '$ test-expr '\''!(A >= b) || (C != d)'\'''
test-expr '!(A >= b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (C != d)'\'''

echo '$ test-expr '\''!(A >= b) || (C != D)'\'''
test-expr '!(A >= b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (C != D)'\'''

echo '$ test-expr '\''!(A >= B) || (c != d)'\'''
test-expr '!(A >= B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (c != d)'\'''

echo '$ test-expr '\''!(A >= B) || (c != D)'\'''
test-expr '!(A >= B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (c != D)'\'''

echo '$ test-expr '\''!(A >= B) || (C != d)'\'''
test-expr '!(A >= B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (C != d)'\'''

echo '$ test-expr '\''!(A >= B) || (C != D)'\'''
test-expr '!(A >= B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (C != D)'\'''

echo '$ test-expr '\''!(a >= b) || (c && d)'\'''
test-expr '!(a >= b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (c && d)'\'''

echo '$ test-expr '\''!(a >= b) || (c && D)'\'''
test-expr '!(a >= b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (c && D)'\'''

echo '$ test-expr '\''!(a >= b) || (C && d)'\'''
test-expr '!(a >= b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (C && d)'\'''

echo '$ test-expr '\''!(a >= b) || (C && D)'\'''
test-expr '!(a >= b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= b) || (C && D)'\'''

echo '$ test-expr '\''!(a >= B) || (c && d)'\'''
test-expr '!(a >= B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (c && d)'\'''

echo '$ test-expr '\''!(a >= B) || (c && D)'\'''
test-expr '!(a >= B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (c && D)'\'''

echo '$ test-expr '\''!(a >= B) || (C && d)'\'''
test-expr '!(a >= B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (C && d)'\'''

echo '$ test-expr '\''!(a >= B) || (C && D)'\'''
test-expr '!(a >= B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a >= B) || (C && D)'\'''

echo '$ test-expr '\''!(A >= b) || (c && d)'\'''
test-expr '!(A >= b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (c && d)'\'''

echo '$ test-expr '\''!(A >= b) || (c && D)'\'''
test-expr '!(A >= b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (c && D)'\'''

echo '$ test-expr '\''!(A >= b) || (C && d)'\'''
test-expr '!(A >= b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (C && d)'\'''

echo '$ test-expr '\''!(A >= b) || (C && D)'\'''
test-expr '!(A >= b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= b) || (C && D)'\'''

echo '$ test-expr '\''!(A >= B) || (c && d)'\'''
test-expr '!(A >= B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (c && d)'\'''

echo '$ test-expr '\''!(A >= B) || (c && D)'\'''
test-expr '!(A >= B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (c && D)'\'''

echo '$ test-expr '\''!(A >= B) || (C && d)'\'''
test-expr '!(A >= B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (C && d)'\'''

echo '$ test-expr '\''!(A >= B) || (C && D)'\'''
test-expr '!(A >= B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A >= B) || (C && D)'\'''

echo '$ test-expr '\''!(a != b) || (c && d)'\'''
test-expr '!(a != b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (c && d)'\'''

echo '$ test-expr '\''!(a != b) || (c && D)'\'''
test-expr '!(a != b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (c && D)'\'''

echo '$ test-expr '\''!(a != b) || (C && d)'\'''
test-expr '!(a != b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (C && d)'\'''

echo '$ test-expr '\''!(a != b) || (C && D)'\'''
test-expr '!(a != b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (C && D)'\'''

echo '$ test-expr '\''!(a != B) || (c && d)'\'''
test-expr '!(a != B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (c && d)'\'''

echo '$ test-expr '\''!(a != B) || (c && D)'\'''
test-expr '!(a != B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (c && D)'\'''

echo '$ test-expr '\''!(a != B) || (C && d)'\'''
test-expr '!(a != B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (C && d)'\'''

echo '$ test-expr '\''!(a != B) || (C && D)'\'''
test-expr '!(a != B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (C && D)'\'''

echo '$ test-expr '\''!(A != b) || (c && d)'\'''
test-expr '!(A != b) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (c && d)'\'''

echo '$ test-expr '\''!(A != b) || (c && D)'\'''
test-expr '!(A != b) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (c && D)'\'''

echo '$ test-expr '\''!(A != b) || (C && d)'\'''
test-expr '!(A != b) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (C && d)'\'''

echo '$ test-expr '\''!(A != b) || (C && D)'\'''
test-expr '!(A != b) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (C && D)'\'''

echo '$ test-expr '\''!(A != B) || (c && d)'\'''
test-expr '!(A != B) || (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (c && d)'\'''

echo '$ test-expr '\''!(A != B) || (c && D)'\'''
test-expr '!(A != B) || (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (c && D)'\'''

echo '$ test-expr '\''!(A != B) || (C && d)'\'''
test-expr '!(A != B) || (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (C && d)'\'''

echo '$ test-expr '\''!(A != B) || (C && D)'\'''
test-expr '!(A != B) || (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (C && D)'\'''

echo '$ test-expr '\''a >= !(b && (c != d))'\'''
test-expr 'a >= !(b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (c != d))'\'''

echo '$ test-expr '\''a >= !(b && (c != D))'\'''
test-expr 'a >= !(b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (c != D))'\'''

echo '$ test-expr '\''a >= !(b && (C != d))'\'''
test-expr 'a >= !(b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (C != d))'\'''

echo '$ test-expr '\''a >= !(b && (C != D))'\'''
test-expr 'a >= !(b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b && (C != D))'\'''

echo '$ test-expr '\''a >= !(B && (c != d))'\'''
test-expr 'a >= !(B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (c != d))'\'''

echo '$ test-expr '\''a >= !(B && (c != D))'\'''
test-expr 'a >= !(B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (c != D))'\'''

echo '$ test-expr '\''a >= !(B && (C != d))'\'''
test-expr 'a >= !(B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (C != d))'\'''

echo '$ test-expr '\''a >= !(B && (C != D))'\'''
test-expr 'a >= !(B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B && (C != D))'\'''

echo '$ test-expr '\''A >= !(b && (c != d))'\'''
test-expr 'A >= !(b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (c != d))'\'''

echo '$ test-expr '\''A >= !(b && (c != D))'\'''
test-expr 'A >= !(b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (c != D))'\'''

echo '$ test-expr '\''A >= !(b && (C != d))'\'''
test-expr 'A >= !(b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (C != d))'\'''

echo '$ test-expr '\''A >= !(b && (C != D))'\'''
test-expr 'A >= !(b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b && (C != D))'\'''

echo '$ test-expr '\''A >= !(B && (c != d))'\'''
test-expr 'A >= !(B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (c != d))'\'''

echo '$ test-expr '\''A >= !(B && (c != D))'\'''
test-expr 'A >= !(B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (c != D))'\'''

echo '$ test-expr '\''A >= !(B && (C != d))'\'''
test-expr 'A >= !(B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (C != d))'\'''

echo '$ test-expr '\''A >= !(B && (C != D))'\'''
test-expr 'A >= !(B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B && (C != D))'\'''

echo '$ test-expr '\''a >= !(b || (c != d))'\'''
test-expr 'a >= !(b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (c != d))'\'''

echo '$ test-expr '\''a >= !(b || (c != D))'\'''
test-expr 'a >= !(b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (c != D))'\'''

echo '$ test-expr '\''a >= !(b || (C != d))'\'''
test-expr 'a >= !(b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (C != d))'\'''

echo '$ test-expr '\''a >= !(b || (C != D))'\'''
test-expr 'a >= !(b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (C != D))'\'''

echo '$ test-expr '\''a >= !(B || (c != d))'\'''
test-expr 'a >= !(B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (c != d))'\'''

echo '$ test-expr '\''a >= !(B || (c != D))'\'''
test-expr 'a >= !(B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (c != D))'\'''

echo '$ test-expr '\''a >= !(B || (C != d))'\'''
test-expr 'a >= !(B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (C != d))'\'''

echo '$ test-expr '\''a >= !(B || (C != D))'\'''
test-expr 'a >= !(B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (C != D))'\'''

echo '$ test-expr '\''A >= !(b || (c != d))'\'''
test-expr 'A >= !(b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (c != d))'\'''

echo '$ test-expr '\''A >= !(b || (c != D))'\'''
test-expr 'A >= !(b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (c != D))'\'''

echo '$ test-expr '\''A >= !(b || (C != d))'\'''
test-expr 'A >= !(b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (C != d))'\'''

echo '$ test-expr '\''A >= !(b || (C != D))'\'''
test-expr 'A >= !(b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (C != D))'\'''

echo '$ test-expr '\''A >= !(B || (c != d))'\'''
test-expr 'A >= !(B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (c != d))'\'''

echo '$ test-expr '\''A >= !(B || (c != D))'\'''
test-expr 'A >= !(B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (c != D))'\'''

echo '$ test-expr '\''A >= !(B || (C != d))'\'''
test-expr 'A >= !(B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (C != d))'\'''

echo '$ test-expr '\''A >= !(B || (C != D))'\'''
test-expr 'A >= !(B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (C != D))'\'''

echo '$ test-expr '\''a >= !(b || (c && d))'\'''
test-expr 'a >= !(b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (c && d))'\'''

echo '$ test-expr '\''a >= !(b || (c && D))'\'''
test-expr 'a >= !(b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (c && D))'\'''

echo '$ test-expr '\''a >= !(b || (C && d))'\'''
test-expr 'a >= !(b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (C && d))'\'''

echo '$ test-expr '\''a >= !(b || (C && D))'\'''
test-expr 'a >= !(b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(b || (C && D))'\'''

echo '$ test-expr '\''a >= !(B || (c && d))'\'''
test-expr 'a >= !(B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (c && d))'\'''

echo '$ test-expr '\''a >= !(B || (c && D))'\'''
test-expr 'a >= !(B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (c && D))'\'''

echo '$ test-expr '\''a >= !(B || (C && d))'\'''
test-expr 'a >= !(B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (C && d))'\'''

echo '$ test-expr '\''a >= !(B || (C && D))'\'''
test-expr 'a >= !(B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a >= !(B || (C && D))'\'''

echo '$ test-expr '\''A >= !(b || (c && d))'\'''
test-expr 'A >= !(b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (c && d))'\'''

echo '$ test-expr '\''A >= !(b || (c && D))'\'''
test-expr 'A >= !(b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (c && D))'\'''

echo '$ test-expr '\''A >= !(b || (C && d))'\'''
test-expr 'A >= !(b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (C && d))'\'''

echo '$ test-expr '\''A >= !(b || (C && D))'\'''
test-expr 'A >= !(b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(b || (C && D))'\'''

echo '$ test-expr '\''A >= !(B || (c && d))'\'''
test-expr 'A >= !(B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (c && d))'\'''

echo '$ test-expr '\''A >= !(B || (c && D))'\'''
test-expr 'A >= !(B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (c && D))'\'''

echo '$ test-expr '\''A >= !(B || (C && d))'\'''
test-expr 'A >= !(B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (C && d))'\'''

echo '$ test-expr '\''A >= !(B || (C && D))'\'''
test-expr 'A >= !(B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A >= !(B || (C && D))'\'''

echo '$ test-expr '\''a != !(b || (c && d))'\'''
test-expr 'a != !(b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (c && d))'\'''

echo '$ test-expr '\''a != !(b || (c && D))'\'''
test-expr 'a != !(b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (c && D))'\'''

echo '$ test-expr '\''a != !(b || (C && d))'\'''
test-expr 'a != !(b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (C && d))'\'''

echo '$ test-expr '\''a != !(b || (C && D))'\'''
test-expr 'a != !(b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (C && D))'\'''

echo '$ test-expr '\''a != !(B || (c && d))'\'''
test-expr 'a != !(B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (c && d))'\'''

echo '$ test-expr '\''a != !(B || (c && D))'\'''
test-expr 'a != !(B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (c && D))'\'''

echo '$ test-expr '\''a != !(B || (C && d))'\'''
test-expr 'a != !(B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (C && d))'\'''

echo '$ test-expr '\''a != !(B || (C && D))'\'''
test-expr 'a != !(B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (C && D))'\'''

echo '$ test-expr '\''A != !(b || (c && d))'\'''
test-expr 'A != !(b || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (c && d))'\'''

echo '$ test-expr '\''A != !(b || (c && D))'\'''
test-expr 'A != !(b || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (c && D))'\'''

echo '$ test-expr '\''A != !(b || (C && d))'\'''
test-expr 'A != !(b || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (C && d))'\'''

echo '$ test-expr '\''A != !(b || (C && D))'\'''
test-expr 'A != !(b || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (C && D))'\'''

echo '$ test-expr '\''A != !(B || (c && d))'\'''
test-expr 'A != !(B || (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (c && d))'\'''

echo '$ test-expr '\''A != !(B || (c && D))'\'''
test-expr 'A != !(B || (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (c && D))'\'''

echo '$ test-expr '\''A != !(B || (C && d))'\'''
test-expr 'A != !(B || (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (C && d))'\'''

echo '$ test-expr '\''A != !(B || (C && D))'\'''
test-expr 'A != !(B || (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (C && D))'\'''

echo '$ test-expr '\''!((a != b) >= c) && d'\'''
test-expr '!((a != b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= c) && d'\'''

echo '$ test-expr '\''!((a != b) >= c) && D'\'''
test-expr '!((a != b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= c) && D'\'''

echo '$ test-expr '\''!((a != b) >= C) && d'\'''
test-expr '!((a != b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= C) && d'\'''

echo '$ test-expr '\''!((a != b) >= C) && D'\'''
test-expr '!((a != b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= C) && D'\'''

echo '$ test-expr '\''!((a != B) >= c) && d'\'''
test-expr '!((a != B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= c) && d'\'''

echo '$ test-expr '\''!((a != B) >= c) && D'\'''
test-expr '!((a != B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= c) && D'\'''

echo '$ test-expr '\''!((a != B) >= C) && d'\'''
test-expr '!((a != B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= C) && d'\'''

echo '$ test-expr '\''!((a != B) >= C) && D'\'''
test-expr '!((a != B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= C) && D'\'''

echo '$ test-expr '\''!((A != b) >= c) && d'\'''
test-expr '!((A != b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= c) && d'\'''

echo '$ test-expr '\''!((A != b) >= c) && D'\'''
test-expr '!((A != b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= c) && D'\'''

echo '$ test-expr '\''!((A != b) >= C) && d'\'''
test-expr '!((A != b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= C) && d'\'''

echo '$ test-expr '\''!((A != b) >= C) && D'\'''
test-expr '!((A != b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= C) && D'\'''

echo '$ test-expr '\''!((A != B) >= c) && d'\'''
test-expr '!((A != B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= c) && d'\'''

echo '$ test-expr '\''!((A != B) >= c) && D'\'''
test-expr '!((A != B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= c) && D'\'''

echo '$ test-expr '\''!((A != B) >= C) && d'\'''
test-expr '!((A != B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= C) && d'\'''

echo '$ test-expr '\''!((A != B) >= C) && D'\'''
test-expr '!((A != B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= C) && D'\'''

echo '$ test-expr '\''!((a != b) >= c) || d'\'''
test-expr '!((a != b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= c) || d'\'''

echo '$ test-expr '\''!((a != b) >= c) || D'\'''
test-expr '!((a != b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= c) || D'\'''

echo '$ test-expr '\''!((a != b) >= C) || d'\'''
test-expr '!((a != b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= C) || d'\'''

echo '$ test-expr '\''!((a != b) >= C) || D'\'''
test-expr '!((a != b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) >= C) || D'\'''

echo '$ test-expr '\''!((a != B) >= c) || d'\'''
test-expr '!((a != B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= c) || d'\'''

echo '$ test-expr '\''!((a != B) >= c) || D'\'''
test-expr '!((a != B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= c) || D'\'''

echo '$ test-expr '\''!((a != B) >= C) || d'\'''
test-expr '!((a != B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= C) || d'\'''

echo '$ test-expr '\''!((a != B) >= C) || D'\'''
test-expr '!((a != B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) >= C) || D'\'''

echo '$ test-expr '\''!((A != b) >= c) || d'\'''
test-expr '!((A != b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= c) || d'\'''

echo '$ test-expr '\''!((A != b) >= c) || D'\'''
test-expr '!((A != b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= c) || D'\'''

echo '$ test-expr '\''!((A != b) >= C) || d'\'''
test-expr '!((A != b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= C) || d'\'''

echo '$ test-expr '\''!((A != b) >= C) || D'\'''
test-expr '!((A != b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) >= C) || D'\'''

echo '$ test-expr '\''!((A != B) >= c) || d'\'''
test-expr '!((A != B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= c) || d'\'''

echo '$ test-expr '\''!((A != B) >= c) || D'\'''
test-expr '!((A != B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= c) || D'\'''

echo '$ test-expr '\''!((A != B) >= C) || d'\'''
test-expr '!((A != B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= C) || d'\'''

echo '$ test-expr '\''!((A != B) >= C) || D'\'''
test-expr '!((A != B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) >= C) || D'\'''

echo '$ test-expr '\''!((a && b) >= c) || d'\'''
test-expr '!((a && b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= c) || d'\'''

echo '$ test-expr '\''!((a && b) >= c) || D'\'''
test-expr '!((a && b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= c) || D'\'''

echo '$ test-expr '\''!((a && b) >= C) || d'\'''
test-expr '!((a && b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= C) || d'\'''

echo '$ test-expr '\''!((a && b) >= C) || D'\'''
test-expr '!((a && b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= C) || D'\'''

echo '$ test-expr '\''!((a && B) >= c) || d'\'''
test-expr '!((a && B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= c) || d'\'''

echo '$ test-expr '\''!((a && B) >= c) || D'\'''
test-expr '!((a && B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= c) || D'\'''

echo '$ test-expr '\''!((a && B) >= C) || d'\'''
test-expr '!((a && B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= C) || d'\'''

echo '$ test-expr '\''!((a && B) >= C) || D'\'''
test-expr '!((a && B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= C) || D'\'''

echo '$ test-expr '\''!((A && b) >= c) || d'\'''
test-expr '!((A && b) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= c) || d'\'''

echo '$ test-expr '\''!((A && b) >= c) || D'\'''
test-expr '!((A && b) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= c) || D'\'''

echo '$ test-expr '\''!((A && b) >= C) || d'\'''
test-expr '!((A && b) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= C) || d'\'''

echo '$ test-expr '\''!((A && b) >= C) || D'\'''
test-expr '!((A && b) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= C) || D'\'''

echo '$ test-expr '\''!((A && B) >= c) || d'\'''
test-expr '!((A && B) >= c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= c) || d'\'''

echo '$ test-expr '\''!((A && B) >= c) || D'\'''
test-expr '!((A && B) >= c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= c) || D'\'''

echo '$ test-expr '\''!((A && B) >= C) || d'\'''
test-expr '!((A && B) >= C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= C) || d'\'''

echo '$ test-expr '\''!((A && B) >= C) || D'\'''
test-expr '!((A && B) >= C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= C) || D'\'''

echo '$ test-expr '\''!((a && b) != c) || d'\'''
test-expr '!((a && b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != c) || d'\'''

echo '$ test-expr '\''!((a && b) != c) || D'\'''
test-expr '!((a && b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != c) || D'\'''

echo '$ test-expr '\''!((a && b) != C) || d'\'''
test-expr '!((a && b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != C) || d'\'''

echo '$ test-expr '\''!((a && b) != C) || D'\'''
test-expr '!((a && b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != C) || D'\'''

echo '$ test-expr '\''!((a && B) != c) || d'\'''
test-expr '!((a && B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != c) || d'\'''

echo '$ test-expr '\''!((a && B) != c) || D'\'''
test-expr '!((a && B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != c) || D'\'''

echo '$ test-expr '\''!((a && B) != C) || d'\'''
test-expr '!((a && B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != C) || d'\'''

echo '$ test-expr '\''!((a && B) != C) || D'\'''
test-expr '!((a && B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != C) || D'\'''

echo '$ test-expr '\''!((A && b) != c) || d'\'''
test-expr '!((A && b) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != c) || d'\'''

echo '$ test-expr '\''!((A && b) != c) || D'\'''
test-expr '!((A && b) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != c) || D'\'''

echo '$ test-expr '\''!((A && b) != C) || d'\'''
test-expr '!((A && b) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != C) || d'\'''

echo '$ test-expr '\''!((A && b) != C) || D'\'''
test-expr '!((A && b) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != C) || D'\'''

echo '$ test-expr '\''!((A && B) != c) || d'\'''
test-expr '!((A && B) != c) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != c) || d'\'''

echo '$ test-expr '\''!((A && B) != c) || D'\'''
test-expr '!((A && B) != c) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != c) || D'\'''

echo '$ test-expr '\''!((A && B) != C) || d'\'''
test-expr '!((A && B) != C) || d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != C) || d'\'''

echo '$ test-expr '\''!((A && B) != C) || D'\'''
test-expr '!((A && B) != C) || D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != C) || D'\'''

echo '$ test-expr '\''a != !((b >= c) && d)'\'''
test-expr 'a != !((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= c) && d)'\'''

echo '$ test-expr '\''a != !((b >= c) && D)'\'''
test-expr 'a != !((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= c) && D)'\'''

echo '$ test-expr '\''a != !((b >= C) && d)'\'''
test-expr 'a != !((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= C) && d)'\'''

echo '$ test-expr '\''a != !((b >= C) && D)'\'''
test-expr 'a != !((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= C) && D)'\'''

echo '$ test-expr '\''a != !((B >= c) && d)'\'''
test-expr 'a != !((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= c) && d)'\'''

echo '$ test-expr '\''a != !((B >= c) && D)'\'''
test-expr 'a != !((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= c) && D)'\'''

echo '$ test-expr '\''a != !((B >= C) && d)'\'''
test-expr 'a != !((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= C) && d)'\'''

echo '$ test-expr '\''a != !((B >= C) && D)'\'''
test-expr 'a != !((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= C) && D)'\'''

echo '$ test-expr '\''A != !((b >= c) && d)'\'''
test-expr 'A != !((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= c) && d)'\'''

echo '$ test-expr '\''A != !((b >= c) && D)'\'''
test-expr 'A != !((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= c) && D)'\'''

echo '$ test-expr '\''A != !((b >= C) && d)'\'''
test-expr 'A != !((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= C) && d)'\'''

echo '$ test-expr '\''A != !((b >= C) && D)'\'''
test-expr 'A != !((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= C) && D)'\'''

echo '$ test-expr '\''A != !((B >= c) && d)'\'''
test-expr 'A != !((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= c) && d)'\'''

echo '$ test-expr '\''A != !((B >= c) && D)'\'''
test-expr 'A != !((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= c) && D)'\'''

echo '$ test-expr '\''A != !((B >= C) && d)'\'''
test-expr 'A != !((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= C) && d)'\'''

echo '$ test-expr '\''A != !((B >= C) && D)'\'''
test-expr 'A != !((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= C) && D)'\'''

echo '$ test-expr '\''a != !((b >= c) || d)'\'''
test-expr 'a != !((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= c) || d)'\'''

echo '$ test-expr '\''a != !((b >= c) || D)'\'''
test-expr 'a != !((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= c) || D)'\'''

echo '$ test-expr '\''a != !((b >= C) || d)'\'''
test-expr 'a != !((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= C) || d)'\'''

echo '$ test-expr '\''a != !((b >= C) || D)'\'''
test-expr 'a != !((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b >= C) || D)'\'''

echo '$ test-expr '\''a != !((B >= c) || d)'\'''
test-expr 'a != !((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= c) || d)'\'''

echo '$ test-expr '\''a != !((B >= c) || D)'\'''
test-expr 'a != !((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= c) || D)'\'''

echo '$ test-expr '\''a != !((B >= C) || d)'\'''
test-expr 'a != !((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= C) || d)'\'''

echo '$ test-expr '\''a != !((B >= C) || D)'\'''
test-expr 'a != !((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B >= C) || D)'\'''

echo '$ test-expr '\''A != !((b >= c) || d)'\'''
test-expr 'A != !((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= c) || d)'\'''

echo '$ test-expr '\''A != !((b >= c) || D)'\'''
test-expr 'A != !((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= c) || D)'\'''

echo '$ test-expr '\''A != !((b >= C) || d)'\'''
test-expr 'A != !((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= C) || d)'\'''

echo '$ test-expr '\''A != !((b >= C) || D)'\'''
test-expr 'A != !((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b >= C) || D)'\'''

echo '$ test-expr '\''A != !((B >= c) || d)'\'''
test-expr 'A != !((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= c) || d)'\'''

echo '$ test-expr '\''A != !((B >= c) || D)'\'''
test-expr 'A != !((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= c) || D)'\'''

echo '$ test-expr '\''A != !((B >= C) || d)'\'''
test-expr 'A != !((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= C) || d)'\'''

echo '$ test-expr '\''A != !((B >= C) || D)'\'''
test-expr 'A != !((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B >= C) || D)'\'''

echo '$ test-expr '\''a && !((b >= c) || d)'\'''
test-expr 'a && !((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= c) || d)'\'''

echo '$ test-expr '\''a && !((b >= c) || D)'\'''
test-expr 'a && !((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= c) || D)'\'''

echo '$ test-expr '\''a && !((b >= C) || d)'\'''
test-expr 'a && !((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= C) || d)'\'''

echo '$ test-expr '\''a && !((b >= C) || D)'\'''
test-expr 'a && !((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= C) || D)'\'''

echo '$ test-expr '\''a && !((B >= c) || d)'\'''
test-expr 'a && !((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= c) || d)'\'''

echo '$ test-expr '\''a && !((B >= c) || D)'\'''
test-expr 'a && !((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= c) || D)'\'''

echo '$ test-expr '\''a && !((B >= C) || d)'\'''
test-expr 'a && !((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= C) || d)'\'''

echo '$ test-expr '\''a && !((B >= C) || D)'\'''
test-expr 'a && !((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= C) || D)'\'''

echo '$ test-expr '\''A && !((b >= c) || d)'\'''
test-expr 'A && !((b >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= c) || d)'\'''

echo '$ test-expr '\''A && !((b >= c) || D)'\'''
test-expr 'A && !((b >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= c) || D)'\'''

echo '$ test-expr '\''A && !((b >= C) || d)'\'''
test-expr 'A && !((b >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= C) || d)'\'''

echo '$ test-expr '\''A && !((b >= C) || D)'\'''
test-expr 'A && !((b >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= C) || D)'\'''

echo '$ test-expr '\''A && !((B >= c) || d)'\'''
test-expr 'A && !((B >= c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= c) || d)'\'''

echo '$ test-expr '\''A && !((B >= c) || D)'\'''
test-expr 'A && !((B >= c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= c) || D)'\'''

echo '$ test-expr '\''A && !((B >= C) || d)'\'''
test-expr 'A && !((B >= C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= C) || d)'\'''

echo '$ test-expr '\''A && !((B >= C) || D)'\'''
test-expr 'A && !((B >= C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= C) || D)'\'''

echo '$ test-expr '\''a && !((b != c) || d)'\'''
test-expr 'a && !((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != c) || d)'\'''

echo '$ test-expr '\''a && !((b != c) || D)'\'''
test-expr 'a && !((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != c) || D)'\'''

echo '$ test-expr '\''a && !((b != C) || d)'\'''
test-expr 'a && !((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != C) || d)'\'''

echo '$ test-expr '\''a && !((b != C) || D)'\'''
test-expr 'a && !((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != C) || D)'\'''

echo '$ test-expr '\''a && !((B != c) || d)'\'''
test-expr 'a && !((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != c) || d)'\'''

echo '$ test-expr '\''a && !((B != c) || D)'\'''
test-expr 'a && !((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != c) || D)'\'''

echo '$ test-expr '\''a && !((B != C) || d)'\'''
test-expr 'a && !((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != C) || d)'\'''

echo '$ test-expr '\''a && !((B != C) || D)'\'''
test-expr 'a && !((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != C) || D)'\'''

echo '$ test-expr '\''A && !((b != c) || d)'\'''
test-expr 'A && !((b != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != c) || d)'\'''

echo '$ test-expr '\''A && !((b != c) || D)'\'''
test-expr 'A && !((b != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != c) || D)'\'''

echo '$ test-expr '\''A && !((b != C) || d)'\'''
test-expr 'A && !((b != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != C) || d)'\'''

echo '$ test-expr '\''A && !((b != C) || D)'\'''
test-expr 'A && !((b != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != C) || D)'\'''

echo '$ test-expr '\''A && !((B != c) || d)'\'''
test-expr 'A && !((B != c) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != c) || d)'\'''

echo '$ test-expr '\''A && !((B != c) || D)'\'''
test-expr 'A && !((B != c) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != c) || D)'\'''

echo '$ test-expr '\''A && !((B != C) || d)'\'''
test-expr 'A && !((B != C) || d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != C) || d)'\'''

echo '$ test-expr '\''A && !((B != C) || D)'\'''
test-expr 'A && !((B != C) || D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != C) || D)'\'''

echo '$ test-expr '\''!(a != (b >= c)) && d'\'''
test-expr '!(a != (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= c)) && d'\'''

echo '$ test-expr '\''!(a != (b >= c)) && D'\'''
test-expr '!(a != (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= c)) && D'\'''

echo '$ test-expr '\''!(a != (b >= C)) && d'\'''
test-expr '!(a != (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= C)) && d'\'''

echo '$ test-expr '\''!(a != (b >= C)) && D'\'''
test-expr '!(a != (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= C)) && D'\'''

echo '$ test-expr '\''!(a != (B >= c)) && d'\'''
test-expr '!(a != (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= c)) && d'\'''

echo '$ test-expr '\''!(a != (B >= c)) && D'\'''
test-expr '!(a != (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= c)) && D'\'''

echo '$ test-expr '\''!(a != (B >= C)) && d'\'''
test-expr '!(a != (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= C)) && d'\'''

echo '$ test-expr '\''!(a != (B >= C)) && D'\'''
test-expr '!(a != (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= C)) && D'\'''

echo '$ test-expr '\''!(A != (b >= c)) && d'\'''
test-expr '!(A != (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= c)) && d'\'''

echo '$ test-expr '\''!(A != (b >= c)) && D'\'''
test-expr '!(A != (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= c)) && D'\'''

echo '$ test-expr '\''!(A != (b >= C)) && d'\'''
test-expr '!(A != (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= C)) && d'\'''

echo '$ test-expr '\''!(A != (b >= C)) && D'\'''
test-expr '!(A != (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= C)) && D'\'''

echo '$ test-expr '\''!(A != (B >= c)) && d'\'''
test-expr '!(A != (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= c)) && d'\'''

echo '$ test-expr '\''!(A != (B >= c)) && D'\'''
test-expr '!(A != (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= c)) && D'\'''

echo '$ test-expr '\''!(A != (B >= C)) && d'\'''
test-expr '!(A != (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= C)) && d'\'''

echo '$ test-expr '\''!(A != (B >= C)) && D'\'''
test-expr '!(A != (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= C)) && D'\'''

echo '$ test-expr '\''!(a != (b >= c)) || d'\'''
test-expr '!(a != (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= c)) || d'\'''

echo '$ test-expr '\''!(a != (b >= c)) || D'\'''
test-expr '!(a != (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= c)) || D'\'''

echo '$ test-expr '\''!(a != (b >= C)) || d'\'''
test-expr '!(a != (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= C)) || d'\'''

echo '$ test-expr '\''!(a != (b >= C)) || D'\'''
test-expr '!(a != (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b >= C)) || D'\'''

echo '$ test-expr '\''!(a != (B >= c)) || d'\'''
test-expr '!(a != (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= c)) || d'\'''

echo '$ test-expr '\''!(a != (B >= c)) || D'\'''
test-expr '!(a != (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= c)) || D'\'''

echo '$ test-expr '\''!(a != (B >= C)) || d'\'''
test-expr '!(a != (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= C)) || d'\'''

echo '$ test-expr '\''!(a != (B >= C)) || D'\'''
test-expr '!(a != (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B >= C)) || D'\'''

echo '$ test-expr '\''!(A != (b >= c)) || d'\'''
test-expr '!(A != (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= c)) || d'\'''

echo '$ test-expr '\''!(A != (b >= c)) || D'\'''
test-expr '!(A != (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= c)) || D'\'''

echo '$ test-expr '\''!(A != (b >= C)) || d'\'''
test-expr '!(A != (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= C)) || d'\'''

echo '$ test-expr '\''!(A != (b >= C)) || D'\'''
test-expr '!(A != (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b >= C)) || D'\'''

echo '$ test-expr '\''!(A != (B >= c)) || d'\'''
test-expr '!(A != (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= c)) || d'\'''

echo '$ test-expr '\''!(A != (B >= c)) || D'\'''
test-expr '!(A != (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= c)) || D'\'''

echo '$ test-expr '\''!(A != (B >= C)) || d'\'''
test-expr '!(A != (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= C)) || d'\'''

echo '$ test-expr '\''!(A != (B >= C)) || D'\'''
test-expr '!(A != (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B >= C)) || D'\'''

echo '$ test-expr '\''!(a && (b >= c)) || d'\'''
test-expr '!(a && (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= c)) || d'\'''

echo '$ test-expr '\''!(a && (b >= c)) || D'\'''
test-expr '!(a && (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= c)) || D'\'''

echo '$ test-expr '\''!(a && (b >= C)) || d'\'''
test-expr '!(a && (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= C)) || d'\'''

echo '$ test-expr '\''!(a && (b >= C)) || D'\'''
test-expr '!(a && (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= C)) || D'\'''

echo '$ test-expr '\''!(a && (B >= c)) || d'\'''
test-expr '!(a && (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= c)) || d'\'''

echo '$ test-expr '\''!(a && (B >= c)) || D'\'''
test-expr '!(a && (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= c)) || D'\'''

echo '$ test-expr '\''!(a && (B >= C)) || d'\'''
test-expr '!(a && (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= C)) || d'\'''

echo '$ test-expr '\''!(a && (B >= C)) || D'\'''
test-expr '!(a && (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= C)) || D'\'''

echo '$ test-expr '\''!(A && (b >= c)) || d'\'''
test-expr '!(A && (b >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= c)) || d'\'''

echo '$ test-expr '\''!(A && (b >= c)) || D'\'''
test-expr '!(A && (b >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= c)) || D'\'''

echo '$ test-expr '\''!(A && (b >= C)) || d'\'''
test-expr '!(A && (b >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= C)) || d'\'''

echo '$ test-expr '\''!(A && (b >= C)) || D'\'''
test-expr '!(A && (b >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= C)) || D'\'''

echo '$ test-expr '\''!(A && (B >= c)) || d'\'''
test-expr '!(A && (B >= c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= c)) || d'\'''

echo '$ test-expr '\''!(A && (B >= c)) || D'\'''
test-expr '!(A && (B >= c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= c)) || D'\'''

echo '$ test-expr '\''!(A && (B >= C)) || d'\'''
test-expr '!(A && (B >= C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= C)) || d'\'''

echo '$ test-expr '\''!(A && (B >= C)) || D'\'''
test-expr '!(A && (B >= C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= C)) || D'\'''

echo '$ test-expr '\''!(a && (b != c)) || d'\'''
test-expr '!(a && (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != c)) || d'\'''

echo '$ test-expr '\''!(a && (b != c)) || D'\'''
test-expr '!(a && (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != c)) || D'\'''

echo '$ test-expr '\''!(a && (b != C)) || d'\'''
test-expr '!(a && (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != C)) || d'\'''

echo '$ test-expr '\''!(a && (b != C)) || D'\'''
test-expr '!(a && (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != C)) || D'\'''

echo '$ test-expr '\''!(a && (B != c)) || d'\'''
test-expr '!(a && (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != c)) || d'\'''

echo '$ test-expr '\''!(a && (B != c)) || D'\'''
test-expr '!(a && (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != c)) || D'\'''

echo '$ test-expr '\''!(a && (B != C)) || d'\'''
test-expr '!(a && (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != C)) || d'\'''

echo '$ test-expr '\''!(a && (B != C)) || D'\'''
test-expr '!(a && (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != C)) || D'\'''

echo '$ test-expr '\''!(A && (b != c)) || d'\'''
test-expr '!(A && (b != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != c)) || d'\'''

echo '$ test-expr '\''!(A && (b != c)) || D'\'''
test-expr '!(A && (b != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != c)) || D'\'''

echo '$ test-expr '\''!(A && (b != C)) || d'\'''
test-expr '!(A && (b != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != C)) || d'\'''

echo '$ test-expr '\''!(A && (b != C)) || D'\'''
test-expr '!(A && (b != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != C)) || D'\'''

echo '$ test-expr '\''!(A && (B != c)) || d'\'''
test-expr '!(A && (B != c)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != c)) || d'\'''

echo '$ test-expr '\''!(A && (B != c)) || D'\'''
test-expr '!(A && (B != c)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != c)) || D'\'''

echo '$ test-expr '\''!(A && (B != C)) || d'\'''
test-expr '!(A && (B != C)) || d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != C)) || d'\'''

echo '$ test-expr '\''!(A && (B != C)) || D'\'''
test-expr '!(A && (B != C)) || D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != C)) || D'\'''

echo '$ test-expr '\''!(a != b) >= (c && d)'\'''
test-expr '!(a != b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (c && d)'\'''

echo '$ test-expr '\''!(a != b) >= (c && D)'\'''
test-expr '!(a != b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (c && D)'\'''

echo '$ test-expr '\''!(a != b) >= (C && d)'\'''
test-expr '!(a != b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (C && d)'\'''

echo '$ test-expr '\''!(a != b) >= (C && D)'\'''
test-expr '!(a != b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (C && D)'\'''

echo '$ test-expr '\''!(a != B) >= (c && d)'\'''
test-expr '!(a != B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (c && d)'\'''

echo '$ test-expr '\''!(a != B) >= (c && D)'\'''
test-expr '!(a != B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (c && D)'\'''

echo '$ test-expr '\''!(a != B) >= (C && d)'\'''
test-expr '!(a != B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (C && d)'\'''

echo '$ test-expr '\''!(a != B) >= (C && D)'\'''
test-expr '!(a != B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (C && D)'\'''

echo '$ test-expr '\''!(A != b) >= (c && d)'\'''
test-expr '!(A != b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (c && d)'\'''

echo '$ test-expr '\''!(A != b) >= (c && D)'\'''
test-expr '!(A != b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (c && D)'\'''

echo '$ test-expr '\''!(A != b) >= (C && d)'\'''
test-expr '!(A != b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (C && d)'\'''

echo '$ test-expr '\''!(A != b) >= (C && D)'\'''
test-expr '!(A != b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (C && D)'\'''

echo '$ test-expr '\''!(A != B) >= (c && d)'\'''
test-expr '!(A != B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (c && d)'\'''

echo '$ test-expr '\''!(A != B) >= (c && D)'\'''
test-expr '!(A != B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (c && D)'\'''

echo '$ test-expr '\''!(A != B) >= (C && d)'\'''
test-expr '!(A != B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (C && d)'\'''

echo '$ test-expr '\''!(A != B) >= (C && D)'\'''
test-expr '!(A != B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (C && D)'\'''

echo '$ test-expr '\''!(a != b) >= (c || d)'\'''
test-expr '!(a != b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (c || d)'\'''

echo '$ test-expr '\''!(a != b) >= (c || D)'\'''
test-expr '!(a != b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (c || D)'\'''

echo '$ test-expr '\''!(a != b) >= (C || d)'\'''
test-expr '!(a != b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (C || d)'\'''

echo '$ test-expr '\''!(a != b) >= (C || D)'\'''
test-expr '!(a != b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) >= (C || D)'\'''

echo '$ test-expr '\''!(a != B) >= (c || d)'\'''
test-expr '!(a != B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (c || d)'\'''

echo '$ test-expr '\''!(a != B) >= (c || D)'\'''
test-expr '!(a != B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (c || D)'\'''

echo '$ test-expr '\''!(a != B) >= (C || d)'\'''
test-expr '!(a != B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (C || d)'\'''

echo '$ test-expr '\''!(a != B) >= (C || D)'\'''
test-expr '!(a != B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) >= (C || D)'\'''

echo '$ test-expr '\''!(A != b) >= (c || d)'\'''
test-expr '!(A != b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (c || d)'\'''

echo '$ test-expr '\''!(A != b) >= (c || D)'\'''
test-expr '!(A != b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (c || D)'\'''

echo '$ test-expr '\''!(A != b) >= (C || d)'\'''
test-expr '!(A != b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (C || d)'\'''

echo '$ test-expr '\''!(A != b) >= (C || D)'\'''
test-expr '!(A != b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) >= (C || D)'\'''

echo '$ test-expr '\''!(A != B) >= (c || d)'\'''
test-expr '!(A != B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (c || d)'\'''

echo '$ test-expr '\''!(A != B) >= (c || D)'\'''
test-expr '!(A != B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (c || D)'\'''

echo '$ test-expr '\''!(A != B) >= (C || d)'\'''
test-expr '!(A != B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (C || d)'\'''

echo '$ test-expr '\''!(A != B) >= (C || D)'\'''
test-expr '!(A != B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) >= (C || D)'\'''

echo '$ test-expr '\''!(a && b) >= (c || d)'\'''
test-expr '!(a && b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (c || d)'\'''

echo '$ test-expr '\''!(a && b) >= (c || D)'\'''
test-expr '!(a && b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (c || D)'\'''

echo '$ test-expr '\''!(a && b) >= (C || d)'\'''
test-expr '!(a && b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (C || d)'\'''

echo '$ test-expr '\''!(a && b) >= (C || D)'\'''
test-expr '!(a && b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (C || D)'\'''

echo '$ test-expr '\''!(a && B) >= (c || d)'\'''
test-expr '!(a && B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (c || d)'\'''

echo '$ test-expr '\''!(a && B) >= (c || D)'\'''
test-expr '!(a && B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (c || D)'\'''

echo '$ test-expr '\''!(a && B) >= (C || d)'\'''
test-expr '!(a && B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (C || d)'\'''

echo '$ test-expr '\''!(a && B) >= (C || D)'\'''
test-expr '!(a && B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (C || D)'\'''

echo '$ test-expr '\''!(A && b) >= (c || d)'\'''
test-expr '!(A && b) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (c || d)'\'''

echo '$ test-expr '\''!(A && b) >= (c || D)'\'''
test-expr '!(A && b) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (c || D)'\'''

echo '$ test-expr '\''!(A && b) >= (C || d)'\'''
test-expr '!(A && b) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (C || d)'\'''

echo '$ test-expr '\''!(A && b) >= (C || D)'\'''
test-expr '!(A && b) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (C || D)'\'''

echo '$ test-expr '\''!(A && B) >= (c || d)'\'''
test-expr '!(A && B) >= (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (c || d)'\'''

echo '$ test-expr '\''!(A && B) >= (c || D)'\'''
test-expr '!(A && B) >= (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (c || D)'\'''

echo '$ test-expr '\''!(A && B) >= (C || d)'\'''
test-expr '!(A && B) >= (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (C || d)'\'''

echo '$ test-expr '\''!(A && B) >= (C || D)'\'''
test-expr '!(A && B) >= (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (C || D)'\'''

echo '$ test-expr '\''!(a && b) != (c || d)'\'''
test-expr '!(a && b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (c || d)'\'''

echo '$ test-expr '\''!(a && b) != (c || D)'\'''
test-expr '!(a && b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (c || D)'\'''

echo '$ test-expr '\''!(a && b) != (C || d)'\'''
test-expr '!(a && b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (C || d)'\'''

echo '$ test-expr '\''!(a && b) != (C || D)'\'''
test-expr '!(a && b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (C || D)'\'''

echo '$ test-expr '\''!(a && B) != (c || d)'\'''
test-expr '!(a && B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (c || d)'\'''

echo '$ test-expr '\''!(a && B) != (c || D)'\'''
test-expr '!(a && B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (c || D)'\'''

echo '$ test-expr '\''!(a && B) != (C || d)'\'''
test-expr '!(a && B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (C || d)'\'''

echo '$ test-expr '\''!(a && B) != (C || D)'\'''
test-expr '!(a && B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (C || D)'\'''

echo '$ test-expr '\''!(A && b) != (c || d)'\'''
test-expr '!(A && b) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (c || d)'\'''

echo '$ test-expr '\''!(A && b) != (c || D)'\'''
test-expr '!(A && b) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (c || D)'\'''

echo '$ test-expr '\''!(A && b) != (C || d)'\'''
test-expr '!(A && b) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (C || d)'\'''

echo '$ test-expr '\''!(A && b) != (C || D)'\'''
test-expr '!(A && b) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (C || D)'\'''

echo '$ test-expr '\''!(A && B) != (c || d)'\'''
test-expr '!(A && B) != (c || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (c || d)'\'''

echo '$ test-expr '\''!(A && B) != (c || D)'\'''
test-expr '!(A && B) != (c || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (c || D)'\'''

echo '$ test-expr '\''!(A && B) != (C || d)'\'''
test-expr '!(A && B) != (C || d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (C || d)'\'''

echo '$ test-expr '\''!(A && B) != (C || D)'\'''
test-expr '!(A && B) != (C || D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (C || D)'\'''

echo '$ test-expr '\''a != !(b >= (c && d))'\'''
test-expr 'a != !(b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (c && d))'\'''

echo '$ test-expr '\''a != !(b >= (c && D))'\'''
test-expr 'a != !(b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (c && D))'\'''

echo '$ test-expr '\''a != !(b >= (C && d))'\'''
test-expr 'a != !(b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (C && d))'\'''

echo '$ test-expr '\''a != !(b >= (C && D))'\'''
test-expr 'a != !(b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (C && D))'\'''

echo '$ test-expr '\''a != !(B >= (c && d))'\'''
test-expr 'a != !(B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (c && d))'\'''

echo '$ test-expr '\''a != !(B >= (c && D))'\'''
test-expr 'a != !(B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (c && D))'\'''

echo '$ test-expr '\''a != !(B >= (C && d))'\'''
test-expr 'a != !(B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (C && d))'\'''

echo '$ test-expr '\''a != !(B >= (C && D))'\'''
test-expr 'a != !(B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (C && D))'\'''

echo '$ test-expr '\''A != !(b >= (c && d))'\'''
test-expr 'A != !(b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (c && d))'\'''

echo '$ test-expr '\''A != !(b >= (c && D))'\'''
test-expr 'A != !(b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (c && D))'\'''

echo '$ test-expr '\''A != !(b >= (C && d))'\'''
test-expr 'A != !(b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (C && d))'\'''

echo '$ test-expr '\''A != !(b >= (C && D))'\'''
test-expr 'A != !(b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (C && D))'\'''

echo '$ test-expr '\''A != !(B >= (c && d))'\'''
test-expr 'A != !(B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (c && d))'\'''

echo '$ test-expr '\''A != !(B >= (c && D))'\'''
test-expr 'A != !(B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (c && D))'\'''

echo '$ test-expr '\''A != !(B >= (C && d))'\'''
test-expr 'A != !(B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (C && d))'\'''

echo '$ test-expr '\''A != !(B >= (C && D))'\'''
test-expr 'A != !(B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (C && D))'\'''

echo '$ test-expr '\''a != !(b >= (c || d))'\'''
test-expr 'a != !(b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (c || d))'\'''

echo '$ test-expr '\''a != !(b >= (c || D))'\'''
test-expr 'a != !(b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (c || D))'\'''

echo '$ test-expr '\''a != !(b >= (C || d))'\'''
test-expr 'a != !(b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (C || d))'\'''

echo '$ test-expr '\''a != !(b >= (C || D))'\'''
test-expr 'a != !(b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b >= (C || D))'\'''

echo '$ test-expr '\''a != !(B >= (c || d))'\'''
test-expr 'a != !(B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (c || d))'\'''

echo '$ test-expr '\''a != !(B >= (c || D))'\'''
test-expr 'a != !(B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (c || D))'\'''

echo '$ test-expr '\''a != !(B >= (C || d))'\'''
test-expr 'a != !(B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (C || d))'\'''

echo '$ test-expr '\''a != !(B >= (C || D))'\'''
test-expr 'a != !(B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B >= (C || D))'\'''

echo '$ test-expr '\''A != !(b >= (c || d))'\'''
test-expr 'A != !(b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (c || d))'\'''

echo '$ test-expr '\''A != !(b >= (c || D))'\'''
test-expr 'A != !(b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (c || D))'\'''

echo '$ test-expr '\''A != !(b >= (C || d))'\'''
test-expr 'A != !(b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (C || d))'\'''

echo '$ test-expr '\''A != !(b >= (C || D))'\'''
test-expr 'A != !(b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b >= (C || D))'\'''

echo '$ test-expr '\''A != !(B >= (c || d))'\'''
test-expr 'A != !(B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (c || d))'\'''

echo '$ test-expr '\''A != !(B >= (c || D))'\'''
test-expr 'A != !(B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (c || D))'\'''

echo '$ test-expr '\''A != !(B >= (C || d))'\'''
test-expr 'A != !(B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (C || d))'\'''

echo '$ test-expr '\''A != !(B >= (C || D))'\'''
test-expr 'A != !(B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B >= (C || D))'\'''

echo '$ test-expr '\''a && !(b >= (c || d))'\'''
test-expr 'a && !(b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (c || d))'\'''

echo '$ test-expr '\''a && !(b >= (c || D))'\'''
test-expr 'a && !(b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (c || D))'\'''

echo '$ test-expr '\''a && !(b >= (C || d))'\'''
test-expr 'a && !(b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (C || d))'\'''

echo '$ test-expr '\''a && !(b >= (C || D))'\'''
test-expr 'a && !(b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (C || D))'\'''

echo '$ test-expr '\''a && !(B >= (c || d))'\'''
test-expr 'a && !(B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (c || d))'\'''

echo '$ test-expr '\''a && !(B >= (c || D))'\'''
test-expr 'a && !(B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (c || D))'\'''

echo '$ test-expr '\''a && !(B >= (C || d))'\'''
test-expr 'a && !(B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (C || d))'\'''

echo '$ test-expr '\''a && !(B >= (C || D))'\'''
test-expr 'a && !(B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (C || D))'\'''

echo '$ test-expr '\''A && !(b >= (c || d))'\'''
test-expr 'A && !(b >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (c || d))'\'''

echo '$ test-expr '\''A && !(b >= (c || D))'\'''
test-expr 'A && !(b >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (c || D))'\'''

echo '$ test-expr '\''A && !(b >= (C || d))'\'''
test-expr 'A && !(b >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (C || d))'\'''

echo '$ test-expr '\''A && !(b >= (C || D))'\'''
test-expr 'A && !(b >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (C || D))'\'''

echo '$ test-expr '\''A && !(B >= (c || d))'\'''
test-expr 'A && !(B >= (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (c || d))'\'''

echo '$ test-expr '\''A && !(B >= (c || D))'\'''
test-expr 'A && !(B >= (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (c || D))'\'''

echo '$ test-expr '\''A && !(B >= (C || d))'\'''
test-expr 'A && !(B >= (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (C || d))'\'''

echo '$ test-expr '\''A && !(B >= (C || D))'\'''
test-expr 'A && !(B >= (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (C || D))'\'''

echo '$ test-expr '\''a && !(b != (c || d))'\'''
test-expr 'a && !(b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (c || d))'\'''

echo '$ test-expr '\''a && !(b != (c || D))'\'''
test-expr 'a && !(b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (c || D))'\'''

echo '$ test-expr '\''a && !(b != (C || d))'\'''
test-expr 'a && !(b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (C || d))'\'''

echo '$ test-expr '\''a && !(b != (C || D))'\'''
test-expr 'a && !(b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (C || D))'\'''

echo '$ test-expr '\''a && !(B != (c || d))'\'''
test-expr 'a && !(B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (c || d))'\'''

echo '$ test-expr '\''a && !(B != (c || D))'\'''
test-expr 'a && !(B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (c || D))'\'''

echo '$ test-expr '\''a && !(B != (C || d))'\'''
test-expr 'a && !(B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (C || d))'\'''

echo '$ test-expr '\''a && !(B != (C || D))'\'''
test-expr 'a && !(B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (C || D))'\'''

echo '$ test-expr '\''A && !(b != (c || d))'\'''
test-expr 'A && !(b != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (c || d))'\'''

echo '$ test-expr '\''A && !(b != (c || D))'\'''
test-expr 'A && !(b != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (c || D))'\'''

echo '$ test-expr '\''A && !(b != (C || d))'\'''
test-expr 'A && !(b != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (C || d))'\'''

echo '$ test-expr '\''A && !(b != (C || D))'\'''
test-expr 'A && !(b != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (C || D))'\'''

echo '$ test-expr '\''A && !(B != (c || d))'\'''
test-expr 'A && !(B != (c || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (c || d))'\'''

echo '$ test-expr '\''A && !(B != (c || D))'\'''
test-expr 'A && !(B != (c || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (c || D))'\'''

echo '$ test-expr '\''A && !(B != (C || d))'\'''
test-expr 'A && !(B != (C || d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (C || d))'\'''

echo '$ test-expr '\''A && !(B != (C || D))'\'''
test-expr 'A && !(B != (C || D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (C || D))'\'''

echo '$ test-expr '\''!((a != b) && c) >= d'\'''
test-expr '!((a != b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && c) >= d'\'''

echo '$ test-expr '\''!((a != b) && c) >= D'\'''
test-expr '!((a != b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && c) >= D'\'''

echo '$ test-expr '\''!((a != b) && C) >= d'\'''
test-expr '!((a != b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && C) >= d'\'''

echo '$ test-expr '\''!((a != b) && C) >= D'\'''
test-expr '!((a != b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) && C) >= D'\'''

echo '$ test-expr '\''!((a != B) && c) >= d'\'''
test-expr '!((a != B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && c) >= d'\'''

echo '$ test-expr '\''!((a != B) && c) >= D'\'''
test-expr '!((a != B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && c) >= D'\'''

echo '$ test-expr '\''!((a != B) && C) >= d'\'''
test-expr '!((a != B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && C) >= d'\'''

echo '$ test-expr '\''!((a != B) && C) >= D'\'''
test-expr '!((a != B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) && C) >= D'\'''

echo '$ test-expr '\''!((A != b) && c) >= d'\'''
test-expr '!((A != b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && c) >= d'\'''

echo '$ test-expr '\''!((A != b) && c) >= D'\'''
test-expr '!((A != b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && c) >= D'\'''

echo '$ test-expr '\''!((A != b) && C) >= d'\'''
test-expr '!((A != b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && C) >= d'\'''

echo '$ test-expr '\''!((A != b) && C) >= D'\'''
test-expr '!((A != b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) && C) >= D'\'''

echo '$ test-expr '\''!((A != B) && c) >= d'\'''
test-expr '!((A != B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && c) >= d'\'''

echo '$ test-expr '\''!((A != B) && c) >= D'\'''
test-expr '!((A != B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && c) >= D'\'''

echo '$ test-expr '\''!((A != B) && C) >= d'\'''
test-expr '!((A != B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && C) >= d'\'''

echo '$ test-expr '\''!((A != B) && C) >= D'\'''
test-expr '!((A != B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) && C) >= D'\'''

echo '$ test-expr '\''!((a != b) || c) >= d'\'''
test-expr '!((a != b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || c) >= d'\'''

echo '$ test-expr '\''!((a != b) || c) >= D'\'''
test-expr '!((a != b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || c) >= D'\'''

echo '$ test-expr '\''!((a != b) || C) >= d'\'''
test-expr '!((a != b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || C) >= d'\'''

echo '$ test-expr '\''!((a != b) || C) >= D'\'''
test-expr '!((a != b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != b) || C) >= D'\'''

echo '$ test-expr '\''!((a != B) || c) >= d'\'''
test-expr '!((a != B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || c) >= d'\'''

echo '$ test-expr '\''!((a != B) || c) >= D'\'''
test-expr '!((a != B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || c) >= D'\'''

echo '$ test-expr '\''!((a != B) || C) >= d'\'''
test-expr '!((a != B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || C) >= d'\'''

echo '$ test-expr '\''!((a != B) || C) >= D'\'''
test-expr '!((a != B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a != B) || C) >= D'\'''

echo '$ test-expr '\''!((A != b) || c) >= d'\'''
test-expr '!((A != b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || c) >= d'\'''

echo '$ test-expr '\''!((A != b) || c) >= D'\'''
test-expr '!((A != b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || c) >= D'\'''

echo '$ test-expr '\''!((A != b) || C) >= d'\'''
test-expr '!((A != b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || C) >= d'\'''

echo '$ test-expr '\''!((A != b) || C) >= D'\'''
test-expr '!((A != b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != b) || C) >= D'\'''

echo '$ test-expr '\''!((A != B) || c) >= d'\'''
test-expr '!((A != B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || c) >= d'\'''

echo '$ test-expr '\''!((A != B) || c) >= D'\'''
test-expr '!((A != B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || c) >= D'\'''

echo '$ test-expr '\''!((A != B) || C) >= d'\'''
test-expr '!((A != B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || C) >= d'\'''

echo '$ test-expr '\''!((A != B) || C) >= D'\'''
test-expr '!((A != B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A != B) || C) >= D'\'''

echo '$ test-expr '\''!((a && b) || c) >= d'\'''
test-expr '!((a && b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || c) >= d'\'''

echo '$ test-expr '\''!((a && b) || c) >= D'\'''
test-expr '!((a && b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || c) >= D'\'''

echo '$ test-expr '\''!((a && b) || C) >= d'\'''
test-expr '!((a && b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || C) >= d'\'''

echo '$ test-expr '\''!((a && b) || C) >= D'\'''
test-expr '!((a && b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || C) >= D'\'''

echo '$ test-expr '\''!((a && B) || c) >= d'\'''
test-expr '!((a && B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || c) >= d'\'''

echo '$ test-expr '\''!((a && B) || c) >= D'\'''
test-expr '!((a && B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || c) >= D'\'''

echo '$ test-expr '\''!((a && B) || C) >= d'\'''
test-expr '!((a && B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || C) >= d'\'''

echo '$ test-expr '\''!((a && B) || C) >= D'\'''
test-expr '!((a && B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || C) >= D'\'''

echo '$ test-expr '\''!((A && b) || c) >= d'\'''
test-expr '!((A && b) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || c) >= d'\'''

echo '$ test-expr '\''!((A && b) || c) >= D'\'''
test-expr '!((A && b) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || c) >= D'\'''

echo '$ test-expr '\''!((A && b) || C) >= d'\'''
test-expr '!((A && b) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || C) >= d'\'''

echo '$ test-expr '\''!((A && b) || C) >= D'\'''
test-expr '!((A && b) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || C) >= D'\'''

echo '$ test-expr '\''!((A && B) || c) >= d'\'''
test-expr '!((A && B) || c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || c) >= d'\'''

echo '$ test-expr '\''!((A && B) || c) >= D'\'''
test-expr '!((A && B) || c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || c) >= D'\'''

echo '$ test-expr '\''!((A && B) || C) >= d'\'''
test-expr '!((A && B) || C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || C) >= d'\'''

echo '$ test-expr '\''!((A && B) || C) >= D'\'''
test-expr '!((A && B) || C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || C) >= D'\'''

echo '$ test-expr '\''!((a && b) || c) != d'\'''
test-expr '!((a && b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || c) != d'\'''

echo '$ test-expr '\''!((a && b) || c) != D'\'''
test-expr '!((a && b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || c) != D'\'''

echo '$ test-expr '\''!((a && b) || C) != d'\'''
test-expr '!((a && b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || C) != d'\'''

echo '$ test-expr '\''!((a && b) || C) != D'\'''
test-expr '!((a && b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) || C) != D'\'''

echo '$ test-expr '\''!((a && B) || c) != d'\'''
test-expr '!((a && B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || c) != d'\'''

echo '$ test-expr '\''!((a && B) || c) != D'\'''
test-expr '!((a && B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || c) != D'\'''

echo '$ test-expr '\''!((a && B) || C) != d'\'''
test-expr '!((a && B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || C) != d'\'''

echo '$ test-expr '\''!((a && B) || C) != D'\'''
test-expr '!((a && B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) || C) != D'\'''

echo '$ test-expr '\''!((A && b) || c) != d'\'''
test-expr '!((A && b) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || c) != d'\'''

echo '$ test-expr '\''!((A && b) || c) != D'\'''
test-expr '!((A && b) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || c) != D'\'''

echo '$ test-expr '\''!((A && b) || C) != d'\'''
test-expr '!((A && b) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || C) != d'\'''

echo '$ test-expr '\''!((A && b) || C) != D'\'''
test-expr '!((A && b) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) || C) != D'\'''

echo '$ test-expr '\''!((A && B) || c) != d'\'''
test-expr '!((A && B) || c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || c) != d'\'''

echo '$ test-expr '\''!((A && B) || c) != D'\'''
test-expr '!((A && B) || c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || c) != D'\'''

echo '$ test-expr '\''!((A && B) || C) != d'\'''
test-expr '!((A && B) || C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || C) != d'\'''

echo '$ test-expr '\''!((A && B) || C) != D'\'''
test-expr '!((A && B) || C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) || C) != D'\'''

echo '$ test-expr '\''a != !((b && c) >= d)'\'''
test-expr 'a != !((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && c) >= d)'\'''

echo '$ test-expr '\''a != !((b && c) >= D)'\'''
test-expr 'a != !((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && c) >= D)'\'''

echo '$ test-expr '\''a != !((b && C) >= d)'\'''
test-expr 'a != !((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && C) >= d)'\'''

echo '$ test-expr '\''a != !((b && C) >= D)'\'''
test-expr 'a != !((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b && C) >= D)'\'''

echo '$ test-expr '\''a != !((B && c) >= d)'\'''
test-expr 'a != !((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && c) >= d)'\'''

echo '$ test-expr '\''a != !((B && c) >= D)'\'''
test-expr 'a != !((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && c) >= D)'\'''

echo '$ test-expr '\''a != !((B && C) >= d)'\'''
test-expr 'a != !((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && C) >= d)'\'''

echo '$ test-expr '\''a != !((B && C) >= D)'\'''
test-expr 'a != !((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B && C) >= D)'\'''

echo '$ test-expr '\''A != !((b && c) >= d)'\'''
test-expr 'A != !((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && c) >= d)'\'''

echo '$ test-expr '\''A != !((b && c) >= D)'\'''
test-expr 'A != !((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && c) >= D)'\'''

echo '$ test-expr '\''A != !((b && C) >= d)'\'''
test-expr 'A != !((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && C) >= d)'\'''

echo '$ test-expr '\''A != !((b && C) >= D)'\'''
test-expr 'A != !((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b && C) >= D)'\'''

echo '$ test-expr '\''A != !((B && c) >= d)'\'''
test-expr 'A != !((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && c) >= d)'\'''

echo '$ test-expr '\''A != !((B && c) >= D)'\'''
test-expr 'A != !((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && c) >= D)'\'''

echo '$ test-expr '\''A != !((B && C) >= d)'\'''
test-expr 'A != !((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && C) >= d)'\'''

echo '$ test-expr '\''A != !((B && C) >= D)'\'''
test-expr 'A != !((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B && C) >= D)'\'''

echo '$ test-expr '\''a != !((b || c) >= d)'\'''
test-expr 'a != !((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || c) >= d)'\'''

echo '$ test-expr '\''a != !((b || c) >= D)'\'''
test-expr 'a != !((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || c) >= D)'\'''

echo '$ test-expr '\''a != !((b || C) >= d)'\'''
test-expr 'a != !((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || C) >= d)'\'''

echo '$ test-expr '\''a != !((b || C) >= D)'\'''
test-expr 'a != !((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((b || C) >= D)'\'''

echo '$ test-expr '\''a != !((B || c) >= d)'\'''
test-expr 'a != !((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || c) >= d)'\'''

echo '$ test-expr '\''a != !((B || c) >= D)'\'''
test-expr 'a != !((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || c) >= D)'\'''

echo '$ test-expr '\''a != !((B || C) >= d)'\'''
test-expr 'a != !((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || C) >= d)'\'''

echo '$ test-expr '\''a != !((B || C) >= D)'\'''
test-expr 'a != !((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a != !((B || C) >= D)'\'''

echo '$ test-expr '\''A != !((b || c) >= d)'\'''
test-expr 'A != !((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || c) >= d)'\'''

echo '$ test-expr '\''A != !((b || c) >= D)'\'''
test-expr 'A != !((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || c) >= D)'\'''

echo '$ test-expr '\''A != !((b || C) >= d)'\'''
test-expr 'A != !((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || C) >= d)'\'''

echo '$ test-expr '\''A != !((b || C) >= D)'\'''
test-expr 'A != !((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((b || C) >= D)'\'''

echo '$ test-expr '\''A != !((B || c) >= d)'\'''
test-expr 'A != !((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || c) >= d)'\'''

echo '$ test-expr '\''A != !((B || c) >= D)'\'''
test-expr 'A != !((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || c) >= D)'\'''

echo '$ test-expr '\''A != !((B || C) >= d)'\'''
test-expr 'A != !((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || C) >= d)'\'''

echo '$ test-expr '\''A != !((B || C) >= D)'\'''
test-expr 'A != !((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A != !((B || C) >= D)'\'''

echo '$ test-expr '\''a && !((b || c) >= d)'\'''
test-expr 'a && !((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || c) >= d)'\'''

echo '$ test-expr '\''a && !((b || c) >= D)'\'''
test-expr 'a && !((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || c) >= D)'\'''

echo '$ test-expr '\''a && !((b || C) >= d)'\'''
test-expr 'a && !((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || C) >= d)'\'''

echo '$ test-expr '\''a && !((b || C) >= D)'\'''
test-expr 'a && !((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || C) >= D)'\'''

echo '$ test-expr '\''a && !((B || c) >= d)'\'''
test-expr 'a && !((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || c) >= d)'\'''

echo '$ test-expr '\''a && !((B || c) >= D)'\'''
test-expr 'a && !((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || c) >= D)'\'''

echo '$ test-expr '\''a && !((B || C) >= d)'\'''
test-expr 'a && !((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || C) >= d)'\'''

echo '$ test-expr '\''a && !((B || C) >= D)'\'''
test-expr 'a && !((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || C) >= D)'\'''

echo '$ test-expr '\''A && !((b || c) >= d)'\'''
test-expr 'A && !((b || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || c) >= d)'\'''

echo '$ test-expr '\''A && !((b || c) >= D)'\'''
test-expr 'A && !((b || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || c) >= D)'\'''

echo '$ test-expr '\''A && !((b || C) >= d)'\'''
test-expr 'A && !((b || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || C) >= d)'\'''

echo '$ test-expr '\''A && !((b || C) >= D)'\'''
test-expr 'A && !((b || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || C) >= D)'\'''

echo '$ test-expr '\''A && !((B || c) >= d)'\'''
test-expr 'A && !((B || c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || c) >= d)'\'''

echo '$ test-expr '\''A && !((B || c) >= D)'\'''
test-expr 'A && !((B || c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || c) >= D)'\'''

echo '$ test-expr '\''A && !((B || C) >= d)'\'''
test-expr 'A && !((B || C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || C) >= d)'\'''

echo '$ test-expr '\''A && !((B || C) >= D)'\'''
test-expr 'A && !((B || C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || C) >= D)'\'''

echo '$ test-expr '\''a && !((b || c) != d)'\'''
test-expr 'a && !((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || c) != d)'\'''

echo '$ test-expr '\''a && !((b || c) != D)'\'''
test-expr 'a && !((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || c) != D)'\'''

echo '$ test-expr '\''a && !((b || C) != d)'\'''
test-expr 'a && !((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || C) != d)'\'''

echo '$ test-expr '\''a && !((b || C) != D)'\'''
test-expr 'a && !((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b || C) != D)'\'''

echo '$ test-expr '\''a && !((B || c) != d)'\'''
test-expr 'a && !((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || c) != d)'\'''

echo '$ test-expr '\''a && !((B || c) != D)'\'''
test-expr 'a && !((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || c) != D)'\'''

echo '$ test-expr '\''a && !((B || C) != d)'\'''
test-expr 'a && !((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || C) != d)'\'''

echo '$ test-expr '\''a && !((B || C) != D)'\'''
test-expr 'a && !((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B || C) != D)'\'''

echo '$ test-expr '\''A && !((b || c) != d)'\'''
test-expr 'A && !((b || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || c) != d)'\'''

echo '$ test-expr '\''A && !((b || c) != D)'\'''
test-expr 'A && !((b || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || c) != D)'\'''

echo '$ test-expr '\''A && !((b || C) != d)'\'''
test-expr 'A && !((b || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || C) != d)'\'''

echo '$ test-expr '\''A && !((b || C) != D)'\'''
test-expr 'A && !((b || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b || C) != D)'\'''

echo '$ test-expr '\''A && !((B || c) != d)'\'''
test-expr 'A && !((B || c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || c) != d)'\'''

echo '$ test-expr '\''A && !((B || c) != D)'\'''
test-expr 'A && !((B || c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || c) != D)'\'''

echo '$ test-expr '\''A && !((B || C) != d)'\'''
test-expr 'A && !((B || C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || C) != d)'\'''

echo '$ test-expr '\''A && !((B || C) != D)'\'''
test-expr 'A && !((B || C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B || C) != D)'\'''

echo '$ test-expr '\''!(a != (b && c)) >= d'\'''
test-expr '!(a != (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && c)) >= d'\'''

echo '$ test-expr '\''!(a != (b && c)) >= D'\'''
test-expr '!(a != (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && c)) >= D'\'''

echo '$ test-expr '\''!(a != (b && C)) >= d'\'''
test-expr '!(a != (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && C)) >= d'\'''

echo '$ test-expr '\''!(a != (b && C)) >= D'\'''
test-expr '!(a != (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b && C)) >= D'\'''

echo '$ test-expr '\''!(a != (B && c)) >= d'\'''
test-expr '!(a != (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && c)) >= d'\'''

echo '$ test-expr '\''!(a != (B && c)) >= D'\'''
test-expr '!(a != (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && c)) >= D'\'''

echo '$ test-expr '\''!(a != (B && C)) >= d'\'''
test-expr '!(a != (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && C)) >= d'\'''

echo '$ test-expr '\''!(a != (B && C)) >= D'\'''
test-expr '!(a != (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B && C)) >= D'\'''

echo '$ test-expr '\''!(A != (b && c)) >= d'\'''
test-expr '!(A != (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && c)) >= d'\'''

echo '$ test-expr '\''!(A != (b && c)) >= D'\'''
test-expr '!(A != (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && c)) >= D'\'''

echo '$ test-expr '\''!(A != (b && C)) >= d'\'''
test-expr '!(A != (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && C)) >= d'\'''

echo '$ test-expr '\''!(A != (b && C)) >= D'\'''
test-expr '!(A != (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b && C)) >= D'\'''

echo '$ test-expr '\''!(A != (B && c)) >= d'\'''
test-expr '!(A != (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && c)) >= d'\'''

echo '$ test-expr '\''!(A != (B && c)) >= D'\'''
test-expr '!(A != (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && c)) >= D'\'''

echo '$ test-expr '\''!(A != (B && C)) >= d'\'''
test-expr '!(A != (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && C)) >= d'\'''

echo '$ test-expr '\''!(A != (B && C)) >= D'\'''
test-expr '!(A != (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B && C)) >= D'\'''

echo '$ test-expr '\''!(a != (b || c)) >= d'\'''
test-expr '!(a != (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || c)) >= d'\'''

echo '$ test-expr '\''!(a != (b || c)) >= D'\'''
test-expr '!(a != (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || c)) >= D'\'''

echo '$ test-expr '\''!(a != (b || C)) >= d'\'''
test-expr '!(a != (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || C)) >= d'\'''

echo '$ test-expr '\''!(a != (b || C)) >= D'\'''
test-expr '!(a != (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (b || C)) >= D'\'''

echo '$ test-expr '\''!(a != (B || c)) >= d'\'''
test-expr '!(a != (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || c)) >= d'\'''

echo '$ test-expr '\''!(a != (B || c)) >= D'\'''
test-expr '!(a != (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || c)) >= D'\'''

echo '$ test-expr '\''!(a != (B || C)) >= d'\'''
test-expr '!(a != (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || C)) >= d'\'''

echo '$ test-expr '\''!(a != (B || C)) >= D'\'''
test-expr '!(a != (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a != (B || C)) >= D'\'''

echo '$ test-expr '\''!(A != (b || c)) >= d'\'''
test-expr '!(A != (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || c)) >= d'\'''

echo '$ test-expr '\''!(A != (b || c)) >= D'\'''
test-expr '!(A != (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || c)) >= D'\'''

echo '$ test-expr '\''!(A != (b || C)) >= d'\'''
test-expr '!(A != (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || C)) >= d'\'''

echo '$ test-expr '\''!(A != (b || C)) >= D'\'''
test-expr '!(A != (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (b || C)) >= D'\'''

echo '$ test-expr '\''!(A != (B || c)) >= d'\'''
test-expr '!(A != (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || c)) >= d'\'''

echo '$ test-expr '\''!(A != (B || c)) >= D'\'''
test-expr '!(A != (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || c)) >= D'\'''

echo '$ test-expr '\''!(A != (B || C)) >= d'\'''
test-expr '!(A != (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || C)) >= d'\'''

echo '$ test-expr '\''!(A != (B || C)) >= D'\'''
test-expr '!(A != (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A != (B || C)) >= D'\'''

echo '$ test-expr '\''!(a && (b || c)) >= d'\'''
test-expr '!(a && (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || c)) >= d'\'''

echo '$ test-expr '\''!(a && (b || c)) >= D'\'''
test-expr '!(a && (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || c)) >= D'\'''

echo '$ test-expr '\''!(a && (b || C)) >= d'\'''
test-expr '!(a && (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || C)) >= d'\'''

echo '$ test-expr '\''!(a && (b || C)) >= D'\'''
test-expr '!(a && (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || C)) >= D'\'''

echo '$ test-expr '\''!(a && (B || c)) >= d'\'''
test-expr '!(a && (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || c)) >= d'\'''

echo '$ test-expr '\''!(a && (B || c)) >= D'\'''
test-expr '!(a && (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || c)) >= D'\'''

echo '$ test-expr '\''!(a && (B || C)) >= d'\'''
test-expr '!(a && (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || C)) >= d'\'''

echo '$ test-expr '\''!(a && (B || C)) >= D'\'''
test-expr '!(a && (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || C)) >= D'\'''

echo '$ test-expr '\''!(A && (b || c)) >= d'\'''
test-expr '!(A && (b || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || c)) >= d'\'''

echo '$ test-expr '\''!(A && (b || c)) >= D'\'''
test-expr '!(A && (b || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || c)) >= D'\'''

echo '$ test-expr '\''!(A && (b || C)) >= d'\'''
test-expr '!(A && (b || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || C)) >= d'\'''

echo '$ test-expr '\''!(A && (b || C)) >= D'\'''
test-expr '!(A && (b || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || C)) >= D'\'''

echo '$ test-expr '\''!(A && (B || c)) >= d'\'''
test-expr '!(A && (B || c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || c)) >= d'\'''

echo '$ test-expr '\''!(A && (B || c)) >= D'\'''
test-expr '!(A && (B || c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || c)) >= D'\'''

echo '$ test-expr '\''!(A && (B || C)) >= d'\'''
test-expr '!(A && (B || C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || C)) >= d'\'''

echo '$ test-expr '\''!(A && (B || C)) >= D'\'''
test-expr '!(A && (B || C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || C)) >= D'\'''

echo '$ test-expr '\''!(a && (b || c)) != d'\'''
test-expr '!(a && (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || c)) != d'\'''

echo '$ test-expr '\''!(a && (b || c)) != D'\'''
test-expr '!(a && (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || c)) != D'\'''

echo '$ test-expr '\''!(a && (b || C)) != d'\'''
test-expr '!(a && (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || C)) != d'\'''

echo '$ test-expr '\''!(a && (b || C)) != D'\'''
test-expr '!(a && (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b || C)) != D'\'''

echo '$ test-expr '\''!(a && (B || c)) != d'\'''
test-expr '!(a && (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || c)) != d'\'''

echo '$ test-expr '\''!(a && (B || c)) != D'\'''
test-expr '!(a && (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || c)) != D'\'''

echo '$ test-expr '\''!(a && (B || C)) != d'\'''
test-expr '!(a && (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || C)) != d'\'''

echo '$ test-expr '\''!(a && (B || C)) != D'\'''
test-expr '!(a && (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B || C)) != D'\'''

echo '$ test-expr '\''!(A && (b || c)) != d'\'''
test-expr '!(A && (b || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || c)) != d'\'''

echo '$ test-expr '\''!(A && (b || c)) != D'\'''
test-expr '!(A && (b || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || c)) != D'\'''

echo '$ test-expr '\''!(A && (b || C)) != d'\'''
test-expr '!(A && (b || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || C)) != d'\'''

echo '$ test-expr '\''!(A && (b || C)) != D'\'''
test-expr '!(A && (b || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b || C)) != D'\'''

echo '$ test-expr '\''!(A && (B || c)) != d'\'''
test-expr '!(A && (B || c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || c)) != d'\'''

echo '$ test-expr '\''!(A && (B || c)) != D'\'''
test-expr '!(A && (B || c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || c)) != D'\'''

echo '$ test-expr '\''!(A && (B || C)) != d'\'''
test-expr '!(A && (B || C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || C)) != d'\'''

echo '$ test-expr '\''!(A && (B || C)) != D'\'''
test-expr '!(A && (B || C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B || C)) != D'\'''

echo '$ test-expr '\''!(a != b) && (c >= d)'\'''
test-expr '!(a != b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (c >= d)'\'''

echo '$ test-expr '\''!(a != b) && (c >= D)'\'''
test-expr '!(a != b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (c >= D)'\'''

echo '$ test-expr '\''!(a != b) && (C >= d)'\'''
test-expr '!(a != b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (C >= d)'\'''

echo '$ test-expr '\''!(a != b) && (C >= D)'\'''
test-expr '!(a != b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) && (C >= D)'\'''

echo '$ test-expr '\''!(a != B) && (c >= d)'\'''
test-expr '!(a != B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (c >= d)'\'''

echo '$ test-expr '\''!(a != B) && (c >= D)'\'''
test-expr '!(a != B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (c >= D)'\'''

echo '$ test-expr '\''!(a != B) && (C >= d)'\'''
test-expr '!(a != B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (C >= d)'\'''

echo '$ test-expr '\''!(a != B) && (C >= D)'\'''
test-expr '!(a != B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) && (C >= D)'\'''

echo '$ test-expr '\''!(A != b) && (c >= d)'\'''
test-expr '!(A != b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (c >= d)'\'''

echo '$ test-expr '\''!(A != b) && (c >= D)'\'''
test-expr '!(A != b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (c >= D)'\'''

echo '$ test-expr '\''!(A != b) && (C >= d)'\'''
test-expr '!(A != b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (C >= d)'\'''

echo '$ test-expr '\''!(A != b) && (C >= D)'\'''
test-expr '!(A != b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) && (C >= D)'\'''

echo '$ test-expr '\''!(A != B) && (c >= d)'\'''
test-expr '!(A != B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (c >= d)'\'''

echo '$ test-expr '\''!(A != B) && (c >= D)'\'''
test-expr '!(A != B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (c >= D)'\'''

echo '$ test-expr '\''!(A != B) && (C >= d)'\'''
test-expr '!(A != B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (C >= d)'\'''

echo '$ test-expr '\''!(A != B) && (C >= D)'\'''
test-expr '!(A != B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) && (C >= D)'\'''

echo '$ test-expr '\''!(a != b) || (c >= d)'\'''
test-expr '!(a != b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (c >= d)'\'''

echo '$ test-expr '\''!(a != b) || (c >= D)'\'''
test-expr '!(a != b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (c >= D)'\'''

echo '$ test-expr '\''!(a != b) || (C >= d)'\'''
test-expr '!(a != b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (C >= d)'\'''

echo '$ test-expr '\''!(a != b) || (C >= D)'\'''
test-expr '!(a != b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != b) || (C >= D)'\'''

echo '$ test-expr '\''!(a != B) || (c >= d)'\'''
test-expr '!(a != B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (c >= d)'\'''

echo '$ test-expr '\''!(a != B) || (c >= D)'\'''
test-expr '!(a != B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (c >= D)'\'''

echo '$ test-expr '\''!(a != B) || (C >= d)'\'''
test-expr '!(a != B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (C >= d)'\'''

echo '$ test-expr '\''!(a != B) || (C >= D)'\'''
test-expr '!(a != B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a != B) || (C >= D)'\'''

echo '$ test-expr '\''!(A != b) || (c >= d)'\'''
test-expr '!(A != b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (c >= d)'\'''

echo '$ test-expr '\''!(A != b) || (c >= D)'\'''
test-expr '!(A != b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (c >= D)'\'''

echo '$ test-expr '\''!(A != b) || (C >= d)'\'''
test-expr '!(A != b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (C >= d)'\'''

echo '$ test-expr '\''!(A != b) || (C >= D)'\'''
test-expr '!(A != b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != b) || (C >= D)'\'''

echo '$ test-expr '\''!(A != B) || (c >= d)'\'''
test-expr '!(A != B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (c >= d)'\'''

echo '$ test-expr '\''!(A != B) || (c >= D)'\'''
test-expr '!(A != B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (c >= D)'\'''

echo '$ test-expr '\''!(A != B) || (C >= d)'\'''
test-expr '!(A != B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (C >= d)'\'''

echo '$ test-expr '\''!(A != B) || (C >= D)'\'''
test-expr '!(A != B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A != B) || (C >= D)'\'''

echo '$ test-expr '\''!(a && b) || (c >= d)'\'''
test-expr '!(a && b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (c >= d)'\'''

echo '$ test-expr '\''!(a && b) || (c >= D)'\'''
test-expr '!(a && b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (c >= D)'\'''

echo '$ test-expr '\''!(a && b) || (C >= d)'\'''
test-expr '!(a && b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (C >= d)'\'''

echo '$ test-expr '\''!(a && b) || (C >= D)'\'''
test-expr '!(a && b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (C >= D)'\'''

echo '$ test-expr '\''!(a && B) || (c >= d)'\'''
test-expr '!(a && B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (c >= d)'\'''

echo '$ test-expr '\''!(a && B) || (c >= D)'\'''
test-expr '!(a && B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (c >= D)'\'''

echo '$ test-expr '\''!(a && B) || (C >= d)'\'''
test-expr '!(a && B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (C >= d)'\'''

echo '$ test-expr '\''!(a && B) || (C >= D)'\'''
test-expr '!(a && B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (C >= D)'\'''

echo '$ test-expr '\''!(A && b) || (c >= d)'\'''
test-expr '!(A && b) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (c >= d)'\'''

echo '$ test-expr '\''!(A && b) || (c >= D)'\'''
test-expr '!(A && b) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (c >= D)'\'''

echo '$ test-expr '\''!(A && b) || (C >= d)'\'''
test-expr '!(A && b) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (C >= d)'\'''

echo '$ test-expr '\''!(A && b) || (C >= D)'\'''
test-expr '!(A && b) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (C >= D)'\'''

echo '$ test-expr '\''!(A && B) || (c >= d)'\'''
test-expr '!(A && B) || (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (c >= d)'\'''

echo '$ test-expr '\''!(A && B) || (c >= D)'\'''
test-expr '!(A && B) || (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (c >= D)'\'''

echo '$ test-expr '\''!(A && B) || (C >= d)'\'''
test-expr '!(A && B) || (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (C >= d)'\'''

echo '$ test-expr '\''!(A && B) || (C >= D)'\'''
test-expr '!(A && B) || (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (C >= D)'\'''

echo '$ test-expr '\''!(a && b) || (c != d)'\'''
test-expr '!(a && b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (c != d)'\'''

echo '$ test-expr '\''!(a && b) || (c != D)'\'''
test-expr '!(a && b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (c != D)'\'''

echo '$ test-expr '\''!(a && b) || (C != d)'\'''
test-expr '!(a && b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (C != d)'\'''

echo '$ test-expr '\''!(a && b) || (C != D)'\'''
test-expr '!(a && b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) || (C != D)'\'''

echo '$ test-expr '\''!(a && B) || (c != d)'\'''
test-expr '!(a && B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (c != d)'\'''

echo '$ test-expr '\''!(a && B) || (c != D)'\'''
test-expr '!(a && B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (c != D)'\'''

echo '$ test-expr '\''!(a && B) || (C != d)'\'''
test-expr '!(a && B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (C != d)'\'''

echo '$ test-expr '\''!(a && B) || (C != D)'\'''
test-expr '!(a && B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) || (C != D)'\'''

echo '$ test-expr '\''!(A && b) || (c != d)'\'''
test-expr '!(A && b) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (c != d)'\'''

echo '$ test-expr '\''!(A && b) || (c != D)'\'''
test-expr '!(A && b) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (c != D)'\'''

echo '$ test-expr '\''!(A && b) || (C != d)'\'''
test-expr '!(A && b) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (C != d)'\'''

echo '$ test-expr '\''!(A && b) || (C != D)'\'''
test-expr '!(A && b) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) || (C != D)'\'''

echo '$ test-expr '\''!(A && B) || (c != d)'\'''
test-expr '!(A && B) || (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (c != d)'\'''

echo '$ test-expr '\''!(A && B) || (c != D)'\'''
test-expr '!(A && B) || (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (c != D)'\'''

echo '$ test-expr '\''!(A && B) || (C != d)'\'''
test-expr '!(A && B) || (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (C != d)'\'''

echo '$ test-expr '\''!(A && B) || (C != D)'\'''
test-expr '!(A && B) || (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) || (C != D)'\'''

echo '$ test-expr '\''a != !(b && (c >= d))'\'''
test-expr 'a != !(b && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (c >= d))'\'''

echo '$ test-expr '\''a != !(b && (c >= D))'\'''
test-expr 'a != !(b && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (c >= D))'\'''

echo '$ test-expr '\''a != !(b && (C >= d))'\'''
test-expr 'a != !(b && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (C >= d))'\'''

echo '$ test-expr '\''a != !(b && (C >= D))'\'''
test-expr 'a != !(b && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b && (C >= D))'\'''

echo '$ test-expr '\''a != !(B && (c >= d))'\'''
test-expr 'a != !(B && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (c >= d))'\'''

echo '$ test-expr '\''a != !(B && (c >= D))'\'''
test-expr 'a != !(B && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (c >= D))'\'''

echo '$ test-expr '\''a != !(B && (C >= d))'\'''
test-expr 'a != !(B && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (C >= d))'\'''

echo '$ test-expr '\''a != !(B && (C >= D))'\'''
test-expr 'a != !(B && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B && (C >= D))'\'''

echo '$ test-expr '\''A != !(b && (c >= d))'\'''
test-expr 'A != !(b && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (c >= d))'\'''

echo '$ test-expr '\''A != !(b && (c >= D))'\'''
test-expr 'A != !(b && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (c >= D))'\'''

echo '$ test-expr '\''A != !(b && (C >= d))'\'''
test-expr 'A != !(b && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (C >= d))'\'''

echo '$ test-expr '\''A != !(b && (C >= D))'\'''
test-expr 'A != !(b && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b && (C >= D))'\'''

echo '$ test-expr '\''A != !(B && (c >= d))'\'''
test-expr 'A != !(B && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (c >= d))'\'''

echo '$ test-expr '\''A != !(B && (c >= D))'\'''
test-expr 'A != !(B && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (c >= D))'\'''

echo '$ test-expr '\''A != !(B && (C >= d))'\'''
test-expr 'A != !(B && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (C >= d))'\'''

echo '$ test-expr '\''A != !(B && (C >= D))'\'''
test-expr 'A != !(B && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B && (C >= D))'\'''

echo '$ test-expr '\''a != !(b || (c >= d))'\'''
test-expr 'a != !(b || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (c >= d))'\'''

echo '$ test-expr '\''a != !(b || (c >= D))'\'''
test-expr 'a != !(b || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (c >= D))'\'''

echo '$ test-expr '\''a != !(b || (C >= d))'\'''
test-expr 'a != !(b || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (C >= d))'\'''

echo '$ test-expr '\''a != !(b || (C >= D))'\'''
test-expr 'a != !(b || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(b || (C >= D))'\'''

echo '$ test-expr '\''a != !(B || (c >= d))'\'''
test-expr 'a != !(B || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (c >= d))'\'''

echo '$ test-expr '\''a != !(B || (c >= D))'\'''
test-expr 'a != !(B || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (c >= D))'\'''

echo '$ test-expr '\''a != !(B || (C >= d))'\'''
test-expr 'a != !(B || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (C >= d))'\'''

echo '$ test-expr '\''a != !(B || (C >= D))'\'''
test-expr 'a != !(B || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a != !(B || (C >= D))'\'''

echo '$ test-expr '\''A != !(b || (c >= d))'\'''
test-expr 'A != !(b || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (c >= d))'\'''

echo '$ test-expr '\''A != !(b || (c >= D))'\'''
test-expr 'A != !(b || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (c >= D))'\'''

echo '$ test-expr '\''A != !(b || (C >= d))'\'''
test-expr 'A != !(b || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (C >= d))'\'''

echo '$ test-expr '\''A != !(b || (C >= D))'\'''
test-expr 'A != !(b || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(b || (C >= D))'\'''

echo '$ test-expr '\''A != !(B || (c >= d))'\'''
test-expr 'A != !(B || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (c >= d))'\'''

echo '$ test-expr '\''A != !(B || (c >= D))'\'''
test-expr 'A != !(B || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (c >= D))'\'''

echo '$ test-expr '\''A != !(B || (C >= d))'\'''
test-expr 'A != !(B || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (C >= d))'\'''

echo '$ test-expr '\''A != !(B || (C >= D))'\'''
test-expr 'A != !(B || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A != !(B || (C >= D))'\'''

echo '$ test-expr '\''a && !(b || (c >= d))'\'''
test-expr 'a && !(b || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (c >= d))'\'''

echo '$ test-expr '\''a && !(b || (c >= D))'\'''
test-expr 'a && !(b || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (c >= D))'\'''

echo '$ test-expr '\''a && !(b || (C >= d))'\'''
test-expr 'a && !(b || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (C >= d))'\'''

echo '$ test-expr '\''a && !(b || (C >= D))'\'''
test-expr 'a && !(b || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (C >= D))'\'''

echo '$ test-expr '\''a && !(B || (c >= d))'\'''
test-expr 'a && !(B || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (c >= d))'\'''

echo '$ test-expr '\''a && !(B || (c >= D))'\'''
test-expr 'a && !(B || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (c >= D))'\'''

echo '$ test-expr '\''a && !(B || (C >= d))'\'''
test-expr 'a && !(B || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (C >= d))'\'''

echo '$ test-expr '\''a && !(B || (C >= D))'\'''
test-expr 'a && !(B || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (C >= D))'\'''

echo '$ test-expr '\''A && !(b || (c >= d))'\'''
test-expr 'A && !(b || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (c >= d))'\'''

echo '$ test-expr '\''A && !(b || (c >= D))'\'''
test-expr 'A && !(b || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (c >= D))'\'''

echo '$ test-expr '\''A && !(b || (C >= d))'\'''
test-expr 'A && !(b || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (C >= d))'\'''

echo '$ test-expr '\''A && !(b || (C >= D))'\'''
test-expr 'A && !(b || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (C >= D))'\'''

echo '$ test-expr '\''A && !(B || (c >= d))'\'''
test-expr 'A && !(B || (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (c >= d))'\'''

echo '$ test-expr '\''A && !(B || (c >= D))'\'''
test-expr 'A && !(B || (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (c >= D))'\'''

echo '$ test-expr '\''A && !(B || (C >= d))'\'''
test-expr 'A && !(B || (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (C >= d))'\'''

echo '$ test-expr '\''A && !(B || (C >= D))'\'''
test-expr 'A && !(B || (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (C >= D))'\'''

echo '$ test-expr '\''a && !(b || (c != d))'\'''
test-expr 'a && !(b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (c != d))'\'''

echo '$ test-expr '\''a && !(b || (c != D))'\'''
test-expr 'a && !(b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (c != D))'\'''

echo '$ test-expr '\''a && !(b || (C != d))'\'''
test-expr 'a && !(b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (C != d))'\'''

echo '$ test-expr '\''a && !(b || (C != D))'\'''
test-expr 'a && !(b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b || (C != D))'\'''

echo '$ test-expr '\''a && !(B || (c != d))'\'''
test-expr 'a && !(B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (c != d))'\'''

echo '$ test-expr '\''a && !(B || (c != D))'\'''
test-expr 'a && !(B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (c != D))'\'''

echo '$ test-expr '\''a && !(B || (C != d))'\'''
test-expr 'a && !(B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (C != d))'\'''

echo '$ test-expr '\''a && !(B || (C != D))'\'''
test-expr 'a && !(B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B || (C != D))'\'''

echo '$ test-expr '\''A && !(b || (c != d))'\'''
test-expr 'A && !(b || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (c != d))'\'''

echo '$ test-expr '\''A && !(b || (c != D))'\'''
test-expr 'A && !(b || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (c != D))'\'''

echo '$ test-expr '\''A && !(b || (C != d))'\'''
test-expr 'A && !(b || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (C != d))'\'''

echo '$ test-expr '\''A && !(b || (C != D))'\'''
test-expr 'A && !(b || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b || (C != D))'\'''

echo '$ test-expr '\''A && !(B || (c != d))'\'''
test-expr 'A && !(B || (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (c != d))'\'''

echo '$ test-expr '\''A && !(B || (c != D))'\'''
test-expr 'A && !(B || (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (c != D))'\'''

echo '$ test-expr '\''A && !(B || (C != d))'\'''
test-expr 'A && !(B || (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (C != d))'\'''

echo '$ test-expr '\''A && !(B || (C != D))'\'''
test-expr 'A && !(B || (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B || (C != D))'\'''

echo '$ test-expr '\''!((a && b) >= c) != d'\'''
test-expr '!((a && b) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= c) != d'\'''

echo '$ test-expr '\''!((a && b) >= c) != D'\'''
test-expr '!((a && b) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= c) != D'\'''

echo '$ test-expr '\''!((a && b) >= C) != d'\'''
test-expr '!((a && b) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= C) != d'\'''

echo '$ test-expr '\''!((a && b) >= C) != D'\'''
test-expr '!((a && b) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) >= C) != D'\'''

echo '$ test-expr '\''!((a && B) >= c) != d'\'''
test-expr '!((a && B) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= c) != d'\'''

echo '$ test-expr '\''!((a && B) >= c) != D'\'''
test-expr '!((a && B) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= c) != D'\'''

echo '$ test-expr '\''!((a && B) >= C) != d'\'''
test-expr '!((a && B) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= C) != d'\'''

echo '$ test-expr '\''!((a && B) >= C) != D'\'''
test-expr '!((a && B) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) >= C) != D'\'''

echo '$ test-expr '\''!((A && b) >= c) != d'\'''
test-expr '!((A && b) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= c) != d'\'''

echo '$ test-expr '\''!((A && b) >= c) != D'\'''
test-expr '!((A && b) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= c) != D'\'''

echo '$ test-expr '\''!((A && b) >= C) != d'\'''
test-expr '!((A && b) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= C) != d'\'''

echo '$ test-expr '\''!((A && b) >= C) != D'\'''
test-expr '!((A && b) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) >= C) != D'\'''

echo '$ test-expr '\''!((A && B) >= c) != d'\'''
test-expr '!((A && B) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= c) != d'\'''

echo '$ test-expr '\''!((A && B) >= c) != D'\'''
test-expr '!((A && B) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= c) != D'\'''

echo '$ test-expr '\''!((A && B) >= C) != d'\'''
test-expr '!((A && B) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= C) != d'\'''

echo '$ test-expr '\''!((A && B) >= C) != D'\'''
test-expr '!((A && B) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) >= C) != D'\'''

echo '$ test-expr '\''!((a || b) >= c) != d'\'''
test-expr '!((a || b) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= c) != d'\'''

echo '$ test-expr '\''!((a || b) >= c) != D'\'''
test-expr '!((a || b) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= c) != D'\'''

echo '$ test-expr '\''!((a || b) >= C) != d'\'''
test-expr '!((a || b) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= C) != d'\'''

echo '$ test-expr '\''!((a || b) >= C) != D'\'''
test-expr '!((a || b) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= C) != D'\'''

echo '$ test-expr '\''!((a || B) >= c) != d'\'''
test-expr '!((a || B) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= c) != d'\'''

echo '$ test-expr '\''!((a || B) >= c) != D'\'''
test-expr '!((a || B) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= c) != D'\'''

echo '$ test-expr '\''!((a || B) >= C) != d'\'''
test-expr '!((a || B) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= C) != d'\'''

echo '$ test-expr '\''!((a || B) >= C) != D'\'''
test-expr '!((a || B) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= C) != D'\'''

echo '$ test-expr '\''!((A || b) >= c) != d'\'''
test-expr '!((A || b) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= c) != d'\'''

echo '$ test-expr '\''!((A || b) >= c) != D'\'''
test-expr '!((A || b) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= c) != D'\'''

echo '$ test-expr '\''!((A || b) >= C) != d'\'''
test-expr '!((A || b) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= C) != d'\'''

echo '$ test-expr '\''!((A || b) >= C) != D'\'''
test-expr '!((A || b) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= C) != D'\'''

echo '$ test-expr '\''!((A || B) >= c) != d'\'''
test-expr '!((A || B) >= c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= c) != d'\'''

echo '$ test-expr '\''!((A || B) >= c) != D'\'''
test-expr '!((A || B) >= c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= c) != D'\'''

echo '$ test-expr '\''!((A || B) >= C) != d'\'''
test-expr '!((A || B) >= C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= C) != d'\'''

echo '$ test-expr '\''!((A || B) >= C) != D'\'''
test-expr '!((A || B) >= C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= C) != D'\'''

echo '$ test-expr '\''!((a || b) >= c) && d'\'''
test-expr '!((a || b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= c) && d'\'''

echo '$ test-expr '\''!((a || b) >= c) && D'\'''
test-expr '!((a || b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= c) && D'\'''

echo '$ test-expr '\''!((a || b) >= C) && d'\'''
test-expr '!((a || b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= C) && d'\'''

echo '$ test-expr '\''!((a || b) >= C) && D'\'''
test-expr '!((a || b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) >= C) && D'\'''

echo '$ test-expr '\''!((a || B) >= c) && d'\'''
test-expr '!((a || B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= c) && d'\'''

echo '$ test-expr '\''!((a || B) >= c) && D'\'''
test-expr '!((a || B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= c) && D'\'''

echo '$ test-expr '\''!((a || B) >= C) && d'\'''
test-expr '!((a || B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= C) && d'\'''

echo '$ test-expr '\''!((a || B) >= C) && D'\'''
test-expr '!((a || B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) >= C) && D'\'''

echo '$ test-expr '\''!((A || b) >= c) && d'\'''
test-expr '!((A || b) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= c) && d'\'''

echo '$ test-expr '\''!((A || b) >= c) && D'\'''
test-expr '!((A || b) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= c) && D'\'''

echo '$ test-expr '\''!((A || b) >= C) && d'\'''
test-expr '!((A || b) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= C) && d'\'''

echo '$ test-expr '\''!((A || b) >= C) && D'\'''
test-expr '!((A || b) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) >= C) && D'\'''

echo '$ test-expr '\''!((A || B) >= c) && d'\'''
test-expr '!((A || B) >= c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= c) && d'\'''

echo '$ test-expr '\''!((A || B) >= c) && D'\'''
test-expr '!((A || B) >= c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= c) && D'\'''

echo '$ test-expr '\''!((A || B) >= C) && d'\'''
test-expr '!((A || B) >= C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= C) && d'\'''

echo '$ test-expr '\''!((A || B) >= C) && D'\'''
test-expr '!((A || B) >= C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) >= C) && D'\'''

echo '$ test-expr '\''!((a || b) != c) && d'\'''
test-expr '!((a || b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != c) && d'\'''

echo '$ test-expr '\''!((a || b) != c) && D'\'''
test-expr '!((a || b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != c) && D'\'''

echo '$ test-expr '\''!((a || b) != C) && d'\'''
test-expr '!((a || b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != C) && d'\'''

echo '$ test-expr '\''!((a || b) != C) && D'\'''
test-expr '!((a || b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != C) && D'\'''

echo '$ test-expr '\''!((a || B) != c) && d'\'''
test-expr '!((a || B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != c) && d'\'''

echo '$ test-expr '\''!((a || B) != c) && D'\'''
test-expr '!((a || B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != c) && D'\'''

echo '$ test-expr '\''!((a || B) != C) && d'\'''
test-expr '!((a || B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != C) && d'\'''

echo '$ test-expr '\''!((a || B) != C) && D'\'''
test-expr '!((a || B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != C) && D'\'''

echo '$ test-expr '\''!((A || b) != c) && d'\'''
test-expr '!((A || b) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != c) && d'\'''

echo '$ test-expr '\''!((A || b) != c) && D'\'''
test-expr '!((A || b) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != c) && D'\'''

echo '$ test-expr '\''!((A || b) != C) && d'\'''
test-expr '!((A || b) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != C) && d'\'''

echo '$ test-expr '\''!((A || b) != C) && D'\'''
test-expr '!((A || b) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != C) && D'\'''

echo '$ test-expr '\''!((A || B) != c) && d'\'''
test-expr '!((A || B) != c) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != c) && d'\'''

echo '$ test-expr '\''!((A || B) != c) && D'\'''
test-expr '!((A || B) != c) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != c) && D'\'''

echo '$ test-expr '\''!((A || B) != C) && d'\'''
test-expr '!((A || B) != C) && d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != C) && d'\'''

echo '$ test-expr '\''!((A || B) != C) && D'\'''
test-expr '!((A || B) != C) && D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != C) && D'\'''

echo '$ test-expr '\''a && !((b >= c) != d)'\'''
test-expr 'a && !((b >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= c) != d)'\'''

echo '$ test-expr '\''a && !((b >= c) != D)'\'''
test-expr 'a && !((b >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= c) != D)'\'''

echo '$ test-expr '\''a && !((b >= C) != d)'\'''
test-expr 'a && !((b >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= C) != d)'\'''

echo '$ test-expr '\''a && !((b >= C) != D)'\'''
test-expr 'a && !((b >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b >= C) != D)'\'''

echo '$ test-expr '\''a && !((B >= c) != d)'\'''
test-expr 'a && !((B >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= c) != d)'\'''

echo '$ test-expr '\''a && !((B >= c) != D)'\'''
test-expr 'a && !((B >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= c) != D)'\'''

echo '$ test-expr '\''a && !((B >= C) != d)'\'''
test-expr 'a && !((B >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= C) != d)'\'''

echo '$ test-expr '\''a && !((B >= C) != D)'\'''
test-expr 'a && !((B >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B >= C) != D)'\'''

echo '$ test-expr '\''A && !((b >= c) != d)'\'''
test-expr 'A && !((b >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= c) != d)'\'''

echo '$ test-expr '\''A && !((b >= c) != D)'\'''
test-expr 'A && !((b >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= c) != D)'\'''

echo '$ test-expr '\''A && !((b >= C) != d)'\'''
test-expr 'A && !((b >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= C) != d)'\'''

echo '$ test-expr '\''A && !((b >= C) != D)'\'''
test-expr 'A && !((b >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b >= C) != D)'\'''

echo '$ test-expr '\''A && !((B >= c) != d)'\'''
test-expr 'A && !((B >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= c) != d)'\'''

echo '$ test-expr '\''A && !((B >= c) != D)'\'''
test-expr 'A && !((B >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= c) != D)'\'''

echo '$ test-expr '\''A && !((B >= C) != d)'\'''
test-expr 'A && !((B >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= C) != d)'\'''

echo '$ test-expr '\''A && !((B >= C) != D)'\'''
test-expr 'A && !((B >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B >= C) != D)'\'''

echo '$ test-expr '\''a || !((b >= c) != d)'\'''
test-expr 'a || !((b >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= c) != d)'\'''

echo '$ test-expr '\''a || !((b >= c) != D)'\'''
test-expr 'a || !((b >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= c) != D)'\'''

echo '$ test-expr '\''a || !((b >= C) != d)'\'''
test-expr 'a || !((b >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= C) != d)'\'''

echo '$ test-expr '\''a || !((b >= C) != D)'\'''
test-expr 'a || !((b >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= C) != D)'\'''

echo '$ test-expr '\''a || !((B >= c) != d)'\'''
test-expr 'a || !((B >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= c) != d)'\'''

echo '$ test-expr '\''a || !((B >= c) != D)'\'''
test-expr 'a || !((B >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= c) != D)'\'''

echo '$ test-expr '\''a || !((B >= C) != d)'\'''
test-expr 'a || !((B >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= C) != d)'\'''

echo '$ test-expr '\''a || !((B >= C) != D)'\'''
test-expr 'a || !((B >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= C) != D)'\'''

echo '$ test-expr '\''A || !((b >= c) != d)'\'''
test-expr 'A || !((b >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= c) != d)'\'''

echo '$ test-expr '\''A || !((b >= c) != D)'\'''
test-expr 'A || !((b >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= c) != D)'\'''

echo '$ test-expr '\''A || !((b >= C) != d)'\'''
test-expr 'A || !((b >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= C) != d)'\'''

echo '$ test-expr '\''A || !((b >= C) != D)'\'''
test-expr 'A || !((b >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= C) != D)'\'''

echo '$ test-expr '\''A || !((B >= c) != d)'\'''
test-expr 'A || !((B >= c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= c) != d)'\'''

echo '$ test-expr '\''A || !((B >= c) != D)'\'''
test-expr 'A || !((B >= c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= c) != D)'\'''

echo '$ test-expr '\''A || !((B >= C) != d)'\'''
test-expr 'A || !((B >= C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= C) != d)'\'''

echo '$ test-expr '\''A || !((B >= C) != D)'\'''
test-expr 'A || !((B >= C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= C) != D)'\'''

echo '$ test-expr '\''a || !((b >= c) && d)'\'''
test-expr 'a || !((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= c) && d)'\'''

echo '$ test-expr '\''a || !((b >= c) && D)'\'''
test-expr 'a || !((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= c) && D)'\'''

echo '$ test-expr '\''a || !((b >= C) && d)'\'''
test-expr 'a || !((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= C) && d)'\'''

echo '$ test-expr '\''a || !((b >= C) && D)'\'''
test-expr 'a || !((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b >= C) && D)'\'''

echo '$ test-expr '\''a || !((B >= c) && d)'\'''
test-expr 'a || !((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= c) && d)'\'''

echo '$ test-expr '\''a || !((B >= c) && D)'\'''
test-expr 'a || !((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= c) && D)'\'''

echo '$ test-expr '\''a || !((B >= C) && d)'\'''
test-expr 'a || !((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= C) && d)'\'''

echo '$ test-expr '\''a || !((B >= C) && D)'\'''
test-expr 'a || !((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B >= C) && D)'\'''

echo '$ test-expr '\''A || !((b >= c) && d)'\'''
test-expr 'A || !((b >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= c) && d)'\'''

echo '$ test-expr '\''A || !((b >= c) && D)'\'''
test-expr 'A || !((b >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= c) && D)'\'''

echo '$ test-expr '\''A || !((b >= C) && d)'\'''
test-expr 'A || !((b >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= C) && d)'\'''

echo '$ test-expr '\''A || !((b >= C) && D)'\'''
test-expr 'A || !((b >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b >= C) && D)'\'''

echo '$ test-expr '\''A || !((B >= c) && d)'\'''
test-expr 'A || !((B >= c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= c) && d)'\'''

echo '$ test-expr '\''A || !((B >= c) && D)'\'''
test-expr 'A || !((B >= c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= c) && D)'\'''

echo '$ test-expr '\''A || !((B >= C) && d)'\'''
test-expr 'A || !((B >= C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= C) && d)'\'''

echo '$ test-expr '\''A || !((B >= C) && D)'\'''
test-expr 'A || !((B >= C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B >= C) && D)'\'''

echo '$ test-expr '\''a || !((b != c) && d)'\'''
test-expr 'a || !((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != c) && d)'\'''

echo '$ test-expr '\''a || !((b != c) && D)'\'''
test-expr 'a || !((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != c) && D)'\'''

echo '$ test-expr '\''a || !((b != C) && d)'\'''
test-expr 'a || !((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != C) && d)'\'''

echo '$ test-expr '\''a || !((b != C) && D)'\'''
test-expr 'a || !((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != C) && D)'\'''

echo '$ test-expr '\''a || !((B != c) && d)'\'''
test-expr 'a || !((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != c) && d)'\'''

echo '$ test-expr '\''a || !((B != c) && D)'\'''
test-expr 'a || !((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != c) && D)'\'''

echo '$ test-expr '\''a || !((B != C) && d)'\'''
test-expr 'a || !((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != C) && d)'\'''

echo '$ test-expr '\''a || !((B != C) && D)'\'''
test-expr 'a || !((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != C) && D)'\'''

echo '$ test-expr '\''A || !((b != c) && d)'\'''
test-expr 'A || !((b != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != c) && d)'\'''

echo '$ test-expr '\''A || !((b != c) && D)'\'''
test-expr 'A || !((b != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != c) && D)'\'''

echo '$ test-expr '\''A || !((b != C) && d)'\'''
test-expr 'A || !((b != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != C) && d)'\'''

echo '$ test-expr '\''A || !((b != C) && D)'\'''
test-expr 'A || !((b != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != C) && D)'\'''

echo '$ test-expr '\''A || !((B != c) && d)'\'''
test-expr 'A || !((B != c) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != c) && d)'\'''

echo '$ test-expr '\''A || !((B != c) && D)'\'''
test-expr 'A || !((B != c) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != c) && D)'\'''

echo '$ test-expr '\''A || !((B != C) && d)'\'''
test-expr 'A || !((B != C) && d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != C) && d)'\'''

echo '$ test-expr '\''A || !((B != C) && D)'\'''
test-expr 'A || !((B != C) && D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != C) && D)'\'''

echo '$ test-expr '\''!(a && (b >= c)) != d'\'''
test-expr '!(a && (b >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= c)) != d'\'''

echo '$ test-expr '\''!(a && (b >= c)) != D'\'''
test-expr '!(a && (b >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= c)) != D'\'''

echo '$ test-expr '\''!(a && (b >= C)) != d'\'''
test-expr '!(a && (b >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= C)) != d'\'''

echo '$ test-expr '\''!(a && (b >= C)) != D'\'''
test-expr '!(a && (b >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b >= C)) != D'\'''

echo '$ test-expr '\''!(a && (B >= c)) != d'\'''
test-expr '!(a && (B >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= c)) != d'\'''

echo '$ test-expr '\''!(a && (B >= c)) != D'\'''
test-expr '!(a && (B >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= c)) != D'\'''

echo '$ test-expr '\''!(a && (B >= C)) != d'\'''
test-expr '!(a && (B >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= C)) != d'\'''

echo '$ test-expr '\''!(a && (B >= C)) != D'\'''
test-expr '!(a && (B >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B >= C)) != D'\'''

echo '$ test-expr '\''!(A && (b >= c)) != d'\'''
test-expr '!(A && (b >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= c)) != d'\'''

echo '$ test-expr '\''!(A && (b >= c)) != D'\'''
test-expr '!(A && (b >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= c)) != D'\'''

echo '$ test-expr '\''!(A && (b >= C)) != d'\'''
test-expr '!(A && (b >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= C)) != d'\'''

echo '$ test-expr '\''!(A && (b >= C)) != D'\'''
test-expr '!(A && (b >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b >= C)) != D'\'''

echo '$ test-expr '\''!(A && (B >= c)) != d'\'''
test-expr '!(A && (B >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= c)) != d'\'''

echo '$ test-expr '\''!(A && (B >= c)) != D'\'''
test-expr '!(A && (B >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= c)) != D'\'''

echo '$ test-expr '\''!(A && (B >= C)) != d'\'''
test-expr '!(A && (B >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= C)) != d'\'''

echo '$ test-expr '\''!(A && (B >= C)) != D'\'''
test-expr '!(A && (B >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B >= C)) != D'\'''

echo '$ test-expr '\''!(a || (b >= c)) != d'\'''
test-expr '!(a || (b >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= c)) != d'\'''

echo '$ test-expr '\''!(a || (b >= c)) != D'\'''
test-expr '!(a || (b >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= c)) != D'\'''

echo '$ test-expr '\''!(a || (b >= C)) != d'\'''
test-expr '!(a || (b >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= C)) != d'\'''

echo '$ test-expr '\''!(a || (b >= C)) != D'\'''
test-expr '!(a || (b >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= C)) != D'\'''

echo '$ test-expr '\''!(a || (B >= c)) != d'\'''
test-expr '!(a || (B >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= c)) != d'\'''

echo '$ test-expr '\''!(a || (B >= c)) != D'\'''
test-expr '!(a || (B >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= c)) != D'\'''

echo '$ test-expr '\''!(a || (B >= C)) != d'\'''
test-expr '!(a || (B >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= C)) != d'\'''

echo '$ test-expr '\''!(a || (B >= C)) != D'\'''
test-expr '!(a || (B >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= C)) != D'\'''

echo '$ test-expr '\''!(A || (b >= c)) != d'\'''
test-expr '!(A || (b >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= c)) != d'\'''

echo '$ test-expr '\''!(A || (b >= c)) != D'\'''
test-expr '!(A || (b >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= c)) != D'\'''

echo '$ test-expr '\''!(A || (b >= C)) != d'\'''
test-expr '!(A || (b >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= C)) != d'\'''

echo '$ test-expr '\''!(A || (b >= C)) != D'\'''
test-expr '!(A || (b >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= C)) != D'\'''

echo '$ test-expr '\''!(A || (B >= c)) != d'\'''
test-expr '!(A || (B >= c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= c)) != d'\'''

echo '$ test-expr '\''!(A || (B >= c)) != D'\'''
test-expr '!(A || (B >= c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= c)) != D'\'''

echo '$ test-expr '\''!(A || (B >= C)) != d'\'''
test-expr '!(A || (B >= C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= C)) != d'\'''

echo '$ test-expr '\''!(A || (B >= C)) != D'\'''
test-expr '!(A || (B >= C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= C)) != D'\'''

echo '$ test-expr '\''!(a || (b >= c)) && d'\'''
test-expr '!(a || (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= c)) && d'\'''

echo '$ test-expr '\''!(a || (b >= c)) && D'\'''
test-expr '!(a || (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= c)) && D'\'''

echo '$ test-expr '\''!(a || (b >= C)) && d'\'''
test-expr '!(a || (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= C)) && d'\'''

echo '$ test-expr '\''!(a || (b >= C)) && D'\'''
test-expr '!(a || (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b >= C)) && D'\'''

echo '$ test-expr '\''!(a || (B >= c)) && d'\'''
test-expr '!(a || (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= c)) && d'\'''

echo '$ test-expr '\''!(a || (B >= c)) && D'\'''
test-expr '!(a || (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= c)) && D'\'''

echo '$ test-expr '\''!(a || (B >= C)) && d'\'''
test-expr '!(a || (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= C)) && d'\'''

echo '$ test-expr '\''!(a || (B >= C)) && D'\'''
test-expr '!(a || (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B >= C)) && D'\'''

echo '$ test-expr '\''!(A || (b >= c)) && d'\'''
test-expr '!(A || (b >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= c)) && d'\'''

echo '$ test-expr '\''!(A || (b >= c)) && D'\'''
test-expr '!(A || (b >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= c)) && D'\'''

echo '$ test-expr '\''!(A || (b >= C)) && d'\'''
test-expr '!(A || (b >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= C)) && d'\'''

echo '$ test-expr '\''!(A || (b >= C)) && D'\'''
test-expr '!(A || (b >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b >= C)) && D'\'''

echo '$ test-expr '\''!(A || (B >= c)) && d'\'''
test-expr '!(A || (B >= c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= c)) && d'\'''

echo '$ test-expr '\''!(A || (B >= c)) && D'\'''
test-expr '!(A || (B >= c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= c)) && D'\'''

echo '$ test-expr '\''!(A || (B >= C)) && d'\'''
test-expr '!(A || (B >= C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= C)) && d'\'''

echo '$ test-expr '\''!(A || (B >= C)) && D'\'''
test-expr '!(A || (B >= C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B >= C)) && D'\'''

echo '$ test-expr '\''!(a || (b != c)) && d'\'''
test-expr '!(a || (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != c)) && d'\'''

echo '$ test-expr '\''!(a || (b != c)) && D'\'''
test-expr '!(a || (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != c)) && D'\'''

echo '$ test-expr '\''!(a || (b != C)) && d'\'''
test-expr '!(a || (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != C)) && d'\'''

echo '$ test-expr '\''!(a || (b != C)) && D'\'''
test-expr '!(a || (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != C)) && D'\'''

echo '$ test-expr '\''!(a || (B != c)) && d'\'''
test-expr '!(a || (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != c)) && d'\'''

echo '$ test-expr '\''!(a || (B != c)) && D'\'''
test-expr '!(a || (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != c)) && D'\'''

echo '$ test-expr '\''!(a || (B != C)) && d'\'''
test-expr '!(a || (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != C)) && d'\'''

echo '$ test-expr '\''!(a || (B != C)) && D'\'''
test-expr '!(a || (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != C)) && D'\'''

echo '$ test-expr '\''!(A || (b != c)) && d'\'''
test-expr '!(A || (b != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != c)) && d'\'''

echo '$ test-expr '\''!(A || (b != c)) && D'\'''
test-expr '!(A || (b != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != c)) && D'\'''

echo '$ test-expr '\''!(A || (b != C)) && d'\'''
test-expr '!(A || (b != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != C)) && d'\'''

echo '$ test-expr '\''!(A || (b != C)) && D'\'''
test-expr '!(A || (b != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != C)) && D'\'''

echo '$ test-expr '\''!(A || (B != c)) && d'\'''
test-expr '!(A || (B != c)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != c)) && d'\'''

echo '$ test-expr '\''!(A || (B != c)) && D'\'''
test-expr '!(A || (B != c)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != c)) && D'\'''

echo '$ test-expr '\''!(A || (B != C)) && d'\'''
test-expr '!(A || (B != C)) && d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != C)) && d'\'''

echo '$ test-expr '\''!(A || (B != C)) && D'\'''
test-expr '!(A || (B != C)) && D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != C)) && D'\'''

echo '$ test-expr '\''!(a && b) >= (c != d)'\'''
test-expr '!(a && b) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (c != d)'\'''

echo '$ test-expr '\''!(a && b) >= (c != D)'\'''
test-expr '!(a && b) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (c != D)'\'''

echo '$ test-expr '\''!(a && b) >= (C != d)'\'''
test-expr '!(a && b) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (C != d)'\'''

echo '$ test-expr '\''!(a && b) >= (C != D)'\'''
test-expr '!(a && b) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) >= (C != D)'\'''

echo '$ test-expr '\''!(a && B) >= (c != d)'\'''
test-expr '!(a && B) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (c != d)'\'''

echo '$ test-expr '\''!(a && B) >= (c != D)'\'''
test-expr '!(a && B) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (c != D)'\'''

echo '$ test-expr '\''!(a && B) >= (C != d)'\'''
test-expr '!(a && B) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (C != d)'\'''

echo '$ test-expr '\''!(a && B) >= (C != D)'\'''
test-expr '!(a && B) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) >= (C != D)'\'''

echo '$ test-expr '\''!(A && b) >= (c != d)'\'''
test-expr '!(A && b) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (c != d)'\'''

echo '$ test-expr '\''!(A && b) >= (c != D)'\'''
test-expr '!(A && b) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (c != D)'\'''

echo '$ test-expr '\''!(A && b) >= (C != d)'\'''
test-expr '!(A && b) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (C != d)'\'''

echo '$ test-expr '\''!(A && b) >= (C != D)'\'''
test-expr '!(A && b) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) >= (C != D)'\'''

echo '$ test-expr '\''!(A && B) >= (c != d)'\'''
test-expr '!(A && B) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (c != d)'\'''

echo '$ test-expr '\''!(A && B) >= (c != D)'\'''
test-expr '!(A && B) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (c != D)'\'''

echo '$ test-expr '\''!(A && B) >= (C != d)'\'''
test-expr '!(A && B) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (C != d)'\'''

echo '$ test-expr '\''!(A && B) >= (C != D)'\'''
test-expr '!(A && B) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) >= (C != D)'\'''

echo '$ test-expr '\''!(a || b) >= (c != d)'\'''
test-expr '!(a || b) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (c != d)'\'''

echo '$ test-expr '\''!(a || b) >= (c != D)'\'''
test-expr '!(a || b) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (c != D)'\'''

echo '$ test-expr '\''!(a || b) >= (C != d)'\'''
test-expr '!(a || b) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (C != d)'\'''

echo '$ test-expr '\''!(a || b) >= (C != D)'\'''
test-expr '!(a || b) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (C != D)'\'''

echo '$ test-expr '\''!(a || B) >= (c != d)'\'''
test-expr '!(a || B) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (c != d)'\'''

echo '$ test-expr '\''!(a || B) >= (c != D)'\'''
test-expr '!(a || B) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (c != D)'\'''

echo '$ test-expr '\''!(a || B) >= (C != d)'\'''
test-expr '!(a || B) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (C != d)'\'''

echo '$ test-expr '\''!(a || B) >= (C != D)'\'''
test-expr '!(a || B) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (C != D)'\'''

echo '$ test-expr '\''!(A || b) >= (c != d)'\'''
test-expr '!(A || b) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (c != d)'\'''

echo '$ test-expr '\''!(A || b) >= (c != D)'\'''
test-expr '!(A || b) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (c != D)'\'''

echo '$ test-expr '\''!(A || b) >= (C != d)'\'''
test-expr '!(A || b) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (C != d)'\'''

echo '$ test-expr '\''!(A || b) >= (C != D)'\'''
test-expr '!(A || b) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (C != D)'\'''

echo '$ test-expr '\''!(A || B) >= (c != d)'\'''
test-expr '!(A || B) >= (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (c != d)'\'''

echo '$ test-expr '\''!(A || B) >= (c != D)'\'''
test-expr '!(A || B) >= (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (c != D)'\'''

echo '$ test-expr '\''!(A || B) >= (C != d)'\'''
test-expr '!(A || B) >= (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (C != d)'\'''

echo '$ test-expr '\''!(A || B) >= (C != D)'\'''
test-expr '!(A || B) >= (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (C != D)'\'''

echo '$ test-expr '\''!(a || b) >= (c && d)'\'''
test-expr '!(a || b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (c && d)'\'''

echo '$ test-expr '\''!(a || b) >= (c && D)'\'''
test-expr '!(a || b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (c && D)'\'''

echo '$ test-expr '\''!(a || b) >= (C && d)'\'''
test-expr '!(a || b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (C && d)'\'''

echo '$ test-expr '\''!(a || b) >= (C && D)'\'''
test-expr '!(a || b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) >= (C && D)'\'''

echo '$ test-expr '\''!(a || B) >= (c && d)'\'''
test-expr '!(a || B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (c && d)'\'''

echo '$ test-expr '\''!(a || B) >= (c && D)'\'''
test-expr '!(a || B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (c && D)'\'''

echo '$ test-expr '\''!(a || B) >= (C && d)'\'''
test-expr '!(a || B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (C && d)'\'''

echo '$ test-expr '\''!(a || B) >= (C && D)'\'''
test-expr '!(a || B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) >= (C && D)'\'''

echo '$ test-expr '\''!(A || b) >= (c && d)'\'''
test-expr '!(A || b) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (c && d)'\'''

echo '$ test-expr '\''!(A || b) >= (c && D)'\'''
test-expr '!(A || b) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (c && D)'\'''

echo '$ test-expr '\''!(A || b) >= (C && d)'\'''
test-expr '!(A || b) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (C && d)'\'''

echo '$ test-expr '\''!(A || b) >= (C && D)'\'''
test-expr '!(A || b) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) >= (C && D)'\'''

echo '$ test-expr '\''!(A || B) >= (c && d)'\'''
test-expr '!(A || B) >= (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (c && d)'\'''

echo '$ test-expr '\''!(A || B) >= (c && D)'\'''
test-expr '!(A || B) >= (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (c && D)'\'''

echo '$ test-expr '\''!(A || B) >= (C && d)'\'''
test-expr '!(A || B) >= (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (C && d)'\'''

echo '$ test-expr '\''!(A || B) >= (C && D)'\'''
test-expr '!(A || B) >= (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) >= (C && D)'\'''

echo '$ test-expr '\''!(a || b) != (c && d)'\'''
test-expr '!(a || b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (c && d)'\'''

echo '$ test-expr '\''!(a || b) != (c && D)'\'''
test-expr '!(a || b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (c && D)'\'''

echo '$ test-expr '\''!(a || b) != (C && d)'\'''
test-expr '!(a || b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (C && d)'\'''

echo '$ test-expr '\''!(a || b) != (C && D)'\'''
test-expr '!(a || b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (C && D)'\'''

echo '$ test-expr '\''!(a || B) != (c && d)'\'''
test-expr '!(a || B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (c && d)'\'''

echo '$ test-expr '\''!(a || B) != (c && D)'\'''
test-expr '!(a || B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (c && D)'\'''

echo '$ test-expr '\''!(a || B) != (C && d)'\'''
test-expr '!(a || B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (C && d)'\'''

echo '$ test-expr '\''!(a || B) != (C && D)'\'''
test-expr '!(a || B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (C && D)'\'''

echo '$ test-expr '\''!(A || b) != (c && d)'\'''
test-expr '!(A || b) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (c && d)'\'''

echo '$ test-expr '\''!(A || b) != (c && D)'\'''
test-expr '!(A || b) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (c && D)'\'''

echo '$ test-expr '\''!(A || b) != (C && d)'\'''
test-expr '!(A || b) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (C && d)'\'''

echo '$ test-expr '\''!(A || b) != (C && D)'\'''
test-expr '!(A || b) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (C && D)'\'''

echo '$ test-expr '\''!(A || B) != (c && d)'\'''
test-expr '!(A || B) != (c && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (c && d)'\'''

echo '$ test-expr '\''!(A || B) != (c && D)'\'''
test-expr '!(A || B) != (c && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (c && D)'\'''

echo '$ test-expr '\''!(A || B) != (C && d)'\'''
test-expr '!(A || B) != (C && d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (C && d)'\'''

echo '$ test-expr '\''!(A || B) != (C && D)'\'''
test-expr '!(A || B) != (C && D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (C && D)'\'''

echo '$ test-expr '\''a && !(b >= (c != d))'\'''
test-expr 'a && !(b >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (c != d))'\'''

echo '$ test-expr '\''a && !(b >= (c != D))'\'''
test-expr 'a && !(b >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (c != D))'\'''

echo '$ test-expr '\''a && !(b >= (C != d))'\'''
test-expr 'a && !(b >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (C != d))'\'''

echo '$ test-expr '\''a && !(b >= (C != D))'\'''
test-expr 'a && !(b >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b >= (C != D))'\'''

echo '$ test-expr '\''a && !(B >= (c != d))'\'''
test-expr 'a && !(B >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (c != d))'\'''

echo '$ test-expr '\''a && !(B >= (c != D))'\'''
test-expr 'a && !(B >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (c != D))'\'''

echo '$ test-expr '\''a && !(B >= (C != d))'\'''
test-expr 'a && !(B >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (C != d))'\'''

echo '$ test-expr '\''a && !(B >= (C != D))'\'''
test-expr 'a && !(B >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B >= (C != D))'\'''

echo '$ test-expr '\''A && !(b >= (c != d))'\'''
test-expr 'A && !(b >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (c != d))'\'''

echo '$ test-expr '\''A && !(b >= (c != D))'\'''
test-expr 'A && !(b >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (c != D))'\'''

echo '$ test-expr '\''A && !(b >= (C != d))'\'''
test-expr 'A && !(b >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (C != d))'\'''

echo '$ test-expr '\''A && !(b >= (C != D))'\'''
test-expr 'A && !(b >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b >= (C != D))'\'''

echo '$ test-expr '\''A && !(B >= (c != d))'\'''
test-expr 'A && !(B >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (c != d))'\'''

echo '$ test-expr '\''A && !(B >= (c != D))'\'''
test-expr 'A && !(B >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (c != D))'\'''

echo '$ test-expr '\''A && !(B >= (C != d))'\'''
test-expr 'A && !(B >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (C != d))'\'''

echo '$ test-expr '\''A && !(B >= (C != D))'\'''
test-expr 'A && !(B >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B >= (C != D))'\'''

echo '$ test-expr '\''a || !(b >= (c != d))'\'''
test-expr 'a || !(b >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (c != d))'\'''

echo '$ test-expr '\''a || !(b >= (c != D))'\'''
test-expr 'a || !(b >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (c != D))'\'''

echo '$ test-expr '\''a || !(b >= (C != d))'\'''
test-expr 'a || !(b >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (C != d))'\'''

echo '$ test-expr '\''a || !(b >= (C != D))'\'''
test-expr 'a || !(b >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (C != D))'\'''

echo '$ test-expr '\''a || !(B >= (c != d))'\'''
test-expr 'a || !(B >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (c != d))'\'''

echo '$ test-expr '\''a || !(B >= (c != D))'\'''
test-expr 'a || !(B >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (c != D))'\'''

echo '$ test-expr '\''a || !(B >= (C != d))'\'''
test-expr 'a || !(B >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (C != d))'\'''

echo '$ test-expr '\''a || !(B >= (C != D))'\'''
test-expr 'a || !(B >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (C != D))'\'''

echo '$ test-expr '\''A || !(b >= (c != d))'\'''
test-expr 'A || !(b >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (c != d))'\'''

echo '$ test-expr '\''A || !(b >= (c != D))'\'''
test-expr 'A || !(b >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (c != D))'\'''

echo '$ test-expr '\''A || !(b >= (C != d))'\'''
test-expr 'A || !(b >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (C != d))'\'''

echo '$ test-expr '\''A || !(b >= (C != D))'\'''
test-expr 'A || !(b >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (C != D))'\'''

echo '$ test-expr '\''A || !(B >= (c != d))'\'''
test-expr 'A || !(B >= (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (c != d))'\'''

echo '$ test-expr '\''A || !(B >= (c != D))'\'''
test-expr 'A || !(B >= (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (c != D))'\'''

echo '$ test-expr '\''A || !(B >= (C != d))'\'''
test-expr 'A || !(B >= (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (C != d))'\'''

echo '$ test-expr '\''A || !(B >= (C != D))'\'''
test-expr 'A || !(B >= (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (C != D))'\'''

echo '$ test-expr '\''a || !(b >= (c && d))'\'''
test-expr 'a || !(b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (c && d))'\'''

echo '$ test-expr '\''a || !(b >= (c && D))'\'''
test-expr 'a || !(b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (c && D))'\'''

echo '$ test-expr '\''a || !(b >= (C && d))'\'''
test-expr 'a || !(b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (C && d))'\'''

echo '$ test-expr '\''a || !(b >= (C && D))'\'''
test-expr 'a || !(b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b >= (C && D))'\'''

echo '$ test-expr '\''a || !(B >= (c && d))'\'''
test-expr 'a || !(B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (c && d))'\'''

echo '$ test-expr '\''a || !(B >= (c && D))'\'''
test-expr 'a || !(B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (c && D))'\'''

echo '$ test-expr '\''a || !(B >= (C && d))'\'''
test-expr 'a || !(B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (C && d))'\'''

echo '$ test-expr '\''a || !(B >= (C && D))'\'''
test-expr 'a || !(B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B >= (C && D))'\'''

echo '$ test-expr '\''A || !(b >= (c && d))'\'''
test-expr 'A || !(b >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (c && d))'\'''

echo '$ test-expr '\''A || !(b >= (c && D))'\'''
test-expr 'A || !(b >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (c && D))'\'''

echo '$ test-expr '\''A || !(b >= (C && d))'\'''
test-expr 'A || !(b >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (C && d))'\'''

echo '$ test-expr '\''A || !(b >= (C && D))'\'''
test-expr 'A || !(b >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b >= (C && D))'\'''

echo '$ test-expr '\''A || !(B >= (c && d))'\'''
test-expr 'A || !(B >= (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (c && d))'\'''

echo '$ test-expr '\''A || !(B >= (c && D))'\'''
test-expr 'A || !(B >= (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (c && D))'\'''

echo '$ test-expr '\''A || !(B >= (C && d))'\'''
test-expr 'A || !(B >= (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (C && d))'\'''

echo '$ test-expr '\''A || !(B >= (C && D))'\'''
test-expr 'A || !(B >= (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B >= (C && D))'\'''

echo '$ test-expr '\''a || !(b != (c && d))'\'''
test-expr 'a || !(b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (c && d))'\'''

echo '$ test-expr '\''a || !(b != (c && D))'\'''
test-expr 'a || !(b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (c && D))'\'''

echo '$ test-expr '\''a || !(b != (C && d))'\'''
test-expr 'a || !(b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (C && d))'\'''

echo '$ test-expr '\''a || !(b != (C && D))'\'''
test-expr 'a || !(b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (C && D))'\'''

echo '$ test-expr '\''a || !(B != (c && d))'\'''
test-expr 'a || !(B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (c && d))'\'''

echo '$ test-expr '\''a || !(B != (c && D))'\'''
test-expr 'a || !(B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (c && D))'\'''

echo '$ test-expr '\''a || !(B != (C && d))'\'''
test-expr 'a || !(B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (C && d))'\'''

echo '$ test-expr '\''a || !(B != (C && D))'\'''
test-expr 'a || !(B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (C && D))'\'''

echo '$ test-expr '\''A || !(b != (c && d))'\'''
test-expr 'A || !(b != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (c && d))'\'''

echo '$ test-expr '\''A || !(b != (c && D))'\'''
test-expr 'A || !(b != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (c && D))'\'''

echo '$ test-expr '\''A || !(b != (C && d))'\'''
test-expr 'A || !(b != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (C && d))'\'''

echo '$ test-expr '\''A || !(b != (C && D))'\'''
test-expr 'A || !(b != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (C && D))'\'''

echo '$ test-expr '\''A || !(B != (c && d))'\'''
test-expr 'A || !(B != (c && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (c && d))'\'''

echo '$ test-expr '\''A || !(B != (c && D))'\'''
test-expr 'A || !(B != (c && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (c && D))'\'''

echo '$ test-expr '\''A || !(B != (C && d))'\'''
test-expr 'A || !(B != (C && d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (C && d))'\'''

echo '$ test-expr '\''A || !(B != (C && D))'\'''
test-expr 'A || !(B != (C && D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (C && D))'\'''

echo '$ test-expr '\''!((a && b) != c) >= d'\'''
test-expr '!((a && b) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != c) >= d'\'''

echo '$ test-expr '\''!((a && b) != c) >= D'\'''
test-expr '!((a && b) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != c) >= D'\'''

echo '$ test-expr '\''!((a && b) != C) >= d'\'''
test-expr '!((a && b) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != C) >= d'\'''

echo '$ test-expr '\''!((a && b) != C) >= D'\'''
test-expr '!((a && b) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && b) != C) >= D'\'''

echo '$ test-expr '\''!((a && B) != c) >= d'\'''
test-expr '!((a && B) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != c) >= d'\'''

echo '$ test-expr '\''!((a && B) != c) >= D'\'''
test-expr '!((a && B) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != c) >= D'\'''

echo '$ test-expr '\''!((a && B) != C) >= d'\'''
test-expr '!((a && B) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != C) >= d'\'''

echo '$ test-expr '\''!((a && B) != C) >= D'\'''
test-expr '!((a && B) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a && B) != C) >= D'\'''

echo '$ test-expr '\''!((A && b) != c) >= d'\'''
test-expr '!((A && b) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != c) >= d'\'''

echo '$ test-expr '\''!((A && b) != c) >= D'\'''
test-expr '!((A && b) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != c) >= D'\'''

echo '$ test-expr '\''!((A && b) != C) >= d'\'''
test-expr '!((A && b) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != C) >= d'\'''

echo '$ test-expr '\''!((A && b) != C) >= D'\'''
test-expr '!((A && b) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && b) != C) >= D'\'''

echo '$ test-expr '\''!((A && B) != c) >= d'\'''
test-expr '!((A && B) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != c) >= d'\'''

echo '$ test-expr '\''!((A && B) != c) >= D'\'''
test-expr '!((A && B) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != c) >= D'\'''

echo '$ test-expr '\''!((A && B) != C) >= d'\'''
test-expr '!((A && B) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != C) >= d'\'''

echo '$ test-expr '\''!((A && B) != C) >= D'\'''
test-expr '!((A && B) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A && B) != C) >= D'\'''

echo '$ test-expr '\''!((a || b) != c) >= d'\'''
test-expr '!((a || b) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != c) >= d'\'''

echo '$ test-expr '\''!((a || b) != c) >= D'\'''
test-expr '!((a || b) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != c) >= D'\'''

echo '$ test-expr '\''!((a || b) != C) >= d'\'''
test-expr '!((a || b) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != C) >= d'\'''

echo '$ test-expr '\''!((a || b) != C) >= D'\'''
test-expr '!((a || b) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) != C) >= D'\'''

echo '$ test-expr '\''!((a || B) != c) >= d'\'''
test-expr '!((a || B) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != c) >= d'\'''

echo '$ test-expr '\''!((a || B) != c) >= D'\'''
test-expr '!((a || B) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != c) >= D'\'''

echo '$ test-expr '\''!((a || B) != C) >= d'\'''
test-expr '!((a || B) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != C) >= d'\'''

echo '$ test-expr '\''!((a || B) != C) >= D'\'''
test-expr '!((a || B) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) != C) >= D'\'''

echo '$ test-expr '\''!((A || b) != c) >= d'\'''
test-expr '!((A || b) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != c) >= d'\'''

echo '$ test-expr '\''!((A || b) != c) >= D'\'''
test-expr '!((A || b) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != c) >= D'\'''

echo '$ test-expr '\''!((A || b) != C) >= d'\'''
test-expr '!((A || b) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != C) >= d'\'''

echo '$ test-expr '\''!((A || b) != C) >= D'\'''
test-expr '!((A || b) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) != C) >= D'\'''

echo '$ test-expr '\''!((A || B) != c) >= d'\'''
test-expr '!((A || B) != c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != c) >= d'\'''

echo '$ test-expr '\''!((A || B) != c) >= D'\'''
test-expr '!((A || B) != c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != c) >= D'\'''

echo '$ test-expr '\''!((A || B) != C) >= d'\'''
test-expr '!((A || B) != C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != C) >= d'\'''

echo '$ test-expr '\''!((A || B) != C) >= D'\'''
test-expr '!((A || B) != C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) != C) >= D'\'''

echo '$ test-expr '\''!((a || b) && c) >= d'\'''
test-expr '!((a || b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && c) >= d'\'''

echo '$ test-expr '\''!((a || b) && c) >= D'\'''
test-expr '!((a || b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && c) >= D'\'''

echo '$ test-expr '\''!((a || b) && C) >= d'\'''
test-expr '!((a || b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && C) >= d'\'''

echo '$ test-expr '\''!((a || b) && C) >= D'\'''
test-expr '!((a || b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && C) >= D'\'''

echo '$ test-expr '\''!((a || B) && c) >= d'\'''
test-expr '!((a || B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && c) >= d'\'''

echo '$ test-expr '\''!((a || B) && c) >= D'\'''
test-expr '!((a || B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && c) >= D'\'''

echo '$ test-expr '\''!((a || B) && C) >= d'\'''
test-expr '!((a || B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && C) >= d'\'''

echo '$ test-expr '\''!((a || B) && C) >= D'\'''
test-expr '!((a || B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && C) >= D'\'''

echo '$ test-expr '\''!((A || b) && c) >= d'\'''
test-expr '!((A || b) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && c) >= d'\'''

echo '$ test-expr '\''!((A || b) && c) >= D'\'''
test-expr '!((A || b) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && c) >= D'\'''

echo '$ test-expr '\''!((A || b) && C) >= d'\'''
test-expr '!((A || b) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && C) >= d'\'''

echo '$ test-expr '\''!((A || b) && C) >= D'\'''
test-expr '!((A || b) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && C) >= D'\'''

echo '$ test-expr '\''!((A || B) && c) >= d'\'''
test-expr '!((A || B) && c) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && c) >= d'\'''

echo '$ test-expr '\''!((A || B) && c) >= D'\'''
test-expr '!((A || B) && c) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && c) >= D'\'''

echo '$ test-expr '\''!((A || B) && C) >= d'\'''
test-expr '!((A || B) && C) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && C) >= d'\'''

echo '$ test-expr '\''!((A || B) && C) >= D'\'''
test-expr '!((A || B) && C) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && C) >= D'\'''

echo '$ test-expr '\''!((a || b) && c) != d'\'''
test-expr '!((a || b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && c) != d'\'''

echo '$ test-expr '\''!((a || b) && c) != D'\'''
test-expr '!((a || b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && c) != D'\'''

echo '$ test-expr '\''!((a || b) && C) != d'\'''
test-expr '!((a || b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && C) != d'\'''

echo '$ test-expr '\''!((a || b) && C) != D'\'''
test-expr '!((a || b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || b) && C) != D'\'''

echo '$ test-expr '\''!((a || B) && c) != d'\'''
test-expr '!((a || B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && c) != d'\'''

echo '$ test-expr '\''!((a || B) && c) != D'\'''
test-expr '!((a || B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && c) != D'\'''

echo '$ test-expr '\''!((a || B) && C) != d'\'''
test-expr '!((a || B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && C) != d'\'''

echo '$ test-expr '\''!((a || B) && C) != D'\'''
test-expr '!((a || B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((a || B) && C) != D'\'''

echo '$ test-expr '\''!((A || b) && c) != d'\'''
test-expr '!((A || b) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && c) != d'\'''

echo '$ test-expr '\''!((A || b) && c) != D'\'''
test-expr '!((A || b) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && c) != D'\'''

echo '$ test-expr '\''!((A || b) && C) != d'\'''
test-expr '!((A || b) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && C) != d'\'''

echo '$ test-expr '\''!((A || b) && C) != D'\'''
test-expr '!((A || b) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || b) && C) != D'\'''

echo '$ test-expr '\''!((A || B) && c) != d'\'''
test-expr '!((A || B) && c) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && c) != d'\'''

echo '$ test-expr '\''!((A || B) && c) != D'\'''
test-expr '!((A || B) && c) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && c) != D'\'''

echo '$ test-expr '\''!((A || B) && C) != d'\'''
test-expr '!((A || B) && C) != d' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && C) != d'\'''

echo '$ test-expr '\''!((A || B) && C) != D'\'''
test-expr '!((A || B) && C) != D' 2>&1 ||
echo 'command failed: test-expr '\''!((A || B) && C) != D'\'''

echo '$ test-expr '\''a && !((b != c) >= d)'\'''
test-expr 'a && !((b != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != c) >= d)'\'''

echo '$ test-expr '\''a && !((b != c) >= D)'\'''
test-expr 'a && !((b != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != c) >= D)'\'''

echo '$ test-expr '\''a && !((b != C) >= d)'\'''
test-expr 'a && !((b != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != C) >= d)'\'''

echo '$ test-expr '\''a && !((b != C) >= D)'\'''
test-expr 'a && !((b != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((b != C) >= D)'\'''

echo '$ test-expr '\''a && !((B != c) >= d)'\'''
test-expr 'a && !((B != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != c) >= d)'\'''

echo '$ test-expr '\''a && !((B != c) >= D)'\'''
test-expr 'a && !((B != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != c) >= D)'\'''

echo '$ test-expr '\''a && !((B != C) >= d)'\'''
test-expr 'a && !((B != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != C) >= d)'\'''

echo '$ test-expr '\''a && !((B != C) >= D)'\'''
test-expr 'a && !((B != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a && !((B != C) >= D)'\'''

echo '$ test-expr '\''A && !((b != c) >= d)'\'''
test-expr 'A && !((b != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != c) >= d)'\'''

echo '$ test-expr '\''A && !((b != c) >= D)'\'''
test-expr 'A && !((b != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != c) >= D)'\'''

echo '$ test-expr '\''A && !((b != C) >= d)'\'''
test-expr 'A && !((b != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != C) >= d)'\'''

echo '$ test-expr '\''A && !((b != C) >= D)'\'''
test-expr 'A && !((b != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((b != C) >= D)'\'''

echo '$ test-expr '\''A && !((B != c) >= d)'\'''
test-expr 'A && !((B != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != c) >= d)'\'''

echo '$ test-expr '\''A && !((B != c) >= D)'\'''
test-expr 'A && !((B != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != c) >= D)'\'''

echo '$ test-expr '\''A && !((B != C) >= d)'\'''
test-expr 'A && !((B != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != C) >= d)'\'''

echo '$ test-expr '\''A && !((B != C) >= D)'\'''
test-expr 'A && !((B != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A && !((B != C) >= D)'\'''

echo '$ test-expr '\''a || !((b != c) >= d)'\'''
test-expr 'a || !((b != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != c) >= d)'\'''

echo '$ test-expr '\''a || !((b != c) >= D)'\'''
test-expr 'a || !((b != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != c) >= D)'\'''

echo '$ test-expr '\''a || !((b != C) >= d)'\'''
test-expr 'a || !((b != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != C) >= d)'\'''

echo '$ test-expr '\''a || !((b != C) >= D)'\'''
test-expr 'a || !((b != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b != C) >= D)'\'''

echo '$ test-expr '\''a || !((B != c) >= d)'\'''
test-expr 'a || !((B != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != c) >= d)'\'''

echo '$ test-expr '\''a || !((B != c) >= D)'\'''
test-expr 'a || !((B != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != c) >= D)'\'''

echo '$ test-expr '\''a || !((B != C) >= d)'\'''
test-expr 'a || !((B != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != C) >= d)'\'''

echo '$ test-expr '\''a || !((B != C) >= D)'\'''
test-expr 'a || !((B != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B != C) >= D)'\'''

echo '$ test-expr '\''A || !((b != c) >= d)'\'''
test-expr 'A || !((b != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != c) >= d)'\'''

echo '$ test-expr '\''A || !((b != c) >= D)'\'''
test-expr 'A || !((b != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != c) >= D)'\'''

echo '$ test-expr '\''A || !((b != C) >= d)'\'''
test-expr 'A || !((b != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != C) >= d)'\'''

echo '$ test-expr '\''A || !((b != C) >= D)'\'''
test-expr 'A || !((b != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b != C) >= D)'\'''

echo '$ test-expr '\''A || !((B != c) >= d)'\'''
test-expr 'A || !((B != c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != c) >= d)'\'''

echo '$ test-expr '\''A || !((B != c) >= D)'\'''
test-expr 'A || !((B != c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != c) >= D)'\'''

echo '$ test-expr '\''A || !((B != C) >= d)'\'''
test-expr 'A || !((B != C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != C) >= d)'\'''

echo '$ test-expr '\''A || !((B != C) >= D)'\'''
test-expr 'A || !((B != C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B != C) >= D)'\'''

echo '$ test-expr '\''a || !((b && c) >= d)'\'''
test-expr 'a || !((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && c) >= d)'\'''

echo '$ test-expr '\''a || !((b && c) >= D)'\'''
test-expr 'a || !((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && c) >= D)'\'''

echo '$ test-expr '\''a || !((b && C) >= d)'\'''
test-expr 'a || !((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && C) >= d)'\'''

echo '$ test-expr '\''a || !((b && C) >= D)'\'''
test-expr 'a || !((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && C) >= D)'\'''

echo '$ test-expr '\''a || !((B && c) >= d)'\'''
test-expr 'a || !((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && c) >= d)'\'''

echo '$ test-expr '\''a || !((B && c) >= D)'\'''
test-expr 'a || !((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && c) >= D)'\'''

echo '$ test-expr '\''a || !((B && C) >= d)'\'''
test-expr 'a || !((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && C) >= d)'\'''

echo '$ test-expr '\''a || !((B && C) >= D)'\'''
test-expr 'a || !((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && C) >= D)'\'''

echo '$ test-expr '\''A || !((b && c) >= d)'\'''
test-expr 'A || !((b && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && c) >= d)'\'''

echo '$ test-expr '\''A || !((b && c) >= D)'\'''
test-expr 'A || !((b && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && c) >= D)'\'''

echo '$ test-expr '\''A || !((b && C) >= d)'\'''
test-expr 'A || !((b && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && C) >= d)'\'''

echo '$ test-expr '\''A || !((b && C) >= D)'\'''
test-expr 'A || !((b && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && C) >= D)'\'''

echo '$ test-expr '\''A || !((B && c) >= d)'\'''
test-expr 'A || !((B && c) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && c) >= d)'\'''

echo '$ test-expr '\''A || !((B && c) >= D)'\'''
test-expr 'A || !((B && c) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && c) >= D)'\'''

echo '$ test-expr '\''A || !((B && C) >= d)'\'''
test-expr 'A || !((B && C) >= d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && C) >= d)'\'''

echo '$ test-expr '\''A || !((B && C) >= D)'\'''
test-expr 'A || !((B && C) >= D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && C) >= D)'\'''

echo '$ test-expr '\''a || !((b && c) != d)'\'''
test-expr 'a || !((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && c) != d)'\'''

echo '$ test-expr '\''a || !((b && c) != D)'\'''
test-expr 'a || !((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && c) != D)'\'''

echo '$ test-expr '\''a || !((b && C) != d)'\'''
test-expr 'a || !((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && C) != d)'\'''

echo '$ test-expr '\''a || !((b && C) != D)'\'''
test-expr 'a || !((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((b && C) != D)'\'''

echo '$ test-expr '\''a || !((B && c) != d)'\'''
test-expr 'a || !((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && c) != d)'\'''

echo '$ test-expr '\''a || !((B && c) != D)'\'''
test-expr 'a || !((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && c) != D)'\'''

echo '$ test-expr '\''a || !((B && C) != d)'\'''
test-expr 'a || !((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && C) != d)'\'''

echo '$ test-expr '\''a || !((B && C) != D)'\'''
test-expr 'a || !((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''a || !((B && C) != D)'\'''

echo '$ test-expr '\''A || !((b && c) != d)'\'''
test-expr 'A || !((b && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && c) != d)'\'''

echo '$ test-expr '\''A || !((b && c) != D)'\'''
test-expr 'A || !((b && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && c) != D)'\'''

echo '$ test-expr '\''A || !((b && C) != d)'\'''
test-expr 'A || !((b && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && C) != d)'\'''

echo '$ test-expr '\''A || !((b && C) != D)'\'''
test-expr 'A || !((b && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((b && C) != D)'\'''

echo '$ test-expr '\''A || !((B && c) != d)'\'''
test-expr 'A || !((B && c) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && c) != d)'\'''

echo '$ test-expr '\''A || !((B && c) != D)'\'''
test-expr 'A || !((B && c) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && c) != D)'\'''

echo '$ test-expr '\''A || !((B && C) != d)'\'''
test-expr 'A || !((B && C) != d)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && C) != d)'\'''

echo '$ test-expr '\''A || !((B && C) != D)'\'''
test-expr 'A || !((B && C) != D)' 2>&1 ||
echo 'command failed: test-expr '\''A || !((B && C) != D)'\'''

echo '$ test-expr '\''!(a && (b != c)) >= d'\'''
test-expr '!(a && (b != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != c)) >= d'\'''

echo '$ test-expr '\''!(a && (b != c)) >= D'\'''
test-expr '!(a && (b != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != c)) >= D'\'''

echo '$ test-expr '\''!(a && (b != C)) >= d'\'''
test-expr '!(a && (b != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != C)) >= d'\'''

echo '$ test-expr '\''!(a && (b != C)) >= D'\'''
test-expr '!(a && (b != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (b != C)) >= D'\'''

echo '$ test-expr '\''!(a && (B != c)) >= d'\'''
test-expr '!(a && (B != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != c)) >= d'\'''

echo '$ test-expr '\''!(a && (B != c)) >= D'\'''
test-expr '!(a && (B != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != c)) >= D'\'''

echo '$ test-expr '\''!(a && (B != C)) >= d'\'''
test-expr '!(a && (B != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != C)) >= d'\'''

echo '$ test-expr '\''!(a && (B != C)) >= D'\'''
test-expr '!(a && (B != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a && (B != C)) >= D'\'''

echo '$ test-expr '\''!(A && (b != c)) >= d'\'''
test-expr '!(A && (b != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != c)) >= d'\'''

echo '$ test-expr '\''!(A && (b != c)) >= D'\'''
test-expr '!(A && (b != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != c)) >= D'\'''

echo '$ test-expr '\''!(A && (b != C)) >= d'\'''
test-expr '!(A && (b != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != C)) >= d'\'''

echo '$ test-expr '\''!(A && (b != C)) >= D'\'''
test-expr '!(A && (b != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (b != C)) >= D'\'''

echo '$ test-expr '\''!(A && (B != c)) >= d'\'''
test-expr '!(A && (B != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != c)) >= d'\'''

echo '$ test-expr '\''!(A && (B != c)) >= D'\'''
test-expr '!(A && (B != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != c)) >= D'\'''

echo '$ test-expr '\''!(A && (B != C)) >= d'\'''
test-expr '!(A && (B != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != C)) >= d'\'''

echo '$ test-expr '\''!(A && (B != C)) >= D'\'''
test-expr '!(A && (B != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A && (B != C)) >= D'\'''

echo '$ test-expr '\''!(a || (b != c)) >= d'\'''
test-expr '!(a || (b != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != c)) >= d'\'''

echo '$ test-expr '\''!(a || (b != c)) >= D'\'''
test-expr '!(a || (b != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != c)) >= D'\'''

echo '$ test-expr '\''!(a || (b != C)) >= d'\'''
test-expr '!(a || (b != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != C)) >= d'\'''

echo '$ test-expr '\''!(a || (b != C)) >= D'\'''
test-expr '!(a || (b != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b != C)) >= D'\'''

echo '$ test-expr '\''!(a || (B != c)) >= d'\'''
test-expr '!(a || (B != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != c)) >= d'\'''

echo '$ test-expr '\''!(a || (B != c)) >= D'\'''
test-expr '!(a || (B != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != c)) >= D'\'''

echo '$ test-expr '\''!(a || (B != C)) >= d'\'''
test-expr '!(a || (B != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != C)) >= d'\'''

echo '$ test-expr '\''!(a || (B != C)) >= D'\'''
test-expr '!(a || (B != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B != C)) >= D'\'''

echo '$ test-expr '\''!(A || (b != c)) >= d'\'''
test-expr '!(A || (b != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != c)) >= d'\'''

echo '$ test-expr '\''!(A || (b != c)) >= D'\'''
test-expr '!(A || (b != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != c)) >= D'\'''

echo '$ test-expr '\''!(A || (b != C)) >= d'\'''
test-expr '!(A || (b != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != C)) >= d'\'''

echo '$ test-expr '\''!(A || (b != C)) >= D'\'''
test-expr '!(A || (b != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b != C)) >= D'\'''

echo '$ test-expr '\''!(A || (B != c)) >= d'\'''
test-expr '!(A || (B != c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != c)) >= d'\'''

echo '$ test-expr '\''!(A || (B != c)) >= D'\'''
test-expr '!(A || (B != c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != c)) >= D'\'''

echo '$ test-expr '\''!(A || (B != C)) >= d'\'''
test-expr '!(A || (B != C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != C)) >= d'\'''

echo '$ test-expr '\''!(A || (B != C)) >= D'\'''
test-expr '!(A || (B != C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B != C)) >= D'\'''

echo '$ test-expr '\''!(a || (b && c)) >= d'\'''
test-expr '!(a || (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && c)) >= d'\'''

echo '$ test-expr '\''!(a || (b && c)) >= D'\'''
test-expr '!(a || (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && c)) >= D'\'''

echo '$ test-expr '\''!(a || (b && C)) >= d'\'''
test-expr '!(a || (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && C)) >= d'\'''

echo '$ test-expr '\''!(a || (b && C)) >= D'\'''
test-expr '!(a || (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && C)) >= D'\'''

echo '$ test-expr '\''!(a || (B && c)) >= d'\'''
test-expr '!(a || (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && c)) >= d'\'''

echo '$ test-expr '\''!(a || (B && c)) >= D'\'''
test-expr '!(a || (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && c)) >= D'\'''

echo '$ test-expr '\''!(a || (B && C)) >= d'\'''
test-expr '!(a || (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && C)) >= d'\'''

echo '$ test-expr '\''!(a || (B && C)) >= D'\'''
test-expr '!(a || (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && C)) >= D'\'''

echo '$ test-expr '\''!(A || (b && c)) >= d'\'''
test-expr '!(A || (b && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && c)) >= d'\'''

echo '$ test-expr '\''!(A || (b && c)) >= D'\'''
test-expr '!(A || (b && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && c)) >= D'\'''

echo '$ test-expr '\''!(A || (b && C)) >= d'\'''
test-expr '!(A || (b && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && C)) >= d'\'''

echo '$ test-expr '\''!(A || (b && C)) >= D'\'''
test-expr '!(A || (b && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && C)) >= D'\'''

echo '$ test-expr '\''!(A || (B && c)) >= d'\'''
test-expr '!(A || (B && c)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && c)) >= d'\'''

echo '$ test-expr '\''!(A || (B && c)) >= D'\'''
test-expr '!(A || (B && c)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && c)) >= D'\'''

echo '$ test-expr '\''!(A || (B && C)) >= d'\'''
test-expr '!(A || (B && C)) >= d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && C)) >= d'\'''

echo '$ test-expr '\''!(A || (B && C)) >= D'\'''
test-expr '!(A || (B && C)) >= D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && C)) >= D'\'''

echo '$ test-expr '\''!(a || (b && c)) != d'\'''
test-expr '!(a || (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && c)) != d'\'''

echo '$ test-expr '\''!(a || (b && c)) != D'\'''
test-expr '!(a || (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && c)) != D'\'''

echo '$ test-expr '\''!(a || (b && C)) != d'\'''
test-expr '!(a || (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && C)) != d'\'''

echo '$ test-expr '\''!(a || (b && C)) != D'\'''
test-expr '!(a || (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (b && C)) != D'\'''

echo '$ test-expr '\''!(a || (B && c)) != d'\'''
test-expr '!(a || (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && c)) != d'\'''

echo '$ test-expr '\''!(a || (B && c)) != D'\'''
test-expr '!(a || (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && c)) != D'\'''

echo '$ test-expr '\''!(a || (B && C)) != d'\'''
test-expr '!(a || (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && C)) != d'\'''

echo '$ test-expr '\''!(a || (B && C)) != D'\'''
test-expr '!(a || (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(a || (B && C)) != D'\'''

echo '$ test-expr '\''!(A || (b && c)) != d'\'''
test-expr '!(A || (b && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && c)) != d'\'''

echo '$ test-expr '\''!(A || (b && c)) != D'\'''
test-expr '!(A || (b && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && c)) != D'\'''

echo '$ test-expr '\''!(A || (b && C)) != d'\'''
test-expr '!(A || (b && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && C)) != d'\'''

echo '$ test-expr '\''!(A || (b && C)) != D'\'''
test-expr '!(A || (b && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (b && C)) != D'\'''

echo '$ test-expr '\''!(A || (B && c)) != d'\'''
test-expr '!(A || (B && c)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && c)) != d'\'''

echo '$ test-expr '\''!(A || (B && c)) != D'\'''
test-expr '!(A || (B && c)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && c)) != D'\'''

echo '$ test-expr '\''!(A || (B && C)) != d'\'''
test-expr '!(A || (B && C)) != d' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && C)) != d'\'''

echo '$ test-expr '\''!(A || (B && C)) != D'\'''
test-expr '!(A || (B && C)) != D' 2>&1 ||
echo 'command failed: test-expr '\''!(A || (B && C)) != D'\'''

echo '$ test-expr '\''!(a && b) != (c >= d)'\'''
test-expr '!(a && b) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (c >= d)'\'''

echo '$ test-expr '\''!(a && b) != (c >= D)'\'''
test-expr '!(a && b) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (c >= D)'\'''

echo '$ test-expr '\''!(a && b) != (C >= d)'\'''
test-expr '!(a && b) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (C >= d)'\'''

echo '$ test-expr '\''!(a && b) != (C >= D)'\'''
test-expr '!(a && b) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && b) != (C >= D)'\'''

echo '$ test-expr '\''!(a && B) != (c >= d)'\'''
test-expr '!(a && B) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (c >= d)'\'''

echo '$ test-expr '\''!(a && B) != (c >= D)'\'''
test-expr '!(a && B) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (c >= D)'\'''

echo '$ test-expr '\''!(a && B) != (C >= d)'\'''
test-expr '!(a && B) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (C >= d)'\'''

echo '$ test-expr '\''!(a && B) != (C >= D)'\'''
test-expr '!(a && B) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a && B) != (C >= D)'\'''

echo '$ test-expr '\''!(A && b) != (c >= d)'\'''
test-expr '!(A && b) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (c >= d)'\'''

echo '$ test-expr '\''!(A && b) != (c >= D)'\'''
test-expr '!(A && b) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (c >= D)'\'''

echo '$ test-expr '\''!(A && b) != (C >= d)'\'''
test-expr '!(A && b) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (C >= d)'\'''

echo '$ test-expr '\''!(A && b) != (C >= D)'\'''
test-expr '!(A && b) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && b) != (C >= D)'\'''

echo '$ test-expr '\''!(A && B) != (c >= d)'\'''
test-expr '!(A && B) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (c >= d)'\'''

echo '$ test-expr '\''!(A && B) != (c >= D)'\'''
test-expr '!(A && B) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (c >= D)'\'''

echo '$ test-expr '\''!(A && B) != (C >= d)'\'''
test-expr '!(A && B) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (C >= d)'\'''

echo '$ test-expr '\''!(A && B) != (C >= D)'\'''
test-expr '!(A && B) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A && B) != (C >= D)'\'''

echo '$ test-expr '\''!(a || b) != (c >= d)'\'''
test-expr '!(a || b) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (c >= d)'\'''

echo '$ test-expr '\''!(a || b) != (c >= D)'\'''
test-expr '!(a || b) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (c >= D)'\'''

echo '$ test-expr '\''!(a || b) != (C >= d)'\'''
test-expr '!(a || b) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (C >= d)'\'''

echo '$ test-expr '\''!(a || b) != (C >= D)'\'''
test-expr '!(a || b) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) != (C >= D)'\'''

echo '$ test-expr '\''!(a || B) != (c >= d)'\'''
test-expr '!(a || B) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (c >= d)'\'''

echo '$ test-expr '\''!(a || B) != (c >= D)'\'''
test-expr '!(a || B) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (c >= D)'\'''

echo '$ test-expr '\''!(a || B) != (C >= d)'\'''
test-expr '!(a || B) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (C >= d)'\'''

echo '$ test-expr '\''!(a || B) != (C >= D)'\'''
test-expr '!(a || B) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) != (C >= D)'\'''

echo '$ test-expr '\''!(A || b) != (c >= d)'\'''
test-expr '!(A || b) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (c >= d)'\'''

echo '$ test-expr '\''!(A || b) != (c >= D)'\'''
test-expr '!(A || b) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (c >= D)'\'''

echo '$ test-expr '\''!(A || b) != (C >= d)'\'''
test-expr '!(A || b) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (C >= d)'\'''

echo '$ test-expr '\''!(A || b) != (C >= D)'\'''
test-expr '!(A || b) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) != (C >= D)'\'''

echo '$ test-expr '\''!(A || B) != (c >= d)'\'''
test-expr '!(A || B) != (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (c >= d)'\'''

echo '$ test-expr '\''!(A || B) != (c >= D)'\'''
test-expr '!(A || B) != (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (c >= D)'\'''

echo '$ test-expr '\''!(A || B) != (C >= d)'\'''
test-expr '!(A || B) != (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (C >= d)'\'''

echo '$ test-expr '\''!(A || B) != (C >= D)'\'''
test-expr '!(A || B) != (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) != (C >= D)'\'''

echo '$ test-expr '\''!(a || b) && (c >= d)'\'''
test-expr '!(a || b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (c >= d)'\'''

echo '$ test-expr '\''!(a || b) && (c >= D)'\'''
test-expr '!(a || b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (c >= D)'\'''

echo '$ test-expr '\''!(a || b) && (C >= d)'\'''
test-expr '!(a || b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (C >= d)'\'''

echo '$ test-expr '\''!(a || b) && (C >= D)'\'''
test-expr '!(a || b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (C >= D)'\'''

echo '$ test-expr '\''!(a || B) && (c >= d)'\'''
test-expr '!(a || B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (c >= d)'\'''

echo '$ test-expr '\''!(a || B) && (c >= D)'\'''
test-expr '!(a || B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (c >= D)'\'''

echo '$ test-expr '\''!(a || B) && (C >= d)'\'''
test-expr '!(a || B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (C >= d)'\'''

echo '$ test-expr '\''!(a || B) && (C >= D)'\'''
test-expr '!(a || B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (C >= D)'\'''

echo '$ test-expr '\''!(A || b) && (c >= d)'\'''
test-expr '!(A || b) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (c >= d)'\'''

echo '$ test-expr '\''!(A || b) && (c >= D)'\'''
test-expr '!(A || b) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (c >= D)'\'''

echo '$ test-expr '\''!(A || b) && (C >= d)'\'''
test-expr '!(A || b) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (C >= d)'\'''

echo '$ test-expr '\''!(A || b) && (C >= D)'\'''
test-expr '!(A || b) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (C >= D)'\'''

echo '$ test-expr '\''!(A || B) && (c >= d)'\'''
test-expr '!(A || B) && (c >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (c >= d)'\'''

echo '$ test-expr '\''!(A || B) && (c >= D)'\'''
test-expr '!(A || B) && (c >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (c >= D)'\'''

echo '$ test-expr '\''!(A || B) && (C >= d)'\'''
test-expr '!(A || B) && (C >= d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (C >= d)'\'''

echo '$ test-expr '\''!(A || B) && (C >= D)'\'''
test-expr '!(A || B) && (C >= D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (C >= D)'\'''

echo '$ test-expr '\''!(a || b) && (c != d)'\'''
test-expr '!(a || b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (c != d)'\'''

echo '$ test-expr '\''!(a || b) && (c != D)'\'''
test-expr '!(a || b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (c != D)'\'''

echo '$ test-expr '\''!(a || b) && (C != d)'\'''
test-expr '!(a || b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (C != d)'\'''

echo '$ test-expr '\''!(a || b) && (C != D)'\'''
test-expr '!(a || b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || b) && (C != D)'\'''

echo '$ test-expr '\''!(a || B) && (c != d)'\'''
test-expr '!(a || B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (c != d)'\'''

echo '$ test-expr '\''!(a || B) && (c != D)'\'''
test-expr '!(a || B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (c != D)'\'''

echo '$ test-expr '\''!(a || B) && (C != d)'\'''
test-expr '!(a || B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (C != d)'\'''

echo '$ test-expr '\''!(a || B) && (C != D)'\'''
test-expr '!(a || B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(a || B) && (C != D)'\'''

echo '$ test-expr '\''!(A || b) && (c != d)'\'''
test-expr '!(A || b) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (c != d)'\'''

echo '$ test-expr '\''!(A || b) && (c != D)'\'''
test-expr '!(A || b) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (c != D)'\'''

echo '$ test-expr '\''!(A || b) && (C != d)'\'''
test-expr '!(A || b) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (C != d)'\'''

echo '$ test-expr '\''!(A || b) && (C != D)'\'''
test-expr '!(A || b) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || b) && (C != D)'\'''

echo '$ test-expr '\''!(A || B) && (c != d)'\'''
test-expr '!(A || B) && (c != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (c != d)'\'''

echo '$ test-expr '\''!(A || B) && (c != D)'\'''
test-expr '!(A || B) && (c != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (c != D)'\'''

echo '$ test-expr '\''!(A || B) && (C != d)'\'''
test-expr '!(A || B) && (C != d)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (C != d)'\'''

echo '$ test-expr '\''!(A || B) && (C != D)'\'''
test-expr '!(A || B) && (C != D)' 2>&1 ||
echo 'command failed: test-expr '\''!(A || B) && (C != D)'\'''

echo '$ test-expr '\''a && !(b != (c >= d))'\'''
test-expr 'a && !(b != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (c >= d))'\'''

echo '$ test-expr '\''a && !(b != (c >= D))'\'''
test-expr 'a && !(b != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (c >= D))'\'''

echo '$ test-expr '\''a && !(b != (C >= d))'\'''
test-expr 'a && !(b != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (C >= d))'\'''

echo '$ test-expr '\''a && !(b != (C >= D))'\'''
test-expr 'a && !(b != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(b != (C >= D))'\'''

echo '$ test-expr '\''a && !(B != (c >= d))'\'''
test-expr 'a && !(B != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (c >= d))'\'''

echo '$ test-expr '\''a && !(B != (c >= D))'\'''
test-expr 'a && !(B != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (c >= D))'\'''

echo '$ test-expr '\''a && !(B != (C >= d))'\'''
test-expr 'a && !(B != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (C >= d))'\'''

echo '$ test-expr '\''a && !(B != (C >= D))'\'''
test-expr 'a && !(B != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a && !(B != (C >= D))'\'''

echo '$ test-expr '\''A && !(b != (c >= d))'\'''
test-expr 'A && !(b != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (c >= d))'\'''

echo '$ test-expr '\''A && !(b != (c >= D))'\'''
test-expr 'A && !(b != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (c >= D))'\'''

echo '$ test-expr '\''A && !(b != (C >= d))'\'''
test-expr 'A && !(b != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (C >= d))'\'''

echo '$ test-expr '\''A && !(b != (C >= D))'\'''
test-expr 'A && !(b != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(b != (C >= D))'\'''

echo '$ test-expr '\''A && !(B != (c >= d))'\'''
test-expr 'A && !(B != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (c >= d))'\'''

echo '$ test-expr '\''A && !(B != (c >= D))'\'''
test-expr 'A && !(B != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (c >= D))'\'''

echo '$ test-expr '\''A && !(B != (C >= d))'\'''
test-expr 'A && !(B != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (C >= d))'\'''

echo '$ test-expr '\''A && !(B != (C >= D))'\'''
test-expr 'A && !(B != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A && !(B != (C >= D))'\'''

echo '$ test-expr '\''a || !(b != (c >= d))'\'''
test-expr 'a || !(b != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (c >= d))'\'''

echo '$ test-expr '\''a || !(b != (c >= D))'\'''
test-expr 'a || !(b != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (c >= D))'\'''

echo '$ test-expr '\''a || !(b != (C >= d))'\'''
test-expr 'a || !(b != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (C >= d))'\'''

echo '$ test-expr '\''a || !(b != (C >= D))'\'''
test-expr 'a || !(b != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b != (C >= D))'\'''

echo '$ test-expr '\''a || !(B != (c >= d))'\'''
test-expr 'a || !(B != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (c >= d))'\'''

echo '$ test-expr '\''a || !(B != (c >= D))'\'''
test-expr 'a || !(B != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (c >= D))'\'''

echo '$ test-expr '\''a || !(B != (C >= d))'\'''
test-expr 'a || !(B != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (C >= d))'\'''

echo '$ test-expr '\''a || !(B != (C >= D))'\'''
test-expr 'a || !(B != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B != (C >= D))'\'''

echo '$ test-expr '\''A || !(b != (c >= d))'\'''
test-expr 'A || !(b != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (c >= d))'\'''

echo '$ test-expr '\''A || !(b != (c >= D))'\'''
test-expr 'A || !(b != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (c >= D))'\'''

echo '$ test-expr '\''A || !(b != (C >= d))'\'''
test-expr 'A || !(b != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (C >= d))'\'''

echo '$ test-expr '\''A || !(b != (C >= D))'\'''
test-expr 'A || !(b != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b != (C >= D))'\'''

echo '$ test-expr '\''A || !(B != (c >= d))'\'''
test-expr 'A || !(B != (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (c >= d))'\'''

echo '$ test-expr '\''A || !(B != (c >= D))'\'''
test-expr 'A || !(B != (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (c >= D))'\'''

echo '$ test-expr '\''A || !(B != (C >= d))'\'''
test-expr 'A || !(B != (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (C >= d))'\'''

echo '$ test-expr '\''A || !(B != (C >= D))'\'''
test-expr 'A || !(B != (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B != (C >= D))'\'''

echo '$ test-expr '\''a || !(b && (c >= d))'\'''
test-expr 'a || !(b && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (c >= d))'\'''

echo '$ test-expr '\''a || !(b && (c >= D))'\'''
test-expr 'a || !(b && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (c >= D))'\'''

echo '$ test-expr '\''a || !(b && (C >= d))'\'''
test-expr 'a || !(b && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (C >= d))'\'''

echo '$ test-expr '\''a || !(b && (C >= D))'\'''
test-expr 'a || !(b && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (C >= D))'\'''

echo '$ test-expr '\''a || !(B && (c >= d))'\'''
test-expr 'a || !(B && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (c >= d))'\'''

echo '$ test-expr '\''a || !(B && (c >= D))'\'''
test-expr 'a || !(B && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (c >= D))'\'''

echo '$ test-expr '\''a || !(B && (C >= d))'\'''
test-expr 'a || !(B && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (C >= d))'\'''

echo '$ test-expr '\''a || !(B && (C >= D))'\'''
test-expr 'a || !(B && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (C >= D))'\'''

echo '$ test-expr '\''A || !(b && (c >= d))'\'''
test-expr 'A || !(b && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (c >= d))'\'''

echo '$ test-expr '\''A || !(b && (c >= D))'\'''
test-expr 'A || !(b && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (c >= D))'\'''

echo '$ test-expr '\''A || !(b && (C >= d))'\'''
test-expr 'A || !(b && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (C >= d))'\'''

echo '$ test-expr '\''A || !(b && (C >= D))'\'''
test-expr 'A || !(b && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (C >= D))'\'''

echo '$ test-expr '\''A || !(B && (c >= d))'\'''
test-expr 'A || !(B && (c >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (c >= d))'\'''

echo '$ test-expr '\''A || !(B && (c >= D))'\'''
test-expr 'A || !(B && (c >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (c >= D))'\'''

echo '$ test-expr '\''A || !(B && (C >= d))'\'''
test-expr 'A || !(B && (C >= d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (C >= d))'\'''

echo '$ test-expr '\''A || !(B && (C >= D))'\'''
test-expr 'A || !(B && (C >= D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (C >= D))'\'''

echo '$ test-expr '\''a || !(b && (c != d))'\'''
test-expr 'a || !(b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (c != d))'\'''

echo '$ test-expr '\''a || !(b && (c != D))'\'''
test-expr 'a || !(b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (c != D))'\'''

echo '$ test-expr '\''a || !(b && (C != d))'\'''
test-expr 'a || !(b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (C != d))'\'''

echo '$ test-expr '\''a || !(b && (C != D))'\'''
test-expr 'a || !(b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(b && (C != D))'\'''

echo '$ test-expr '\''a || !(B && (c != d))'\'''
test-expr 'a || !(B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (c != d))'\'''

echo '$ test-expr '\''a || !(B && (c != D))'\'''
test-expr 'a || !(B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (c != D))'\'''

echo '$ test-expr '\''a || !(B && (C != d))'\'''
test-expr 'a || !(B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (C != d))'\'''

echo '$ test-expr '\''a || !(B && (C != D))'\'''
test-expr 'a || !(B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''a || !(B && (C != D))'\'''

echo '$ test-expr '\''A || !(b && (c != d))'\'''
test-expr 'A || !(b && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (c != d))'\'''

echo '$ test-expr '\''A || !(b && (c != D))'\'''
test-expr 'A || !(b && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (c != D))'\'''

echo '$ test-expr '\''A || !(b && (C != d))'\'''
test-expr 'A || !(b && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (C != d))'\'''

echo '$ test-expr '\''A || !(b && (C != D))'\'''
test-expr 'A || !(b && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(b && (C != D))'\'''

echo '$ test-expr '\''A || !(B && (c != d))'\'''
test-expr 'A || !(B && (c != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (c != d))'\'''

echo '$ test-expr '\''A || !(B && (c != D))'\'''
test-expr 'A || !(B && (c != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (c != D))'\'''

echo '$ test-expr '\''A || !(B && (C != d))'\'''
test-expr 'A || !(B && (C != d))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (C != d))'\'''

echo '$ test-expr '\''A || !(B && (C != D))'\'''
test-expr 'A || !(B && (C != D))' 2>&1 ||
echo 'command failed: test-expr '\''A || !(B && (C != D))'\'''
)

