#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:rex-opt2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L rex-opt2.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr "'\''a'\''"
0 match_rex("a")
$ test-expr "'\''a'\''I"
0 match_rex("a","I")
$ test-expr "'\''a'\''II"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''II
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''II"
$ test-expr "'\''a'\''III"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''III
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''III"
$ test-expr "'\''a'\''IIS"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''IIS
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''IIS"
$ test-expr "'\''a'\''IIU"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''IIU
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''IIU"
$ test-expr "'\''a'\''IIX"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''IIX
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''IIX"
$ test-expr "'\''a'\''IS"
0 match_rex("a","IS")
$ test-expr "'\''a'\''ISI"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''ISI
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''ISI"
$ test-expr "'\''a'\''ISS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''ISS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''ISS"
$ test-expr "'\''a'\''ISU"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''ISX"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''IU"
0 match_rex("a","IU")
$ test-expr "'\''a'\''IUI"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''IUI
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''IUI"
$ test-expr "'\''a'\''IUS"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''IUU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''IUU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''IUU"
$ test-expr "'\''a'\''IUX"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''IX"
0 match_rex("a","IX")
$ test-expr "'\''a'\''IXI"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''IXI
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''IXI"
$ test-expr "'\''a'\''IXS"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''IXU"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''IXX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''IXX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''IXX"
$ test-expr "'\''a'\''S"
0 match_rex("a","S")
$ test-expr "'\''a'\''SI"
0 match_rex("a","IS")
$ test-expr "'\''a'\''SII"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SII
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SII"
$ test-expr "'\''a'\''SIS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SIS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SIS"
$ test-expr "'\''a'\''SIU"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''SIX"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''SS"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''SS
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''SS"
$ test-expr "'\''a'\''SSI"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''SSI
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''SSI"
$ test-expr "'\''a'\''SSS"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''SSS
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''SSS"
$ test-expr "'\''a'\''SSU"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''SSU
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''SSU"
$ test-expr "'\''a'\''SSX"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''SSX
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''SSX"
$ test-expr "'\''a'\''SU"
0 match_rex("a","SU")
$ test-expr "'\''a'\''SUI"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''SUS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SUS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SUS"
$ test-expr "'\''a'\''SUU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SUU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SUU"
$ test-expr "'\''a'\''SUX"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''SX"
0 match_rex("a","SX")
$ test-expr "'\''a'\''SXI"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''SXS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SXS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SXS"
$ test-expr "'\''a'\''SXU"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''SXX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''SXX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''SXX"
$ test-expr "'\''a'\''U"
0 match_rex("a","U")
$ test-expr "'\''a'\''UI"
0 match_rex("a","IU")
$ test-expr "'\''a'\''UII"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''UII
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''UII"
$ test-expr "'\''a'\''UIS"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''UIU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''UIU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''UIU"
$ test-expr "'\''a'\''UIX"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''US"
0 match_rex("a","SU")
$ test-expr "'\''a'\''USI"
0 match_rex("a","ISU")
$ test-expr "'\''a'\''USS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''USS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''USS"
$ test-expr "'\''a'\''USU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''USU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''USU"
$ test-expr "'\''a'\''USX"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''UU"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''UU
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''UU"
$ test-expr "'\''a'\''UUI"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''UUI
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''UUI"
$ test-expr "'\''a'\''UUS"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''UUS
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''UUS"
$ test-expr "'\''a'\''UUU"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''UUU
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''UUU"
$ test-expr "'\''a'\''UUX"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''UUX
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''UUX"
$ test-expr "'\''a'\''UX"
0 match_rex("a","UX")
$ test-expr "'\''a'\''UXI"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''UXS"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''UXU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''UXU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''UXU"
$ test-expr "'\''a'\''UXX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''UXX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''UXX"
$ test-expr "'\''a'\''X"
0 match_rex("a","X")
$ test-expr "'\''a'\''XI"
0 match_rex("a","IX")
$ test-expr "'\''a'\''XII"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XII
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XII"
$ test-expr "'\''a'\''XIS"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''XIU"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''XIX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XIX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XIX"
$ test-expr "'\''a'\''XS"
0 match_rex("a","SX")
$ test-expr "'\''a'\''XSI"
0 match_rex("a","ISX")
$ test-expr "'\''a'\''XSS"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XSS
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XSS"
$ test-expr "'\''a'\''XSU"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''XSX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XSX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XSX"
$ test-expr "'\''a'\''XU"
0 match_rex("a","UX")
$ test-expr "'\''a'\''XUI"
0 match_rex("a","IUX")
$ test-expr "'\''a'\''XUS"
0 match_rex("a","SUX")
$ test-expr "'\''a'\''XUU"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XUU
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XUU"
$ test-expr "'\''a'\''XUX"
test-expr: error:1:6: compiler error: duplicated regex option char
test-expr: error:1:6: compiler error: '\''a'\''XUX
test-expr: error:1:6: compiler error:      ^
command failed: test-expr "'\''a'\''XUX"
$ test-expr "'\''a'\''XX"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''XX
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''XX"
$ test-expr "'\''a'\''XXI"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''XXI
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''XXI"
$ test-expr "'\''a'\''XXS"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''XXS
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''XXS"
$ test-expr "'\''a'\''XXU"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''XXU
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''XXU"
$ test-expr "'\''a'\''XXX"
test-expr: error:1:5: compiler error: duplicated regex option char
test-expr: error:1:5: compiler error: '\''a'\''XXX
test-expr: error:1:5: compiler error:     ^
command failed: test-expr "'\''a'\''XXX"'
) -L rex-opt2.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr "'\''a'\''"'
test-expr "'a'" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''"'

echo '$ test-expr "'\''a'\''I"'
test-expr "'a'I" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''I"'

echo '$ test-expr "'\''a'\''II"'
test-expr "'a'II" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''II"'

echo '$ test-expr "'\''a'\''III"'
test-expr "'a'III" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''III"'

echo '$ test-expr "'\''a'\''IIS"'
test-expr "'a'IIS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IIS"'

echo '$ test-expr "'\''a'\''IIU"'
test-expr "'a'IIU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IIU"'

echo '$ test-expr "'\''a'\''IIX"'
test-expr "'a'IIX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IIX"'

echo '$ test-expr "'\''a'\''IS"'
test-expr "'a'IS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IS"'

echo '$ test-expr "'\''a'\''ISI"'
test-expr "'a'ISI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''ISI"'

echo '$ test-expr "'\''a'\''ISS"'
test-expr "'a'ISS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''ISS"'

echo '$ test-expr "'\''a'\''ISU"'
test-expr "'a'ISU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''ISU"'

echo '$ test-expr "'\''a'\''ISX"'
test-expr "'a'ISX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''ISX"'

echo '$ test-expr "'\''a'\''IU"'
test-expr "'a'IU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IU"'

echo '$ test-expr "'\''a'\''IUI"'
test-expr "'a'IUI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IUI"'

echo '$ test-expr "'\''a'\''IUS"'
test-expr "'a'IUS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IUS"'

echo '$ test-expr "'\''a'\''IUU"'
test-expr "'a'IUU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IUU"'

echo '$ test-expr "'\''a'\''IUX"'
test-expr "'a'IUX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IUX"'

echo '$ test-expr "'\''a'\''IX"'
test-expr "'a'IX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IX"'

echo '$ test-expr "'\''a'\''IXI"'
test-expr "'a'IXI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IXI"'

echo '$ test-expr "'\''a'\''IXS"'
test-expr "'a'IXS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IXS"'

echo '$ test-expr "'\''a'\''IXU"'
test-expr "'a'IXU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IXU"'

echo '$ test-expr "'\''a'\''IXX"'
test-expr "'a'IXX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''IXX"'

echo '$ test-expr "'\''a'\''S"'
test-expr "'a'S" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''S"'

echo '$ test-expr "'\''a'\''SI"'
test-expr "'a'SI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SI"'

echo '$ test-expr "'\''a'\''SII"'
test-expr "'a'SII" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SII"'

echo '$ test-expr "'\''a'\''SIS"'
test-expr "'a'SIS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SIS"'

echo '$ test-expr "'\''a'\''SIU"'
test-expr "'a'SIU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SIU"'

echo '$ test-expr "'\''a'\''SIX"'
test-expr "'a'SIX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SIX"'

echo '$ test-expr "'\''a'\''SS"'
test-expr "'a'SS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SS"'

echo '$ test-expr "'\''a'\''SSI"'
test-expr "'a'SSI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SSI"'

echo '$ test-expr "'\''a'\''SSS"'
test-expr "'a'SSS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SSS"'

echo '$ test-expr "'\''a'\''SSU"'
test-expr "'a'SSU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SSU"'

echo '$ test-expr "'\''a'\''SSX"'
test-expr "'a'SSX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SSX"'

echo '$ test-expr "'\''a'\''SU"'
test-expr "'a'SU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SU"'

echo '$ test-expr "'\''a'\''SUI"'
test-expr "'a'SUI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SUI"'

echo '$ test-expr "'\''a'\''SUS"'
test-expr "'a'SUS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SUS"'

echo '$ test-expr "'\''a'\''SUU"'
test-expr "'a'SUU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SUU"'

echo '$ test-expr "'\''a'\''SUX"'
test-expr "'a'SUX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SUX"'

echo '$ test-expr "'\''a'\''SX"'
test-expr "'a'SX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SX"'

echo '$ test-expr "'\''a'\''SXI"'
test-expr "'a'SXI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SXI"'

echo '$ test-expr "'\''a'\''SXS"'
test-expr "'a'SXS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SXS"'

echo '$ test-expr "'\''a'\''SXU"'
test-expr "'a'SXU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SXU"'

echo '$ test-expr "'\''a'\''SXX"'
test-expr "'a'SXX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''SXX"'

echo '$ test-expr "'\''a'\''U"'
test-expr "'a'U" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''U"'

echo '$ test-expr "'\''a'\''UI"'
test-expr "'a'UI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UI"'

echo '$ test-expr "'\''a'\''UII"'
test-expr "'a'UII" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UII"'

echo '$ test-expr "'\''a'\''UIS"'
test-expr "'a'UIS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UIS"'

echo '$ test-expr "'\''a'\''UIU"'
test-expr "'a'UIU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UIU"'

echo '$ test-expr "'\''a'\''UIX"'
test-expr "'a'UIX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UIX"'

echo '$ test-expr "'\''a'\''US"'
test-expr "'a'US" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''US"'

echo '$ test-expr "'\''a'\''USI"'
test-expr "'a'USI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''USI"'

echo '$ test-expr "'\''a'\''USS"'
test-expr "'a'USS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''USS"'

echo '$ test-expr "'\''a'\''USU"'
test-expr "'a'USU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''USU"'

echo '$ test-expr "'\''a'\''USX"'
test-expr "'a'USX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''USX"'

echo '$ test-expr "'\''a'\''UU"'
test-expr "'a'UU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UU"'

echo '$ test-expr "'\''a'\''UUI"'
test-expr "'a'UUI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UUI"'

echo '$ test-expr "'\''a'\''UUS"'
test-expr "'a'UUS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UUS"'

echo '$ test-expr "'\''a'\''UUU"'
test-expr "'a'UUU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UUU"'

echo '$ test-expr "'\''a'\''UUX"'
test-expr "'a'UUX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UUX"'

echo '$ test-expr "'\''a'\''UX"'
test-expr "'a'UX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UX"'

echo '$ test-expr "'\''a'\''UXI"'
test-expr "'a'UXI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UXI"'

echo '$ test-expr "'\''a'\''UXS"'
test-expr "'a'UXS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UXS"'

echo '$ test-expr "'\''a'\''UXU"'
test-expr "'a'UXU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UXU"'

echo '$ test-expr "'\''a'\''UXX"'
test-expr "'a'UXX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''UXX"'

echo '$ test-expr "'\''a'\''X"'
test-expr "'a'X" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''X"'

echo '$ test-expr "'\''a'\''XI"'
test-expr "'a'XI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XI"'

echo '$ test-expr "'\''a'\''XII"'
test-expr "'a'XII" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XII"'

echo '$ test-expr "'\''a'\''XIS"'
test-expr "'a'XIS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XIS"'

echo '$ test-expr "'\''a'\''XIU"'
test-expr "'a'XIU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XIU"'

echo '$ test-expr "'\''a'\''XIX"'
test-expr "'a'XIX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XIX"'

echo '$ test-expr "'\''a'\''XS"'
test-expr "'a'XS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XS"'

echo '$ test-expr "'\''a'\''XSI"'
test-expr "'a'XSI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XSI"'

echo '$ test-expr "'\''a'\''XSS"'
test-expr "'a'XSS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XSS"'

echo '$ test-expr "'\''a'\''XSU"'
test-expr "'a'XSU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XSU"'

echo '$ test-expr "'\''a'\''XSX"'
test-expr "'a'XSX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XSX"'

echo '$ test-expr "'\''a'\''XU"'
test-expr "'a'XU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XU"'

echo '$ test-expr "'\''a'\''XUI"'
test-expr "'a'XUI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XUI"'

echo '$ test-expr "'\''a'\''XUS"'
test-expr "'a'XUS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XUS"'

echo '$ test-expr "'\''a'\''XUU"'
test-expr "'a'XUU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XUU"'

echo '$ test-expr "'\''a'\''XUX"'
test-expr "'a'XUX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XUX"'

echo '$ test-expr "'\''a'\''XX"'
test-expr "'a'XX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XX"'

echo '$ test-expr "'\''a'\''XXI"'
test-expr "'a'XXI" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XXI"'

echo '$ test-expr "'\''a'\''XXS"'
test-expr "'a'XXS" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XXS"'

echo '$ test-expr "'\''a'\''XXU"'
test-expr "'a'XXU" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XXU"'

echo '$ test-expr "'\''a'\''XXX"'
test-expr "'a'XXX" 2>&1 ||
echo 'command failed: test-expr "'\''a'\''XXX"'
)

