#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-plain-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-plain-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\''
[[{}],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],456]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],"bar"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\''
[[{}],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],456]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],"bar"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\''
[[{}],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],456]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],"bar"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\''
[[{}],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],456]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],"foo"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],"bar"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],null]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],false]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],true]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],123]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],456]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\''
[[{}],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],"bar"]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],{}]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [[{}],[]]
json: error: <stdin>:1:7:       ^
[[{}],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,false]'\''
[null,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,true]'\''
[null,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,123]'\''
[null,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\''
[null,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,123]'\''
[false,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\''
[false,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,null]'\''
[456,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,456]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,"bar"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,false]'\''
[456,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,456]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,"bar"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,true]'\''
[456,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,456]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,"bar"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,456]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,"bar"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,123]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,456]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\''
[456,"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,"bar"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",null]'\''
["bar",null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",456]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar","bar"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",false]'\''
["bar",false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",456]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar","bar"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",true]'\''
["bar",true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",456]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar","bar"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",123]'\''
["bar",123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",456]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar","foo"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar","bar"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",null]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",false]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",true]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",123]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",456]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\''
["bar","foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar","bar"]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",{}]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:8: ["bar",[]]
json: error: <stdin>:1:8:        ^
["bar",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},null]'\''
[{},null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},456]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},"bar"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},false]'\''
[{},false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},456]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},"bar"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},true]'\''
[{},true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},456]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},"bar"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},123]'\''
[{},123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},456]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},"foo"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},"bar"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},null]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},false]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},true]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},123]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},456]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\''
[{},"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},"bar"]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},{}]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [{},[]]
json: error: <stdin>:1:5:     ^
[{},
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],null]'\''
[[],null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],456]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],"bar"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],false]'\''
[[],false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],456]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],"bar"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],true]'\''
[[],true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],456]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],"bar"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],123]'\''
[[],123]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],456]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],"foo"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],"bar"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":123}'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],null]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],false]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],true]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],123]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],456]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\''
[[],"foo"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],"bar"]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],{}]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:5: type check error: type mismatch: expected a value of type `{"plain":"foo"}'\''
json: error: <stdin>:1:5: [[],[]]
json: error: <stdin>:1:5:     ^
[[],
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
) -L list-closed-array-basic-plain-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
)

