#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-list
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-list.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":[]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":[]}'\'''
) -L object-list.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":[]}}]}'\'' <<< '\''{"foo":[]}'\'''
)

