#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins7.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr -e float -l 0
1
$ test-expr -e double -l 0
1
$ test-expr -e ldouble -l 0
1
$ test-expr -e float -l 1
1
$ test-expr -e double -l 1
1
$ test-expr -e ldouble -l 1
1
$ test-expr -e float -l 10
1
$ test-expr -e double -l 10
1
$ test-expr -e ldouble -l 10
1
$ test-expr -e float -l 11e2
1
$ test-expr -e double -l 11e2
1
$ test-expr -e ldouble -l 11e2
1
$ test-expr -e float -l 11E2
1
$ test-expr -e double -l 11E2
1
$ test-expr -e ldouble -l 11E2
1
$ test-expr -e float -l 2
1
$ test-expr -e double -l 2
1
$ test-expr -e ldouble -l 2
1
$ test-expr -e float -l 20
1
$ test-expr -e double -l 20
1
$ test-expr -e ldouble -l 20
1
$ test-expr -e float -l 21e2
1
$ test-expr -e double -l 21e2
1
$ test-expr -e ldouble -l 21e2
1
$ test-expr -e float -l 21E2
1
$ test-expr -e double -l 21E2
1
$ test-expr -e ldouble -l 21E2
1
$ test-expr -e float -l 3
1
$ test-expr -e double -l 3
1
$ test-expr -e ldouble -l 3
1
$ test-expr -e float -l 30
1
$ test-expr -e double -l 30
1
$ test-expr -e ldouble -l 30
1
$ test-expr -e float -l 31e2
1
$ test-expr -e double -l 31e2
1
$ test-expr -e ldouble -l 31e2
1
$ test-expr -e float -l 31E2
1
$ test-expr -e double -l 31E2
1
$ test-expr -e ldouble -l 31E2
1
$ test-expr -e float -l 4
1
$ test-expr -e double -l 4
1
$ test-expr -e ldouble -l 4
1
$ test-expr -e float -l 40
1
$ test-expr -e double -l 40
1
$ test-expr -e ldouble -l 40
1
$ test-expr -e float -l 41e2
1
$ test-expr -e double -l 41e2
1
$ test-expr -e ldouble -l 41e2
1
$ test-expr -e float -l 41E2
1
$ test-expr -e double -l 41E2
1
$ test-expr -e ldouble -l 41E2
1
$ test-expr -e float -l 5
1
$ test-expr -e double -l 5
1
$ test-expr -e ldouble -l 5
1
$ test-expr -e float -l 50
1
$ test-expr -e double -l 50
1
$ test-expr -e ldouble -l 50
1
$ test-expr -e float -l 51e2
1
$ test-expr -e double -l 51e2
1
$ test-expr -e ldouble -l 51e2
1
$ test-expr -e float -l 51E2
1
$ test-expr -e double -l 51E2
1
$ test-expr -e ldouble -l 51E2
1
$ test-expr -e float -l 6
1
$ test-expr -e double -l 6
1
$ test-expr -e ldouble -l 6
1
$ test-expr -e float -l 60
1
$ test-expr -e double -l 60
1
$ test-expr -e ldouble -l 60
1
$ test-expr -e float -l 61e2
1
$ test-expr -e double -l 61e2
1
$ test-expr -e ldouble -l 61e2
1
$ test-expr -e float -l 61E2
1
$ test-expr -e double -l 61E2
1
$ test-expr -e ldouble -l 61E2
1
$ test-expr -e float -l 7
1
$ test-expr -e double -l 7
1
$ test-expr -e ldouble -l 7
1
$ test-expr -e float -l 70
1
$ test-expr -e double -l 70
1
$ test-expr -e ldouble -l 70
1
$ test-expr -e float -l 71e2
1
$ test-expr -e double -l 71e2
1
$ test-expr -e ldouble -l 71e2
1
$ test-expr -e float -l 71E2
1
$ test-expr -e double -l 71E2
1
$ test-expr -e ldouble -l 71E2
1
$ test-expr -e float -l 8
1
$ test-expr -e double -l 8
1
$ test-expr -e ldouble -l 8
1
$ test-expr -e float -l 80
1
$ test-expr -e double -l 80
1
$ test-expr -e ldouble -l 80
1
$ test-expr -e float -l 81e2
1
$ test-expr -e double -l 81e2
1
$ test-expr -e ldouble -l 81e2
1
$ test-expr -e float -l 81E2
1
$ test-expr -e double -l 81E2
1
$ test-expr -e ldouble -l 81E2
1
$ test-expr -e float -l 9
1
$ test-expr -e double -l 9
1
$ test-expr -e ldouble -l 9
1
$ test-expr -e float -l 90
1
$ test-expr -e double -l 90
1
$ test-expr -e ldouble -l 90
1
$ test-expr -e float -l 91e2
1
$ test-expr -e double -l 91e2
1
$ test-expr -e ldouble -l 91e2
1
$ test-expr -e float -l 91E2
1
$ test-expr -e double -l 91E2
1
$ test-expr -e ldouble -l 91E2
1
$ test-expr -e float -l -0
1
$ test-expr -e double -l -0
1
$ test-expr -e ldouble -l -0
1
$ test-expr -e float -l -1
1
$ test-expr -e double -l -1
1
$ test-expr -e ldouble -l -1
1
$ test-expr -e float -l -10
1
$ test-expr -e double -l -10
1
$ test-expr -e ldouble -l -10
1
$ test-expr -e float -l -11e2
1
$ test-expr -e double -l -11e2
1
$ test-expr -e ldouble -l -11e2
1
$ test-expr -e float -l -11E2
1
$ test-expr -e double -l -11E2
1
$ test-expr -e ldouble -l -11E2
1
$ test-expr -e float -l -2
1
$ test-expr -e double -l -2
1
$ test-expr -e ldouble -l -2
1
$ test-expr -e float -l -20
1
$ test-expr -e double -l -20
1
$ test-expr -e ldouble -l -20
1
$ test-expr -e float -l -21e2
1
$ test-expr -e double -l -21e2
1
$ test-expr -e ldouble -l -21e2
1
$ test-expr -e float -l -21E2
1
$ test-expr -e double -l -21E2
1
$ test-expr -e ldouble -l -21E2
1
$ test-expr -e float -l -3
1
$ test-expr -e double -l -3
1
$ test-expr -e ldouble -l -3
1
$ test-expr -e float -l -30
1
$ test-expr -e double -l -30
1
$ test-expr -e ldouble -l -30
1
$ test-expr -e float -l -31e2
1
$ test-expr -e double -l -31e2
1
$ test-expr -e ldouble -l -31e2
1
$ test-expr -e float -l -31E2
1
$ test-expr -e double -l -31E2
1
$ test-expr -e ldouble -l -31E2
1
$ test-expr -e float -l -4
1
$ test-expr -e double -l -4
1
$ test-expr -e ldouble -l -4
1
$ test-expr -e float -l -40
1
$ test-expr -e double -l -40
1
$ test-expr -e ldouble -l -40
1
$ test-expr -e float -l -41e2
1
$ test-expr -e double -l -41e2
1
$ test-expr -e ldouble -l -41e2
1
$ test-expr -e float -l -41E2
1
$ test-expr -e double -l -41E2
1
$ test-expr -e ldouble -l -41E2
1
$ test-expr -e float -l -5
1
$ test-expr -e double -l -5
1
$ test-expr -e ldouble -l -5
1
$ test-expr -e float -l -50
1
$ test-expr -e double -l -50
1
$ test-expr -e ldouble -l -50
1
$ test-expr -e float -l -51e2
1
$ test-expr -e double -l -51e2
1
$ test-expr -e ldouble -l -51e2
1
$ test-expr -e float -l -51E2
1
$ test-expr -e double -l -51E2
1
$ test-expr -e ldouble -l -51E2
1
$ test-expr -e float -l -6
1
$ test-expr -e double -l -6
1
$ test-expr -e ldouble -l -6
1
$ test-expr -e float -l -60
1
$ test-expr -e double -l -60
1
$ test-expr -e ldouble -l -60
1
$ test-expr -e float -l -61e2
1
$ test-expr -e double -l -61e2
1
$ test-expr -e ldouble -l -61e2
1
$ test-expr -e float -l -61E2
1
$ test-expr -e double -l -61E2
1
$ test-expr -e ldouble -l -61E2
1
$ test-expr -e float -l -7
1
$ test-expr -e double -l -7
1
$ test-expr -e ldouble -l -7
1
$ test-expr -e float -l -70
1
$ test-expr -e double -l -70
1
$ test-expr -e ldouble -l -70
1
$ test-expr -e float -l -71e2
1
$ test-expr -e double -l -71e2
1
$ test-expr -e ldouble -l -71e2
1
$ test-expr -e float -l -71E2
1
$ test-expr -e double -l -71E2
1
$ test-expr -e ldouble -l -71E2
1
$ test-expr -e float -l -8
1
$ test-expr -e double -l -8
1
$ test-expr -e ldouble -l -8
1
$ test-expr -e float -l -80
1
$ test-expr -e double -l -80
1
$ test-expr -e ldouble -l -80
1
$ test-expr -e float -l -81e2
1
$ test-expr -e double -l -81e2
1
$ test-expr -e ldouble -l -81e2
1
$ test-expr -e float -l -81E2
1
$ test-expr -e double -l -81E2
1
$ test-expr -e ldouble -l -81E2
1
$ test-expr -e float -l -9
1
$ test-expr -e double -l -9
1
$ test-expr -e ldouble -l -9
1
$ test-expr -e float -l -90
1
$ test-expr -e double -l -90
1
$ test-expr -e ldouble -l -90
1
$ test-expr -e float -l -91e2
1
$ test-expr -e double -l -91e2
1
$ test-expr -e ldouble -l -91e2
1
$ test-expr -e float -l -91E2
1
$ test-expr -e double -l -91E2
1
$ test-expr -e ldouble -l -91E2
1
$ test-expr -e float -l '\''"."'\''
0
$ test-expr -e double -l '\''"."'\''
0
$ test-expr -e ldouble -l '\''"."'\''
0
$ test-expr -e float -l '\''".0"'\''
1
$ test-expr -e double -l '\''".0"'\''
1
$ test-expr -e ldouble -l '\''".0"'\''
1
$ test-expr -e float -l '\''".1e2"'\''
1
$ test-expr -e double -l '\''".1e2"'\''
1
$ test-expr -e ldouble -l '\''".1e2"'\''
1
$ test-expr -e float -l '\''".1E2"'\''
1
$ test-expr -e double -l '\''".1E2"'\''
1
$ test-expr -e ldouble -l '\''".1E2"'\''
1
$ test-expr -e float -l '\''".1p2"'\''
0
$ test-expr -e double -l '\''".1p2"'\''
0
$ test-expr -e ldouble -l '\''".1p2"'\''
0
$ test-expr -e float -l '\''".1P2"'\''
0
$ test-expr -e double -l '\''".1P2"'\''
0
$ test-expr -e ldouble -l '\''".1P2"'\''
0
$ test-expr -e float -l '\''"0x"'\''
0
$ test-expr -e double -l '\''"0x"'\''
0
$ test-expr -e ldouble -l '\''"0x"'\''
0
$ test-expr -e float -l '\''"0x0"'\''
0
$ test-expr -e double -l '\''"0x0"'\''
0
$ test-expr -e ldouble -l '\''"0x0"'\''
0
$ test-expr -e float -l '\''"0x1e2"'\''
0
$ test-expr -e double -l '\''"0x1e2"'\''
0
$ test-expr -e ldouble -l '\''"0x1e2"'\''
0
$ test-expr -e float -l '\''"0x1E2"'\''
0
$ test-expr -e double -l '\''"0x1E2"'\''
0
$ test-expr -e ldouble -l '\''"0x1E2"'\''
0
$ test-expr -e float -l '\''"0x1p2"'\''
0
$ test-expr -e double -l '\''"0x1p2"'\''
0
$ test-expr -e ldouble -l '\''"0x1p2"'\''
0
$ test-expr -e float -l '\''"0x1P2"'\''
0
$ test-expr -e double -l '\''"0x1P2"'\''
0
$ test-expr -e ldouble -l '\''"0x1P2"'\''
0
$ test-expr -e float -l '\''"0X"'\''
0
$ test-expr -e double -l '\''"0X"'\''
0
$ test-expr -e ldouble -l '\''"0X"'\''
0
$ test-expr -e float -l '\''"0X0"'\''
0
$ test-expr -e double -l '\''"0X0"'\''
0
$ test-expr -e ldouble -l '\''"0X0"'\''
0
$ test-expr -e float -l '\''"0X1e2"'\''
0
$ test-expr -e double -l '\''"0X1e2"'\''
0
$ test-expr -e ldouble -l '\''"0X1e2"'\''
0
$ test-expr -e float -l '\''"0X1E2"'\''
0
$ test-expr -e double -l '\''"0X1E2"'\''
0
$ test-expr -e ldouble -l '\''"0X1E2"'\''
0
$ test-expr -e float -l '\''"0X1p2"'\''
0
$ test-expr -e double -l '\''"0X1p2"'\''
0
$ test-expr -e ldouble -l '\''"0X1p2"'\''
0
$ test-expr -e float -l '\''"0X1P2"'\''
0
$ test-expr -e double -l '\''"0X1P2"'\''
0
$ test-expr -e ldouble -l '\''"0X1P2"'\''
0
$ test-expr -e float -l '\''"0"'\''
1
$ test-expr -e double -l '\''"0"'\''
1
$ test-expr -e ldouble -l '\''"0"'\''
1
$ test-expr -e float -l '\''"00"'\''
1
$ test-expr -e double -l '\''"00"'\''
1
$ test-expr -e ldouble -l '\''"00"'\''
1
$ test-expr -e float -l '\''"01e2"'\''
1
$ test-expr -e double -l '\''"01e2"'\''
1
$ test-expr -e ldouble -l '\''"01e2"'\''
1
$ test-expr -e float -l '\''"01E2"'\''
1
$ test-expr -e double -l '\''"01E2"'\''
1
$ test-expr -e ldouble -l '\''"01E2"'\''
1
$ test-expr -e float -l '\''"01p2"'\''
0
$ test-expr -e double -l '\''"01p2"'\''
0
$ test-expr -e ldouble -l '\''"01p2"'\''
0
$ test-expr -e float -l '\''"01P2"'\''
0
$ test-expr -e double -l '\''"01P2"'\''
0
$ test-expr -e ldouble -l '\''"01P2"'\''
0
$ test-expr -e float -l '\''"1"'\''
1
$ test-expr -e double -l '\''"1"'\''
1
$ test-expr -e ldouble -l '\''"1"'\''
1
$ test-expr -e float -l '\''"10"'\''
1
$ test-expr -e double -l '\''"10"'\''
1
$ test-expr -e ldouble -l '\''"10"'\''
1
$ test-expr -e float -l '\''"11e2"'\''
1
$ test-expr -e double -l '\''"11e2"'\''
1
$ test-expr -e ldouble -l '\''"11e2"'\''
1
$ test-expr -e float -l '\''"11E2"'\''
1
$ test-expr -e double -l '\''"11E2"'\''
1
$ test-expr -e ldouble -l '\''"11E2"'\''
1
$ test-expr -e float -l '\''"11p2"'\''
0
$ test-expr -e double -l '\''"11p2"'\''
0
$ test-expr -e ldouble -l '\''"11p2"'\''
0
$ test-expr -e float -l '\''"11P2"'\''
0
$ test-expr -e double -l '\''"11P2"'\''
0
$ test-expr -e ldouble -l '\''"11P2"'\''
0
$ test-expr -e float -l '\''"2"'\''
1
$ test-expr -e double -l '\''"2"'\''
1
$ test-expr -e ldouble -l '\''"2"'\''
1
$ test-expr -e float -l '\''"20"'\''
1
$ test-expr -e double -l '\''"20"'\''
1
$ test-expr -e ldouble -l '\''"20"'\''
1
$ test-expr -e float -l '\''"21e2"'\''
1
$ test-expr -e double -l '\''"21e2"'\''
1
$ test-expr -e ldouble -l '\''"21e2"'\''
1
$ test-expr -e float -l '\''"21E2"'\''
1
$ test-expr -e double -l '\''"21E2"'\''
1
$ test-expr -e ldouble -l '\''"21E2"'\''
1
$ test-expr -e float -l '\''"21p2"'\''
0
$ test-expr -e double -l '\''"21p2"'\''
0
$ test-expr -e ldouble -l '\''"21p2"'\''
0
$ test-expr -e float -l '\''"21P2"'\''
0
$ test-expr -e double -l '\''"21P2"'\''
0
$ test-expr -e ldouble -l '\''"21P2"'\''
0
$ test-expr -e float -l '\''"3"'\''
1
$ test-expr -e double -l '\''"3"'\''
1
$ test-expr -e ldouble -l '\''"3"'\''
1
$ test-expr -e float -l '\''"30"'\''
1
$ test-expr -e double -l '\''"30"'\''
1
$ test-expr -e ldouble -l '\''"30"'\''
1
$ test-expr -e float -l '\''"31e2"'\''
1
$ test-expr -e double -l '\''"31e2"'\''
1
$ test-expr -e ldouble -l '\''"31e2"'\''
1
$ test-expr -e float -l '\''"31E2"'\''
1
$ test-expr -e double -l '\''"31E2"'\''
1
$ test-expr -e ldouble -l '\''"31E2"'\''
1
$ test-expr -e float -l '\''"31p2"'\''
0
$ test-expr -e double -l '\''"31p2"'\''
0
$ test-expr -e ldouble -l '\''"31p2"'\''
0
$ test-expr -e float -l '\''"31P2"'\''
0
$ test-expr -e double -l '\''"31P2"'\''
0
$ test-expr -e ldouble -l '\''"31P2"'\''
0
$ test-expr -e float -l '\''"4"'\''
1
$ test-expr -e double -l '\''"4"'\''
1
$ test-expr -e ldouble -l '\''"4"'\''
1
$ test-expr -e float -l '\''"40"'\''
1
$ test-expr -e double -l '\''"40"'\''
1
$ test-expr -e ldouble -l '\''"40"'\''
1
$ test-expr -e float -l '\''"41e2"'\''
1
$ test-expr -e double -l '\''"41e2"'\''
1
$ test-expr -e ldouble -l '\''"41e2"'\''
1
$ test-expr -e float -l '\''"41E2"'\''
1
$ test-expr -e double -l '\''"41E2"'\''
1
$ test-expr -e ldouble -l '\''"41E2"'\''
1
$ test-expr -e float -l '\''"41p2"'\''
0
$ test-expr -e double -l '\''"41p2"'\''
0
$ test-expr -e ldouble -l '\''"41p2"'\''
0
$ test-expr -e float -l '\''"41P2"'\''
0
$ test-expr -e double -l '\''"41P2"'\''
0
$ test-expr -e ldouble -l '\''"41P2"'\''
0
$ test-expr -e float -l '\''"5"'\''
1
$ test-expr -e double -l '\''"5"'\''
1
$ test-expr -e ldouble -l '\''"5"'\''
1
$ test-expr -e float -l '\''"50"'\''
1
$ test-expr -e double -l '\''"50"'\''
1
$ test-expr -e ldouble -l '\''"50"'\''
1
$ test-expr -e float -l '\''"51e2"'\''
1
$ test-expr -e double -l '\''"51e2"'\''
1
$ test-expr -e ldouble -l '\''"51e2"'\''
1
$ test-expr -e float -l '\''"51E2"'\''
1
$ test-expr -e double -l '\''"51E2"'\''
1
$ test-expr -e ldouble -l '\''"51E2"'\''
1
$ test-expr -e float -l '\''"51p2"'\''
0
$ test-expr -e double -l '\''"51p2"'\''
0
$ test-expr -e ldouble -l '\''"51p2"'\''
0
$ test-expr -e float -l '\''"51P2"'\''
0
$ test-expr -e double -l '\''"51P2"'\''
0
$ test-expr -e ldouble -l '\''"51P2"'\''
0
$ test-expr -e float -l '\''"6"'\''
1
$ test-expr -e double -l '\''"6"'\''
1
$ test-expr -e ldouble -l '\''"6"'\''
1
$ test-expr -e float -l '\''"60"'\''
1
$ test-expr -e double -l '\''"60"'\''
1
$ test-expr -e ldouble -l '\''"60"'\''
1
$ test-expr -e float -l '\''"61e2"'\''
1
$ test-expr -e double -l '\''"61e2"'\''
1
$ test-expr -e ldouble -l '\''"61e2"'\''
1
$ test-expr -e float -l '\''"61E2"'\''
1
$ test-expr -e double -l '\''"61E2"'\''
1
$ test-expr -e ldouble -l '\''"61E2"'\''
1
$ test-expr -e float -l '\''"61p2"'\''
0
$ test-expr -e double -l '\''"61p2"'\''
0
$ test-expr -e ldouble -l '\''"61p2"'\''
0
$ test-expr -e float -l '\''"61P2"'\''
0
$ test-expr -e double -l '\''"61P2"'\''
0
$ test-expr -e ldouble -l '\''"61P2"'\''
0
$ test-expr -e float -l '\''"7"'\''
1
$ test-expr -e double -l '\''"7"'\''
1
$ test-expr -e ldouble -l '\''"7"'\''
1
$ test-expr -e float -l '\''"70"'\''
1
$ test-expr -e double -l '\''"70"'\''
1
$ test-expr -e ldouble -l '\''"70"'\''
1
$ test-expr -e float -l '\''"71e2"'\''
1
$ test-expr -e double -l '\''"71e2"'\''
1
$ test-expr -e ldouble -l '\''"71e2"'\''
1
$ test-expr -e float -l '\''"71E2"'\''
1
$ test-expr -e double -l '\''"71E2"'\''
1
$ test-expr -e ldouble -l '\''"71E2"'\''
1
$ test-expr -e float -l '\''"71p2"'\''
0
$ test-expr -e double -l '\''"71p2"'\''
0
$ test-expr -e ldouble -l '\''"71p2"'\''
0
$ test-expr -e float -l '\''"71P2"'\''
0
$ test-expr -e double -l '\''"71P2"'\''
0
$ test-expr -e ldouble -l '\''"71P2"'\''
0
$ test-expr -e float -l '\''"8"'\''
1
$ test-expr -e double -l '\''"8"'\''
1
$ test-expr -e ldouble -l '\''"8"'\''
1
$ test-expr -e float -l '\''"80"'\''
1
$ test-expr -e double -l '\''"80"'\''
1
$ test-expr -e ldouble -l '\''"80"'\''
1
$ test-expr -e float -l '\''"81e2"'\''
1
$ test-expr -e double -l '\''"81e2"'\''
1
$ test-expr -e ldouble -l '\''"81e2"'\''
1
$ test-expr -e float -l '\''"81E2"'\''
1
$ test-expr -e double -l '\''"81E2"'\''
1
$ test-expr -e ldouble -l '\''"81E2"'\''
1
$ test-expr -e float -l '\''"81p2"'\''
0
$ test-expr -e double -l '\''"81p2"'\''
0
$ test-expr -e ldouble -l '\''"81p2"'\''
0
$ test-expr -e float -l '\''"81P2"'\''
0
$ test-expr -e double -l '\''"81P2"'\''
0
$ test-expr -e ldouble -l '\''"81P2"'\''
0
$ test-expr -e float -l '\''"9"'\''
1
$ test-expr -e double -l '\''"9"'\''
1
$ test-expr -e ldouble -l '\''"9"'\''
1
$ test-expr -e float -l '\''"90"'\''
1
$ test-expr -e double -l '\''"90"'\''
1
$ test-expr -e ldouble -l '\''"90"'\''
1
$ test-expr -e float -l '\''"91e2"'\''
1
$ test-expr -e double -l '\''"91e2"'\''
1
$ test-expr -e ldouble -l '\''"91e2"'\''
1
$ test-expr -e float -l '\''"91E2"'\''
1
$ test-expr -e double -l '\''"91E2"'\''
1
$ test-expr -e ldouble -l '\''"91E2"'\''
1
$ test-expr -e float -l '\''"91p2"'\''
0
$ test-expr -e double -l '\''"91p2"'\''
0
$ test-expr -e ldouble -l '\''"91p2"'\''
0
$ test-expr -e float -l '\''"91P2"'\''
0
$ test-expr -e double -l '\''"91P2"'\''
0
$ test-expr -e ldouble -l '\''"91P2"'\''
0
$ test-expr -e float -l '\''"-."'\''
0
$ test-expr -e double -l '\''"-."'\''
0
$ test-expr -e ldouble -l '\''"-."'\''
0
$ test-expr -e float -l '\''"-.0"'\''
1
$ test-expr -e double -l '\''"-.0"'\''
1
$ test-expr -e ldouble -l '\''"-.0"'\''
1
$ test-expr -e float -l '\''"-.1e2"'\''
1
$ test-expr -e double -l '\''"-.1e2"'\''
1
$ test-expr -e ldouble -l '\''"-.1e2"'\''
1
$ test-expr -e float -l '\''"-.1E2"'\''
1
$ test-expr -e double -l '\''"-.1E2"'\''
1
$ test-expr -e ldouble -l '\''"-.1E2"'\''
1
$ test-expr -e float -l '\''"-.1p2"'\''
0
$ test-expr -e double -l '\''"-.1p2"'\''
0
$ test-expr -e ldouble -l '\''"-.1p2"'\''
0
$ test-expr -e float -l '\''"-.1P2"'\''
0
$ test-expr -e double -l '\''"-.1P2"'\''
0
$ test-expr -e ldouble -l '\''"-.1P2"'\''
0
$ test-expr -e float -l '\''"-0x"'\''
0
$ test-expr -e double -l '\''"-0x"'\''
0
$ test-expr -e ldouble -l '\''"-0x"'\''
0
$ test-expr -e float -l '\''"-0x0"'\''
0
$ test-expr -e double -l '\''"-0x0"'\''
0
$ test-expr -e ldouble -l '\''"-0x0"'\''
0
$ test-expr -e float -l '\''"-0x1e2"'\''
0
$ test-expr -e double -l '\''"-0x1e2"'\''
0
$ test-expr -e ldouble -l '\''"-0x1e2"'\''
0
$ test-expr -e float -l '\''"-0x1E2"'\''
0
$ test-expr -e double -l '\''"-0x1E2"'\''
0
$ test-expr -e ldouble -l '\''"-0x1E2"'\''
0
$ test-expr -e float -l '\''"-0x1p2"'\''
0
$ test-expr -e double -l '\''"-0x1p2"'\''
0
$ test-expr -e ldouble -l '\''"-0x1p2"'\''
0
$ test-expr -e float -l '\''"-0x1P2"'\''
0
$ test-expr -e double -l '\''"-0x1P2"'\''
0
$ test-expr -e ldouble -l '\''"-0x1P2"'\''
0
$ test-expr -e float -l '\''"-0X"'\''
0
$ test-expr -e double -l '\''"-0X"'\''
0
$ test-expr -e ldouble -l '\''"-0X"'\''
0
$ test-expr -e float -l '\''"-0X0"'\''
0
$ test-expr -e double -l '\''"-0X0"'\''
0
$ test-expr -e ldouble -l '\''"-0X0"'\''
0
$ test-expr -e float -l '\''"-0X1e2"'\''
0
$ test-expr -e double -l '\''"-0X1e2"'\''
0
$ test-expr -e ldouble -l '\''"-0X1e2"'\''
0
$ test-expr -e float -l '\''"-0X1E2"'\''
0
$ test-expr -e double -l '\''"-0X1E2"'\''
0
$ test-expr -e ldouble -l '\''"-0X1E2"'\''
0
$ test-expr -e float -l '\''"-0X1p2"'\''
0
$ test-expr -e double -l '\''"-0X1p2"'\''
0
$ test-expr -e ldouble -l '\''"-0X1p2"'\''
0
$ test-expr -e float -l '\''"-0X1P2"'\''
0
$ test-expr -e double -l '\''"-0X1P2"'\''
0
$ test-expr -e ldouble -l '\''"-0X1P2"'\''
0
$ test-expr -e float -l '\''"-0"'\''
1
$ test-expr -e double -l '\''"-0"'\''
1
$ test-expr -e ldouble -l '\''"-0"'\''
1
$ test-expr -e float -l '\''"-00"'\''
1
$ test-expr -e double -l '\''"-00"'\''
1
$ test-expr -e ldouble -l '\''"-00"'\''
1
$ test-expr -e float -l '\''"-01e2"'\''
1
$ test-expr -e double -l '\''"-01e2"'\''
1
$ test-expr -e ldouble -l '\''"-01e2"'\''
1
$ test-expr -e float -l '\''"-01E2"'\''
1
$ test-expr -e double -l '\''"-01E2"'\''
1
$ test-expr -e ldouble -l '\''"-01E2"'\''
1
$ test-expr -e float -l '\''"-01p2"'\''
0
$ test-expr -e double -l '\''"-01p2"'\''
0
$ test-expr -e ldouble -l '\''"-01p2"'\''
0
$ test-expr -e float -l '\''"-01P2"'\''
0
$ test-expr -e double -l '\''"-01P2"'\''
0
$ test-expr -e ldouble -l '\''"-01P2"'\''
0
$ test-expr -e float -l '\''"-1"'\''
1
$ test-expr -e double -l '\''"-1"'\''
1
$ test-expr -e ldouble -l '\''"-1"'\''
1
$ test-expr -e float -l '\''"-10"'\''
1
$ test-expr -e double -l '\''"-10"'\''
1
$ test-expr -e ldouble -l '\''"-10"'\''
1
$ test-expr -e float -l '\''"-11e2"'\''
1
$ test-expr -e double -l '\''"-11e2"'\''
1
$ test-expr -e ldouble -l '\''"-11e2"'\''
1
$ test-expr -e float -l '\''"-11E2"'\''
1
$ test-expr -e double -l '\''"-11E2"'\''
1
$ test-expr -e ldouble -l '\''"-11E2"'\''
1
$ test-expr -e float -l '\''"-11p2"'\''
0
$ test-expr -e double -l '\''"-11p2"'\''
0
$ test-expr -e ldouble -l '\''"-11p2"'\''
0
$ test-expr -e float -l '\''"-11P2"'\''
0
$ test-expr -e double -l '\''"-11P2"'\''
0
$ test-expr -e ldouble -l '\''"-11P2"'\''
0
$ test-expr -e float -l '\''"-2"'\''
1
$ test-expr -e double -l '\''"-2"'\''
1
$ test-expr -e ldouble -l '\''"-2"'\''
1
$ test-expr -e float -l '\''"-20"'\''
1
$ test-expr -e double -l '\''"-20"'\''
1
$ test-expr -e ldouble -l '\''"-20"'\''
1
$ test-expr -e float -l '\''"-21e2"'\''
1
$ test-expr -e double -l '\''"-21e2"'\''
1
$ test-expr -e ldouble -l '\''"-21e2"'\''
1
$ test-expr -e float -l '\''"-21E2"'\''
1
$ test-expr -e double -l '\''"-21E2"'\''
1
$ test-expr -e ldouble -l '\''"-21E2"'\''
1
$ test-expr -e float -l '\''"-21p2"'\''
0
$ test-expr -e double -l '\''"-21p2"'\''
0
$ test-expr -e ldouble -l '\''"-21p2"'\''
0
$ test-expr -e float -l '\''"-21P2"'\''
0
$ test-expr -e double -l '\''"-21P2"'\''
0
$ test-expr -e ldouble -l '\''"-21P2"'\''
0
$ test-expr -e float -l '\''"-3"'\''
1
$ test-expr -e double -l '\''"-3"'\''
1
$ test-expr -e ldouble -l '\''"-3"'\''
1
$ test-expr -e float -l '\''"-30"'\''
1
$ test-expr -e double -l '\''"-30"'\''
1
$ test-expr -e ldouble -l '\''"-30"'\''
1
$ test-expr -e float -l '\''"-31e2"'\''
1
$ test-expr -e double -l '\''"-31e2"'\''
1
$ test-expr -e ldouble -l '\''"-31e2"'\''
1
$ test-expr -e float -l '\''"-31E2"'\''
1
$ test-expr -e double -l '\''"-31E2"'\''
1
$ test-expr -e ldouble -l '\''"-31E2"'\''
1
$ test-expr -e float -l '\''"-31p2"'\''
0
$ test-expr -e double -l '\''"-31p2"'\''
0
$ test-expr -e ldouble -l '\''"-31p2"'\''
0
$ test-expr -e float -l '\''"-31P2"'\''
0
$ test-expr -e double -l '\''"-31P2"'\''
0
$ test-expr -e ldouble -l '\''"-31P2"'\''
0
$ test-expr -e float -l '\''"-4"'\''
1
$ test-expr -e double -l '\''"-4"'\''
1
$ test-expr -e ldouble -l '\''"-4"'\''
1
$ test-expr -e float -l '\''"-40"'\''
1
$ test-expr -e double -l '\''"-40"'\''
1
$ test-expr -e ldouble -l '\''"-40"'\''
1
$ test-expr -e float -l '\''"-41e2"'\''
1
$ test-expr -e double -l '\''"-41e2"'\''
1
$ test-expr -e ldouble -l '\''"-41e2"'\''
1
$ test-expr -e float -l '\''"-41E2"'\''
1
$ test-expr -e double -l '\''"-41E2"'\''
1
$ test-expr -e ldouble -l '\''"-41E2"'\''
1
$ test-expr -e float -l '\''"-41p2"'\''
0
$ test-expr -e double -l '\''"-41p2"'\''
0
$ test-expr -e ldouble -l '\''"-41p2"'\''
0
$ test-expr -e float -l '\''"-41P2"'\''
0
$ test-expr -e double -l '\''"-41P2"'\''
0
$ test-expr -e ldouble -l '\''"-41P2"'\''
0
$ test-expr -e float -l '\''"-5"'\''
1
$ test-expr -e double -l '\''"-5"'\''
1
$ test-expr -e ldouble -l '\''"-5"'\''
1
$ test-expr -e float -l '\''"-50"'\''
1
$ test-expr -e double -l '\''"-50"'\''
1
$ test-expr -e ldouble -l '\''"-50"'\''
1
$ test-expr -e float -l '\''"-51e2"'\''
1
$ test-expr -e double -l '\''"-51e2"'\''
1
$ test-expr -e ldouble -l '\''"-51e2"'\''
1
$ test-expr -e float -l '\''"-51E2"'\''
1
$ test-expr -e double -l '\''"-51E2"'\''
1
$ test-expr -e ldouble -l '\''"-51E2"'\''
1
$ test-expr -e float -l '\''"-51p2"'\''
0
$ test-expr -e double -l '\''"-51p2"'\''
0
$ test-expr -e ldouble -l '\''"-51p2"'\''
0
$ test-expr -e float -l '\''"-51P2"'\''
0
$ test-expr -e double -l '\''"-51P2"'\''
0
$ test-expr -e ldouble -l '\''"-51P2"'\''
0
$ test-expr -e float -l '\''"-6"'\''
1
$ test-expr -e double -l '\''"-6"'\''
1
$ test-expr -e ldouble -l '\''"-6"'\''
1
$ test-expr -e float -l '\''"-60"'\''
1
$ test-expr -e double -l '\''"-60"'\''
1
$ test-expr -e ldouble -l '\''"-60"'\''
1
$ test-expr -e float -l '\''"-61e2"'\''
1
$ test-expr -e double -l '\''"-61e2"'\''
1
$ test-expr -e ldouble -l '\''"-61e2"'\''
1
$ test-expr -e float -l '\''"-61E2"'\''
1
$ test-expr -e double -l '\''"-61E2"'\''
1
$ test-expr -e ldouble -l '\''"-61E2"'\''
1
$ test-expr -e float -l '\''"-61p2"'\''
0
$ test-expr -e double -l '\''"-61p2"'\''
0
$ test-expr -e ldouble -l '\''"-61p2"'\''
0
$ test-expr -e float -l '\''"-61P2"'\''
0
$ test-expr -e double -l '\''"-61P2"'\''
0
$ test-expr -e ldouble -l '\''"-61P2"'\''
0
$ test-expr -e float -l '\''"-7"'\''
1
$ test-expr -e double -l '\''"-7"'\''
1
$ test-expr -e ldouble -l '\''"-7"'\''
1
$ test-expr -e float -l '\''"-70"'\''
1
$ test-expr -e double -l '\''"-70"'\''
1
$ test-expr -e ldouble -l '\''"-70"'\''
1
$ test-expr -e float -l '\''"-71e2"'\''
1
$ test-expr -e double -l '\''"-71e2"'\''
1
$ test-expr -e ldouble -l '\''"-71e2"'\''
1
$ test-expr -e float -l '\''"-71E2"'\''
1
$ test-expr -e double -l '\''"-71E2"'\''
1
$ test-expr -e ldouble -l '\''"-71E2"'\''
1
$ test-expr -e float -l '\''"-71p2"'\''
0
$ test-expr -e double -l '\''"-71p2"'\''
0
$ test-expr -e ldouble -l '\''"-71p2"'\''
0
$ test-expr -e float -l '\''"-71P2"'\''
0
$ test-expr -e double -l '\''"-71P2"'\''
0
$ test-expr -e ldouble -l '\''"-71P2"'\''
0
$ test-expr -e float -l '\''"-8"'\''
1
$ test-expr -e double -l '\''"-8"'\''
1
$ test-expr -e ldouble -l '\''"-8"'\''
1
$ test-expr -e float -l '\''"-80"'\''
1
$ test-expr -e double -l '\''"-80"'\''
1
$ test-expr -e ldouble -l '\''"-80"'\''
1
$ test-expr -e float -l '\''"-81e2"'\''
1
$ test-expr -e double -l '\''"-81e2"'\''
1
$ test-expr -e ldouble -l '\''"-81e2"'\''
1
$ test-expr -e float -l '\''"-81E2"'\''
1
$ test-expr -e double -l '\''"-81E2"'\''
1
$ test-expr -e ldouble -l '\''"-81E2"'\''
1
$ test-expr -e float -l '\''"-81p2"'\''
0
$ test-expr -e double -l '\''"-81p2"'\''
0
$ test-expr -e ldouble -l '\''"-81p2"'\''
0
$ test-expr -e float -l '\''"-81P2"'\''
0
$ test-expr -e double -l '\''"-81P2"'\''
0
$ test-expr -e ldouble -l '\''"-81P2"'\''
0
$ test-expr -e float -l '\''"-9"'\''
1
$ test-expr -e double -l '\''"-9"'\''
1
$ test-expr -e ldouble -l '\''"-9"'\''
1
$ test-expr -e float -l '\''"-90"'\''
1
$ test-expr -e double -l '\''"-90"'\''
1
$ test-expr -e ldouble -l '\''"-90"'\''
1
$ test-expr -e float -l '\''"-91e2"'\''
1
$ test-expr -e double -l '\''"-91e2"'\''
1
$ test-expr -e ldouble -l '\''"-91e2"'\''
1
$ test-expr -e float -l '\''"-91E2"'\''
1
$ test-expr -e double -l '\''"-91E2"'\''
1
$ test-expr -e ldouble -l '\''"-91E2"'\''
1
$ test-expr -e float -l '\''"-91p2"'\''
0
$ test-expr -e double -l '\''"-91p2"'\''
0
$ test-expr -e ldouble -l '\''"-91p2"'\''
0
$ test-expr -e float -l '\''"-91P2"'\''
0
$ test-expr -e double -l '\''"-91P2"'\''
0
$ test-expr -e ldouble -l '\''"-91P2"'\''
0
$ test-expr -e float -l '\''"+."'\''
0
$ test-expr -e double -l '\''"+."'\''
0
$ test-expr -e ldouble -l '\''"+."'\''
0
$ test-expr -e float -l '\''"+.0"'\''
1
$ test-expr -e double -l '\''"+.0"'\''
1
$ test-expr -e ldouble -l '\''"+.0"'\''
1
$ test-expr -e float -l '\''"+.1e2"'\''
1
$ test-expr -e double -l '\''"+.1e2"'\''
1
$ test-expr -e ldouble -l '\''"+.1e2"'\''
1
$ test-expr -e float -l '\''"+.1E2"'\''
1
$ test-expr -e double -l '\''"+.1E2"'\''
1
$ test-expr -e ldouble -l '\''"+.1E2"'\''
1
$ test-expr -e float -l '\''"+.1p2"'\''
0
$ test-expr -e double -l '\''"+.1p2"'\''
0
$ test-expr -e ldouble -l '\''"+.1p2"'\''
0
$ test-expr -e float -l '\''"+.1P2"'\''
0
$ test-expr -e double -l '\''"+.1P2"'\''
0
$ test-expr -e ldouble -l '\''"+.1P2"'\''
0
$ test-expr -e float -l '\''"+0x"'\''
0
$ test-expr -e double -l '\''"+0x"'\''
0
$ test-expr -e ldouble -l '\''"+0x"'\''
0
$ test-expr -e float -l '\''"+0x0"'\''
0
$ test-expr -e double -l '\''"+0x0"'\''
0
$ test-expr -e ldouble -l '\''"+0x0"'\''
0
$ test-expr -e float -l '\''"+0x1e2"'\''
0
$ test-expr -e double -l '\''"+0x1e2"'\''
0
$ test-expr -e ldouble -l '\''"+0x1e2"'\''
0
$ test-expr -e float -l '\''"+0x1E2"'\''
0
$ test-expr -e double -l '\''"+0x1E2"'\''
0
$ test-expr -e ldouble -l '\''"+0x1E2"'\''
0
$ test-expr -e float -l '\''"+0x1p2"'\''
0
$ test-expr -e double -l '\''"+0x1p2"'\''
0
$ test-expr -e ldouble -l '\''"+0x1p2"'\''
0
$ test-expr -e float -l '\''"+0x1P2"'\''
0
$ test-expr -e double -l '\''"+0x1P2"'\''
0
$ test-expr -e ldouble -l '\''"+0x1P2"'\''
0
$ test-expr -e float -l '\''"+0X"'\''
0
$ test-expr -e double -l '\''"+0X"'\''
0
$ test-expr -e ldouble -l '\''"+0X"'\''
0
$ test-expr -e float -l '\''"+0X0"'\''
0
$ test-expr -e double -l '\''"+0X0"'\''
0
$ test-expr -e ldouble -l '\''"+0X0"'\''
0
$ test-expr -e float -l '\''"+0X1e2"'\''
0
$ test-expr -e double -l '\''"+0X1e2"'\''
0
$ test-expr -e ldouble -l '\''"+0X1e2"'\''
0
$ test-expr -e float -l '\''"+0X1E2"'\''
0
$ test-expr -e double -l '\''"+0X1E2"'\''
0
$ test-expr -e ldouble -l '\''"+0X1E2"'\''
0
$ test-expr -e float -l '\''"+0X1p2"'\''
0
$ test-expr -e double -l '\''"+0X1p2"'\''
0
$ test-expr -e ldouble -l '\''"+0X1p2"'\''
0
$ test-expr -e float -l '\''"+0X1P2"'\''
0
$ test-expr -e double -l '\''"+0X1P2"'\''
0
$ test-expr -e ldouble -l '\''"+0X1P2"'\''
0
$ test-expr -e float -l '\''"+0"'\''
1
$ test-expr -e double -l '\''"+0"'\''
1
$ test-expr -e ldouble -l '\''"+0"'\''
1
$ test-expr -e float -l '\''"+00"'\''
1
$ test-expr -e double -l '\''"+00"'\''
1
$ test-expr -e ldouble -l '\''"+00"'\''
1
$ test-expr -e float -l '\''"+01e2"'\''
1
$ test-expr -e double -l '\''"+01e2"'\''
1
$ test-expr -e ldouble -l '\''"+01e2"'\''
1
$ test-expr -e float -l '\''"+01E2"'\''
1
$ test-expr -e double -l '\''"+01E2"'\''
1
$ test-expr -e ldouble -l '\''"+01E2"'\''
1
$ test-expr -e float -l '\''"+01p2"'\''
0
$ test-expr -e double -l '\''"+01p2"'\''
0
$ test-expr -e ldouble -l '\''"+01p2"'\''
0
$ test-expr -e float -l '\''"+01P2"'\''
0
$ test-expr -e double -l '\''"+01P2"'\''
0
$ test-expr -e ldouble -l '\''"+01P2"'\''
0
$ test-expr -e float -l '\''"+1"'\''
1
$ test-expr -e double -l '\''"+1"'\''
1
$ test-expr -e ldouble -l '\''"+1"'\''
1
$ test-expr -e float -l '\''"+10"'\''
1
$ test-expr -e double -l '\''"+10"'\''
1
$ test-expr -e ldouble -l '\''"+10"'\''
1
$ test-expr -e float -l '\''"+11e2"'\''
1
$ test-expr -e double -l '\''"+11e2"'\''
1
$ test-expr -e ldouble -l '\''"+11e2"'\''
1
$ test-expr -e float -l '\''"+11E2"'\''
1
$ test-expr -e double -l '\''"+11E2"'\''
1
$ test-expr -e ldouble -l '\''"+11E2"'\''
1
$ test-expr -e float -l '\''"+11p2"'\''
0
$ test-expr -e double -l '\''"+11p2"'\''
0
$ test-expr -e ldouble -l '\''"+11p2"'\''
0
$ test-expr -e float -l '\''"+11P2"'\''
0
$ test-expr -e double -l '\''"+11P2"'\''
0
$ test-expr -e ldouble -l '\''"+11P2"'\''
0
$ test-expr -e float -l '\''"+2"'\''
1
$ test-expr -e double -l '\''"+2"'\''
1
$ test-expr -e ldouble -l '\''"+2"'\''
1
$ test-expr -e float -l '\''"+20"'\''
1
$ test-expr -e double -l '\''"+20"'\''
1
$ test-expr -e ldouble -l '\''"+20"'\''
1
$ test-expr -e float -l '\''"+21e2"'\''
1
$ test-expr -e double -l '\''"+21e2"'\''
1
$ test-expr -e ldouble -l '\''"+21e2"'\''
1
$ test-expr -e float -l '\''"+21E2"'\''
1
$ test-expr -e double -l '\''"+21E2"'\''
1
$ test-expr -e ldouble -l '\''"+21E2"'\''
1
$ test-expr -e float -l '\''"+21p2"'\''
0
$ test-expr -e double -l '\''"+21p2"'\''
0
$ test-expr -e ldouble -l '\''"+21p2"'\''
0
$ test-expr -e float -l '\''"+21P2"'\''
0
$ test-expr -e double -l '\''"+21P2"'\''
0
$ test-expr -e ldouble -l '\''"+21P2"'\''
0
$ test-expr -e float -l '\''"+3"'\''
1
$ test-expr -e double -l '\''"+3"'\''
1
$ test-expr -e ldouble -l '\''"+3"'\''
1
$ test-expr -e float -l '\''"+30"'\''
1
$ test-expr -e double -l '\''"+30"'\''
1
$ test-expr -e ldouble -l '\''"+30"'\''
1
$ test-expr -e float -l '\''"+31e2"'\''
1
$ test-expr -e double -l '\''"+31e2"'\''
1
$ test-expr -e ldouble -l '\''"+31e2"'\''
1
$ test-expr -e float -l '\''"+31E2"'\''
1
$ test-expr -e double -l '\''"+31E2"'\''
1
$ test-expr -e ldouble -l '\''"+31E2"'\''
1
$ test-expr -e float -l '\''"+31p2"'\''
0
$ test-expr -e double -l '\''"+31p2"'\''
0
$ test-expr -e ldouble -l '\''"+31p2"'\''
0
$ test-expr -e float -l '\''"+31P2"'\''
0
$ test-expr -e double -l '\''"+31P2"'\''
0
$ test-expr -e ldouble -l '\''"+31P2"'\''
0
$ test-expr -e float -l '\''"+4"'\''
1
$ test-expr -e double -l '\''"+4"'\''
1
$ test-expr -e ldouble -l '\''"+4"'\''
1
$ test-expr -e float -l '\''"+40"'\''
1
$ test-expr -e double -l '\''"+40"'\''
1
$ test-expr -e ldouble -l '\''"+40"'\''
1
$ test-expr -e float -l '\''"+41e2"'\''
1
$ test-expr -e double -l '\''"+41e2"'\''
1
$ test-expr -e ldouble -l '\''"+41e2"'\''
1
$ test-expr -e float -l '\''"+41E2"'\''
1
$ test-expr -e double -l '\''"+41E2"'\''
1
$ test-expr -e ldouble -l '\''"+41E2"'\''
1
$ test-expr -e float -l '\''"+41p2"'\''
0
$ test-expr -e double -l '\''"+41p2"'\''
0
$ test-expr -e ldouble -l '\''"+41p2"'\''
0
$ test-expr -e float -l '\''"+41P2"'\''
0
$ test-expr -e double -l '\''"+41P2"'\''
0
$ test-expr -e ldouble -l '\''"+41P2"'\''
0
$ test-expr -e float -l '\''"+5"'\''
1
$ test-expr -e double -l '\''"+5"'\''
1
$ test-expr -e ldouble -l '\''"+5"'\''
1
$ test-expr -e float -l '\''"+50"'\''
1
$ test-expr -e double -l '\''"+50"'\''
1
$ test-expr -e ldouble -l '\''"+50"'\''
1
$ test-expr -e float -l '\''"+51e2"'\''
1
$ test-expr -e double -l '\''"+51e2"'\''
1
$ test-expr -e ldouble -l '\''"+51e2"'\''
1
$ test-expr -e float -l '\''"+51E2"'\''
1
$ test-expr -e double -l '\''"+51E2"'\''
1
$ test-expr -e ldouble -l '\''"+51E2"'\''
1
$ test-expr -e float -l '\''"+51p2"'\''
0
$ test-expr -e double -l '\''"+51p2"'\''
0
$ test-expr -e ldouble -l '\''"+51p2"'\''
0
$ test-expr -e float -l '\''"+51P2"'\''
0
$ test-expr -e double -l '\''"+51P2"'\''
0
$ test-expr -e ldouble -l '\''"+51P2"'\''
0
$ test-expr -e float -l '\''"+6"'\''
1
$ test-expr -e double -l '\''"+6"'\''
1
$ test-expr -e ldouble -l '\''"+6"'\''
1
$ test-expr -e float -l '\''"+60"'\''
1
$ test-expr -e double -l '\''"+60"'\''
1
$ test-expr -e ldouble -l '\''"+60"'\''
1
$ test-expr -e float -l '\''"+61e2"'\''
1
$ test-expr -e double -l '\''"+61e2"'\''
1
$ test-expr -e ldouble -l '\''"+61e2"'\''
1
$ test-expr -e float -l '\''"+61E2"'\''
1
$ test-expr -e double -l '\''"+61E2"'\''
1
$ test-expr -e ldouble -l '\''"+61E2"'\''
1
$ test-expr -e float -l '\''"+61p2"'\''
0
$ test-expr -e double -l '\''"+61p2"'\''
0
$ test-expr -e ldouble -l '\''"+61p2"'\''
0
$ test-expr -e float -l '\''"+61P2"'\''
0
$ test-expr -e double -l '\''"+61P2"'\''
0
$ test-expr -e ldouble -l '\''"+61P2"'\''
0
$ test-expr -e float -l '\''"+7"'\''
1
$ test-expr -e double -l '\''"+7"'\''
1
$ test-expr -e ldouble -l '\''"+7"'\''
1
$ test-expr -e float -l '\''"+70"'\''
1
$ test-expr -e double -l '\''"+70"'\''
1
$ test-expr -e ldouble -l '\''"+70"'\''
1
$ test-expr -e float -l '\''"+71e2"'\''
1
$ test-expr -e double -l '\''"+71e2"'\''
1
$ test-expr -e ldouble -l '\''"+71e2"'\''
1
$ test-expr -e float -l '\''"+71E2"'\''
1
$ test-expr -e double -l '\''"+71E2"'\''
1
$ test-expr -e ldouble -l '\''"+71E2"'\''
1
$ test-expr -e float -l '\''"+71p2"'\''
0
$ test-expr -e double -l '\''"+71p2"'\''
0
$ test-expr -e ldouble -l '\''"+71p2"'\''
0
$ test-expr -e float -l '\''"+71P2"'\''
0
$ test-expr -e double -l '\''"+71P2"'\''
0
$ test-expr -e ldouble -l '\''"+71P2"'\''
0
$ test-expr -e float -l '\''"+8"'\''
1
$ test-expr -e double -l '\''"+8"'\''
1
$ test-expr -e ldouble -l '\''"+8"'\''
1
$ test-expr -e float -l '\''"+80"'\''
1
$ test-expr -e double -l '\''"+80"'\''
1
$ test-expr -e ldouble -l '\''"+80"'\''
1
$ test-expr -e float -l '\''"+81e2"'\''
1
$ test-expr -e double -l '\''"+81e2"'\''
1
$ test-expr -e ldouble -l '\''"+81e2"'\''
1
$ test-expr -e float -l '\''"+81E2"'\''
1
$ test-expr -e double -l '\''"+81E2"'\''
1
$ test-expr -e ldouble -l '\''"+81E2"'\''
1
$ test-expr -e float -l '\''"+81p2"'\''
0
$ test-expr -e double -l '\''"+81p2"'\''
0
$ test-expr -e ldouble -l '\''"+81p2"'\''
0
$ test-expr -e float -l '\''"+81P2"'\''
0
$ test-expr -e double -l '\''"+81P2"'\''
0
$ test-expr -e ldouble -l '\''"+81P2"'\''
0
$ test-expr -e float -l '\''"+9"'\''
1
$ test-expr -e double -l '\''"+9"'\''
1
$ test-expr -e ldouble -l '\''"+9"'\''
1
$ test-expr -e float -l '\''"+90"'\''
1
$ test-expr -e double -l '\''"+90"'\''
1
$ test-expr -e ldouble -l '\''"+90"'\''
1
$ test-expr -e float -l '\''"+91e2"'\''
1
$ test-expr -e double -l '\''"+91e2"'\''
1
$ test-expr -e ldouble -l '\''"+91e2"'\''
1
$ test-expr -e float -l '\''"+91E2"'\''
1
$ test-expr -e double -l '\''"+91E2"'\''
1
$ test-expr -e ldouble -l '\''"+91E2"'\''
1
$ test-expr -e float -l '\''"+91p2"'\''
0
$ test-expr -e double -l '\''"+91p2"'\''
0
$ test-expr -e ldouble -l '\''"+91p2"'\''
0
$ test-expr -e float -l '\''"+91P2"'\''
0
$ test-expr -e double -l '\''"+91P2"'\''
0
$ test-expr -e ldouble -l '\''"+91P2"'\''
0'
) -L builtins7.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr -e float -l 0'
test-expr -e float -l 0 2>&1 ||
echo 'command failed: test-expr -e float -l 0'

echo '$ test-expr -e double -l 0'
test-expr -e double -l 0 2>&1 ||
echo 'command failed: test-expr -e double -l 0'

echo '$ test-expr -e ldouble -l 0'
test-expr -e ldouble -l 0 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 0'

echo '$ test-expr -e float -l 1'
test-expr -e float -l 1 2>&1 ||
echo 'command failed: test-expr -e float -l 1'

echo '$ test-expr -e double -l 1'
test-expr -e double -l 1 2>&1 ||
echo 'command failed: test-expr -e double -l 1'

echo '$ test-expr -e ldouble -l 1'
test-expr -e ldouble -l 1 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 1'

echo '$ test-expr -e float -l 10'
test-expr -e float -l 10 2>&1 ||
echo 'command failed: test-expr -e float -l 10'

echo '$ test-expr -e double -l 10'
test-expr -e double -l 10 2>&1 ||
echo 'command failed: test-expr -e double -l 10'

echo '$ test-expr -e ldouble -l 10'
test-expr -e ldouble -l 10 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 10'

echo '$ test-expr -e float -l 11e2'
test-expr -e float -l 11e2 2>&1 ||
echo 'command failed: test-expr -e float -l 11e2'

echo '$ test-expr -e double -l 11e2'
test-expr -e double -l 11e2 2>&1 ||
echo 'command failed: test-expr -e double -l 11e2'

echo '$ test-expr -e ldouble -l 11e2'
test-expr -e ldouble -l 11e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 11e2'

echo '$ test-expr -e float -l 11E2'
test-expr -e float -l 11E2 2>&1 ||
echo 'command failed: test-expr -e float -l 11E2'

echo '$ test-expr -e double -l 11E2'
test-expr -e double -l 11E2 2>&1 ||
echo 'command failed: test-expr -e double -l 11E2'

echo '$ test-expr -e ldouble -l 11E2'
test-expr -e ldouble -l 11E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 11E2'

echo '$ test-expr -e float -l 2'
test-expr -e float -l 2 2>&1 ||
echo 'command failed: test-expr -e float -l 2'

echo '$ test-expr -e double -l 2'
test-expr -e double -l 2 2>&1 ||
echo 'command failed: test-expr -e double -l 2'

echo '$ test-expr -e ldouble -l 2'
test-expr -e ldouble -l 2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 2'

echo '$ test-expr -e float -l 20'
test-expr -e float -l 20 2>&1 ||
echo 'command failed: test-expr -e float -l 20'

echo '$ test-expr -e double -l 20'
test-expr -e double -l 20 2>&1 ||
echo 'command failed: test-expr -e double -l 20'

echo '$ test-expr -e ldouble -l 20'
test-expr -e ldouble -l 20 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 20'

echo '$ test-expr -e float -l 21e2'
test-expr -e float -l 21e2 2>&1 ||
echo 'command failed: test-expr -e float -l 21e2'

echo '$ test-expr -e double -l 21e2'
test-expr -e double -l 21e2 2>&1 ||
echo 'command failed: test-expr -e double -l 21e2'

echo '$ test-expr -e ldouble -l 21e2'
test-expr -e ldouble -l 21e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 21e2'

echo '$ test-expr -e float -l 21E2'
test-expr -e float -l 21E2 2>&1 ||
echo 'command failed: test-expr -e float -l 21E2'

echo '$ test-expr -e double -l 21E2'
test-expr -e double -l 21E2 2>&1 ||
echo 'command failed: test-expr -e double -l 21E2'

echo '$ test-expr -e ldouble -l 21E2'
test-expr -e ldouble -l 21E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 21E2'

echo '$ test-expr -e float -l 3'
test-expr -e float -l 3 2>&1 ||
echo 'command failed: test-expr -e float -l 3'

echo '$ test-expr -e double -l 3'
test-expr -e double -l 3 2>&1 ||
echo 'command failed: test-expr -e double -l 3'

echo '$ test-expr -e ldouble -l 3'
test-expr -e ldouble -l 3 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 3'

echo '$ test-expr -e float -l 30'
test-expr -e float -l 30 2>&1 ||
echo 'command failed: test-expr -e float -l 30'

echo '$ test-expr -e double -l 30'
test-expr -e double -l 30 2>&1 ||
echo 'command failed: test-expr -e double -l 30'

echo '$ test-expr -e ldouble -l 30'
test-expr -e ldouble -l 30 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 30'

echo '$ test-expr -e float -l 31e2'
test-expr -e float -l 31e2 2>&1 ||
echo 'command failed: test-expr -e float -l 31e2'

echo '$ test-expr -e double -l 31e2'
test-expr -e double -l 31e2 2>&1 ||
echo 'command failed: test-expr -e double -l 31e2'

echo '$ test-expr -e ldouble -l 31e2'
test-expr -e ldouble -l 31e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 31e2'

echo '$ test-expr -e float -l 31E2'
test-expr -e float -l 31E2 2>&1 ||
echo 'command failed: test-expr -e float -l 31E2'

echo '$ test-expr -e double -l 31E2'
test-expr -e double -l 31E2 2>&1 ||
echo 'command failed: test-expr -e double -l 31E2'

echo '$ test-expr -e ldouble -l 31E2'
test-expr -e ldouble -l 31E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 31E2'

echo '$ test-expr -e float -l 4'
test-expr -e float -l 4 2>&1 ||
echo 'command failed: test-expr -e float -l 4'

echo '$ test-expr -e double -l 4'
test-expr -e double -l 4 2>&1 ||
echo 'command failed: test-expr -e double -l 4'

echo '$ test-expr -e ldouble -l 4'
test-expr -e ldouble -l 4 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 4'

echo '$ test-expr -e float -l 40'
test-expr -e float -l 40 2>&1 ||
echo 'command failed: test-expr -e float -l 40'

echo '$ test-expr -e double -l 40'
test-expr -e double -l 40 2>&1 ||
echo 'command failed: test-expr -e double -l 40'

echo '$ test-expr -e ldouble -l 40'
test-expr -e ldouble -l 40 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 40'

echo '$ test-expr -e float -l 41e2'
test-expr -e float -l 41e2 2>&1 ||
echo 'command failed: test-expr -e float -l 41e2'

echo '$ test-expr -e double -l 41e2'
test-expr -e double -l 41e2 2>&1 ||
echo 'command failed: test-expr -e double -l 41e2'

echo '$ test-expr -e ldouble -l 41e2'
test-expr -e ldouble -l 41e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 41e2'

echo '$ test-expr -e float -l 41E2'
test-expr -e float -l 41E2 2>&1 ||
echo 'command failed: test-expr -e float -l 41E2'

echo '$ test-expr -e double -l 41E2'
test-expr -e double -l 41E2 2>&1 ||
echo 'command failed: test-expr -e double -l 41E2'

echo '$ test-expr -e ldouble -l 41E2'
test-expr -e ldouble -l 41E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 41E2'

echo '$ test-expr -e float -l 5'
test-expr -e float -l 5 2>&1 ||
echo 'command failed: test-expr -e float -l 5'

echo '$ test-expr -e double -l 5'
test-expr -e double -l 5 2>&1 ||
echo 'command failed: test-expr -e double -l 5'

echo '$ test-expr -e ldouble -l 5'
test-expr -e ldouble -l 5 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 5'

echo '$ test-expr -e float -l 50'
test-expr -e float -l 50 2>&1 ||
echo 'command failed: test-expr -e float -l 50'

echo '$ test-expr -e double -l 50'
test-expr -e double -l 50 2>&1 ||
echo 'command failed: test-expr -e double -l 50'

echo '$ test-expr -e ldouble -l 50'
test-expr -e ldouble -l 50 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 50'

echo '$ test-expr -e float -l 51e2'
test-expr -e float -l 51e2 2>&1 ||
echo 'command failed: test-expr -e float -l 51e2'

echo '$ test-expr -e double -l 51e2'
test-expr -e double -l 51e2 2>&1 ||
echo 'command failed: test-expr -e double -l 51e2'

echo '$ test-expr -e ldouble -l 51e2'
test-expr -e ldouble -l 51e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 51e2'

echo '$ test-expr -e float -l 51E2'
test-expr -e float -l 51E2 2>&1 ||
echo 'command failed: test-expr -e float -l 51E2'

echo '$ test-expr -e double -l 51E2'
test-expr -e double -l 51E2 2>&1 ||
echo 'command failed: test-expr -e double -l 51E2'

echo '$ test-expr -e ldouble -l 51E2'
test-expr -e ldouble -l 51E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 51E2'

echo '$ test-expr -e float -l 6'
test-expr -e float -l 6 2>&1 ||
echo 'command failed: test-expr -e float -l 6'

echo '$ test-expr -e double -l 6'
test-expr -e double -l 6 2>&1 ||
echo 'command failed: test-expr -e double -l 6'

echo '$ test-expr -e ldouble -l 6'
test-expr -e ldouble -l 6 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 6'

echo '$ test-expr -e float -l 60'
test-expr -e float -l 60 2>&1 ||
echo 'command failed: test-expr -e float -l 60'

echo '$ test-expr -e double -l 60'
test-expr -e double -l 60 2>&1 ||
echo 'command failed: test-expr -e double -l 60'

echo '$ test-expr -e ldouble -l 60'
test-expr -e ldouble -l 60 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 60'

echo '$ test-expr -e float -l 61e2'
test-expr -e float -l 61e2 2>&1 ||
echo 'command failed: test-expr -e float -l 61e2'

echo '$ test-expr -e double -l 61e2'
test-expr -e double -l 61e2 2>&1 ||
echo 'command failed: test-expr -e double -l 61e2'

echo '$ test-expr -e ldouble -l 61e2'
test-expr -e ldouble -l 61e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 61e2'

echo '$ test-expr -e float -l 61E2'
test-expr -e float -l 61E2 2>&1 ||
echo 'command failed: test-expr -e float -l 61E2'

echo '$ test-expr -e double -l 61E2'
test-expr -e double -l 61E2 2>&1 ||
echo 'command failed: test-expr -e double -l 61E2'

echo '$ test-expr -e ldouble -l 61E2'
test-expr -e ldouble -l 61E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 61E2'

echo '$ test-expr -e float -l 7'
test-expr -e float -l 7 2>&1 ||
echo 'command failed: test-expr -e float -l 7'

echo '$ test-expr -e double -l 7'
test-expr -e double -l 7 2>&1 ||
echo 'command failed: test-expr -e double -l 7'

echo '$ test-expr -e ldouble -l 7'
test-expr -e ldouble -l 7 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 7'

echo '$ test-expr -e float -l 70'
test-expr -e float -l 70 2>&1 ||
echo 'command failed: test-expr -e float -l 70'

echo '$ test-expr -e double -l 70'
test-expr -e double -l 70 2>&1 ||
echo 'command failed: test-expr -e double -l 70'

echo '$ test-expr -e ldouble -l 70'
test-expr -e ldouble -l 70 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 70'

echo '$ test-expr -e float -l 71e2'
test-expr -e float -l 71e2 2>&1 ||
echo 'command failed: test-expr -e float -l 71e2'

echo '$ test-expr -e double -l 71e2'
test-expr -e double -l 71e2 2>&1 ||
echo 'command failed: test-expr -e double -l 71e2'

echo '$ test-expr -e ldouble -l 71e2'
test-expr -e ldouble -l 71e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 71e2'

echo '$ test-expr -e float -l 71E2'
test-expr -e float -l 71E2 2>&1 ||
echo 'command failed: test-expr -e float -l 71E2'

echo '$ test-expr -e double -l 71E2'
test-expr -e double -l 71E2 2>&1 ||
echo 'command failed: test-expr -e double -l 71E2'

echo '$ test-expr -e ldouble -l 71E2'
test-expr -e ldouble -l 71E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 71E2'

echo '$ test-expr -e float -l 8'
test-expr -e float -l 8 2>&1 ||
echo 'command failed: test-expr -e float -l 8'

echo '$ test-expr -e double -l 8'
test-expr -e double -l 8 2>&1 ||
echo 'command failed: test-expr -e double -l 8'

echo '$ test-expr -e ldouble -l 8'
test-expr -e ldouble -l 8 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 8'

echo '$ test-expr -e float -l 80'
test-expr -e float -l 80 2>&1 ||
echo 'command failed: test-expr -e float -l 80'

echo '$ test-expr -e double -l 80'
test-expr -e double -l 80 2>&1 ||
echo 'command failed: test-expr -e double -l 80'

echo '$ test-expr -e ldouble -l 80'
test-expr -e ldouble -l 80 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 80'

echo '$ test-expr -e float -l 81e2'
test-expr -e float -l 81e2 2>&1 ||
echo 'command failed: test-expr -e float -l 81e2'

echo '$ test-expr -e double -l 81e2'
test-expr -e double -l 81e2 2>&1 ||
echo 'command failed: test-expr -e double -l 81e2'

echo '$ test-expr -e ldouble -l 81e2'
test-expr -e ldouble -l 81e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 81e2'

echo '$ test-expr -e float -l 81E2'
test-expr -e float -l 81E2 2>&1 ||
echo 'command failed: test-expr -e float -l 81E2'

echo '$ test-expr -e double -l 81E2'
test-expr -e double -l 81E2 2>&1 ||
echo 'command failed: test-expr -e double -l 81E2'

echo '$ test-expr -e ldouble -l 81E2'
test-expr -e ldouble -l 81E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 81E2'

echo '$ test-expr -e float -l 9'
test-expr -e float -l 9 2>&1 ||
echo 'command failed: test-expr -e float -l 9'

echo '$ test-expr -e double -l 9'
test-expr -e double -l 9 2>&1 ||
echo 'command failed: test-expr -e double -l 9'

echo '$ test-expr -e ldouble -l 9'
test-expr -e ldouble -l 9 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 9'

echo '$ test-expr -e float -l 90'
test-expr -e float -l 90 2>&1 ||
echo 'command failed: test-expr -e float -l 90'

echo '$ test-expr -e double -l 90'
test-expr -e double -l 90 2>&1 ||
echo 'command failed: test-expr -e double -l 90'

echo '$ test-expr -e ldouble -l 90'
test-expr -e ldouble -l 90 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 90'

echo '$ test-expr -e float -l 91e2'
test-expr -e float -l 91e2 2>&1 ||
echo 'command failed: test-expr -e float -l 91e2'

echo '$ test-expr -e double -l 91e2'
test-expr -e double -l 91e2 2>&1 ||
echo 'command failed: test-expr -e double -l 91e2'

echo '$ test-expr -e ldouble -l 91e2'
test-expr -e ldouble -l 91e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 91e2'

echo '$ test-expr -e float -l 91E2'
test-expr -e float -l 91E2 2>&1 ||
echo 'command failed: test-expr -e float -l 91E2'

echo '$ test-expr -e double -l 91E2'
test-expr -e double -l 91E2 2>&1 ||
echo 'command failed: test-expr -e double -l 91E2'

echo '$ test-expr -e ldouble -l 91E2'
test-expr -e ldouble -l 91E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l 91E2'

echo '$ test-expr -e float -l -0'
test-expr -e float -l -0 2>&1 ||
echo 'command failed: test-expr -e float -l -0'

echo '$ test-expr -e double -l -0'
test-expr -e double -l -0 2>&1 ||
echo 'command failed: test-expr -e double -l -0'

echo '$ test-expr -e ldouble -l -0'
test-expr -e ldouble -l -0 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -0'

echo '$ test-expr -e float -l -1'
test-expr -e float -l -1 2>&1 ||
echo 'command failed: test-expr -e float -l -1'

echo '$ test-expr -e double -l -1'
test-expr -e double -l -1 2>&1 ||
echo 'command failed: test-expr -e double -l -1'

echo '$ test-expr -e ldouble -l -1'
test-expr -e ldouble -l -1 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -1'

echo '$ test-expr -e float -l -10'
test-expr -e float -l -10 2>&1 ||
echo 'command failed: test-expr -e float -l -10'

echo '$ test-expr -e double -l -10'
test-expr -e double -l -10 2>&1 ||
echo 'command failed: test-expr -e double -l -10'

echo '$ test-expr -e ldouble -l -10'
test-expr -e ldouble -l -10 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -10'

echo '$ test-expr -e float -l -11e2'
test-expr -e float -l -11e2 2>&1 ||
echo 'command failed: test-expr -e float -l -11e2'

echo '$ test-expr -e double -l -11e2'
test-expr -e double -l -11e2 2>&1 ||
echo 'command failed: test-expr -e double -l -11e2'

echo '$ test-expr -e ldouble -l -11e2'
test-expr -e ldouble -l -11e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -11e2'

echo '$ test-expr -e float -l -11E2'
test-expr -e float -l -11E2 2>&1 ||
echo 'command failed: test-expr -e float -l -11E2'

echo '$ test-expr -e double -l -11E2'
test-expr -e double -l -11E2 2>&1 ||
echo 'command failed: test-expr -e double -l -11E2'

echo '$ test-expr -e ldouble -l -11E2'
test-expr -e ldouble -l -11E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -11E2'

echo '$ test-expr -e float -l -2'
test-expr -e float -l -2 2>&1 ||
echo 'command failed: test-expr -e float -l -2'

echo '$ test-expr -e double -l -2'
test-expr -e double -l -2 2>&1 ||
echo 'command failed: test-expr -e double -l -2'

echo '$ test-expr -e ldouble -l -2'
test-expr -e ldouble -l -2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -2'

echo '$ test-expr -e float -l -20'
test-expr -e float -l -20 2>&1 ||
echo 'command failed: test-expr -e float -l -20'

echo '$ test-expr -e double -l -20'
test-expr -e double -l -20 2>&1 ||
echo 'command failed: test-expr -e double -l -20'

echo '$ test-expr -e ldouble -l -20'
test-expr -e ldouble -l -20 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -20'

echo '$ test-expr -e float -l -21e2'
test-expr -e float -l -21e2 2>&1 ||
echo 'command failed: test-expr -e float -l -21e2'

echo '$ test-expr -e double -l -21e2'
test-expr -e double -l -21e2 2>&1 ||
echo 'command failed: test-expr -e double -l -21e2'

echo '$ test-expr -e ldouble -l -21e2'
test-expr -e ldouble -l -21e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -21e2'

echo '$ test-expr -e float -l -21E2'
test-expr -e float -l -21E2 2>&1 ||
echo 'command failed: test-expr -e float -l -21E2'

echo '$ test-expr -e double -l -21E2'
test-expr -e double -l -21E2 2>&1 ||
echo 'command failed: test-expr -e double -l -21E2'

echo '$ test-expr -e ldouble -l -21E2'
test-expr -e ldouble -l -21E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -21E2'

echo '$ test-expr -e float -l -3'
test-expr -e float -l -3 2>&1 ||
echo 'command failed: test-expr -e float -l -3'

echo '$ test-expr -e double -l -3'
test-expr -e double -l -3 2>&1 ||
echo 'command failed: test-expr -e double -l -3'

echo '$ test-expr -e ldouble -l -3'
test-expr -e ldouble -l -3 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -3'

echo '$ test-expr -e float -l -30'
test-expr -e float -l -30 2>&1 ||
echo 'command failed: test-expr -e float -l -30'

echo '$ test-expr -e double -l -30'
test-expr -e double -l -30 2>&1 ||
echo 'command failed: test-expr -e double -l -30'

echo '$ test-expr -e ldouble -l -30'
test-expr -e ldouble -l -30 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -30'

echo '$ test-expr -e float -l -31e2'
test-expr -e float -l -31e2 2>&1 ||
echo 'command failed: test-expr -e float -l -31e2'

echo '$ test-expr -e double -l -31e2'
test-expr -e double -l -31e2 2>&1 ||
echo 'command failed: test-expr -e double -l -31e2'

echo '$ test-expr -e ldouble -l -31e2'
test-expr -e ldouble -l -31e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -31e2'

echo '$ test-expr -e float -l -31E2'
test-expr -e float -l -31E2 2>&1 ||
echo 'command failed: test-expr -e float -l -31E2'

echo '$ test-expr -e double -l -31E2'
test-expr -e double -l -31E2 2>&1 ||
echo 'command failed: test-expr -e double -l -31E2'

echo '$ test-expr -e ldouble -l -31E2'
test-expr -e ldouble -l -31E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -31E2'

echo '$ test-expr -e float -l -4'
test-expr -e float -l -4 2>&1 ||
echo 'command failed: test-expr -e float -l -4'

echo '$ test-expr -e double -l -4'
test-expr -e double -l -4 2>&1 ||
echo 'command failed: test-expr -e double -l -4'

echo '$ test-expr -e ldouble -l -4'
test-expr -e ldouble -l -4 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -4'

echo '$ test-expr -e float -l -40'
test-expr -e float -l -40 2>&1 ||
echo 'command failed: test-expr -e float -l -40'

echo '$ test-expr -e double -l -40'
test-expr -e double -l -40 2>&1 ||
echo 'command failed: test-expr -e double -l -40'

echo '$ test-expr -e ldouble -l -40'
test-expr -e ldouble -l -40 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -40'

echo '$ test-expr -e float -l -41e2'
test-expr -e float -l -41e2 2>&1 ||
echo 'command failed: test-expr -e float -l -41e2'

echo '$ test-expr -e double -l -41e2'
test-expr -e double -l -41e2 2>&1 ||
echo 'command failed: test-expr -e double -l -41e2'

echo '$ test-expr -e ldouble -l -41e2'
test-expr -e ldouble -l -41e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -41e2'

echo '$ test-expr -e float -l -41E2'
test-expr -e float -l -41E2 2>&1 ||
echo 'command failed: test-expr -e float -l -41E2'

echo '$ test-expr -e double -l -41E2'
test-expr -e double -l -41E2 2>&1 ||
echo 'command failed: test-expr -e double -l -41E2'

echo '$ test-expr -e ldouble -l -41E2'
test-expr -e ldouble -l -41E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -41E2'

echo '$ test-expr -e float -l -5'
test-expr -e float -l -5 2>&1 ||
echo 'command failed: test-expr -e float -l -5'

echo '$ test-expr -e double -l -5'
test-expr -e double -l -5 2>&1 ||
echo 'command failed: test-expr -e double -l -5'

echo '$ test-expr -e ldouble -l -5'
test-expr -e ldouble -l -5 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -5'

echo '$ test-expr -e float -l -50'
test-expr -e float -l -50 2>&1 ||
echo 'command failed: test-expr -e float -l -50'

echo '$ test-expr -e double -l -50'
test-expr -e double -l -50 2>&1 ||
echo 'command failed: test-expr -e double -l -50'

echo '$ test-expr -e ldouble -l -50'
test-expr -e ldouble -l -50 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -50'

echo '$ test-expr -e float -l -51e2'
test-expr -e float -l -51e2 2>&1 ||
echo 'command failed: test-expr -e float -l -51e2'

echo '$ test-expr -e double -l -51e2'
test-expr -e double -l -51e2 2>&1 ||
echo 'command failed: test-expr -e double -l -51e2'

echo '$ test-expr -e ldouble -l -51e2'
test-expr -e ldouble -l -51e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -51e2'

echo '$ test-expr -e float -l -51E2'
test-expr -e float -l -51E2 2>&1 ||
echo 'command failed: test-expr -e float -l -51E2'

echo '$ test-expr -e double -l -51E2'
test-expr -e double -l -51E2 2>&1 ||
echo 'command failed: test-expr -e double -l -51E2'

echo '$ test-expr -e ldouble -l -51E2'
test-expr -e ldouble -l -51E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -51E2'

echo '$ test-expr -e float -l -6'
test-expr -e float -l -6 2>&1 ||
echo 'command failed: test-expr -e float -l -6'

echo '$ test-expr -e double -l -6'
test-expr -e double -l -6 2>&1 ||
echo 'command failed: test-expr -e double -l -6'

echo '$ test-expr -e ldouble -l -6'
test-expr -e ldouble -l -6 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -6'

echo '$ test-expr -e float -l -60'
test-expr -e float -l -60 2>&1 ||
echo 'command failed: test-expr -e float -l -60'

echo '$ test-expr -e double -l -60'
test-expr -e double -l -60 2>&1 ||
echo 'command failed: test-expr -e double -l -60'

echo '$ test-expr -e ldouble -l -60'
test-expr -e ldouble -l -60 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -60'

echo '$ test-expr -e float -l -61e2'
test-expr -e float -l -61e2 2>&1 ||
echo 'command failed: test-expr -e float -l -61e2'

echo '$ test-expr -e double -l -61e2'
test-expr -e double -l -61e2 2>&1 ||
echo 'command failed: test-expr -e double -l -61e2'

echo '$ test-expr -e ldouble -l -61e2'
test-expr -e ldouble -l -61e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -61e2'

echo '$ test-expr -e float -l -61E2'
test-expr -e float -l -61E2 2>&1 ||
echo 'command failed: test-expr -e float -l -61E2'

echo '$ test-expr -e double -l -61E2'
test-expr -e double -l -61E2 2>&1 ||
echo 'command failed: test-expr -e double -l -61E2'

echo '$ test-expr -e ldouble -l -61E2'
test-expr -e ldouble -l -61E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -61E2'

echo '$ test-expr -e float -l -7'
test-expr -e float -l -7 2>&1 ||
echo 'command failed: test-expr -e float -l -7'

echo '$ test-expr -e double -l -7'
test-expr -e double -l -7 2>&1 ||
echo 'command failed: test-expr -e double -l -7'

echo '$ test-expr -e ldouble -l -7'
test-expr -e ldouble -l -7 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -7'

echo '$ test-expr -e float -l -70'
test-expr -e float -l -70 2>&1 ||
echo 'command failed: test-expr -e float -l -70'

echo '$ test-expr -e double -l -70'
test-expr -e double -l -70 2>&1 ||
echo 'command failed: test-expr -e double -l -70'

echo '$ test-expr -e ldouble -l -70'
test-expr -e ldouble -l -70 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -70'

echo '$ test-expr -e float -l -71e2'
test-expr -e float -l -71e2 2>&1 ||
echo 'command failed: test-expr -e float -l -71e2'

echo '$ test-expr -e double -l -71e2'
test-expr -e double -l -71e2 2>&1 ||
echo 'command failed: test-expr -e double -l -71e2'

echo '$ test-expr -e ldouble -l -71e2'
test-expr -e ldouble -l -71e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -71e2'

echo '$ test-expr -e float -l -71E2'
test-expr -e float -l -71E2 2>&1 ||
echo 'command failed: test-expr -e float -l -71E2'

echo '$ test-expr -e double -l -71E2'
test-expr -e double -l -71E2 2>&1 ||
echo 'command failed: test-expr -e double -l -71E2'

echo '$ test-expr -e ldouble -l -71E2'
test-expr -e ldouble -l -71E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -71E2'

echo '$ test-expr -e float -l -8'
test-expr -e float -l -8 2>&1 ||
echo 'command failed: test-expr -e float -l -8'

echo '$ test-expr -e double -l -8'
test-expr -e double -l -8 2>&1 ||
echo 'command failed: test-expr -e double -l -8'

echo '$ test-expr -e ldouble -l -8'
test-expr -e ldouble -l -8 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -8'

echo '$ test-expr -e float -l -80'
test-expr -e float -l -80 2>&1 ||
echo 'command failed: test-expr -e float -l -80'

echo '$ test-expr -e double -l -80'
test-expr -e double -l -80 2>&1 ||
echo 'command failed: test-expr -e double -l -80'

echo '$ test-expr -e ldouble -l -80'
test-expr -e ldouble -l -80 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -80'

echo '$ test-expr -e float -l -81e2'
test-expr -e float -l -81e2 2>&1 ||
echo 'command failed: test-expr -e float -l -81e2'

echo '$ test-expr -e double -l -81e2'
test-expr -e double -l -81e2 2>&1 ||
echo 'command failed: test-expr -e double -l -81e2'

echo '$ test-expr -e ldouble -l -81e2'
test-expr -e ldouble -l -81e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -81e2'

echo '$ test-expr -e float -l -81E2'
test-expr -e float -l -81E2 2>&1 ||
echo 'command failed: test-expr -e float -l -81E2'

echo '$ test-expr -e double -l -81E2'
test-expr -e double -l -81E2 2>&1 ||
echo 'command failed: test-expr -e double -l -81E2'

echo '$ test-expr -e ldouble -l -81E2'
test-expr -e ldouble -l -81E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -81E2'

echo '$ test-expr -e float -l -9'
test-expr -e float -l -9 2>&1 ||
echo 'command failed: test-expr -e float -l -9'

echo '$ test-expr -e double -l -9'
test-expr -e double -l -9 2>&1 ||
echo 'command failed: test-expr -e double -l -9'

echo '$ test-expr -e ldouble -l -9'
test-expr -e ldouble -l -9 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -9'

echo '$ test-expr -e float -l -90'
test-expr -e float -l -90 2>&1 ||
echo 'command failed: test-expr -e float -l -90'

echo '$ test-expr -e double -l -90'
test-expr -e double -l -90 2>&1 ||
echo 'command failed: test-expr -e double -l -90'

echo '$ test-expr -e ldouble -l -90'
test-expr -e ldouble -l -90 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -90'

echo '$ test-expr -e float -l -91e2'
test-expr -e float -l -91e2 2>&1 ||
echo 'command failed: test-expr -e float -l -91e2'

echo '$ test-expr -e double -l -91e2'
test-expr -e double -l -91e2 2>&1 ||
echo 'command failed: test-expr -e double -l -91e2'

echo '$ test-expr -e ldouble -l -91e2'
test-expr -e ldouble -l -91e2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -91e2'

echo '$ test-expr -e float -l -91E2'
test-expr -e float -l -91E2 2>&1 ||
echo 'command failed: test-expr -e float -l -91E2'

echo '$ test-expr -e double -l -91E2'
test-expr -e double -l -91E2 2>&1 ||
echo 'command failed: test-expr -e double -l -91E2'

echo '$ test-expr -e ldouble -l -91E2'
test-expr -e ldouble -l -91E2 2>&1 ||
echo 'command failed: test-expr -e ldouble -l -91E2'

echo '$ test-expr -e float -l '\''"."'\'''
test-expr -e float -l '"."' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"."'\'''

echo '$ test-expr -e double -l '\''"."'\'''
test-expr -e double -l '"."' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"."'\'''

echo '$ test-expr -e ldouble -l '\''"."'\'''
test-expr -e ldouble -l '"."' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"."'\'''

echo '$ test-expr -e float -l '\''".0"'\'''
test-expr -e float -l '".0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''".0"'\'''

echo '$ test-expr -e double -l '\''".0"'\'''
test-expr -e double -l '".0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''".0"'\'''

echo '$ test-expr -e ldouble -l '\''".0"'\'''
test-expr -e ldouble -l '".0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''".0"'\'''

echo '$ test-expr -e float -l '\''".1e2"'\'''
test-expr -e float -l '".1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''".1e2"'\'''

echo '$ test-expr -e double -l '\''".1e2"'\'''
test-expr -e double -l '".1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''".1e2"'\'''

echo '$ test-expr -e ldouble -l '\''".1e2"'\'''
test-expr -e ldouble -l '".1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''".1e2"'\'''

echo '$ test-expr -e float -l '\''".1E2"'\'''
test-expr -e float -l '".1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''".1E2"'\'''

echo '$ test-expr -e double -l '\''".1E2"'\'''
test-expr -e double -l '".1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''".1E2"'\'''

echo '$ test-expr -e ldouble -l '\''".1E2"'\'''
test-expr -e ldouble -l '".1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''".1E2"'\'''

echo '$ test-expr -e float -l '\''".1p2"'\'''
test-expr -e float -l '".1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''".1p2"'\'''

echo '$ test-expr -e double -l '\''".1p2"'\'''
test-expr -e double -l '".1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''".1p2"'\'''

echo '$ test-expr -e ldouble -l '\''".1p2"'\'''
test-expr -e ldouble -l '".1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''".1p2"'\'''

echo '$ test-expr -e float -l '\''".1P2"'\'''
test-expr -e float -l '".1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''".1P2"'\'''

echo '$ test-expr -e double -l '\''".1P2"'\'''
test-expr -e double -l '".1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''".1P2"'\'''

echo '$ test-expr -e ldouble -l '\''".1P2"'\'''
test-expr -e ldouble -l '".1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''".1P2"'\'''

echo '$ test-expr -e float -l '\''"0x"'\'''
test-expr -e float -l '"0x"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x"'\'''

echo '$ test-expr -e double -l '\''"0x"'\'''
test-expr -e double -l '"0x"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x"'\'''

echo '$ test-expr -e ldouble -l '\''"0x"'\'''
test-expr -e ldouble -l '"0x"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x"'\'''

echo '$ test-expr -e float -l '\''"0x0"'\'''
test-expr -e float -l '"0x0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x0"'\'''

echo '$ test-expr -e double -l '\''"0x0"'\'''
test-expr -e double -l '"0x0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x0"'\'''

echo '$ test-expr -e ldouble -l '\''"0x0"'\'''
test-expr -e ldouble -l '"0x0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x0"'\'''

echo '$ test-expr -e float -l '\''"0x1e2"'\'''
test-expr -e float -l '"0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x1e2"'\'''

echo '$ test-expr -e double -l '\''"0x1e2"'\'''
test-expr -e double -l '"0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"0x1e2"'\'''
test-expr -e ldouble -l '"0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x1e2"'\'''

echo '$ test-expr -e float -l '\''"0x1E2"'\'''
test-expr -e float -l '"0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x1E2"'\'''

echo '$ test-expr -e double -l '\''"0x1E2"'\'''
test-expr -e double -l '"0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"0x1E2"'\'''
test-expr -e ldouble -l '"0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x1E2"'\'''

echo '$ test-expr -e float -l '\''"0x1p2"'\'''
test-expr -e float -l '"0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x1p2"'\'''

echo '$ test-expr -e double -l '\''"0x1p2"'\'''
test-expr -e double -l '"0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"0x1p2"'\'''
test-expr -e ldouble -l '"0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x1p2"'\'''

echo '$ test-expr -e float -l '\''"0x1P2"'\'''
test-expr -e float -l '"0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0x1P2"'\'''

echo '$ test-expr -e double -l '\''"0x1P2"'\'''
test-expr -e double -l '"0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0x1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"0x1P2"'\'''
test-expr -e ldouble -l '"0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0x1P2"'\'''

echo '$ test-expr -e float -l '\''"0X"'\'''
test-expr -e float -l '"0X"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X"'\'''

echo '$ test-expr -e double -l '\''"0X"'\'''
test-expr -e double -l '"0X"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X"'\'''

echo '$ test-expr -e ldouble -l '\''"0X"'\'''
test-expr -e ldouble -l '"0X"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X"'\'''

echo '$ test-expr -e float -l '\''"0X0"'\'''
test-expr -e float -l '"0X0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X0"'\'''

echo '$ test-expr -e double -l '\''"0X0"'\'''
test-expr -e double -l '"0X0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X0"'\'''

echo '$ test-expr -e ldouble -l '\''"0X0"'\'''
test-expr -e ldouble -l '"0X0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X0"'\'''

echo '$ test-expr -e float -l '\''"0X1e2"'\'''
test-expr -e float -l '"0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X1e2"'\'''

echo '$ test-expr -e double -l '\''"0X1e2"'\'''
test-expr -e double -l '"0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"0X1e2"'\'''
test-expr -e ldouble -l '"0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X1e2"'\'''

echo '$ test-expr -e float -l '\''"0X1E2"'\'''
test-expr -e float -l '"0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X1E2"'\'''

echo '$ test-expr -e double -l '\''"0X1E2"'\'''
test-expr -e double -l '"0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"0X1E2"'\'''
test-expr -e ldouble -l '"0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X1E2"'\'''

echo '$ test-expr -e float -l '\''"0X1p2"'\'''
test-expr -e float -l '"0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X1p2"'\'''

echo '$ test-expr -e double -l '\''"0X1p2"'\'''
test-expr -e double -l '"0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"0X1p2"'\'''
test-expr -e ldouble -l '"0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X1p2"'\'''

echo '$ test-expr -e float -l '\''"0X1P2"'\'''
test-expr -e float -l '"0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0X1P2"'\'''

echo '$ test-expr -e double -l '\''"0X1P2"'\'''
test-expr -e double -l '"0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0X1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"0X1P2"'\'''
test-expr -e ldouble -l '"0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0X1P2"'\'''

echo '$ test-expr -e float -l '\''"0"'\'''
test-expr -e float -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"0"'\'''

echo '$ test-expr -e double -l '\''"0"'\'''
test-expr -e double -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"0"'\'''

echo '$ test-expr -e ldouble -l '\''"0"'\'''
test-expr -e ldouble -l '"0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"0"'\'''

echo '$ test-expr -e float -l '\''"00"'\'''
test-expr -e float -l '"00"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"00"'\'''

echo '$ test-expr -e double -l '\''"00"'\'''
test-expr -e double -l '"00"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"00"'\'''

echo '$ test-expr -e ldouble -l '\''"00"'\'''
test-expr -e ldouble -l '"00"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"00"'\'''

echo '$ test-expr -e float -l '\''"01e2"'\'''
test-expr -e float -l '"01e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"01e2"'\'''

echo '$ test-expr -e double -l '\''"01e2"'\'''
test-expr -e double -l '"01e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"01e2"'\'''

echo '$ test-expr -e ldouble -l '\''"01e2"'\'''
test-expr -e ldouble -l '"01e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"01e2"'\'''

echo '$ test-expr -e float -l '\''"01E2"'\'''
test-expr -e float -l '"01E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"01E2"'\'''

echo '$ test-expr -e double -l '\''"01E2"'\'''
test-expr -e double -l '"01E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"01E2"'\'''

echo '$ test-expr -e ldouble -l '\''"01E2"'\'''
test-expr -e ldouble -l '"01E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"01E2"'\'''

echo '$ test-expr -e float -l '\''"01p2"'\'''
test-expr -e float -l '"01p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"01p2"'\'''

echo '$ test-expr -e double -l '\''"01p2"'\'''
test-expr -e double -l '"01p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"01p2"'\'''

echo '$ test-expr -e ldouble -l '\''"01p2"'\'''
test-expr -e ldouble -l '"01p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"01p2"'\'''

echo '$ test-expr -e float -l '\''"01P2"'\'''
test-expr -e float -l '"01P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"01P2"'\'''

echo '$ test-expr -e double -l '\''"01P2"'\'''
test-expr -e double -l '"01P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"01P2"'\'''

echo '$ test-expr -e ldouble -l '\''"01P2"'\'''
test-expr -e ldouble -l '"01P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"01P2"'\'''

echo '$ test-expr -e float -l '\''"1"'\'''
test-expr -e float -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"1"'\'''

echo '$ test-expr -e double -l '\''"1"'\'''
test-expr -e double -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"1"'\'''

echo '$ test-expr -e ldouble -l '\''"1"'\'''
test-expr -e ldouble -l '"1"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"1"'\'''

echo '$ test-expr -e float -l '\''"10"'\'''
test-expr -e float -l '"10"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"10"'\'''

echo '$ test-expr -e double -l '\''"10"'\'''
test-expr -e double -l '"10"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"10"'\'''

echo '$ test-expr -e ldouble -l '\''"10"'\'''
test-expr -e ldouble -l '"10"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"10"'\'''

echo '$ test-expr -e float -l '\''"11e2"'\'''
test-expr -e float -l '"11e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"11e2"'\'''

echo '$ test-expr -e double -l '\''"11e2"'\'''
test-expr -e double -l '"11e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"11e2"'\'''

echo '$ test-expr -e ldouble -l '\''"11e2"'\'''
test-expr -e ldouble -l '"11e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"11e2"'\'''

echo '$ test-expr -e float -l '\''"11E2"'\'''
test-expr -e float -l '"11E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"11E2"'\'''

echo '$ test-expr -e double -l '\''"11E2"'\'''
test-expr -e double -l '"11E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"11E2"'\'''

echo '$ test-expr -e ldouble -l '\''"11E2"'\'''
test-expr -e ldouble -l '"11E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"11E2"'\'''

echo '$ test-expr -e float -l '\''"11p2"'\'''
test-expr -e float -l '"11p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"11p2"'\'''

echo '$ test-expr -e double -l '\''"11p2"'\'''
test-expr -e double -l '"11p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"11p2"'\'''

echo '$ test-expr -e ldouble -l '\''"11p2"'\'''
test-expr -e ldouble -l '"11p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"11p2"'\'''

echo '$ test-expr -e float -l '\''"11P2"'\'''
test-expr -e float -l '"11P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"11P2"'\'''

echo '$ test-expr -e double -l '\''"11P2"'\'''
test-expr -e double -l '"11P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"11P2"'\'''

echo '$ test-expr -e ldouble -l '\''"11P2"'\'''
test-expr -e ldouble -l '"11P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"11P2"'\'''

echo '$ test-expr -e float -l '\''"2"'\'''
test-expr -e float -l '"2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"2"'\'''

echo '$ test-expr -e double -l '\''"2"'\'''
test-expr -e double -l '"2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"2"'\'''

echo '$ test-expr -e ldouble -l '\''"2"'\'''
test-expr -e ldouble -l '"2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"2"'\'''

echo '$ test-expr -e float -l '\''"20"'\'''
test-expr -e float -l '"20"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"20"'\'''

echo '$ test-expr -e double -l '\''"20"'\'''
test-expr -e double -l '"20"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"20"'\'''

echo '$ test-expr -e ldouble -l '\''"20"'\'''
test-expr -e ldouble -l '"20"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"20"'\'''

echo '$ test-expr -e float -l '\''"21e2"'\'''
test-expr -e float -l '"21e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"21e2"'\'''

echo '$ test-expr -e double -l '\''"21e2"'\'''
test-expr -e double -l '"21e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"21e2"'\'''

echo '$ test-expr -e ldouble -l '\''"21e2"'\'''
test-expr -e ldouble -l '"21e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"21e2"'\'''

echo '$ test-expr -e float -l '\''"21E2"'\'''
test-expr -e float -l '"21E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"21E2"'\'''

echo '$ test-expr -e double -l '\''"21E2"'\'''
test-expr -e double -l '"21E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"21E2"'\'''

echo '$ test-expr -e ldouble -l '\''"21E2"'\'''
test-expr -e ldouble -l '"21E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"21E2"'\'''

echo '$ test-expr -e float -l '\''"21p2"'\'''
test-expr -e float -l '"21p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"21p2"'\'''

echo '$ test-expr -e double -l '\''"21p2"'\'''
test-expr -e double -l '"21p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"21p2"'\'''

echo '$ test-expr -e ldouble -l '\''"21p2"'\'''
test-expr -e ldouble -l '"21p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"21p2"'\'''

echo '$ test-expr -e float -l '\''"21P2"'\'''
test-expr -e float -l '"21P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"21P2"'\'''

echo '$ test-expr -e double -l '\''"21P2"'\'''
test-expr -e double -l '"21P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"21P2"'\'''

echo '$ test-expr -e ldouble -l '\''"21P2"'\'''
test-expr -e ldouble -l '"21P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"21P2"'\'''

echo '$ test-expr -e float -l '\''"3"'\'''
test-expr -e float -l '"3"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"3"'\'''

echo '$ test-expr -e double -l '\''"3"'\'''
test-expr -e double -l '"3"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"3"'\'''

echo '$ test-expr -e ldouble -l '\''"3"'\'''
test-expr -e ldouble -l '"3"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"3"'\'''

echo '$ test-expr -e float -l '\''"30"'\'''
test-expr -e float -l '"30"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"30"'\'''

echo '$ test-expr -e double -l '\''"30"'\'''
test-expr -e double -l '"30"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"30"'\'''

echo '$ test-expr -e ldouble -l '\''"30"'\'''
test-expr -e ldouble -l '"30"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"30"'\'''

echo '$ test-expr -e float -l '\''"31e2"'\'''
test-expr -e float -l '"31e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"31e2"'\'''

echo '$ test-expr -e double -l '\''"31e2"'\'''
test-expr -e double -l '"31e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"31e2"'\'''

echo '$ test-expr -e ldouble -l '\''"31e2"'\'''
test-expr -e ldouble -l '"31e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"31e2"'\'''

echo '$ test-expr -e float -l '\''"31E2"'\'''
test-expr -e float -l '"31E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"31E2"'\'''

echo '$ test-expr -e double -l '\''"31E2"'\'''
test-expr -e double -l '"31E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"31E2"'\'''

echo '$ test-expr -e ldouble -l '\''"31E2"'\'''
test-expr -e ldouble -l '"31E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"31E2"'\'''

echo '$ test-expr -e float -l '\''"31p2"'\'''
test-expr -e float -l '"31p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"31p2"'\'''

echo '$ test-expr -e double -l '\''"31p2"'\'''
test-expr -e double -l '"31p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"31p2"'\'''

echo '$ test-expr -e ldouble -l '\''"31p2"'\'''
test-expr -e ldouble -l '"31p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"31p2"'\'''

echo '$ test-expr -e float -l '\''"31P2"'\'''
test-expr -e float -l '"31P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"31P2"'\'''

echo '$ test-expr -e double -l '\''"31P2"'\'''
test-expr -e double -l '"31P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"31P2"'\'''

echo '$ test-expr -e ldouble -l '\''"31P2"'\'''
test-expr -e ldouble -l '"31P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"31P2"'\'''

echo '$ test-expr -e float -l '\''"4"'\'''
test-expr -e float -l '"4"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"4"'\'''

echo '$ test-expr -e double -l '\''"4"'\'''
test-expr -e double -l '"4"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"4"'\'''

echo '$ test-expr -e ldouble -l '\''"4"'\'''
test-expr -e ldouble -l '"4"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"4"'\'''

echo '$ test-expr -e float -l '\''"40"'\'''
test-expr -e float -l '"40"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"40"'\'''

echo '$ test-expr -e double -l '\''"40"'\'''
test-expr -e double -l '"40"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"40"'\'''

echo '$ test-expr -e ldouble -l '\''"40"'\'''
test-expr -e ldouble -l '"40"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"40"'\'''

echo '$ test-expr -e float -l '\''"41e2"'\'''
test-expr -e float -l '"41e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"41e2"'\'''

echo '$ test-expr -e double -l '\''"41e2"'\'''
test-expr -e double -l '"41e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"41e2"'\'''

echo '$ test-expr -e ldouble -l '\''"41e2"'\'''
test-expr -e ldouble -l '"41e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"41e2"'\'''

echo '$ test-expr -e float -l '\''"41E2"'\'''
test-expr -e float -l '"41E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"41E2"'\'''

echo '$ test-expr -e double -l '\''"41E2"'\'''
test-expr -e double -l '"41E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"41E2"'\'''

echo '$ test-expr -e ldouble -l '\''"41E2"'\'''
test-expr -e ldouble -l '"41E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"41E2"'\'''

echo '$ test-expr -e float -l '\''"41p2"'\'''
test-expr -e float -l '"41p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"41p2"'\'''

echo '$ test-expr -e double -l '\''"41p2"'\'''
test-expr -e double -l '"41p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"41p2"'\'''

echo '$ test-expr -e ldouble -l '\''"41p2"'\'''
test-expr -e ldouble -l '"41p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"41p2"'\'''

echo '$ test-expr -e float -l '\''"41P2"'\'''
test-expr -e float -l '"41P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"41P2"'\'''

echo '$ test-expr -e double -l '\''"41P2"'\'''
test-expr -e double -l '"41P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"41P2"'\'''

echo '$ test-expr -e ldouble -l '\''"41P2"'\'''
test-expr -e ldouble -l '"41P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"41P2"'\'''

echo '$ test-expr -e float -l '\''"5"'\'''
test-expr -e float -l '"5"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"5"'\'''

echo '$ test-expr -e double -l '\''"5"'\'''
test-expr -e double -l '"5"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"5"'\'''

echo '$ test-expr -e ldouble -l '\''"5"'\'''
test-expr -e ldouble -l '"5"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"5"'\'''

echo '$ test-expr -e float -l '\''"50"'\'''
test-expr -e float -l '"50"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"50"'\'''

echo '$ test-expr -e double -l '\''"50"'\'''
test-expr -e double -l '"50"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"50"'\'''

echo '$ test-expr -e ldouble -l '\''"50"'\'''
test-expr -e ldouble -l '"50"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"50"'\'''

echo '$ test-expr -e float -l '\''"51e2"'\'''
test-expr -e float -l '"51e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"51e2"'\'''

echo '$ test-expr -e double -l '\''"51e2"'\'''
test-expr -e double -l '"51e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"51e2"'\'''

echo '$ test-expr -e ldouble -l '\''"51e2"'\'''
test-expr -e ldouble -l '"51e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"51e2"'\'''

echo '$ test-expr -e float -l '\''"51E2"'\'''
test-expr -e float -l '"51E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"51E2"'\'''

echo '$ test-expr -e double -l '\''"51E2"'\'''
test-expr -e double -l '"51E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"51E2"'\'''

echo '$ test-expr -e ldouble -l '\''"51E2"'\'''
test-expr -e ldouble -l '"51E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"51E2"'\'''

echo '$ test-expr -e float -l '\''"51p2"'\'''
test-expr -e float -l '"51p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"51p2"'\'''

echo '$ test-expr -e double -l '\''"51p2"'\'''
test-expr -e double -l '"51p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"51p2"'\'''

echo '$ test-expr -e ldouble -l '\''"51p2"'\'''
test-expr -e ldouble -l '"51p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"51p2"'\'''

echo '$ test-expr -e float -l '\''"51P2"'\'''
test-expr -e float -l '"51P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"51P2"'\'''

echo '$ test-expr -e double -l '\''"51P2"'\'''
test-expr -e double -l '"51P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"51P2"'\'''

echo '$ test-expr -e ldouble -l '\''"51P2"'\'''
test-expr -e ldouble -l '"51P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"51P2"'\'''

echo '$ test-expr -e float -l '\''"6"'\'''
test-expr -e float -l '"6"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"6"'\'''

echo '$ test-expr -e double -l '\''"6"'\'''
test-expr -e double -l '"6"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"6"'\'''

echo '$ test-expr -e ldouble -l '\''"6"'\'''
test-expr -e ldouble -l '"6"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"6"'\'''

echo '$ test-expr -e float -l '\''"60"'\'''
test-expr -e float -l '"60"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"60"'\'''

echo '$ test-expr -e double -l '\''"60"'\'''
test-expr -e double -l '"60"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"60"'\'''

echo '$ test-expr -e ldouble -l '\''"60"'\'''
test-expr -e ldouble -l '"60"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"60"'\'''

echo '$ test-expr -e float -l '\''"61e2"'\'''
test-expr -e float -l '"61e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"61e2"'\'''

echo '$ test-expr -e double -l '\''"61e2"'\'''
test-expr -e double -l '"61e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"61e2"'\'''

echo '$ test-expr -e ldouble -l '\''"61e2"'\'''
test-expr -e ldouble -l '"61e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"61e2"'\'''

echo '$ test-expr -e float -l '\''"61E2"'\'''
test-expr -e float -l '"61E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"61E2"'\'''

echo '$ test-expr -e double -l '\''"61E2"'\'''
test-expr -e double -l '"61E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"61E2"'\'''

echo '$ test-expr -e ldouble -l '\''"61E2"'\'''
test-expr -e ldouble -l '"61E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"61E2"'\'''

echo '$ test-expr -e float -l '\''"61p2"'\'''
test-expr -e float -l '"61p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"61p2"'\'''

echo '$ test-expr -e double -l '\''"61p2"'\'''
test-expr -e double -l '"61p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"61p2"'\'''

echo '$ test-expr -e ldouble -l '\''"61p2"'\'''
test-expr -e ldouble -l '"61p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"61p2"'\'''

echo '$ test-expr -e float -l '\''"61P2"'\'''
test-expr -e float -l '"61P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"61P2"'\'''

echo '$ test-expr -e double -l '\''"61P2"'\'''
test-expr -e double -l '"61P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"61P2"'\'''

echo '$ test-expr -e ldouble -l '\''"61P2"'\'''
test-expr -e ldouble -l '"61P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"61P2"'\'''

echo '$ test-expr -e float -l '\''"7"'\'''
test-expr -e float -l '"7"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"7"'\'''

echo '$ test-expr -e double -l '\''"7"'\'''
test-expr -e double -l '"7"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"7"'\'''

echo '$ test-expr -e ldouble -l '\''"7"'\'''
test-expr -e ldouble -l '"7"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"7"'\'''

echo '$ test-expr -e float -l '\''"70"'\'''
test-expr -e float -l '"70"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"70"'\'''

echo '$ test-expr -e double -l '\''"70"'\'''
test-expr -e double -l '"70"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"70"'\'''

echo '$ test-expr -e ldouble -l '\''"70"'\'''
test-expr -e ldouble -l '"70"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"70"'\'''

echo '$ test-expr -e float -l '\''"71e2"'\'''
test-expr -e float -l '"71e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"71e2"'\'''

echo '$ test-expr -e double -l '\''"71e2"'\'''
test-expr -e double -l '"71e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"71e2"'\'''

echo '$ test-expr -e ldouble -l '\''"71e2"'\'''
test-expr -e ldouble -l '"71e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"71e2"'\'''

echo '$ test-expr -e float -l '\''"71E2"'\'''
test-expr -e float -l '"71E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"71E2"'\'''

echo '$ test-expr -e double -l '\''"71E2"'\'''
test-expr -e double -l '"71E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"71E2"'\'''

echo '$ test-expr -e ldouble -l '\''"71E2"'\'''
test-expr -e ldouble -l '"71E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"71E2"'\'''

echo '$ test-expr -e float -l '\''"71p2"'\'''
test-expr -e float -l '"71p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"71p2"'\'''

echo '$ test-expr -e double -l '\''"71p2"'\'''
test-expr -e double -l '"71p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"71p2"'\'''

echo '$ test-expr -e ldouble -l '\''"71p2"'\'''
test-expr -e ldouble -l '"71p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"71p2"'\'''

echo '$ test-expr -e float -l '\''"71P2"'\'''
test-expr -e float -l '"71P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"71P2"'\'''

echo '$ test-expr -e double -l '\''"71P2"'\'''
test-expr -e double -l '"71P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"71P2"'\'''

echo '$ test-expr -e ldouble -l '\''"71P2"'\'''
test-expr -e ldouble -l '"71P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"71P2"'\'''

echo '$ test-expr -e float -l '\''"8"'\'''
test-expr -e float -l '"8"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"8"'\'''

echo '$ test-expr -e double -l '\''"8"'\'''
test-expr -e double -l '"8"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"8"'\'''

echo '$ test-expr -e ldouble -l '\''"8"'\'''
test-expr -e ldouble -l '"8"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"8"'\'''

echo '$ test-expr -e float -l '\''"80"'\'''
test-expr -e float -l '"80"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"80"'\'''

echo '$ test-expr -e double -l '\''"80"'\'''
test-expr -e double -l '"80"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"80"'\'''

echo '$ test-expr -e ldouble -l '\''"80"'\'''
test-expr -e ldouble -l '"80"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"80"'\'''

echo '$ test-expr -e float -l '\''"81e2"'\'''
test-expr -e float -l '"81e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"81e2"'\'''

echo '$ test-expr -e double -l '\''"81e2"'\'''
test-expr -e double -l '"81e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"81e2"'\'''

echo '$ test-expr -e ldouble -l '\''"81e2"'\'''
test-expr -e ldouble -l '"81e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"81e2"'\'''

echo '$ test-expr -e float -l '\''"81E2"'\'''
test-expr -e float -l '"81E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"81E2"'\'''

echo '$ test-expr -e double -l '\''"81E2"'\'''
test-expr -e double -l '"81E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"81E2"'\'''

echo '$ test-expr -e ldouble -l '\''"81E2"'\'''
test-expr -e ldouble -l '"81E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"81E2"'\'''

echo '$ test-expr -e float -l '\''"81p2"'\'''
test-expr -e float -l '"81p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"81p2"'\'''

echo '$ test-expr -e double -l '\''"81p2"'\'''
test-expr -e double -l '"81p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"81p2"'\'''

echo '$ test-expr -e ldouble -l '\''"81p2"'\'''
test-expr -e ldouble -l '"81p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"81p2"'\'''

echo '$ test-expr -e float -l '\''"81P2"'\'''
test-expr -e float -l '"81P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"81P2"'\'''

echo '$ test-expr -e double -l '\''"81P2"'\'''
test-expr -e double -l '"81P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"81P2"'\'''

echo '$ test-expr -e ldouble -l '\''"81P2"'\'''
test-expr -e ldouble -l '"81P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"81P2"'\'''

echo '$ test-expr -e float -l '\''"9"'\'''
test-expr -e float -l '"9"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"9"'\'''

echo '$ test-expr -e double -l '\''"9"'\'''
test-expr -e double -l '"9"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"9"'\'''

echo '$ test-expr -e ldouble -l '\''"9"'\'''
test-expr -e ldouble -l '"9"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"9"'\'''

echo '$ test-expr -e float -l '\''"90"'\'''
test-expr -e float -l '"90"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"90"'\'''

echo '$ test-expr -e double -l '\''"90"'\'''
test-expr -e double -l '"90"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"90"'\'''

echo '$ test-expr -e ldouble -l '\''"90"'\'''
test-expr -e ldouble -l '"90"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"90"'\'''

echo '$ test-expr -e float -l '\''"91e2"'\'''
test-expr -e float -l '"91e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"91e2"'\'''

echo '$ test-expr -e double -l '\''"91e2"'\'''
test-expr -e double -l '"91e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"91e2"'\'''

echo '$ test-expr -e ldouble -l '\''"91e2"'\'''
test-expr -e ldouble -l '"91e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"91e2"'\'''

echo '$ test-expr -e float -l '\''"91E2"'\'''
test-expr -e float -l '"91E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"91E2"'\'''

echo '$ test-expr -e double -l '\''"91E2"'\'''
test-expr -e double -l '"91E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"91E2"'\'''

echo '$ test-expr -e ldouble -l '\''"91E2"'\'''
test-expr -e ldouble -l '"91E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"91E2"'\'''

echo '$ test-expr -e float -l '\''"91p2"'\'''
test-expr -e float -l '"91p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"91p2"'\'''

echo '$ test-expr -e double -l '\''"91p2"'\'''
test-expr -e double -l '"91p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"91p2"'\'''

echo '$ test-expr -e ldouble -l '\''"91p2"'\'''
test-expr -e ldouble -l '"91p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"91p2"'\'''

echo '$ test-expr -e float -l '\''"91P2"'\'''
test-expr -e float -l '"91P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"91P2"'\'''

echo '$ test-expr -e double -l '\''"91P2"'\'''
test-expr -e double -l '"91P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"91P2"'\'''

echo '$ test-expr -e ldouble -l '\''"91P2"'\'''
test-expr -e ldouble -l '"91P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"91P2"'\'''

echo '$ test-expr -e float -l '\''"-."'\'''
test-expr -e float -l '"-."' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-."'\'''

echo '$ test-expr -e double -l '\''"-."'\'''
test-expr -e double -l '"-."' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-."'\'''

echo '$ test-expr -e ldouble -l '\''"-."'\'''
test-expr -e ldouble -l '"-."' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-."'\'''

echo '$ test-expr -e float -l '\''"-.0"'\'''
test-expr -e float -l '"-.0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-.0"'\'''

echo '$ test-expr -e double -l '\''"-.0"'\'''
test-expr -e double -l '"-.0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-.0"'\'''

echo '$ test-expr -e ldouble -l '\''"-.0"'\'''
test-expr -e ldouble -l '"-.0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-.0"'\'''

echo '$ test-expr -e float -l '\''"-.1e2"'\'''
test-expr -e float -l '"-.1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-.1e2"'\'''

echo '$ test-expr -e double -l '\''"-.1e2"'\'''
test-expr -e double -l '"-.1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-.1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-.1e2"'\'''
test-expr -e ldouble -l '"-.1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-.1e2"'\'''

echo '$ test-expr -e float -l '\''"-.1E2"'\'''
test-expr -e float -l '"-.1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-.1E2"'\'''

echo '$ test-expr -e double -l '\''"-.1E2"'\'''
test-expr -e double -l '"-.1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-.1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-.1E2"'\'''
test-expr -e ldouble -l '"-.1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-.1E2"'\'''

echo '$ test-expr -e float -l '\''"-.1p2"'\'''
test-expr -e float -l '"-.1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-.1p2"'\'''

echo '$ test-expr -e double -l '\''"-.1p2"'\'''
test-expr -e double -l '"-.1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-.1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-.1p2"'\'''
test-expr -e ldouble -l '"-.1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-.1p2"'\'''

echo '$ test-expr -e float -l '\''"-.1P2"'\'''
test-expr -e float -l '"-.1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-.1P2"'\'''

echo '$ test-expr -e double -l '\''"-.1P2"'\'''
test-expr -e double -l '"-.1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-.1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-.1P2"'\'''
test-expr -e ldouble -l '"-.1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-.1P2"'\'''

echo '$ test-expr -e float -l '\''"-0x"'\'''
test-expr -e float -l '"-0x"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x"'\'''

echo '$ test-expr -e double -l '\''"-0x"'\'''
test-expr -e double -l '"-0x"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x"'\'''
test-expr -e ldouble -l '"-0x"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x"'\'''

echo '$ test-expr -e float -l '\''"-0x0"'\'''
test-expr -e float -l '"-0x0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x0"'\'''

echo '$ test-expr -e double -l '\''"-0x0"'\'''
test-expr -e double -l '"-0x0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x0"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x0"'\'''
test-expr -e ldouble -l '"-0x0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x0"'\'''

echo '$ test-expr -e float -l '\''"-0x1e2"'\'''
test-expr -e float -l '"-0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x1e2"'\'''

echo '$ test-expr -e double -l '\''"-0x1e2"'\'''
test-expr -e double -l '"-0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x1e2"'\'''
test-expr -e ldouble -l '"-0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x1e2"'\'''

echo '$ test-expr -e float -l '\''"-0x1E2"'\'''
test-expr -e float -l '"-0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x1E2"'\'''

echo '$ test-expr -e double -l '\''"-0x1E2"'\'''
test-expr -e double -l '"-0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x1E2"'\'''
test-expr -e ldouble -l '"-0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x1E2"'\'''

echo '$ test-expr -e float -l '\''"-0x1p2"'\'''
test-expr -e float -l '"-0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x1p2"'\'''

echo '$ test-expr -e double -l '\''"-0x1p2"'\'''
test-expr -e double -l '"-0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x1p2"'\'''
test-expr -e ldouble -l '"-0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x1p2"'\'''

echo '$ test-expr -e float -l '\''"-0x1P2"'\'''
test-expr -e float -l '"-0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0x1P2"'\'''

echo '$ test-expr -e double -l '\''"-0x1P2"'\'''
test-expr -e double -l '"-0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0x1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0x1P2"'\'''
test-expr -e ldouble -l '"-0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0x1P2"'\'''

echo '$ test-expr -e float -l '\''"-0X"'\'''
test-expr -e float -l '"-0X"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X"'\'''

echo '$ test-expr -e double -l '\''"-0X"'\'''
test-expr -e double -l '"-0X"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X"'\'''
test-expr -e ldouble -l '"-0X"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X"'\'''

echo '$ test-expr -e float -l '\''"-0X0"'\'''
test-expr -e float -l '"-0X0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X0"'\'''

echo '$ test-expr -e double -l '\''"-0X0"'\'''
test-expr -e double -l '"-0X0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X0"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X0"'\'''
test-expr -e ldouble -l '"-0X0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X0"'\'''

echo '$ test-expr -e float -l '\''"-0X1e2"'\'''
test-expr -e float -l '"-0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X1e2"'\'''

echo '$ test-expr -e double -l '\''"-0X1e2"'\'''
test-expr -e double -l '"-0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X1e2"'\'''
test-expr -e ldouble -l '"-0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X1e2"'\'''

echo '$ test-expr -e float -l '\''"-0X1E2"'\'''
test-expr -e float -l '"-0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X1E2"'\'''

echo '$ test-expr -e double -l '\''"-0X1E2"'\'''
test-expr -e double -l '"-0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X1E2"'\'''
test-expr -e ldouble -l '"-0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X1E2"'\'''

echo '$ test-expr -e float -l '\''"-0X1p2"'\'''
test-expr -e float -l '"-0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X1p2"'\'''

echo '$ test-expr -e double -l '\''"-0X1p2"'\'''
test-expr -e double -l '"-0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X1p2"'\'''
test-expr -e ldouble -l '"-0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X1p2"'\'''

echo '$ test-expr -e float -l '\''"-0X1P2"'\'''
test-expr -e float -l '"-0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0X1P2"'\'''

echo '$ test-expr -e double -l '\''"-0X1P2"'\'''
test-expr -e double -l '"-0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0X1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-0X1P2"'\'''
test-expr -e ldouble -l '"-0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0X1P2"'\'''

echo '$ test-expr -e float -l '\''"-0"'\'''
test-expr -e float -l '"-0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-0"'\'''

echo '$ test-expr -e double -l '\''"-0"'\'''
test-expr -e double -l '"-0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-0"'\'''

echo '$ test-expr -e ldouble -l '\''"-0"'\'''
test-expr -e ldouble -l '"-0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-0"'\'''

echo '$ test-expr -e float -l '\''"-00"'\'''
test-expr -e float -l '"-00"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-00"'\'''

echo '$ test-expr -e double -l '\''"-00"'\'''
test-expr -e double -l '"-00"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-00"'\'''

echo '$ test-expr -e ldouble -l '\''"-00"'\'''
test-expr -e ldouble -l '"-00"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-00"'\'''

echo '$ test-expr -e float -l '\''"-01e2"'\'''
test-expr -e float -l '"-01e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-01e2"'\'''

echo '$ test-expr -e double -l '\''"-01e2"'\'''
test-expr -e double -l '"-01e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-01e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-01e2"'\'''
test-expr -e ldouble -l '"-01e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-01e2"'\'''

echo '$ test-expr -e float -l '\''"-01E2"'\'''
test-expr -e float -l '"-01E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-01E2"'\'''

echo '$ test-expr -e double -l '\''"-01E2"'\'''
test-expr -e double -l '"-01E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-01E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-01E2"'\'''
test-expr -e ldouble -l '"-01E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-01E2"'\'''

echo '$ test-expr -e float -l '\''"-01p2"'\'''
test-expr -e float -l '"-01p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-01p2"'\'''

echo '$ test-expr -e double -l '\''"-01p2"'\'''
test-expr -e double -l '"-01p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-01p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-01p2"'\'''
test-expr -e ldouble -l '"-01p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-01p2"'\'''

echo '$ test-expr -e float -l '\''"-01P2"'\'''
test-expr -e float -l '"-01P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-01P2"'\'''

echo '$ test-expr -e double -l '\''"-01P2"'\'''
test-expr -e double -l '"-01P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-01P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-01P2"'\'''
test-expr -e ldouble -l '"-01P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-01P2"'\'''

echo '$ test-expr -e float -l '\''"-1"'\'''
test-expr -e float -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-1"'\'''

echo '$ test-expr -e double -l '\''"-1"'\'''
test-expr -e double -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-1"'\'''

echo '$ test-expr -e ldouble -l '\''"-1"'\'''
test-expr -e ldouble -l '"-1"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-1"'\'''

echo '$ test-expr -e float -l '\''"-10"'\'''
test-expr -e float -l '"-10"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-10"'\'''

echo '$ test-expr -e double -l '\''"-10"'\'''
test-expr -e double -l '"-10"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-10"'\'''

echo '$ test-expr -e ldouble -l '\''"-10"'\'''
test-expr -e ldouble -l '"-10"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-10"'\'''

echo '$ test-expr -e float -l '\''"-11e2"'\'''
test-expr -e float -l '"-11e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-11e2"'\'''

echo '$ test-expr -e double -l '\''"-11e2"'\'''
test-expr -e double -l '"-11e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-11e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-11e2"'\'''
test-expr -e ldouble -l '"-11e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-11e2"'\'''

echo '$ test-expr -e float -l '\''"-11E2"'\'''
test-expr -e float -l '"-11E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-11E2"'\'''

echo '$ test-expr -e double -l '\''"-11E2"'\'''
test-expr -e double -l '"-11E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-11E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-11E2"'\'''
test-expr -e ldouble -l '"-11E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-11E2"'\'''

echo '$ test-expr -e float -l '\''"-11p2"'\'''
test-expr -e float -l '"-11p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-11p2"'\'''

echo '$ test-expr -e double -l '\''"-11p2"'\'''
test-expr -e double -l '"-11p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-11p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-11p2"'\'''
test-expr -e ldouble -l '"-11p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-11p2"'\'''

echo '$ test-expr -e float -l '\''"-11P2"'\'''
test-expr -e float -l '"-11P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-11P2"'\'''

echo '$ test-expr -e double -l '\''"-11P2"'\'''
test-expr -e double -l '"-11P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-11P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-11P2"'\'''
test-expr -e ldouble -l '"-11P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-11P2"'\'''

echo '$ test-expr -e float -l '\''"-2"'\'''
test-expr -e float -l '"-2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-2"'\'''

echo '$ test-expr -e double -l '\''"-2"'\'''
test-expr -e double -l '"-2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-2"'\'''

echo '$ test-expr -e ldouble -l '\''"-2"'\'''
test-expr -e ldouble -l '"-2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-2"'\'''

echo '$ test-expr -e float -l '\''"-20"'\'''
test-expr -e float -l '"-20"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-20"'\'''

echo '$ test-expr -e double -l '\''"-20"'\'''
test-expr -e double -l '"-20"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-20"'\'''

echo '$ test-expr -e ldouble -l '\''"-20"'\'''
test-expr -e ldouble -l '"-20"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-20"'\'''

echo '$ test-expr -e float -l '\''"-21e2"'\'''
test-expr -e float -l '"-21e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-21e2"'\'''

echo '$ test-expr -e double -l '\''"-21e2"'\'''
test-expr -e double -l '"-21e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-21e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-21e2"'\'''
test-expr -e ldouble -l '"-21e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-21e2"'\'''

echo '$ test-expr -e float -l '\''"-21E2"'\'''
test-expr -e float -l '"-21E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-21E2"'\'''

echo '$ test-expr -e double -l '\''"-21E2"'\'''
test-expr -e double -l '"-21E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-21E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-21E2"'\'''
test-expr -e ldouble -l '"-21E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-21E2"'\'''

echo '$ test-expr -e float -l '\''"-21p2"'\'''
test-expr -e float -l '"-21p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-21p2"'\'''

echo '$ test-expr -e double -l '\''"-21p2"'\'''
test-expr -e double -l '"-21p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-21p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-21p2"'\'''
test-expr -e ldouble -l '"-21p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-21p2"'\'''

echo '$ test-expr -e float -l '\''"-21P2"'\'''
test-expr -e float -l '"-21P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-21P2"'\'''

echo '$ test-expr -e double -l '\''"-21P2"'\'''
test-expr -e double -l '"-21P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-21P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-21P2"'\'''
test-expr -e ldouble -l '"-21P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-21P2"'\'''

echo '$ test-expr -e float -l '\''"-3"'\'''
test-expr -e float -l '"-3"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-3"'\'''

echo '$ test-expr -e double -l '\''"-3"'\'''
test-expr -e double -l '"-3"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-3"'\'''

echo '$ test-expr -e ldouble -l '\''"-3"'\'''
test-expr -e ldouble -l '"-3"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-3"'\'''

echo '$ test-expr -e float -l '\''"-30"'\'''
test-expr -e float -l '"-30"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-30"'\'''

echo '$ test-expr -e double -l '\''"-30"'\'''
test-expr -e double -l '"-30"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-30"'\'''

echo '$ test-expr -e ldouble -l '\''"-30"'\'''
test-expr -e ldouble -l '"-30"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-30"'\'''

echo '$ test-expr -e float -l '\''"-31e2"'\'''
test-expr -e float -l '"-31e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-31e2"'\'''

echo '$ test-expr -e double -l '\''"-31e2"'\'''
test-expr -e double -l '"-31e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-31e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-31e2"'\'''
test-expr -e ldouble -l '"-31e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-31e2"'\'''

echo '$ test-expr -e float -l '\''"-31E2"'\'''
test-expr -e float -l '"-31E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-31E2"'\'''

echo '$ test-expr -e double -l '\''"-31E2"'\'''
test-expr -e double -l '"-31E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-31E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-31E2"'\'''
test-expr -e ldouble -l '"-31E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-31E2"'\'''

echo '$ test-expr -e float -l '\''"-31p2"'\'''
test-expr -e float -l '"-31p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-31p2"'\'''

echo '$ test-expr -e double -l '\''"-31p2"'\'''
test-expr -e double -l '"-31p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-31p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-31p2"'\'''
test-expr -e ldouble -l '"-31p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-31p2"'\'''

echo '$ test-expr -e float -l '\''"-31P2"'\'''
test-expr -e float -l '"-31P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-31P2"'\'''

echo '$ test-expr -e double -l '\''"-31P2"'\'''
test-expr -e double -l '"-31P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-31P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-31P2"'\'''
test-expr -e ldouble -l '"-31P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-31P2"'\'''

echo '$ test-expr -e float -l '\''"-4"'\'''
test-expr -e float -l '"-4"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-4"'\'''

echo '$ test-expr -e double -l '\''"-4"'\'''
test-expr -e double -l '"-4"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-4"'\'''

echo '$ test-expr -e ldouble -l '\''"-4"'\'''
test-expr -e ldouble -l '"-4"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-4"'\'''

echo '$ test-expr -e float -l '\''"-40"'\'''
test-expr -e float -l '"-40"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-40"'\'''

echo '$ test-expr -e double -l '\''"-40"'\'''
test-expr -e double -l '"-40"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-40"'\'''

echo '$ test-expr -e ldouble -l '\''"-40"'\'''
test-expr -e ldouble -l '"-40"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-40"'\'''

echo '$ test-expr -e float -l '\''"-41e2"'\'''
test-expr -e float -l '"-41e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-41e2"'\'''

echo '$ test-expr -e double -l '\''"-41e2"'\'''
test-expr -e double -l '"-41e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-41e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-41e2"'\'''
test-expr -e ldouble -l '"-41e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-41e2"'\'''

echo '$ test-expr -e float -l '\''"-41E2"'\'''
test-expr -e float -l '"-41E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-41E2"'\'''

echo '$ test-expr -e double -l '\''"-41E2"'\'''
test-expr -e double -l '"-41E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-41E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-41E2"'\'''
test-expr -e ldouble -l '"-41E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-41E2"'\'''

echo '$ test-expr -e float -l '\''"-41p2"'\'''
test-expr -e float -l '"-41p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-41p2"'\'''

echo '$ test-expr -e double -l '\''"-41p2"'\'''
test-expr -e double -l '"-41p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-41p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-41p2"'\'''
test-expr -e ldouble -l '"-41p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-41p2"'\'''

echo '$ test-expr -e float -l '\''"-41P2"'\'''
test-expr -e float -l '"-41P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-41P2"'\'''

echo '$ test-expr -e double -l '\''"-41P2"'\'''
test-expr -e double -l '"-41P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-41P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-41P2"'\'''
test-expr -e ldouble -l '"-41P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-41P2"'\'''

echo '$ test-expr -e float -l '\''"-5"'\'''
test-expr -e float -l '"-5"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-5"'\'''

echo '$ test-expr -e double -l '\''"-5"'\'''
test-expr -e double -l '"-5"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-5"'\'''

echo '$ test-expr -e ldouble -l '\''"-5"'\'''
test-expr -e ldouble -l '"-5"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-5"'\'''

echo '$ test-expr -e float -l '\''"-50"'\'''
test-expr -e float -l '"-50"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-50"'\'''

echo '$ test-expr -e double -l '\''"-50"'\'''
test-expr -e double -l '"-50"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-50"'\'''

echo '$ test-expr -e ldouble -l '\''"-50"'\'''
test-expr -e ldouble -l '"-50"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-50"'\'''

echo '$ test-expr -e float -l '\''"-51e2"'\'''
test-expr -e float -l '"-51e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-51e2"'\'''

echo '$ test-expr -e double -l '\''"-51e2"'\'''
test-expr -e double -l '"-51e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-51e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-51e2"'\'''
test-expr -e ldouble -l '"-51e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-51e2"'\'''

echo '$ test-expr -e float -l '\''"-51E2"'\'''
test-expr -e float -l '"-51E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-51E2"'\'''

echo '$ test-expr -e double -l '\''"-51E2"'\'''
test-expr -e double -l '"-51E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-51E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-51E2"'\'''
test-expr -e ldouble -l '"-51E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-51E2"'\'''

echo '$ test-expr -e float -l '\''"-51p2"'\'''
test-expr -e float -l '"-51p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-51p2"'\'''

echo '$ test-expr -e double -l '\''"-51p2"'\'''
test-expr -e double -l '"-51p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-51p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-51p2"'\'''
test-expr -e ldouble -l '"-51p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-51p2"'\'''

echo '$ test-expr -e float -l '\''"-51P2"'\'''
test-expr -e float -l '"-51P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-51P2"'\'''

echo '$ test-expr -e double -l '\''"-51P2"'\'''
test-expr -e double -l '"-51P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-51P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-51P2"'\'''
test-expr -e ldouble -l '"-51P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-51P2"'\'''

echo '$ test-expr -e float -l '\''"-6"'\'''
test-expr -e float -l '"-6"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-6"'\'''

echo '$ test-expr -e double -l '\''"-6"'\'''
test-expr -e double -l '"-6"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-6"'\'''

echo '$ test-expr -e ldouble -l '\''"-6"'\'''
test-expr -e ldouble -l '"-6"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-6"'\'''

echo '$ test-expr -e float -l '\''"-60"'\'''
test-expr -e float -l '"-60"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-60"'\'''

echo '$ test-expr -e double -l '\''"-60"'\'''
test-expr -e double -l '"-60"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-60"'\'''

echo '$ test-expr -e ldouble -l '\''"-60"'\'''
test-expr -e ldouble -l '"-60"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-60"'\'''

echo '$ test-expr -e float -l '\''"-61e2"'\'''
test-expr -e float -l '"-61e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-61e2"'\'''

echo '$ test-expr -e double -l '\''"-61e2"'\'''
test-expr -e double -l '"-61e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-61e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-61e2"'\'''
test-expr -e ldouble -l '"-61e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-61e2"'\'''

echo '$ test-expr -e float -l '\''"-61E2"'\'''
test-expr -e float -l '"-61E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-61E2"'\'''

echo '$ test-expr -e double -l '\''"-61E2"'\'''
test-expr -e double -l '"-61E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-61E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-61E2"'\'''
test-expr -e ldouble -l '"-61E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-61E2"'\'''

echo '$ test-expr -e float -l '\''"-61p2"'\'''
test-expr -e float -l '"-61p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-61p2"'\'''

echo '$ test-expr -e double -l '\''"-61p2"'\'''
test-expr -e double -l '"-61p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-61p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-61p2"'\'''
test-expr -e ldouble -l '"-61p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-61p2"'\'''

echo '$ test-expr -e float -l '\''"-61P2"'\'''
test-expr -e float -l '"-61P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-61P2"'\'''

echo '$ test-expr -e double -l '\''"-61P2"'\'''
test-expr -e double -l '"-61P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-61P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-61P2"'\'''
test-expr -e ldouble -l '"-61P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-61P2"'\'''

echo '$ test-expr -e float -l '\''"-7"'\'''
test-expr -e float -l '"-7"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-7"'\'''

echo '$ test-expr -e double -l '\''"-7"'\'''
test-expr -e double -l '"-7"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-7"'\'''

echo '$ test-expr -e ldouble -l '\''"-7"'\'''
test-expr -e ldouble -l '"-7"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-7"'\'''

echo '$ test-expr -e float -l '\''"-70"'\'''
test-expr -e float -l '"-70"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-70"'\'''

echo '$ test-expr -e double -l '\''"-70"'\'''
test-expr -e double -l '"-70"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-70"'\'''

echo '$ test-expr -e ldouble -l '\''"-70"'\'''
test-expr -e ldouble -l '"-70"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-70"'\'''

echo '$ test-expr -e float -l '\''"-71e2"'\'''
test-expr -e float -l '"-71e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-71e2"'\'''

echo '$ test-expr -e double -l '\''"-71e2"'\'''
test-expr -e double -l '"-71e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-71e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-71e2"'\'''
test-expr -e ldouble -l '"-71e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-71e2"'\'''

echo '$ test-expr -e float -l '\''"-71E2"'\'''
test-expr -e float -l '"-71E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-71E2"'\'''

echo '$ test-expr -e double -l '\''"-71E2"'\'''
test-expr -e double -l '"-71E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-71E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-71E2"'\'''
test-expr -e ldouble -l '"-71E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-71E2"'\'''

echo '$ test-expr -e float -l '\''"-71p2"'\'''
test-expr -e float -l '"-71p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-71p2"'\'''

echo '$ test-expr -e double -l '\''"-71p2"'\'''
test-expr -e double -l '"-71p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-71p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-71p2"'\'''
test-expr -e ldouble -l '"-71p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-71p2"'\'''

echo '$ test-expr -e float -l '\''"-71P2"'\'''
test-expr -e float -l '"-71P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-71P2"'\'''

echo '$ test-expr -e double -l '\''"-71P2"'\'''
test-expr -e double -l '"-71P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-71P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-71P2"'\'''
test-expr -e ldouble -l '"-71P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-71P2"'\'''

echo '$ test-expr -e float -l '\''"-8"'\'''
test-expr -e float -l '"-8"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-8"'\'''

echo '$ test-expr -e double -l '\''"-8"'\'''
test-expr -e double -l '"-8"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-8"'\'''

echo '$ test-expr -e ldouble -l '\''"-8"'\'''
test-expr -e ldouble -l '"-8"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-8"'\'''

echo '$ test-expr -e float -l '\''"-80"'\'''
test-expr -e float -l '"-80"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-80"'\'''

echo '$ test-expr -e double -l '\''"-80"'\'''
test-expr -e double -l '"-80"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-80"'\'''

echo '$ test-expr -e ldouble -l '\''"-80"'\'''
test-expr -e ldouble -l '"-80"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-80"'\'''

echo '$ test-expr -e float -l '\''"-81e2"'\'''
test-expr -e float -l '"-81e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-81e2"'\'''

echo '$ test-expr -e double -l '\''"-81e2"'\'''
test-expr -e double -l '"-81e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-81e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-81e2"'\'''
test-expr -e ldouble -l '"-81e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-81e2"'\'''

echo '$ test-expr -e float -l '\''"-81E2"'\'''
test-expr -e float -l '"-81E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-81E2"'\'''

echo '$ test-expr -e double -l '\''"-81E2"'\'''
test-expr -e double -l '"-81E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-81E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-81E2"'\'''
test-expr -e ldouble -l '"-81E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-81E2"'\'''

echo '$ test-expr -e float -l '\''"-81p2"'\'''
test-expr -e float -l '"-81p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-81p2"'\'''

echo '$ test-expr -e double -l '\''"-81p2"'\'''
test-expr -e double -l '"-81p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-81p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-81p2"'\'''
test-expr -e ldouble -l '"-81p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-81p2"'\'''

echo '$ test-expr -e float -l '\''"-81P2"'\'''
test-expr -e float -l '"-81P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-81P2"'\'''

echo '$ test-expr -e double -l '\''"-81P2"'\'''
test-expr -e double -l '"-81P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-81P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-81P2"'\'''
test-expr -e ldouble -l '"-81P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-81P2"'\'''

echo '$ test-expr -e float -l '\''"-9"'\'''
test-expr -e float -l '"-9"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-9"'\'''

echo '$ test-expr -e double -l '\''"-9"'\'''
test-expr -e double -l '"-9"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-9"'\'''

echo '$ test-expr -e ldouble -l '\''"-9"'\'''
test-expr -e ldouble -l '"-9"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-9"'\'''

echo '$ test-expr -e float -l '\''"-90"'\'''
test-expr -e float -l '"-90"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-90"'\'''

echo '$ test-expr -e double -l '\''"-90"'\'''
test-expr -e double -l '"-90"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-90"'\'''

echo '$ test-expr -e ldouble -l '\''"-90"'\'''
test-expr -e ldouble -l '"-90"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-90"'\'''

echo '$ test-expr -e float -l '\''"-91e2"'\'''
test-expr -e float -l '"-91e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-91e2"'\'''

echo '$ test-expr -e double -l '\''"-91e2"'\'''
test-expr -e double -l '"-91e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-91e2"'\'''

echo '$ test-expr -e ldouble -l '\''"-91e2"'\'''
test-expr -e ldouble -l '"-91e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-91e2"'\'''

echo '$ test-expr -e float -l '\''"-91E2"'\'''
test-expr -e float -l '"-91E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-91E2"'\'''

echo '$ test-expr -e double -l '\''"-91E2"'\'''
test-expr -e double -l '"-91E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-91E2"'\'''

echo '$ test-expr -e ldouble -l '\''"-91E2"'\'''
test-expr -e ldouble -l '"-91E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-91E2"'\'''

echo '$ test-expr -e float -l '\''"-91p2"'\'''
test-expr -e float -l '"-91p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-91p2"'\'''

echo '$ test-expr -e double -l '\''"-91p2"'\'''
test-expr -e double -l '"-91p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-91p2"'\'''

echo '$ test-expr -e ldouble -l '\''"-91p2"'\'''
test-expr -e ldouble -l '"-91p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-91p2"'\'''

echo '$ test-expr -e float -l '\''"-91P2"'\'''
test-expr -e float -l '"-91P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"-91P2"'\'''

echo '$ test-expr -e double -l '\''"-91P2"'\'''
test-expr -e double -l '"-91P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"-91P2"'\'''

echo '$ test-expr -e ldouble -l '\''"-91P2"'\'''
test-expr -e ldouble -l '"-91P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"-91P2"'\'''

echo '$ test-expr -e float -l '\''"+."'\'''
test-expr -e float -l '"+."' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+."'\'''

echo '$ test-expr -e double -l '\''"+."'\'''
test-expr -e double -l '"+."' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+."'\'''

echo '$ test-expr -e ldouble -l '\''"+."'\'''
test-expr -e ldouble -l '"+."' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+."'\'''

echo '$ test-expr -e float -l '\''"+.0"'\'''
test-expr -e float -l '"+.0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+.0"'\'''

echo '$ test-expr -e double -l '\''"+.0"'\'''
test-expr -e double -l '"+.0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+.0"'\'''

echo '$ test-expr -e ldouble -l '\''"+.0"'\'''
test-expr -e ldouble -l '"+.0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+.0"'\'''

echo '$ test-expr -e float -l '\''"+.1e2"'\'''
test-expr -e float -l '"+.1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+.1e2"'\'''

echo '$ test-expr -e double -l '\''"+.1e2"'\'''
test-expr -e double -l '"+.1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+.1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+.1e2"'\'''
test-expr -e ldouble -l '"+.1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+.1e2"'\'''

echo '$ test-expr -e float -l '\''"+.1E2"'\'''
test-expr -e float -l '"+.1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+.1E2"'\'''

echo '$ test-expr -e double -l '\''"+.1E2"'\'''
test-expr -e double -l '"+.1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+.1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+.1E2"'\'''
test-expr -e ldouble -l '"+.1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+.1E2"'\'''

echo '$ test-expr -e float -l '\''"+.1p2"'\'''
test-expr -e float -l '"+.1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+.1p2"'\'''

echo '$ test-expr -e double -l '\''"+.1p2"'\'''
test-expr -e double -l '"+.1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+.1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+.1p2"'\'''
test-expr -e ldouble -l '"+.1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+.1p2"'\'''

echo '$ test-expr -e float -l '\''"+.1P2"'\'''
test-expr -e float -l '"+.1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+.1P2"'\'''

echo '$ test-expr -e double -l '\''"+.1P2"'\'''
test-expr -e double -l '"+.1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+.1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+.1P2"'\'''
test-expr -e ldouble -l '"+.1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+.1P2"'\'''

echo '$ test-expr -e float -l '\''"+0x"'\'''
test-expr -e float -l '"+0x"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x"'\'''

echo '$ test-expr -e double -l '\''"+0x"'\'''
test-expr -e double -l '"+0x"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x"'\'''
test-expr -e ldouble -l '"+0x"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x"'\'''

echo '$ test-expr -e float -l '\''"+0x0"'\'''
test-expr -e float -l '"+0x0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x0"'\'''

echo '$ test-expr -e double -l '\''"+0x0"'\'''
test-expr -e double -l '"+0x0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x0"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x0"'\'''
test-expr -e ldouble -l '"+0x0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x0"'\'''

echo '$ test-expr -e float -l '\''"+0x1e2"'\'''
test-expr -e float -l '"+0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x1e2"'\'''

echo '$ test-expr -e double -l '\''"+0x1e2"'\'''
test-expr -e double -l '"+0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x1e2"'\'''
test-expr -e ldouble -l '"+0x1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x1e2"'\'''

echo '$ test-expr -e float -l '\''"+0x1E2"'\'''
test-expr -e float -l '"+0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x1E2"'\'''

echo '$ test-expr -e double -l '\''"+0x1E2"'\'''
test-expr -e double -l '"+0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x1E2"'\'''
test-expr -e ldouble -l '"+0x1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x1E2"'\'''

echo '$ test-expr -e float -l '\''"+0x1p2"'\'''
test-expr -e float -l '"+0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x1p2"'\'''

echo '$ test-expr -e double -l '\''"+0x1p2"'\'''
test-expr -e double -l '"+0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x1p2"'\'''
test-expr -e ldouble -l '"+0x1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x1p2"'\'''

echo '$ test-expr -e float -l '\''"+0x1P2"'\'''
test-expr -e float -l '"+0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0x1P2"'\'''

echo '$ test-expr -e double -l '\''"+0x1P2"'\'''
test-expr -e double -l '"+0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0x1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0x1P2"'\'''
test-expr -e ldouble -l '"+0x1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0x1P2"'\'''

echo '$ test-expr -e float -l '\''"+0X"'\'''
test-expr -e float -l '"+0X"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X"'\'''

echo '$ test-expr -e double -l '\''"+0X"'\'''
test-expr -e double -l '"+0X"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X"'\'''
test-expr -e ldouble -l '"+0X"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X"'\'''

echo '$ test-expr -e float -l '\''"+0X0"'\'''
test-expr -e float -l '"+0X0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X0"'\'''

echo '$ test-expr -e double -l '\''"+0X0"'\'''
test-expr -e double -l '"+0X0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X0"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X0"'\'''
test-expr -e ldouble -l '"+0X0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X0"'\'''

echo '$ test-expr -e float -l '\''"+0X1e2"'\'''
test-expr -e float -l '"+0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X1e2"'\'''

echo '$ test-expr -e double -l '\''"+0X1e2"'\'''
test-expr -e double -l '"+0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X1e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X1e2"'\'''
test-expr -e ldouble -l '"+0X1e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X1e2"'\'''

echo '$ test-expr -e float -l '\''"+0X1E2"'\'''
test-expr -e float -l '"+0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X1E2"'\'''

echo '$ test-expr -e double -l '\''"+0X1E2"'\'''
test-expr -e double -l '"+0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X1E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X1E2"'\'''
test-expr -e ldouble -l '"+0X1E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X1E2"'\'''

echo '$ test-expr -e float -l '\''"+0X1p2"'\'''
test-expr -e float -l '"+0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X1p2"'\'''

echo '$ test-expr -e double -l '\''"+0X1p2"'\'''
test-expr -e double -l '"+0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X1p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X1p2"'\'''
test-expr -e ldouble -l '"+0X1p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X1p2"'\'''

echo '$ test-expr -e float -l '\''"+0X1P2"'\'''
test-expr -e float -l '"+0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0X1P2"'\'''

echo '$ test-expr -e double -l '\''"+0X1P2"'\'''
test-expr -e double -l '"+0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0X1P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+0X1P2"'\'''
test-expr -e ldouble -l '"+0X1P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0X1P2"'\'''

echo '$ test-expr -e float -l '\''"+0"'\'''
test-expr -e float -l '"+0"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+0"'\'''

echo '$ test-expr -e double -l '\''"+0"'\'''
test-expr -e double -l '"+0"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+0"'\'''

echo '$ test-expr -e ldouble -l '\''"+0"'\'''
test-expr -e ldouble -l '"+0"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+0"'\'''

echo '$ test-expr -e float -l '\''"+00"'\'''
test-expr -e float -l '"+00"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+00"'\'''

echo '$ test-expr -e double -l '\''"+00"'\'''
test-expr -e double -l '"+00"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+00"'\'''

echo '$ test-expr -e ldouble -l '\''"+00"'\'''
test-expr -e ldouble -l '"+00"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+00"'\'''

echo '$ test-expr -e float -l '\''"+01e2"'\'''
test-expr -e float -l '"+01e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+01e2"'\'''

echo '$ test-expr -e double -l '\''"+01e2"'\'''
test-expr -e double -l '"+01e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+01e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+01e2"'\'''
test-expr -e ldouble -l '"+01e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+01e2"'\'''

echo '$ test-expr -e float -l '\''"+01E2"'\'''
test-expr -e float -l '"+01E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+01E2"'\'''

echo '$ test-expr -e double -l '\''"+01E2"'\'''
test-expr -e double -l '"+01E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+01E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+01E2"'\'''
test-expr -e ldouble -l '"+01E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+01E2"'\'''

echo '$ test-expr -e float -l '\''"+01p2"'\'''
test-expr -e float -l '"+01p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+01p2"'\'''

echo '$ test-expr -e double -l '\''"+01p2"'\'''
test-expr -e double -l '"+01p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+01p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+01p2"'\'''
test-expr -e ldouble -l '"+01p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+01p2"'\'''

echo '$ test-expr -e float -l '\''"+01P2"'\'''
test-expr -e float -l '"+01P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+01P2"'\'''

echo '$ test-expr -e double -l '\''"+01P2"'\'''
test-expr -e double -l '"+01P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+01P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+01P2"'\'''
test-expr -e ldouble -l '"+01P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+01P2"'\'''

echo '$ test-expr -e float -l '\''"+1"'\'''
test-expr -e float -l '"+1"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+1"'\'''

echo '$ test-expr -e double -l '\''"+1"'\'''
test-expr -e double -l '"+1"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+1"'\'''

echo '$ test-expr -e ldouble -l '\''"+1"'\'''
test-expr -e ldouble -l '"+1"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+1"'\'''

echo '$ test-expr -e float -l '\''"+10"'\'''
test-expr -e float -l '"+10"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+10"'\'''

echo '$ test-expr -e double -l '\''"+10"'\'''
test-expr -e double -l '"+10"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+10"'\'''

echo '$ test-expr -e ldouble -l '\''"+10"'\'''
test-expr -e ldouble -l '"+10"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+10"'\'''

echo '$ test-expr -e float -l '\''"+11e2"'\'''
test-expr -e float -l '"+11e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+11e2"'\'''

echo '$ test-expr -e double -l '\''"+11e2"'\'''
test-expr -e double -l '"+11e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+11e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+11e2"'\'''
test-expr -e ldouble -l '"+11e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+11e2"'\'''

echo '$ test-expr -e float -l '\''"+11E2"'\'''
test-expr -e float -l '"+11E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+11E2"'\'''

echo '$ test-expr -e double -l '\''"+11E2"'\'''
test-expr -e double -l '"+11E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+11E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+11E2"'\'''
test-expr -e ldouble -l '"+11E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+11E2"'\'''

echo '$ test-expr -e float -l '\''"+11p2"'\'''
test-expr -e float -l '"+11p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+11p2"'\'''

echo '$ test-expr -e double -l '\''"+11p2"'\'''
test-expr -e double -l '"+11p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+11p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+11p2"'\'''
test-expr -e ldouble -l '"+11p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+11p2"'\'''

echo '$ test-expr -e float -l '\''"+11P2"'\'''
test-expr -e float -l '"+11P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+11P2"'\'''

echo '$ test-expr -e double -l '\''"+11P2"'\'''
test-expr -e double -l '"+11P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+11P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+11P2"'\'''
test-expr -e ldouble -l '"+11P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+11P2"'\'''

echo '$ test-expr -e float -l '\''"+2"'\'''
test-expr -e float -l '"+2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+2"'\'''

echo '$ test-expr -e double -l '\''"+2"'\'''
test-expr -e double -l '"+2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+2"'\'''

echo '$ test-expr -e ldouble -l '\''"+2"'\'''
test-expr -e ldouble -l '"+2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+2"'\'''

echo '$ test-expr -e float -l '\''"+20"'\'''
test-expr -e float -l '"+20"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+20"'\'''

echo '$ test-expr -e double -l '\''"+20"'\'''
test-expr -e double -l '"+20"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+20"'\'''

echo '$ test-expr -e ldouble -l '\''"+20"'\'''
test-expr -e ldouble -l '"+20"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+20"'\'''

echo '$ test-expr -e float -l '\''"+21e2"'\'''
test-expr -e float -l '"+21e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+21e2"'\'''

echo '$ test-expr -e double -l '\''"+21e2"'\'''
test-expr -e double -l '"+21e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+21e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+21e2"'\'''
test-expr -e ldouble -l '"+21e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+21e2"'\'''

echo '$ test-expr -e float -l '\''"+21E2"'\'''
test-expr -e float -l '"+21E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+21E2"'\'''

echo '$ test-expr -e double -l '\''"+21E2"'\'''
test-expr -e double -l '"+21E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+21E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+21E2"'\'''
test-expr -e ldouble -l '"+21E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+21E2"'\'''

echo '$ test-expr -e float -l '\''"+21p2"'\'''
test-expr -e float -l '"+21p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+21p2"'\'''

echo '$ test-expr -e double -l '\''"+21p2"'\'''
test-expr -e double -l '"+21p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+21p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+21p2"'\'''
test-expr -e ldouble -l '"+21p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+21p2"'\'''

echo '$ test-expr -e float -l '\''"+21P2"'\'''
test-expr -e float -l '"+21P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+21P2"'\'''

echo '$ test-expr -e double -l '\''"+21P2"'\'''
test-expr -e double -l '"+21P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+21P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+21P2"'\'''
test-expr -e ldouble -l '"+21P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+21P2"'\'''

echo '$ test-expr -e float -l '\''"+3"'\'''
test-expr -e float -l '"+3"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+3"'\'''

echo '$ test-expr -e double -l '\''"+3"'\'''
test-expr -e double -l '"+3"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+3"'\'''

echo '$ test-expr -e ldouble -l '\''"+3"'\'''
test-expr -e ldouble -l '"+3"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+3"'\'''

echo '$ test-expr -e float -l '\''"+30"'\'''
test-expr -e float -l '"+30"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+30"'\'''

echo '$ test-expr -e double -l '\''"+30"'\'''
test-expr -e double -l '"+30"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+30"'\'''

echo '$ test-expr -e ldouble -l '\''"+30"'\'''
test-expr -e ldouble -l '"+30"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+30"'\'''

echo '$ test-expr -e float -l '\''"+31e2"'\'''
test-expr -e float -l '"+31e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+31e2"'\'''

echo '$ test-expr -e double -l '\''"+31e2"'\'''
test-expr -e double -l '"+31e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+31e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+31e2"'\'''
test-expr -e ldouble -l '"+31e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+31e2"'\'''

echo '$ test-expr -e float -l '\''"+31E2"'\'''
test-expr -e float -l '"+31E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+31E2"'\'''

echo '$ test-expr -e double -l '\''"+31E2"'\'''
test-expr -e double -l '"+31E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+31E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+31E2"'\'''
test-expr -e ldouble -l '"+31E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+31E2"'\'''

echo '$ test-expr -e float -l '\''"+31p2"'\'''
test-expr -e float -l '"+31p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+31p2"'\'''

echo '$ test-expr -e double -l '\''"+31p2"'\'''
test-expr -e double -l '"+31p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+31p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+31p2"'\'''
test-expr -e ldouble -l '"+31p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+31p2"'\'''

echo '$ test-expr -e float -l '\''"+31P2"'\'''
test-expr -e float -l '"+31P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+31P2"'\'''

echo '$ test-expr -e double -l '\''"+31P2"'\'''
test-expr -e double -l '"+31P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+31P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+31P2"'\'''
test-expr -e ldouble -l '"+31P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+31P2"'\'''

echo '$ test-expr -e float -l '\''"+4"'\'''
test-expr -e float -l '"+4"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+4"'\'''

echo '$ test-expr -e double -l '\''"+4"'\'''
test-expr -e double -l '"+4"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+4"'\'''

echo '$ test-expr -e ldouble -l '\''"+4"'\'''
test-expr -e ldouble -l '"+4"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+4"'\'''

echo '$ test-expr -e float -l '\''"+40"'\'''
test-expr -e float -l '"+40"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+40"'\'''

echo '$ test-expr -e double -l '\''"+40"'\'''
test-expr -e double -l '"+40"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+40"'\'''

echo '$ test-expr -e ldouble -l '\''"+40"'\'''
test-expr -e ldouble -l '"+40"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+40"'\'''

echo '$ test-expr -e float -l '\''"+41e2"'\'''
test-expr -e float -l '"+41e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+41e2"'\'''

echo '$ test-expr -e double -l '\''"+41e2"'\'''
test-expr -e double -l '"+41e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+41e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+41e2"'\'''
test-expr -e ldouble -l '"+41e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+41e2"'\'''

echo '$ test-expr -e float -l '\''"+41E2"'\'''
test-expr -e float -l '"+41E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+41E2"'\'''

echo '$ test-expr -e double -l '\''"+41E2"'\'''
test-expr -e double -l '"+41E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+41E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+41E2"'\'''
test-expr -e ldouble -l '"+41E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+41E2"'\'''

echo '$ test-expr -e float -l '\''"+41p2"'\'''
test-expr -e float -l '"+41p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+41p2"'\'''

echo '$ test-expr -e double -l '\''"+41p2"'\'''
test-expr -e double -l '"+41p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+41p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+41p2"'\'''
test-expr -e ldouble -l '"+41p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+41p2"'\'''

echo '$ test-expr -e float -l '\''"+41P2"'\'''
test-expr -e float -l '"+41P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+41P2"'\'''

echo '$ test-expr -e double -l '\''"+41P2"'\'''
test-expr -e double -l '"+41P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+41P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+41P2"'\'''
test-expr -e ldouble -l '"+41P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+41P2"'\'''

echo '$ test-expr -e float -l '\''"+5"'\'''
test-expr -e float -l '"+5"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+5"'\'''

echo '$ test-expr -e double -l '\''"+5"'\'''
test-expr -e double -l '"+5"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+5"'\'''

echo '$ test-expr -e ldouble -l '\''"+5"'\'''
test-expr -e ldouble -l '"+5"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+5"'\'''

echo '$ test-expr -e float -l '\''"+50"'\'''
test-expr -e float -l '"+50"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+50"'\'''

echo '$ test-expr -e double -l '\''"+50"'\'''
test-expr -e double -l '"+50"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+50"'\'''

echo '$ test-expr -e ldouble -l '\''"+50"'\'''
test-expr -e ldouble -l '"+50"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+50"'\'''

echo '$ test-expr -e float -l '\''"+51e2"'\'''
test-expr -e float -l '"+51e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+51e2"'\'''

echo '$ test-expr -e double -l '\''"+51e2"'\'''
test-expr -e double -l '"+51e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+51e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+51e2"'\'''
test-expr -e ldouble -l '"+51e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+51e2"'\'''

echo '$ test-expr -e float -l '\''"+51E2"'\'''
test-expr -e float -l '"+51E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+51E2"'\'''

echo '$ test-expr -e double -l '\''"+51E2"'\'''
test-expr -e double -l '"+51E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+51E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+51E2"'\'''
test-expr -e ldouble -l '"+51E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+51E2"'\'''

echo '$ test-expr -e float -l '\''"+51p2"'\'''
test-expr -e float -l '"+51p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+51p2"'\'''

echo '$ test-expr -e double -l '\''"+51p2"'\'''
test-expr -e double -l '"+51p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+51p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+51p2"'\'''
test-expr -e ldouble -l '"+51p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+51p2"'\'''

echo '$ test-expr -e float -l '\''"+51P2"'\'''
test-expr -e float -l '"+51P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+51P2"'\'''

echo '$ test-expr -e double -l '\''"+51P2"'\'''
test-expr -e double -l '"+51P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+51P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+51P2"'\'''
test-expr -e ldouble -l '"+51P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+51P2"'\'''

echo '$ test-expr -e float -l '\''"+6"'\'''
test-expr -e float -l '"+6"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+6"'\'''

echo '$ test-expr -e double -l '\''"+6"'\'''
test-expr -e double -l '"+6"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+6"'\'''

echo '$ test-expr -e ldouble -l '\''"+6"'\'''
test-expr -e ldouble -l '"+6"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+6"'\'''

echo '$ test-expr -e float -l '\''"+60"'\'''
test-expr -e float -l '"+60"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+60"'\'''

echo '$ test-expr -e double -l '\''"+60"'\'''
test-expr -e double -l '"+60"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+60"'\'''

echo '$ test-expr -e ldouble -l '\''"+60"'\'''
test-expr -e ldouble -l '"+60"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+60"'\'''

echo '$ test-expr -e float -l '\''"+61e2"'\'''
test-expr -e float -l '"+61e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+61e2"'\'''

echo '$ test-expr -e double -l '\''"+61e2"'\'''
test-expr -e double -l '"+61e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+61e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+61e2"'\'''
test-expr -e ldouble -l '"+61e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+61e2"'\'''

echo '$ test-expr -e float -l '\''"+61E2"'\'''
test-expr -e float -l '"+61E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+61E2"'\'''

echo '$ test-expr -e double -l '\''"+61E2"'\'''
test-expr -e double -l '"+61E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+61E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+61E2"'\'''
test-expr -e ldouble -l '"+61E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+61E2"'\'''

echo '$ test-expr -e float -l '\''"+61p2"'\'''
test-expr -e float -l '"+61p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+61p2"'\'''

echo '$ test-expr -e double -l '\''"+61p2"'\'''
test-expr -e double -l '"+61p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+61p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+61p2"'\'''
test-expr -e ldouble -l '"+61p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+61p2"'\'''

echo '$ test-expr -e float -l '\''"+61P2"'\'''
test-expr -e float -l '"+61P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+61P2"'\'''

echo '$ test-expr -e double -l '\''"+61P2"'\'''
test-expr -e double -l '"+61P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+61P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+61P2"'\'''
test-expr -e ldouble -l '"+61P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+61P2"'\'''

echo '$ test-expr -e float -l '\''"+7"'\'''
test-expr -e float -l '"+7"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+7"'\'''

echo '$ test-expr -e double -l '\''"+7"'\'''
test-expr -e double -l '"+7"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+7"'\'''

echo '$ test-expr -e ldouble -l '\''"+7"'\'''
test-expr -e ldouble -l '"+7"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+7"'\'''

echo '$ test-expr -e float -l '\''"+70"'\'''
test-expr -e float -l '"+70"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+70"'\'''

echo '$ test-expr -e double -l '\''"+70"'\'''
test-expr -e double -l '"+70"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+70"'\'''

echo '$ test-expr -e ldouble -l '\''"+70"'\'''
test-expr -e ldouble -l '"+70"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+70"'\'''

echo '$ test-expr -e float -l '\''"+71e2"'\'''
test-expr -e float -l '"+71e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+71e2"'\'''

echo '$ test-expr -e double -l '\''"+71e2"'\'''
test-expr -e double -l '"+71e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+71e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+71e2"'\'''
test-expr -e ldouble -l '"+71e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+71e2"'\'''

echo '$ test-expr -e float -l '\''"+71E2"'\'''
test-expr -e float -l '"+71E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+71E2"'\'''

echo '$ test-expr -e double -l '\''"+71E2"'\'''
test-expr -e double -l '"+71E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+71E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+71E2"'\'''
test-expr -e ldouble -l '"+71E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+71E2"'\'''

echo '$ test-expr -e float -l '\''"+71p2"'\'''
test-expr -e float -l '"+71p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+71p2"'\'''

echo '$ test-expr -e double -l '\''"+71p2"'\'''
test-expr -e double -l '"+71p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+71p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+71p2"'\'''
test-expr -e ldouble -l '"+71p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+71p2"'\'''

echo '$ test-expr -e float -l '\''"+71P2"'\'''
test-expr -e float -l '"+71P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+71P2"'\'''

echo '$ test-expr -e double -l '\''"+71P2"'\'''
test-expr -e double -l '"+71P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+71P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+71P2"'\'''
test-expr -e ldouble -l '"+71P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+71P2"'\'''

echo '$ test-expr -e float -l '\''"+8"'\'''
test-expr -e float -l '"+8"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+8"'\'''

echo '$ test-expr -e double -l '\''"+8"'\'''
test-expr -e double -l '"+8"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+8"'\'''

echo '$ test-expr -e ldouble -l '\''"+8"'\'''
test-expr -e ldouble -l '"+8"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+8"'\'''

echo '$ test-expr -e float -l '\''"+80"'\'''
test-expr -e float -l '"+80"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+80"'\'''

echo '$ test-expr -e double -l '\''"+80"'\'''
test-expr -e double -l '"+80"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+80"'\'''

echo '$ test-expr -e ldouble -l '\''"+80"'\'''
test-expr -e ldouble -l '"+80"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+80"'\'''

echo '$ test-expr -e float -l '\''"+81e2"'\'''
test-expr -e float -l '"+81e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+81e2"'\'''

echo '$ test-expr -e double -l '\''"+81e2"'\'''
test-expr -e double -l '"+81e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+81e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+81e2"'\'''
test-expr -e ldouble -l '"+81e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+81e2"'\'''

echo '$ test-expr -e float -l '\''"+81E2"'\'''
test-expr -e float -l '"+81E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+81E2"'\'''

echo '$ test-expr -e double -l '\''"+81E2"'\'''
test-expr -e double -l '"+81E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+81E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+81E2"'\'''
test-expr -e ldouble -l '"+81E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+81E2"'\'''

echo '$ test-expr -e float -l '\''"+81p2"'\'''
test-expr -e float -l '"+81p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+81p2"'\'''

echo '$ test-expr -e double -l '\''"+81p2"'\'''
test-expr -e double -l '"+81p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+81p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+81p2"'\'''
test-expr -e ldouble -l '"+81p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+81p2"'\'''

echo '$ test-expr -e float -l '\''"+81P2"'\'''
test-expr -e float -l '"+81P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+81P2"'\'''

echo '$ test-expr -e double -l '\''"+81P2"'\'''
test-expr -e double -l '"+81P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+81P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+81P2"'\'''
test-expr -e ldouble -l '"+81P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+81P2"'\'''

echo '$ test-expr -e float -l '\''"+9"'\'''
test-expr -e float -l '"+9"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+9"'\'''

echo '$ test-expr -e double -l '\''"+9"'\'''
test-expr -e double -l '"+9"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+9"'\'''

echo '$ test-expr -e ldouble -l '\''"+9"'\'''
test-expr -e ldouble -l '"+9"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+9"'\'''

echo '$ test-expr -e float -l '\''"+90"'\'''
test-expr -e float -l '"+90"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+90"'\'''

echo '$ test-expr -e double -l '\''"+90"'\'''
test-expr -e double -l '"+90"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+90"'\'''

echo '$ test-expr -e ldouble -l '\''"+90"'\'''
test-expr -e ldouble -l '"+90"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+90"'\'''

echo '$ test-expr -e float -l '\''"+91e2"'\'''
test-expr -e float -l '"+91e2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+91e2"'\'''

echo '$ test-expr -e double -l '\''"+91e2"'\'''
test-expr -e double -l '"+91e2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+91e2"'\'''

echo '$ test-expr -e ldouble -l '\''"+91e2"'\'''
test-expr -e ldouble -l '"+91e2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+91e2"'\'''

echo '$ test-expr -e float -l '\''"+91E2"'\'''
test-expr -e float -l '"+91E2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+91E2"'\'''

echo '$ test-expr -e double -l '\''"+91E2"'\'''
test-expr -e double -l '"+91E2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+91E2"'\'''

echo '$ test-expr -e ldouble -l '\''"+91E2"'\'''
test-expr -e ldouble -l '"+91E2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+91E2"'\'''

echo '$ test-expr -e float -l '\''"+91p2"'\'''
test-expr -e float -l '"+91p2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+91p2"'\'''

echo '$ test-expr -e double -l '\''"+91p2"'\'''
test-expr -e double -l '"+91p2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+91p2"'\'''

echo '$ test-expr -e ldouble -l '\''"+91p2"'\'''
test-expr -e ldouble -l '"+91p2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+91p2"'\'''

echo '$ test-expr -e float -l '\''"+91P2"'\'''
test-expr -e float -l '"+91P2"' 2>&1 ||
echo 'command failed: test-expr -e float -l '\''"+91P2"'\'''

echo '$ test-expr -e double -l '\''"+91P2"'\'''
test-expr -e double -l '"+91P2"' 2>&1 ||
echo 'command failed: test-expr -e double -l '\''"+91P2"'\'''

echo '$ test-expr -e ldouble -l '\''"+91P2"'\'''
test-expr -e ldouble -l '"+91P2"' 2>&1 ||
echo 'command failed: test-expr -e ldouble -l '\''"+91P2"'\'''
)

