#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:84
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 84.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< null
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< null
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< false
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< false
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< 123
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< 123
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"dict","args":[...]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
json: error: <stdin>:1:14: type check error: duplicate argument name: "foo"
json: error: <stdin>:1:14: {"foo":"bar","foo":true}
json: error: <stdin>:1:14:              ^
{"foo":"bar",
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\''
{"foo":"bar","faa":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"foo":456}'\''
json: error: <stdin>:1:24: type check error: too many arguments
json: error: <stdin>:1:24: {"foo":"bar","faa":true,"foo":456}
json: error: <stdin>:1:24:                        ^
{"foo":"bar","faa":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"foo":456}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"faa":456}'\''
json: error: <stdin>:1:24: type check error: too many arguments
json: error: <stdin>:1:24: {"foo":"bar","faa":true,"faa":456}
json: error: <stdin>:1:24:                        ^
{"foo":"bar","faa":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"faa":456}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar"}'\''
{"faa":"bar"}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true}'\''
{"faa":"bar","foo":true}
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"faa":456}'\''
json: error: <stdin>:1:24: type check error: too many arguments
json: error: <stdin>:1:24: {"faa":"bar","foo":true,"faa":456}
json: error: <stdin>:1:24:                        ^
{"faa":"bar","foo":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"faa":456}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"foo":456}'\''
json: error: <stdin>:1:24: type check error: too many arguments
json: error: <stdin>:1:24: {"faa":"bar","foo":true,"foo":456}
json: error: <stdin>:1:24:                        ^
{"faa":"bar","foo":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"foo":456}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
json: error: <stdin>:1:14: type check error: duplicate argument name: "foo"
json: error: <stdin>:1:14: {"foo":"bar","foo":true}
json: error: <stdin>:1:14:              ^
{"foo":"bar",
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","faa":true}'\''
json: error: <stdin>:1:14: type check error: duplicate argument name: "faa"
json: error: <stdin>:1:14: {"faa":"bar","faa":true}
json: error: <stdin>:1:14:              ^
{"faa":"bar",
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","faa":true}'\'''
) -L 84.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< null'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< null 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< null'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< false'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< false 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< false'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< 123'
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< 123 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< 123'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''[]'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar","foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar","faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"foo":456}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar","faa":true,"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"foo":456}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"faa":456}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar","faa":true,"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","faa":true,"faa":456}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar"}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"faa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar"}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"faa":"bar","foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"faa":456}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"faa":"bar","foo":true,"faa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"faa":456}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"foo":456}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"faa":"bar","foo":true,"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","foo":true,"foo":456}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"foo":"bar","foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"foo":"bar","foo":true}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","faa":true}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}' <<< '{"faa":"bar","faa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"faa","type":"type"}]}'\'' <<< '\''{"faa":"bar","faa":true}'\'''
)

