#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-basic-object-plain-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-basic-object-plain-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
null
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
true
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
123
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
456
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
"bar"
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
{}
$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\''
[]'
) -L list-basic-object-plain-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["type",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["null",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["boolean",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["number",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["string",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["object",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":["array",{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''[]'\'''
)

