#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:object-list6
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object-list6.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["null",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["boolean",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
{"foo":456}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["number",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
{"foo":"baz"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["string",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
{"foo":{}}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["object",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":[]}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":null}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\''
{"foo":false}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":false}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\''
{"foo":true}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":true}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\''
{"foo":123}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"bar"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":123}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":false}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":true}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":123}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":456}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\''
{"foo":"bar"}
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":"baz"}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"type":"list","args":["array",{"plain":"bar"}]}'\''
json: error: <stdin>:1:8: {"foo":{}}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\''
$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\''
{"foo":[]}'
) -L object-list6.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["type",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["null",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["boolean",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["number",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["string",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["object",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":null}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":false}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":true}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":123}]}}]}'\'' <<< '\''{"foo":[]}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":false}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":true}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":123}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":456}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"bar"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":"baz"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":"baz"}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":{}}'\'''

echo '$ json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
json -d '{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}' <<< '{"foo":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"object","args":[{"name":"foo","type":{"type":"list","args":["array",{"plain":"bar"}]}}]}'\'' <<< '\''{"foo":[]}'\'''
)

