#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:obj-type-basic2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L obj-type-basic2.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''["n"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["n"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["n"]'\''
$ json <<< '\''["n?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["n?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["n?"]'\''
$ json <<< '\''["nu"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nu"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nu"]'\''
$ json <<< '\''["nu?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nu?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nu?"]'\''
$ json <<< '\''["nul"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nul"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nul"]'\''
$ json <<< '\''["nul?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nul?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nul?"]'\''
$ json <<< '\''["null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null"]'\''
$ json <<< '\''["null?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["null?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["null?"]'\''
$ json <<< '\''["t"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["t"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["t"]'\''
$ json <<< '\''["t?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["t?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["t?"]'\''
$ json <<< '\''["ty"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ty"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ty"]'\''
$ json <<< '\''["ty?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ty?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ty?"]'\''
$ json <<< '\''["typ"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["typ"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["typ"]'\''
$ json <<< '\''["typ?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["typ?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["typ?"]'\''
$ json <<< '\''["type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type"]'\''
$ json <<< '\''["type?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["type?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["type?"]'\''
$ json <<< '\''["b"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["b"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["b"]'\''
$ json <<< '\''["b?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["b?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["b?"]'\''
$ json <<< '\''["bo"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["bo"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["bo"]'\''
$ json <<< '\''["bo?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["bo?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["bo?"]'\''
$ json <<< '\''["boo"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boo"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boo"]'\''
$ json <<< '\''["boo?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boo?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boo?"]'\''
$ json <<< '\''["bool"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["bool"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["bool"]'\''
$ json <<< '\''["bool?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["bool?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["bool?"]'\''
$ json <<< '\''["boole"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boole"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boole"]'\''
$ json <<< '\''["boole?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boole?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boole?"]'\''
$ json <<< '\''["boolea"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boolea"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boolea"]'\''
$ json <<< '\''["boolea?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boolea?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boolea?"]'\''
$ json <<< '\''["boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean"]'\''
$ json <<< '\''["boolean?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["boolean?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["boolean?"]'\''
$ json <<< '\''["n"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["n"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["n"]'\''
$ json <<< '\''["n?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["n?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["n?"]'\''
$ json <<< '\''["nu"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nu"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nu"]'\''
$ json <<< '\''["nu?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["nu?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["nu?"]'\''
$ json <<< '\''["num"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["num"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["num"]'\''
$ json <<< '\''["num?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["num?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["num?"]'\''
$ json <<< '\''["numb"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["numb"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["numb"]'\''
$ json <<< '\''["numb?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["numb?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["numb?"]'\''
$ json <<< '\''["numbe"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["numbe"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["numbe"]'\''
$ json <<< '\''["numbe?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["numbe?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["numbe?"]'\''
$ json <<< '\''["number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number"]'\''
$ json <<< '\''["number?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["number?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["number?"]'\''
$ json <<< '\''["s"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["s"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["s"]'\''
$ json <<< '\''["s?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["s?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["s?"]'\''
$ json <<< '\''["st"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["st"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["st"]'\''
$ json <<< '\''["st?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["st?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["st?"]'\''
$ json <<< '\''["str"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["str"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["str"]'\''
$ json <<< '\''["str?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["str?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["str?"]'\''
$ json <<< '\''["stri"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["stri"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["stri"]'\''
$ json <<< '\''["stri?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["stri?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["stri?"]'\''
$ json <<< '\''["strin"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["strin"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["strin"]'\''
$ json <<< '\''["strin?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["strin?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["strin?"]'\''
$ json <<< '\''["string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string"]'\''
$ json <<< '\''["string?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["string?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["string?"]'\''
$ json <<< '\''["o"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["o"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["o"]'\''
$ json <<< '\''["o?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["o?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["o?"]'\''
$ json <<< '\''["ob"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ob"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ob"]'\''
$ json <<< '\''["ob?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ob?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ob?"]'\''
$ json <<< '\''["obj"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["obj"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["obj"]'\''
$ json <<< '\''["obj?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["obj?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["obj?"]'\''
$ json <<< '\''["obje"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["obje"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["obje"]'\''
$ json <<< '\''["obje?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["obje?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["obje?"]'\''
$ json <<< '\''["objec"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["objec"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["objec"]'\''
$ json <<< '\''["objec?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["objec?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["objec?"]'\''
$ json <<< '\''["object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object"]'\''
$ json <<< '\''["object?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["object?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["object?"]'\''
$ json <<< '\''["a"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["a"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["a"]'\''
$ json <<< '\''["a?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["a?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["a?"]'\''
$ json <<< '\''["ar"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ar"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ar"]'\''
$ json <<< '\''["ar?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["ar?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["ar?"]'\''
$ json <<< '\''["arr"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["arr"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["arr"]'\''
$ json <<< '\''["arr?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["arr?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["arr?"]'\''
$ json <<< '\''["arra"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["arra"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["arra"]'\''
$ json <<< '\''["arra?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["arra?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["arra?"]'\''
$ json <<< '\''["array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array"]'\''
$ json <<< '\''["array?"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["array?"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["array?"]'\'''
) -L obj-type-basic2.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''["n"]'\'''
json <<< '["n"]' 2>&1 ||
echo 'command failed: json <<< '\''["n"]'\'''

echo '$ json <<< '\''["n?"]'\'''
json <<< '["n?"]' 2>&1 ||
echo 'command failed: json <<< '\''["n?"]'\'''

echo '$ json <<< '\''["nu"]'\'''
json <<< '["nu"]' 2>&1 ||
echo 'command failed: json <<< '\''["nu"]'\'''

echo '$ json <<< '\''["nu?"]'\'''
json <<< '["nu?"]' 2>&1 ||
echo 'command failed: json <<< '\''["nu?"]'\'''

echo '$ json <<< '\''["nul"]'\'''
json <<< '["nul"]' 2>&1 ||
echo 'command failed: json <<< '\''["nul"]'\'''

echo '$ json <<< '\''["nul?"]'\'''
json <<< '["nul?"]' 2>&1 ||
echo 'command failed: json <<< '\''["nul?"]'\'''

echo '$ json <<< '\''["null"]'\'''
json <<< '["null"]' 2>&1 ||
echo 'command failed: json <<< '\''["null"]'\'''

echo '$ json <<< '\''["null?"]'\'''
json <<< '["null?"]' 2>&1 ||
echo 'command failed: json <<< '\''["null?"]'\'''

echo '$ json <<< '\''["t"]'\'''
json <<< '["t"]' 2>&1 ||
echo 'command failed: json <<< '\''["t"]'\'''

echo '$ json <<< '\''["t?"]'\'''
json <<< '["t?"]' 2>&1 ||
echo 'command failed: json <<< '\''["t?"]'\'''

echo '$ json <<< '\''["ty"]'\'''
json <<< '["ty"]' 2>&1 ||
echo 'command failed: json <<< '\''["ty"]'\'''

echo '$ json <<< '\''["ty?"]'\'''
json <<< '["ty?"]' 2>&1 ||
echo 'command failed: json <<< '\''["ty?"]'\'''

echo '$ json <<< '\''["typ"]'\'''
json <<< '["typ"]' 2>&1 ||
echo 'command failed: json <<< '\''["typ"]'\'''

echo '$ json <<< '\''["typ?"]'\'''
json <<< '["typ?"]' 2>&1 ||
echo 'command failed: json <<< '\''["typ?"]'\'''

echo '$ json <<< '\''["type"]'\'''
json <<< '["type"]' 2>&1 ||
echo 'command failed: json <<< '\''["type"]'\'''

echo '$ json <<< '\''["type?"]'\'''
json <<< '["type?"]' 2>&1 ||
echo 'command failed: json <<< '\''["type?"]'\'''

echo '$ json <<< '\''["b"]'\'''
json <<< '["b"]' 2>&1 ||
echo 'command failed: json <<< '\''["b"]'\'''

echo '$ json <<< '\''["b?"]'\'''
json <<< '["b?"]' 2>&1 ||
echo 'command failed: json <<< '\''["b?"]'\'''

echo '$ json <<< '\''["bo"]'\'''
json <<< '["bo"]' 2>&1 ||
echo 'command failed: json <<< '\''["bo"]'\'''

echo '$ json <<< '\''["bo?"]'\'''
json <<< '["bo?"]' 2>&1 ||
echo 'command failed: json <<< '\''["bo?"]'\'''

echo '$ json <<< '\''["boo"]'\'''
json <<< '["boo"]' 2>&1 ||
echo 'command failed: json <<< '\''["boo"]'\'''

echo '$ json <<< '\''["boo?"]'\'''
json <<< '["boo?"]' 2>&1 ||
echo 'command failed: json <<< '\''["boo?"]'\'''

echo '$ json <<< '\''["bool"]'\'''
json <<< '["bool"]' 2>&1 ||
echo 'command failed: json <<< '\''["bool"]'\'''

echo '$ json <<< '\''["bool?"]'\'''
json <<< '["bool?"]' 2>&1 ||
echo 'command failed: json <<< '\''["bool?"]'\'''

echo '$ json <<< '\''["boole"]'\'''
json <<< '["boole"]' 2>&1 ||
echo 'command failed: json <<< '\''["boole"]'\'''

echo '$ json <<< '\''["boole?"]'\'''
json <<< '["boole?"]' 2>&1 ||
echo 'command failed: json <<< '\''["boole?"]'\'''

echo '$ json <<< '\''["boolea"]'\'''
json <<< '["boolea"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolea"]'\'''

echo '$ json <<< '\''["boolea?"]'\'''
json <<< '["boolea?"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolea?"]'\'''

echo '$ json <<< '\''["boolean"]'\'''
json <<< '["boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean"]'\'''

echo '$ json <<< '\''["boolean?"]'\'''
json <<< '["boolean?"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean?"]'\'''

echo '$ json <<< '\''["n"]'\'''
json <<< '["n"]' 2>&1 ||
echo 'command failed: json <<< '\''["n"]'\'''

echo '$ json <<< '\''["n?"]'\'''
json <<< '["n?"]' 2>&1 ||
echo 'command failed: json <<< '\''["n?"]'\'''

echo '$ json <<< '\''["nu"]'\'''
json <<< '["nu"]' 2>&1 ||
echo 'command failed: json <<< '\''["nu"]'\'''

echo '$ json <<< '\''["nu?"]'\'''
json <<< '["nu?"]' 2>&1 ||
echo 'command failed: json <<< '\''["nu?"]'\'''

echo '$ json <<< '\''["num"]'\'''
json <<< '["num"]' 2>&1 ||
echo 'command failed: json <<< '\''["num"]'\'''

echo '$ json <<< '\''["num?"]'\'''
json <<< '["num?"]' 2>&1 ||
echo 'command failed: json <<< '\''["num?"]'\'''

echo '$ json <<< '\''["numb"]'\'''
json <<< '["numb"]' 2>&1 ||
echo 'command failed: json <<< '\''["numb"]'\'''

echo '$ json <<< '\''["numb?"]'\'''
json <<< '["numb?"]' 2>&1 ||
echo 'command failed: json <<< '\''["numb?"]'\'''

echo '$ json <<< '\''["numbe"]'\'''
json <<< '["numbe"]' 2>&1 ||
echo 'command failed: json <<< '\''["numbe"]'\'''

echo '$ json <<< '\''["numbe?"]'\'''
json <<< '["numbe?"]' 2>&1 ||
echo 'command failed: json <<< '\''["numbe?"]'\'''

echo '$ json <<< '\''["number"]'\'''
json <<< '["number"]' 2>&1 ||
echo 'command failed: json <<< '\''["number"]'\'''

echo '$ json <<< '\''["number?"]'\'''
json <<< '["number?"]' 2>&1 ||
echo 'command failed: json <<< '\''["number?"]'\'''

echo '$ json <<< '\''["s"]'\'''
json <<< '["s"]' 2>&1 ||
echo 'command failed: json <<< '\''["s"]'\'''

echo '$ json <<< '\''["s?"]'\'''
json <<< '["s?"]' 2>&1 ||
echo 'command failed: json <<< '\''["s?"]'\'''

echo '$ json <<< '\''["st"]'\'''
json <<< '["st"]' 2>&1 ||
echo 'command failed: json <<< '\''["st"]'\'''

echo '$ json <<< '\''["st?"]'\'''
json <<< '["st?"]' 2>&1 ||
echo 'command failed: json <<< '\''["st?"]'\'''

echo '$ json <<< '\''["str"]'\'''
json <<< '["str"]' 2>&1 ||
echo 'command failed: json <<< '\''["str"]'\'''

echo '$ json <<< '\''["str?"]'\'''
json <<< '["str?"]' 2>&1 ||
echo 'command failed: json <<< '\''["str?"]'\'''

echo '$ json <<< '\''["stri"]'\'''
json <<< '["stri"]' 2>&1 ||
echo 'command failed: json <<< '\''["stri"]'\'''

echo '$ json <<< '\''["stri?"]'\'''
json <<< '["stri?"]' 2>&1 ||
echo 'command failed: json <<< '\''["stri?"]'\'''

echo '$ json <<< '\''["strin"]'\'''
json <<< '["strin"]' 2>&1 ||
echo 'command failed: json <<< '\''["strin"]'\'''

echo '$ json <<< '\''["strin?"]'\'''
json <<< '["strin?"]' 2>&1 ||
echo 'command failed: json <<< '\''["strin?"]'\'''

echo '$ json <<< '\''["string"]'\'''
json <<< '["string"]' 2>&1 ||
echo 'command failed: json <<< '\''["string"]'\'''

echo '$ json <<< '\''["string?"]'\'''
json <<< '["string?"]' 2>&1 ||
echo 'command failed: json <<< '\''["string?"]'\'''

echo '$ json <<< '\''["o"]'\'''
json <<< '["o"]' 2>&1 ||
echo 'command failed: json <<< '\''["o"]'\'''

echo '$ json <<< '\''["o?"]'\'''
json <<< '["o?"]' 2>&1 ||
echo 'command failed: json <<< '\''["o?"]'\'''

echo '$ json <<< '\''["ob"]'\'''
json <<< '["ob"]' 2>&1 ||
echo 'command failed: json <<< '\''["ob"]'\'''

echo '$ json <<< '\''["ob?"]'\'''
json <<< '["ob?"]' 2>&1 ||
echo 'command failed: json <<< '\''["ob?"]'\'''

echo '$ json <<< '\''["obj"]'\'''
json <<< '["obj"]' 2>&1 ||
echo 'command failed: json <<< '\''["obj"]'\'''

echo '$ json <<< '\''["obj?"]'\'''
json <<< '["obj?"]' 2>&1 ||
echo 'command failed: json <<< '\''["obj?"]'\'''

echo '$ json <<< '\''["obje"]'\'''
json <<< '["obje"]' 2>&1 ||
echo 'command failed: json <<< '\''["obje"]'\'''

echo '$ json <<< '\''["obje?"]'\'''
json <<< '["obje?"]' 2>&1 ||
echo 'command failed: json <<< '\''["obje?"]'\'''

echo '$ json <<< '\''["objec"]'\'''
json <<< '["objec"]' 2>&1 ||
echo 'command failed: json <<< '\''["objec"]'\'''

echo '$ json <<< '\''["objec?"]'\'''
json <<< '["objec?"]' 2>&1 ||
echo 'command failed: json <<< '\''["objec?"]'\'''

echo '$ json <<< '\''["object"]'\'''
json <<< '["object"]' 2>&1 ||
echo 'command failed: json <<< '\''["object"]'\'''

echo '$ json <<< '\''["object?"]'\'''
json <<< '["object?"]' 2>&1 ||
echo 'command failed: json <<< '\''["object?"]'\'''

echo '$ json <<< '\''["a"]'\'''
json <<< '["a"]' 2>&1 ||
echo 'command failed: json <<< '\''["a"]'\'''

echo '$ json <<< '\''["a?"]'\'''
json <<< '["a?"]' 2>&1 ||
echo 'command failed: json <<< '\''["a?"]'\'''

echo '$ json <<< '\''["ar"]'\'''
json <<< '["ar"]' 2>&1 ||
echo 'command failed: json <<< '\''["ar"]'\'''

echo '$ json <<< '\''["ar?"]'\'''
json <<< '["ar?"]' 2>&1 ||
echo 'command failed: json <<< '\''["ar?"]'\'''

echo '$ json <<< '\''["arr"]'\'''
json <<< '["arr"]' 2>&1 ||
echo 'command failed: json <<< '\''["arr"]'\'''

echo '$ json <<< '\''["arr?"]'\'''
json <<< '["arr?"]' 2>&1 ||
echo 'command failed: json <<< '\''["arr?"]'\'''

echo '$ json <<< '\''["arra"]'\'''
json <<< '["arra"]' 2>&1 ||
echo 'command failed: json <<< '\''["arra"]'\'''

echo '$ json <<< '\''["arra?"]'\'''
json <<< '["arra?"]' 2>&1 ||
echo 'command failed: json <<< '\''["arra?"]'\'''

echo '$ json <<< '\''["array"]'\'''
json <<< '["array"]' 2>&1 ||
echo 'command failed: json <<< '\''["array"]'\'''

echo '$ json <<< '\''["array?"]'\'''
json <<< '["array?"]' 2>&1 ||
echo 'command failed: json <<< '\''["array?"]'\'''
)

