#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:29
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 29.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -O <<< '\''{"a":1;}'\'' --no-verbose
json: error: <stdin>:1:7: lex error: invalid char
command failed: json -O <<< '\''{"a":1;}'\'' --no-verbose
$ json -O <<< '\''{"a":1;}'\'' -V
json: error: <stdin>:1:7: lex error: invalid char
json: error: <stdin>:1:7: {"a":1;}
json: error: <stdin>:1:7:       ^
command failed: json -O <<< '\''{"a":1;}'\'' -V
$ json -Tc <<< '\''{"a":1;}'\'' --no-verbose
json: error: <stdin>:1:7: parse error: invalid char
command failed: json -Tc <<< '\''{"a":1;}'\'' --no-verbose
$ json -Tc <<< '\''{"a":1;}'\'' -V
json: error: <stdin>:1:7: parse error: invalid char
json: error: <stdin>:1:7: {"a":1;}
json: error: <stdin>:1:7:       ^
command failed: json -Tc <<< '\''{"a":1;}'\'' -V'
) -L 29.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -O <<< '\''{"a":1;}'\'' --no-verbose'
json -O <<< '{"a":1;}' --no-verbose 2>&1 ||
echo 'command failed: json -O <<< '\''{"a":1;}'\'' --no-verbose'

echo '$ json -O <<< '\''{"a":1;}'\'' -V'
json -O <<< '{"a":1;}' -V 2>&1 ||
echo 'command failed: json -O <<< '\''{"a":1;}'\'' -V'

echo '$ json -Tc <<< '\''{"a":1;}'\'' --no-verbose'
json -Tc <<< '{"a":1;}' --no-verbose 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"a":1;}'\'' --no-verbose'

echo '$ json -Tc <<< '\''{"a":1;}'\'' -V'
json -Tc <<< '{"a":1;}' -V 2>&1 ||
echo 'command failed: json -Tc <<< '\''{"a":1;}'\'' -V'
)

