#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:dyn-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dyn-lib.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ shopt -s expand_aliases
$ alias json=json0
$ json -F -
json: error: input filter library cannot be stdin
command failed: json -F -
$ json -F -- -
json: error: -: filter library: failed loading library
command failed: json -F -- -
$ json -V -F -- -
json: error: -: filter library: failed loading library: dlopen failed: -: cannot open shared object file: No such file or directory
command failed: json -V -F -- -
$ json -f -- -
json: error: -: filter library: failed loading library
command failed: json -f -- -
$ json -V -f -- -
json: error: -: filter library: failed loading library: dlopen failed: -: cannot open shared object file: No such file or directory
command failed: json -V -f -- -
$ json -F /dev/null
json: error: /dev/null: filter library: failed loading library
command failed: json -F /dev/null
$ json -F -- /dev/null
json: error: /dev/null: filter library: failed loading library
command failed: json -F -- /dev/null
$ json -V -F -- /dev/null
json: error: /dev/null: filter library: failed loading library: dlopen failed: /dev/null: file too short
command failed: json -V -F -- /dev/null
$ json -f -- /dev/null
json: error: /dev/null: filter library: failed loading library
command failed: json -f -- /dev/null
$ json -V -f -- /dev/null
json: error: /dev/null: filter library: failed loading library: dlopen failed: /dev/null: file too short
command failed: json -V -f -- /dev/null'
) -L dyn-lib.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json=json0'
alias json=json0 2>&1 ||
echo 'command failed: alias json=json0'

echo '$ json -F -'
json -F - 2>&1 ||
echo 'command failed: json -F -'

echo '$ json -F -- -'
json -F -- - 2>&1 ||
echo 'command failed: json -F -- -'

echo '$ json -V -F -- -'
json -V -F -- - 2>&1 ||
echo 'command failed: json -V -F -- -'

echo '$ json -f -- -'
json -f -- - 2>&1 ||
echo 'command failed: json -f -- -'

echo '$ json -V -f -- -'
json -V -f -- - 2>&1 ||
echo 'command failed: json -V -f -- -'

echo '$ json -F /dev/null'
json -F /dev/null 2>&1 ||
echo 'command failed: json -F /dev/null'

echo '$ json -F -- /dev/null'
json -F -- /dev/null 2>&1 ||
echo 'command failed: json -F -- /dev/null'

echo '$ json -V -F -- /dev/null'
json -V -F -- /dev/null 2>&1 ||
echo 'command failed: json -V -F -- /dev/null'

echo '$ json -f -- /dev/null'
json -f -- /dev/null 2>&1 ||
echo 'command failed: json -f -- /dev/null'

echo '$ json -V -f -- /dev/null'
json -V -f -- /dev/null 2>&1 ||
echo 'command failed: json -V -f -- /dev/null'
)

