#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr:builtins5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L builtins5.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }
$ test-expr '\''date(`%N`)'\'' '\''"0"'\''
1
$ test-expr '\''date(`%Nbar`)'\'' '\''"0bar"'\''
1
$ test-expr '\''date(`%N `)'\'' '\''"0 "'\''
1
$ test-expr '\''date(`%N bar`)'\'' '\''"0 bar"'\''
1
$ test-expr '\''date(` %N`)'\'' '\''" 0"'\''
1
$ test-expr '\''date(` %Nbar`)'\'' '\''" 0bar"'\''
1
$ test-expr '\''date(` %N `)'\'' '\''" 0 "'\''
1
$ test-expr '\''date(` %N bar`)'\'' '\''" 0 bar"'\''
1
$ test-expr '\''date(`foo%N`)'\'' '\''"foo0"'\''
1
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo0bar"'\''
1
$ test-expr '\''date(`foo%N `)'\'' '\''"foo0 "'\''
1
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo0 bar"'\''
1
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 0"'\''
1
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 0bar"'\''
1
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 0 "'\''
1
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 0 bar"'\''
1
$ test-expr '\''date(`%N`)'\'' '\''"1"'\''
1
$ test-expr '\''date(`%Nbar`)'\'' '\''"1bar"'\''
1
$ test-expr '\''date(`%N `)'\'' '\''"1 "'\''
1
$ test-expr '\''date(`%N bar`)'\'' '\''"1 bar"'\''
1
$ test-expr '\''date(` %N`)'\'' '\''" 1"'\''
1
$ test-expr '\''date(` %Nbar`)'\'' '\''" 1bar"'\''
1
$ test-expr '\''date(` %N `)'\'' '\''" 1 "'\''
1
$ test-expr '\''date(` %N bar`)'\'' '\''" 1 bar"'\''
1
$ test-expr '\''date(`foo%N`)'\'' '\''"foo1"'\''
1
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1bar"'\''
1
$ test-expr '\''date(`foo%N `)'\'' '\''"foo1 "'\''
1
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1 bar"'\''
1
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1"'\''
1
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1bar"'\''
1
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1 "'\''
1
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1 bar"'\''
1
$ test-expr '\''date(`%N`)'\'' '\''"999999998"'\''
1
$ test-expr '\''date(`%Nbar`)'\'' '\''"999999998bar"'\''
1
$ test-expr '\''date(`%N `)'\'' '\''"999999998 "'\''
1
$ test-expr '\''date(`%N bar`)'\'' '\''"999999998 bar"'\''
1
$ test-expr '\''date(` %N`)'\'' '\''" 999999998"'\''
1
$ test-expr '\''date(` %Nbar`)'\'' '\''" 999999998bar"'\''
1
$ test-expr '\''date(` %N `)'\'' '\''" 999999998 "'\''
1
$ test-expr '\''date(` %N bar`)'\'' '\''" 999999998 bar"'\''
1
$ test-expr '\''date(`foo%N`)'\'' '\''"foo999999998"'\''
1
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999998bar"'\''
1
$ test-expr '\''date(`foo%N `)'\'' '\''"foo999999998 "'\''
1
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999998 bar"'\''
1
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 999999998"'\''
1
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999998bar"'\''
1
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 999999998 "'\''
1
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999998 bar"'\''
1
$ test-expr '\''date(`%N`)'\'' '\''"999999999"'\''
1
$ test-expr '\''date(`%Nbar`)'\'' '\''"999999999bar"'\''
1
$ test-expr '\''date(`%N `)'\'' '\''"999999999 "'\''
1
$ test-expr '\''date(`%N bar`)'\'' '\''"999999999 bar"'\''
1
$ test-expr '\''date(` %N`)'\'' '\''" 999999999"'\''
1
$ test-expr '\''date(` %Nbar`)'\'' '\''" 999999999bar"'\''
1
$ test-expr '\''date(` %N `)'\'' '\''" 999999999 "'\''
1
$ test-expr '\''date(` %N bar`)'\'' '\''" 999999999 bar"'\''
1
$ test-expr '\''date(`foo%N`)'\'' '\''"foo999999999"'\''
1
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999999bar"'\''
1
$ test-expr '\''date(`foo%N `)'\'' '\''"foo999999999 "'\''
1
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999999 bar"'\''
1
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 999999999"'\''
1
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999999bar"'\''
1
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 999999999 "'\''
1
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999999 bar"'\''
1
$ test-expr '\''date(`%N`)'\'' '\''"1000000000"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"1000000000bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"1000000000 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"1000000000 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" 1000000000"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" 1000000000bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" 1000000000 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" 1000000000 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo1000000000"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000000bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo1000000000 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000000 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000000"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000000bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000000 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000000 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"1000000001"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"1000000001bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"1000000001 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"1000000001 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" 1000000001"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" 1000000001bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" 1000000001 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" 1000000001 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo1000000001"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000001bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo1000000001 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000001 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000001"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000001bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000001 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000001 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-0"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-0bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-0 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-0 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -0"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -0bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -0 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -0 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-0"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-0bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-0 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-0 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -0"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -0bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -0 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -0 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-1"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-1bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-1 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-1 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -1"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -1bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -1 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -1 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-999999998"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-999999998bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-999999998 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-999999998 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -999999998"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -999999998bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -999999998 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -999999998 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-999999998"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999998bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-999999998 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999998 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -999999998"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999998bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -999999998 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999998 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-999999999"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-999999999bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-999999999 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-999999999 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -999999999"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -999999999bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -999999999 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -999999999 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-999999999"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999999bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-999999999 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999999 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -999999999"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999999bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -999999999 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999999 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-1000000000"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-1000000000bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-1000000000 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-1000000000 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -1000000000"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -1000000000bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -1000000000 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -1000000000 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000000"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000000bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000000 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000000 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000000"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000000bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000000 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000000 bar"'\''
0
$ test-expr '\''date(`%N`)'\'' '\''"-1000000001"'\''
0
$ test-expr '\''date(`%Nbar`)'\'' '\''"-1000000001bar"'\''
0
$ test-expr '\''date(`%N `)'\'' '\''"-1000000001 "'\''
0
$ test-expr '\''date(`%N bar`)'\'' '\''"-1000000001 bar"'\''
0
$ test-expr '\''date(` %N`)'\'' '\''" -1000000001"'\''
0
$ test-expr '\''date(` %Nbar`)'\'' '\''" -1000000001bar"'\''
0
$ test-expr '\''date(` %N `)'\'' '\''" -1000000001 "'\''
0
$ test-expr '\''date(` %N bar`)'\'' '\''" -1000000001 bar"'\''
0
$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000001"'\''
0
$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000001bar"'\''
0
$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000001 "'\''
0
$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000001 bar"'\''
0
$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000001"'\''
0
$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000001bar"'\''
0
$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000001 "'\''
0
$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000001 bar"'\''
0'
) -L builtins5.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vb default -E; }'

echo '$ test-expr '\''date(`%N`)'\'' '\''"0"'\'''
test-expr 'date(`%N`)' '"0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"0"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"0bar"'\'''
test-expr 'date(`%Nbar`)' '"0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"0bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"0 "'\'''
test-expr 'date(`%N `)' '"0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"0 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"0 bar"'\'''
test-expr 'date(`%N bar`)' '"0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"0 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 0"'\'''
test-expr 'date(` %N`)' '" 0"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 0"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 0bar"'\'''
test-expr 'date(` %Nbar`)' '" 0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 0bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 0 "'\'''
test-expr 'date(` %N `)' '" 0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 0 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 0 bar"'\'''
test-expr 'date(` %N bar`)' '" 0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 0 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo0"'\'''
test-expr 'date(`foo%N`)' '"foo0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo0"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo0bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo0bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo0 "'\'''
test-expr 'date(`foo%N `)' '"foo0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo0 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo0 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo0 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 0"'\'''
test-expr 'date(`foo %N`)' '"foo 0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 0"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 0bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 0bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 0 "'\'''
test-expr 'date(`foo %N `)' '"foo 0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 0 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 0 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 0 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"1"'\'''
test-expr 'date(`%N`)' '"1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"1"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"1bar"'\'''
test-expr 'date(`%Nbar`)' '"1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"1bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"1 "'\'''
test-expr 'date(`%N `)' '"1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"1 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"1 bar"'\'''
test-expr 'date(`%N bar`)' '"1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"1 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 1"'\'''
test-expr 'date(` %N`)' '" 1"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 1"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 1bar"'\'''
test-expr 'date(` %Nbar`)' '" 1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 1bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 1 "'\'''
test-expr 'date(` %N `)' '" 1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 1 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 1 bar"'\'''
test-expr 'date(` %N bar`)' '" 1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 1 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo1"'\'''
test-expr 'date(`foo%N`)' '"foo1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo1"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo1 "'\'''
test-expr 'date(`foo%N `)' '"foo1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo1 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo1 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1"'\'''
test-expr 'date(`foo %N`)' '"foo 1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 1"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1 "'\'''
test-expr 'date(`foo %N `)' '"foo 1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 1 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"999999998"'\'''
test-expr 'date(`%N`)' '"999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"999999998"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"999999998bar"'\'''
test-expr 'date(`%Nbar`)' '"999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"999999998bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"999999998 "'\'''
test-expr 'date(`%N `)' '"999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"999999998 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"999999998 bar"'\'''
test-expr 'date(`%N bar`)' '"999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"999999998 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 999999998"'\'''
test-expr 'date(` %N`)' '" 999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 999999998"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 999999998bar"'\'''
test-expr 'date(` %Nbar`)' '" 999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 999999998bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 999999998 "'\'''
test-expr 'date(` %N `)' '" 999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 999999998 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 999999998 bar"'\'''
test-expr 'date(` %N bar`)' '" 999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 999999998 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo999999998"'\'''
test-expr 'date(`foo%N`)' '"foo999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo999999998"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999998bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999998bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo999999998 "'\'''
test-expr 'date(`foo%N `)' '"foo999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo999999998 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999998 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999998 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 999999998"'\'''
test-expr 'date(`foo %N`)' '"foo 999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 999999998"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999998bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999998bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 999999998 "'\'''
test-expr 'date(`foo %N `)' '"foo 999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 999999998 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999998 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999998 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"999999999"'\'''
test-expr 'date(`%N`)' '"999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"999999999"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"999999999bar"'\'''
test-expr 'date(`%Nbar`)' '"999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"999999999bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"999999999 "'\'''
test-expr 'date(`%N `)' '"999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"999999999 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"999999999 bar"'\'''
test-expr 'date(`%N bar`)' '"999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"999999999 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 999999999"'\'''
test-expr 'date(` %N`)' '" 999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 999999999"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 999999999bar"'\'''
test-expr 'date(` %Nbar`)' '" 999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 999999999bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 999999999 "'\'''
test-expr 'date(` %N `)' '" 999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 999999999 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 999999999 bar"'\'''
test-expr 'date(` %N bar`)' '" 999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 999999999 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo999999999"'\'''
test-expr 'date(`foo%N`)' '"foo999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo999999999"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999999bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo999999999bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo999999999 "'\'''
test-expr 'date(`foo%N `)' '"foo999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo999999999 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999999 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo999999999 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 999999999"'\'''
test-expr 'date(`foo %N`)' '"foo 999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 999999999"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999999bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 999999999bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 999999999 "'\'''
test-expr 'date(`foo %N `)' '"foo 999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 999999999 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999999 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 999999999 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"1000000000"'\'''
test-expr 'date(`%N`)' '"1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"1000000000"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"1000000000bar"'\'''
test-expr 'date(`%Nbar`)' '"1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"1000000000bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"1000000000 "'\'''
test-expr 'date(`%N `)' '"1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"1000000000 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"1000000000 bar"'\'''
test-expr 'date(`%N bar`)' '"1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"1000000000 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 1000000000"'\'''
test-expr 'date(` %N`)' '" 1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 1000000000"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 1000000000bar"'\'''
test-expr 'date(` %Nbar`)' '" 1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 1000000000bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 1000000000 "'\'''
test-expr 'date(` %N `)' '" 1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 1000000000 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 1000000000 bar"'\'''
test-expr 'date(` %N bar`)' '" 1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 1000000000 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo1000000000"'\'''
test-expr 'date(`foo%N`)' '"foo1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo1000000000"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000000bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000000bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo1000000000 "'\'''
test-expr 'date(`foo%N `)' '"foo1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo1000000000 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000000 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000000 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000000"'\'''
test-expr 'date(`foo %N`)' '"foo 1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000000"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000000bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000000bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000000 "'\'''
test-expr 'date(`foo %N `)' '"foo 1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000000 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000000 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000000 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"1000000001"'\'''
test-expr 'date(`%N`)' '"1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"1000000001"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"1000000001bar"'\'''
test-expr 'date(`%Nbar`)' '"1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"1000000001bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"1000000001 "'\'''
test-expr 'date(`%N `)' '"1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"1000000001 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"1000000001 bar"'\'''
test-expr 'date(`%N bar`)' '"1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"1000000001 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" 1000000001"'\'''
test-expr 'date(` %N`)' '" 1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" 1000000001"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" 1000000001bar"'\'''
test-expr 'date(` %Nbar`)' '" 1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" 1000000001bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" 1000000001 "'\'''
test-expr 'date(` %N `)' '" 1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" 1000000001 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" 1000000001 bar"'\'''
test-expr 'date(` %N bar`)' '" 1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" 1000000001 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo1000000001"'\'''
test-expr 'date(`foo%N`)' '"foo1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo1000000001"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000001bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo1000000001bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo1000000001 "'\'''
test-expr 'date(`foo%N `)' '"foo1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo1000000001 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000001 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo1000000001 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000001"'\'''
test-expr 'date(`foo %N`)' '"foo 1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo 1000000001"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000001bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo 1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo 1000000001bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000001 "'\'''
test-expr 'date(`foo %N `)' '"foo 1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo 1000000001 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000001 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo 1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo 1000000001 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-0"'\'''
test-expr 'date(`%N`)' '"-0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-0"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-0bar"'\'''
test-expr 'date(`%Nbar`)' '"-0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-0bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-0 "'\'''
test-expr 'date(`%N `)' '"-0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-0 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-0 bar"'\'''
test-expr 'date(`%N bar`)' '"-0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-0 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -0"'\'''
test-expr 'date(` %N`)' '" -0"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -0"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -0bar"'\'''
test-expr 'date(` %Nbar`)' '" -0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -0bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -0 "'\'''
test-expr 'date(` %N `)' '" -0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -0 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -0 bar"'\'''
test-expr 'date(` %N bar`)' '" -0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -0 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-0"'\'''
test-expr 'date(`foo%N`)' '"foo-0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-0"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-0bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-0bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-0 "'\'''
test-expr 'date(`foo%N `)' '"foo-0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-0 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-0 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-0 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -0"'\'''
test-expr 'date(`foo %N`)' '"foo -0"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -0"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -0bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -0bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -0bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -0 "'\'''
test-expr 'date(`foo %N `)' '"foo -0 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -0 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -0 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -0 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -0 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-1"'\'''
test-expr 'date(`%N`)' '"-1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-1"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-1bar"'\'''
test-expr 'date(`%Nbar`)' '"-1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-1bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-1 "'\'''
test-expr 'date(`%N `)' '"-1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-1 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-1 bar"'\'''
test-expr 'date(`%N bar`)' '"-1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-1 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -1"'\'''
test-expr 'date(` %N`)' '" -1"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -1"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -1bar"'\'''
test-expr 'date(` %Nbar`)' '" -1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -1bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -1 "'\'''
test-expr 'date(` %N `)' '" -1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -1 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -1 bar"'\'''
test-expr 'date(` %N bar`)' '" -1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -1 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1"'\'''
test-expr 'date(`foo%N`)' '"foo-1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-1"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1 "'\'''
test-expr 'date(`foo%N `)' '"foo-1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-1 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1"'\'''
test-expr 'date(`foo %N`)' '"foo -1"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -1"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -1bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1 "'\'''
test-expr 'date(`foo %N `)' '"foo -1 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -1 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -1 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-999999998"'\'''
test-expr 'date(`%N`)' '"-999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-999999998"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-999999998bar"'\'''
test-expr 'date(`%Nbar`)' '"-999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-999999998bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-999999998 "'\'''
test-expr 'date(`%N `)' '"-999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-999999998 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-999999998 bar"'\'''
test-expr 'date(`%N bar`)' '"-999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-999999998 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -999999998"'\'''
test-expr 'date(` %N`)' '" -999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -999999998"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -999999998bar"'\'''
test-expr 'date(` %Nbar`)' '" -999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -999999998bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -999999998 "'\'''
test-expr 'date(` %N `)' '" -999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -999999998 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -999999998 bar"'\'''
test-expr 'date(` %N bar`)' '" -999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -999999998 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-999999998"'\'''
test-expr 'date(`foo%N`)' '"foo-999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-999999998"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999998bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999998bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-999999998 "'\'''
test-expr 'date(`foo%N `)' '"foo-999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-999999998 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999998 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999998 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -999999998"'\'''
test-expr 'date(`foo %N`)' '"foo -999999998"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -999999998"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999998bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -999999998bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999998bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -999999998 "'\'''
test-expr 'date(`foo %N `)' '"foo -999999998 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -999999998 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999998 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -999999998 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999998 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-999999999"'\'''
test-expr 'date(`%N`)' '"-999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-999999999"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-999999999bar"'\'''
test-expr 'date(`%Nbar`)' '"-999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-999999999bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-999999999 "'\'''
test-expr 'date(`%N `)' '"-999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-999999999 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-999999999 bar"'\'''
test-expr 'date(`%N bar`)' '"-999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-999999999 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -999999999"'\'''
test-expr 'date(` %N`)' '" -999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -999999999"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -999999999bar"'\'''
test-expr 'date(` %Nbar`)' '" -999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -999999999bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -999999999 "'\'''
test-expr 'date(` %N `)' '" -999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -999999999 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -999999999 bar"'\'''
test-expr 'date(` %N bar`)' '" -999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -999999999 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-999999999"'\'''
test-expr 'date(`foo%N`)' '"foo-999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-999999999"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999999bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-999999999bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-999999999 "'\'''
test-expr 'date(`foo%N `)' '"foo-999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-999999999 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999999 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-999999999 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -999999999"'\'''
test-expr 'date(`foo %N`)' '"foo -999999999"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -999999999"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999999bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -999999999bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -999999999bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -999999999 "'\'''
test-expr 'date(`foo %N `)' '"foo -999999999 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -999999999 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999999 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -999999999 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -999999999 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-1000000000"'\'''
test-expr 'date(`%N`)' '"-1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-1000000000"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-1000000000bar"'\'''
test-expr 'date(`%Nbar`)' '"-1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-1000000000bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-1000000000 "'\'''
test-expr 'date(`%N `)' '"-1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-1000000000 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-1000000000 bar"'\'''
test-expr 'date(`%N bar`)' '"-1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-1000000000 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -1000000000"'\'''
test-expr 'date(` %N`)' '" -1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -1000000000"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -1000000000bar"'\'''
test-expr 'date(` %Nbar`)' '" -1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -1000000000bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -1000000000 "'\'''
test-expr 'date(` %N `)' '" -1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -1000000000 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -1000000000 bar"'\'''
test-expr 'date(` %N bar`)' '" -1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -1000000000 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000000"'\'''
test-expr 'date(`foo%N`)' '"foo-1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000000"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000000bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000000bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000000 "'\'''
test-expr 'date(`foo%N `)' '"foo-1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000000 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000000 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000000 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000000"'\'''
test-expr 'date(`foo %N`)' '"foo -1000000000"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000000"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000000bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -1000000000bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000000bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000000 "'\'''
test-expr 'date(`foo %N `)' '"foo -1000000000 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000000 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000000 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -1000000000 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000000 bar"'\'''

echo '$ test-expr '\''date(`%N`)'\'' '\''"-1000000001"'\'''
test-expr 'date(`%N`)' '"-1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N`)'\'' '\''"-1000000001"'\'''

echo '$ test-expr '\''date(`%Nbar`)'\'' '\''"-1000000001bar"'\'''
test-expr 'date(`%Nbar`)' '"-1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%Nbar`)'\'' '\''"-1000000001bar"'\'''

echo '$ test-expr '\''date(`%N `)'\'' '\''"-1000000001 "'\'''
test-expr 'date(`%N `)' '"-1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N `)'\'' '\''"-1000000001 "'\'''

echo '$ test-expr '\''date(`%N bar`)'\'' '\''"-1000000001 bar"'\'''
test-expr 'date(`%N bar`)' '"-1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`%N bar`)'\'' '\''"-1000000001 bar"'\'''

echo '$ test-expr '\''date(` %N`)'\'' '\''" -1000000001"'\'''
test-expr 'date(` %N`)' '" -1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N`)'\'' '\''" -1000000001"'\'''

echo '$ test-expr '\''date(` %Nbar`)'\'' '\''" -1000000001bar"'\'''
test-expr 'date(` %Nbar`)' '" -1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %Nbar`)'\'' '\''" -1000000001bar"'\'''

echo '$ test-expr '\''date(` %N `)'\'' '\''" -1000000001 "'\'''
test-expr 'date(` %N `)' '" -1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N `)'\'' '\''" -1000000001 "'\'''

echo '$ test-expr '\''date(` %N bar`)'\'' '\''" -1000000001 bar"'\'''
test-expr 'date(` %N bar`)' '" -1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(` %N bar`)'\'' '\''" -1000000001 bar"'\'''

echo '$ test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000001"'\'''
test-expr 'date(`foo%N`)' '"foo-1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N`)'\'' '\''"foo-1000000001"'\'''

echo '$ test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000001bar"'\'''
test-expr 'date(`foo%Nbar`)' '"foo-1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%Nbar`)'\'' '\''"foo-1000000001bar"'\'''

echo '$ test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000001 "'\'''
test-expr 'date(`foo%N `)' '"foo-1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N `)'\'' '\''"foo-1000000001 "'\'''

echo '$ test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000001 bar"'\'''
test-expr 'date(`foo%N bar`)' '"foo-1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo%N bar`)'\'' '\''"foo-1000000001 bar"'\'''

echo '$ test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000001"'\'''
test-expr 'date(`foo %N`)' '"foo -1000000001"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N`)'\'' '\''"foo -1000000001"'\'''

echo '$ test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000001bar"'\'''
test-expr 'date(`foo %Nbar`)' '"foo -1000000001bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %Nbar`)'\'' '\''"foo -1000000001bar"'\'''

echo '$ test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000001 "'\'''
test-expr 'date(`foo %N `)' '"foo -1000000001 "' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N `)'\'' '\''"foo -1000000001 "'\'''

echo '$ test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000001 bar"'\'''
test-expr 'date(`foo %N bar`)' '"foo -1000000001 bar"' 2>&1 ||
echo 'command failed: test-expr '\''date(`foo %N bar`)'\'' '\''"foo -1000000001 bar"'\'''
)

