#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C gen-def:expr-dup
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L expr-dup.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ set -o pipefail
$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }
$ json-litex -d '\''{"bar1":"date(long_iso)","bar2":"date(long_iso)"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    const_id(long_iso),
    call_builtin(date)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 2
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(long_iso)"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(long_iso)"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"int(8)","bar2":"int(8)"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    const_num(8),
    call_builtin(int)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 2
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "int(8)"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "int(8)"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"date(`%Y`)","bar2":"date(`%Y`)"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    const_str("%Y"),
    call_builtin(date)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 2
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(`%Y`)"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "date(`%Y`)"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"#`foo`","bar2":"#`foo`"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    count_str("foo")
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 1
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "#`foo`"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "#`foo`"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"#/foo/","bar2":"#/foo/"}'\''
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_object_node_arg_t __9[];
static const struct json_litex_node_t __10;
static const struct json_litex_expr_node_t __3[] = {
    count_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "#/foo/"
    },
    .attr.string = &__4,
    .path = __9 + 0,
    .parent = &__10
};
static const struct json_litex_node_t __6 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "#/foo/"
    },
    .attr.string = &__4,
    .path = __9 + 1,
    .parent = &__10
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __7(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__5;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__6;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __8 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __7
};
static const struct json_litex_object_node_arg_t __9[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__5
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__6
    }
};
static const struct json_litex_node_t __10 = {
    .type = json_litex_object_node_type,
    .attr.object = &__8,
    .node.object = {
        .args = __9,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__10
};
$ json-litex -d '\''{"bar1":"`foo`","bar2":"`foo`"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    match_str("foo")
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 1
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`foo`"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "`foo`"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"/foo/","bar2":"/foo/"}'\''
\#if 0
enum {
  I = SZ(1) << json_litex_expr_rex_opt_ignore_case,
  S = SZ(1) << json_litex_expr_rex_opt_dot_match_all,
  U = SZ(1) << json_litex_expr_rex_opt_no_utf8_check,
  X = SZ(1) << json_litex_expr_rex_opt_extended_pat,
};
\#endif
static const uchar_t __0[] = {
};
\#if 0
static const struct json_litex_expr_rex_t __1[] = {
    {
        .text = (const uchar_t*) "foo"
    }
};
\#endif
static const struct json_litex_expr_rex_def_t __2 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
\#if 0
    .elems = __1,
\#endif
    .size = 1
};
static const struct json_litex_object_node_arg_t __9[];
static const struct json_litex_node_t __10;
static const struct json_litex_expr_node_t __3[] = {
    match_rex(0)
};
static const struct json_litex_expr_def_t __4 = {
    .nodes = __3,
    .size = 1
};
static const struct json_litex_node_t __5 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/foo/"
    },
    .attr.string = &__4,
    .path = __9 + 0,
    .parent = &__10
};
static const struct json_litex_node_t __6 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/foo/"
    },
    .attr.string = &__4,
    .path = __9 + 1,
    .parent = &__10
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __7(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__5;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__6;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __8 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __7
};
static const struct json_litex_object_node_arg_t __9[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__5
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__6
    }
};
static const struct json_litex_node_t __10 = {
    .type = json_litex_object_node_type,
    .attr.object = &__8,
    .node.object = {
        .args = __9,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__2,
    .node = &__10
};
$ json-litex -d '\''{"bar1":"null||string","bar2":"null||string"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    call_builtin(null),
    jump_true(2, false),
    call_builtin(string)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 3
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null||string"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null||string"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"null&&string","bar2":"null&&string"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    call_builtin(null),
    jump_false(2, false),
    call_builtin(string)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 3
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null&&string"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null&&string"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"str&&len","bar2":"str&&len"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    call_builtin(string),
    jump_false(3, false),
    call_builtin(len),
    make_bool()
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 4
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "str&&len"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "str&&len"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"len>0","bar2":"len>0"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    call_builtin(len),
    const_num(0),
    cmp_op(gt)
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 3
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "len>0"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "len>0"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};
$ json-litex -d '\''{"bar1":"!len","bar2":"!len"}'\''
static const struct json_litex_object_node_arg_t __6[];
static const struct json_litex_node_t __7;
static const struct json_litex_expr_node_t __0[] = {
    call_builtin(len),
    not_op()
};
static const struct json_litex_expr_def_t __1 = {
    .nodes = __0,
    .size = 2
};
static const struct json_litex_node_t __2 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "!len"
    },
    .attr.string = &__1,
    .path = __6 + 0,
    .parent = &__7
};
static const struct json_litex_node_t __3 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "!len"
    },
    .attr.string = &__1,
    .path = __6 + 1,
    .parent = &__7
};
static inline bool prefix(
    const char* p, const char* q)
{
    while (*p && *p == *q)
         ++ p, ++ q;
    return *p == 0;
}
static const struct json_litex_node_t* __4(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (prefix("bar", p)) {
        p += 3;
        switch (*p ++) {
        case '\''1'\'':
            if (*p == 0)
                return &__2;
            return NULL;
        case '\''2'\'':
            if (*p == 0)
                return &__3;
        }
    }
    return NULL;
}
static const struct json_litex_object_attr_t __5 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __4
};
static const struct json_litex_object_node_arg_t __6[] = {
    {
        .key = {
            .val = (const uchar_t*) "bar1"
        },
        .val = &__2
    },
    {
        .key = {
            .val = (const uchar_t*) "bar2"
        },
        .val = &__3
    }
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_object_node_type,
    .attr.object = &__5,
    .node.object = {
        .args = __6,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .node = &__7
};'
) -L expr-dup.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'
json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'$'};\n''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'; } 2>&1 ||
echo 'command failed: json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'

echo '$ json-litex -d '\''{"bar1":"date(long_iso)","bar2":"date(long_iso)"}'\'''
json-litex -d '{"bar1":"date(long_iso)","bar2":"date(long_iso)"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"date(long_iso)","bar2":"date(long_iso)"}'\'''

echo '$ json-litex -d '\''{"bar1":"int(8)","bar2":"int(8)"}'\'''
json-litex -d '{"bar1":"int(8)","bar2":"int(8)"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"int(8)","bar2":"int(8)"}'\'''

echo '$ json-litex -d '\''{"bar1":"date(`%Y`)","bar2":"date(`%Y`)"}'\'''
json-litex -d '{"bar1":"date(`%Y`)","bar2":"date(`%Y`)"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"date(`%Y`)","bar2":"date(`%Y`)"}'\'''

echo '$ json-litex -d '\''{"bar1":"#`foo`","bar2":"#`foo`"}'\'''
json-litex -d '{"bar1":"#`foo`","bar2":"#`foo`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"#`foo`","bar2":"#`foo`"}'\'''

echo '$ json-litex -d '\''{"bar1":"#/foo/","bar2":"#/foo/"}'\'''
json-litex -d '{"bar1":"#/foo/","bar2":"#/foo/"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"#/foo/","bar2":"#/foo/"}'\'''

echo '$ json-litex -d '\''{"bar1":"`foo`","bar2":"`foo`"}'\'''
json-litex -d '{"bar1":"`foo`","bar2":"`foo`"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"`foo`","bar2":"`foo`"}'\'''

echo '$ json-litex -d '\''{"bar1":"/foo/","bar2":"/foo/"}'\'''
json-litex -d '{"bar1":"/foo/","bar2":"/foo/"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"/foo/","bar2":"/foo/"}'\'''

echo '$ json-litex -d '\''{"bar1":"null||string","bar2":"null||string"}'\'''
json-litex -d '{"bar1":"null||string","bar2":"null||string"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"null||string","bar2":"null||string"}'\'''

echo '$ json-litex -d '\''{"bar1":"null&&string","bar2":"null&&string"}'\'''
json-litex -d '{"bar1":"null&&string","bar2":"null&&string"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"null&&string","bar2":"null&&string"}'\'''

echo '$ json-litex -d '\''{"bar1":"str&&len","bar2":"str&&len"}'\'''
json-litex -d '{"bar1":"str&&len","bar2":"str&&len"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"str&&len","bar2":"str&&len"}'\'''

echo '$ json-litex -d '\''{"bar1":"len>0","bar2":"len>0"}'\'''
json-litex -d '{"bar1":"len>0","bar2":"len>0"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"len>0","bar2":"len>0"}'\'''

echo '$ json-litex -d '\''{"bar1":"!len","bar2":"!len"}'\'''
json-litex -d '{"bar1":"!len","bar2":"!len"}' 2>&1 ||
echo 'command failed: json-litex -d '\''{"bar1":"!len","bar2":"!len"}'\'''
)

