#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C gen-def:sobj-litex-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L sobj-litex-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ set -o pipefail
$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }
$ json-litex ../lib/test-litex.so
static const uchar_t __0[] = {
};
static const struct json_litex_expr_rex_def_t __1 = {
    .codes = {
        .type = json_litex_expr_rex_codes_streams,
        .code.streams = {
            .bytes = __0,
            .size = 0
        }
    },
    .size = 2
};
static const struct json_litex_object_node_arg_t __32[];
static const struct json_litex_node_t __33;
static const struct json_litex_object_node_arg_t __21[];
static const struct json_litex_node_t __22;
static const struct json_litex_node_t __18;
static const struct json_litex_expr_node_t __2[] = {
    match_rex(0),
    jump_false(4, false),
    const_num(1),
    count_str("\n"),
    cmp_op(ge)
};
static const struct json_litex_expr_def_t __3 = {
    .nodes = __2,
    .size = 5
};
static const struct json_litex_node_t __4 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "/^[[:ascii:]]*$/ && #`\n` <= 1"
    },
    .attr.string = &__3,
    .parent = &__18
};
static const struct json_litex_object_node_arg_t __14[];
static const struct json_litex_node_t __15;
static const struct json_litex_object_node_arg_t __10[];
static const struct json_litex_node_t __11;
static const struct json_litex_expr_node_t __5[] = {
    call_builtin(null),
    jump_true(6, false),
    match_rex(1),
    jump_false(4, false),
    count_str("x"),
    count_str("y"),
    cmp_op(lt)
};
static const struct json_litex_expr_def_t __6 = {
    .nodes = __5,
    .size = 7
};
static const struct json_litex_node_t __7 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || /^x+y+$/ && #`x` < #`y`"
    },
    .attr.string = &__6,
    .path = __10 + 0,
    .parent = &__11
};
static const struct json_litex_node_t* __8(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''d'\'' &&
        *p == 0)
        return &__7;
    return NULL;
}
static const struct json_litex_object_attr_t __9 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __8
};
static const struct json_litex_object_node_arg_t __10[] = {
    {
        .key = {
            .val = (const uchar_t*) "d"
        },
        .val = &__7
    }
};
static const struct json_litex_node_t __11 = {
    .type = json_litex_object_node_type,
    .attr.object = &__9,
    .node.object = {
        .args = __10,
        .size = 1
    },
    .path = __14 + 0,
    .parent = &__15
};
static const struct json_litex_node_t* __12(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''c'\'' &&
        *p == 0)
        return &__11;
    return NULL;
}
static const struct json_litex_object_attr_t __13 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __12
};
static const struct json_litex_object_node_arg_t __14[] = {
    {
        .key = {
            .val = (const uchar_t*) "c"
        },
        .val = &__11
    }
};
static const struct json_litex_node_t __15 = {
    .type = json_litex_object_node_type,
    .attr.object = &__13,
    .node.object = {
        .args = __14,
        .size = 1
    },
    .parent = &__18
};
static const struct json_litex_array_attr_t __16 = {
    .string = &__4,
    .object = &__15
};
static const struct json_litex_node_t* __17[] = {
    &__4,
    &__15,
    NULL
};
static const struct json_litex_node_t __18 = {
    .type = json_litex_array_node_type,
    .attr.array = &__16,
    .node.array = {
        .args = __17,
        .size = 2
    },
    .path = __21 + 0,
    .parent = &__22
};
static const struct json_litex_node_t* __19(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''b'\'' &&
        *p == 0)
        return &__18;
    return NULL;
}
static const struct json_litex_object_attr_t __20 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __19
};
static const struct json_litex_object_node_arg_t __21[] = {
    {
        .key = {
            .val = (const uchar_t*) "b"
        },
        .val = &__18
    }
};
static const struct json_litex_node_t __22 = {
    .type = json_litex_object_node_type,
    .attr.object = &__20,
    .node.object = {
        .args = __21,
        .size = 1
    },
    .path = __32 + 0,
    .parent = &__33
};
static const struct json_litex_object_node_arg_t __28[];
static const struct json_litex_node_t __29;
static const struct json_litex_expr_node_t __23[] = {
    call_builtin(null),
    jump_true(3, false),
    const_str("%Y-%m-%d"),
    call_builtin(date)
};
static const struct json_litex_expr_def_t __24 = {
    .nodes = __23,
    .size = 4
};
static const struct json_litex_node_t __25 = {
    .type = json_litex_string_node_type,
    .node.string = {
        .val = (const uchar_t*) "null || date(`%Y-%m-%d`)"
    },
    .attr.string = &__24,
    .path = __28 + 0,
    .parent = &__29
};
static const struct json_litex_node_t* __26(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    if (*p ++ == '\''d'\'' &&
        *p == 0)
        return &__25;
    return NULL;
}
static const struct json_litex_object_attr_t __27 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __26
};
static const struct json_litex_object_node_arg_t __28[] = {
    {
        .key = {
            .val = (const uchar_t*) "d"
        },
        .val = &__25
    }
};
static const struct json_litex_node_t __29 = {
    .type = json_litex_object_node_type,
    .attr.object = &__27,
    .node.object = {
        .args = __28,
        .size = 1
    },
    .path = __32 + 1,
    .parent = &__33
};
static const struct json_litex_node_t* __30(
    const struct json_litex_trie_node_t* n UNUSED,
    const char* p)
{
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return &__22;
        return NULL;
    case '\''c'\'':
        if (*p == 0)
            return &__29;
    }
    return NULL;
}
static const struct json_litex_object_attr_t __31 = {
    .lookup = (json_litex_object_attr_lookup_func_t) __30
};
static const struct json_litex_object_node_arg_t __32[] = {
    {
        .key = {
            .val = (const uchar_t*) "a"
        },
        .val = &__22
    },
    {
        .key = {
            .val = (const uchar_t*) "c"
        },
        .val = &__29
    }
};
static const struct json_litex_node_t __33 = {
    .type = json_litex_object_node_type,
    .attr.object = &__31,
    .node.object = {
        .args = __32,
        .size = 2
    }
};
static const struct json_litex_def_t MODULE_LITEX_DEF = {
    .rexes = &__1,
    .node = &__33
};'
) -L sobj-litex-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'
json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r 's/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'$'};\n''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'; } 2>&1 ||
echo 'command failed: json-litex() {  LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -D "$@"|sed -r '\''s/^#/\\#/;/^\s*\/\//d;/^\s*$/d;/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/{p;i'\''$'\''};\n'\'''\''};/^static\s+const\s+uchar_t\s+__0\s*\[\s*\]\s*=\s*\{\s*$/,/^\}\s*;\s*$/d;/^\s+\.bytes\s*=\s*__0\s*,\s*$/!b;n;/^\s*\.size\s*=\s*[0-9]+\s*$/s/[0-9]+/0/'\''; }'

echo '$ json-litex ../lib/test-litex.so'
json-litex ../lib/test-litex.so 2>&1 ||
echo 'command failed: json-litex ../lib/test-litex.so'
)

