#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number10
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number10.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ json <<< 1.1.1
json: error: <stdin>:1:4: lex error: invalid char
json: error: <stdin>:1:4: 1.1.1
json: error: <stdin>:1:4:    ^
1.1
command failed: json <<< 1.1.1
$ json <<< 1.1e1e1
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: 1.1e1e1
json: error: <stdin>:1:6:      ^
1.1e1
command failed: json <<< 1.1e1e1'
) -L number10.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ json <<< 1.1.1'
json <<< 1.1.1 2>&1 ||
echo 'command failed: json <<< 1.1.1'

echo '$ json <<< 1.1e1e1'
json <<< 1.1e1e1 2>&1 ||
echo 'command failed: json <<< 1.1e1e1'
)

