#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:object2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L object2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --parse "$@"; }
$ json <<< '\''{'\''
json: error: <stdin>:2:1: parse error: unexpected token
json: error: <stdin>:2:1: {
json: error: <stdin>:2:1:  ^
command failed: json <<< '\''{'\''
$ json <<< '\''}'\''
json: error: <stdin>:1:1: parse error: unexpected token
json: error: <stdin>:1:1: }
json: error: <stdin>:1:1: ^
command failed: json <<< '\''}'\''
$ json <<< '\''{,}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {,}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{,}'\''
$ json <<< '\''{:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{:0}'\''
$ json <<< '\''{null:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {null:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{null:0}'\''
$ json <<< '\''{false:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {false:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{false:0}'\''
$ json <<< '\''{true:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {true:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{true:0}'\''
$ json <<< '\''{123:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {123:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{123:0}'\''
$ json <<< '\''{{}:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {{}:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{{}:0}'\''
$ json <<< '\''{[]:0}'\''
json: error: <stdin>:1:2: parse error: unexpected token
json: error: <stdin>:1:2: {[]:0}
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''{[]:0}'\''
$ json <<< '\''{"foo":}'\''
json: error: <stdin>:1:8: parse error: unexpected token
json: error: <stdin>:1:8: {"foo":}
json: error: <stdin>:1:8:        ^
command failed: json <<< '\''{"foo":}'\''
$ json <<< '\''{"foo",}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo",}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo",}'\''
$ json <<< '\''{"foo"null}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"null}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"null}'\''
$ json <<< '\''{"foo"false}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"false}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"false}'\''
$ json <<< '\''{"foo"true}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"true}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"true}'\''
$ json <<< '\''{"foo"123}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"123}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"123}'\''
$ json <<< '\''{"foo"{}}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"{}}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"{}}'\''
$ json <<< '\''{"foo"[]}'\''
json: error: <stdin>:1:7: parse error: unexpected token
json: error: <stdin>:1:7: {"foo"[]}
json: error: <stdin>:1:7:       ^
command failed: json <<< '\''{"foo"[]}'\''
$ json <<< '\''{"foo":null,}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":null,}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":null,}'\''
$ json <<< '\''{"foo":false,}'\''
json: error: <stdin>:1:14: parse error: unexpected token
json: error: <stdin>:1:14: {"foo":false,}
json: error: <stdin>:1:14:              ^
command failed: json <<< '\''{"foo":false,}'\''
$ json <<< '\''{"foo":true,}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":true,}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":true,}'\''
$ json <<< '\''{"foo":123,}'\''
json: error: <stdin>:1:12: parse error: unexpected token
json: error: <stdin>:1:12: {"foo":123,}
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''{"foo":123,}'\''
$ json <<< '\''{"foo":{},}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":{},}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":{},}'\''
$ json <<< '\''{"foo":[],}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":[],}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":[],}'\''
$ json <<< '\''{"foo":null null}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":null null}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":null null}'\''
$ json <<< '\''{"foo":false true}'\''
json: error: <stdin>:1:14: parse error: unexpected token
json: error: <stdin>:1:14: {"foo":false true}
json: error: <stdin>:1:14:              ^
command failed: json <<< '\''{"foo":false true}'\''
$ json <<< '\''{"foo":true false}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":true false}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":true false}'\''
$ json <<< '\''{"foo":123 321}'\''
json: error: <stdin>:1:12: parse error: unexpected token
json: error: <stdin>:1:12: {"foo":123 321}
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''{"foo":123 321}'\''
$ json <<< '\''{"foo":{} []}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":{} []}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":{} []}'\''
$ json <<< '\''{"foo":[] {}}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":[] {}}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":[] {}}'\''
$ json <<< '\''{"foo":null,null}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":null,null}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":null,null}'\''
$ json <<< '\''{"foo":false,true}'\''
json: error: <stdin>:1:14: parse error: unexpected token
json: error: <stdin>:1:14: {"foo":false,true}
json: error: <stdin>:1:14:              ^
command failed: json <<< '\''{"foo":false,true}'\''
$ json <<< '\''{"foo":true,false}'\''
json: error: <stdin>:1:13: parse error: unexpected token
json: error: <stdin>:1:13: {"foo":true,false}
json: error: <stdin>:1:13:             ^
command failed: json <<< '\''{"foo":true,false}'\''
$ json <<< '\''{"foo":123,321}'\''
json: error: <stdin>:1:12: parse error: unexpected token
json: error: <stdin>:1:12: {"foo":123,321}
json: error: <stdin>:1:12:            ^
command failed: json <<< '\''{"foo":123,321}'\''
$ json <<< '\''{"foo":{},[]}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":{},[]}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":{},[]}'\''
$ json <<< '\''{"foo":[],{}}'\''
json: error: <stdin>:1:11: parse error: unexpected token
json: error: <stdin>:1:11: {"foo":[],{}}
json: error: <stdin>:1:11:           ^
command failed: json <<< '\''{"foo":[],{}}'\'''
) -L object2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --parse "$@"; }'
json() { json0 --parse "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --parse "$@"; }'

echo '$ json <<< '\''{'\'''
json <<< '{' 2>&1 ||
echo 'command failed: json <<< '\''{'\'''

echo '$ json <<< '\''}'\'''
json <<< '}' 2>&1 ||
echo 'command failed: json <<< '\''}'\'''

echo '$ json <<< '\''{,}'\'''
json <<< '{,}' 2>&1 ||
echo 'command failed: json <<< '\''{,}'\'''

echo '$ json <<< '\''{:0}'\'''
json <<< '{:0}' 2>&1 ||
echo 'command failed: json <<< '\''{:0}'\'''

echo '$ json <<< '\''{null:0}'\'''
json <<< '{null:0}' 2>&1 ||
echo 'command failed: json <<< '\''{null:0}'\'''

echo '$ json <<< '\''{false:0}'\'''
json <<< '{false:0}' 2>&1 ||
echo 'command failed: json <<< '\''{false:0}'\'''

echo '$ json <<< '\''{true:0}'\'''
json <<< '{true:0}' 2>&1 ||
echo 'command failed: json <<< '\''{true:0}'\'''

echo '$ json <<< '\''{123:0}'\'''
json <<< '{123:0}' 2>&1 ||
echo 'command failed: json <<< '\''{123:0}'\'''

echo '$ json <<< '\''{{}:0}'\'''
json <<< '{{}:0}' 2>&1 ||
echo 'command failed: json <<< '\''{{}:0}'\'''

echo '$ json <<< '\''{[]:0}'\'''
json <<< '{[]:0}' 2>&1 ||
echo 'command failed: json <<< '\''{[]:0}'\'''

echo '$ json <<< '\''{"foo":}'\'''
json <<< '{"foo":}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":}'\'''

echo '$ json <<< '\''{"foo",}'\'''
json <<< '{"foo",}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo",}'\'''

echo '$ json <<< '\''{"foo"null}'\'''
json <<< '{"foo"null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"null}'\'''

echo '$ json <<< '\''{"foo"false}'\'''
json <<< '{"foo"false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"false}'\'''

echo '$ json <<< '\''{"foo"true}'\'''
json <<< '{"foo"true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"true}'\'''

echo '$ json <<< '\''{"foo"123}'\'''
json <<< '{"foo"123}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"123}'\'''

echo '$ json <<< '\''{"foo"{}}'\'''
json <<< '{"foo"{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"{}}'\'''

echo '$ json <<< '\''{"foo"[]}'\'''
json <<< '{"foo"[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo"[]}'\'''

echo '$ json <<< '\''{"foo":null,}'\'''
json <<< '{"foo":null,}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,}'\'''

echo '$ json <<< '\''{"foo":false,}'\'''
json <<< '{"foo":false,}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false,}'\'''

echo '$ json <<< '\''{"foo":true,}'\'''
json <<< '{"foo":true,}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true,}'\'''

echo '$ json <<< '\''{"foo":123,}'\'''
json <<< '{"foo":123,}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":123,}'\'''

echo '$ json <<< '\''{"foo":{},}'\'''
json <<< '{"foo":{},}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{},}'\'''

echo '$ json <<< '\''{"foo":[],}'\'''
json <<< '{"foo":[],}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[],}'\'''

echo '$ json <<< '\''{"foo":null null}'\'''
json <<< '{"foo":null null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null null}'\'''

echo '$ json <<< '\''{"foo":false true}'\'''
json <<< '{"foo":false true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false true}'\'''

echo '$ json <<< '\''{"foo":true false}'\'''
json <<< '{"foo":true false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true false}'\'''

echo '$ json <<< '\''{"foo":123 321}'\'''
json <<< '{"foo":123 321}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":123 321}'\'''

echo '$ json <<< '\''{"foo":{} []}'\'''
json <<< '{"foo":{} []}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{} []}'\'''

echo '$ json <<< '\''{"foo":[] {}}'\'''
json <<< '{"foo":[] {}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[] {}}'\'''

echo '$ json <<< '\''{"foo":null,null}'\'''
json <<< '{"foo":null,null}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":null,null}'\'''

echo '$ json <<< '\''{"foo":false,true}'\'''
json <<< '{"foo":false,true}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":false,true}'\'''

echo '$ json <<< '\''{"foo":true,false}'\'''
json <<< '{"foo":true,false}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":true,false}'\'''

echo '$ json <<< '\''{"foo":123,321}'\'''
json <<< '{"foo":123,321}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":123,321}'\'''

echo '$ json <<< '\''{"foo":{},[]}'\'''
json <<< '{"foo":{},[]}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":{},[]}'\'''

echo '$ json <<< '\''{"foo":[],{}}'\'''
json <<< '{"foo":[],{}}' 2>&1 ||
echo 'command failed: json <<< '\''{"foo":[],{}}'\'''
)

