#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-surrogate-pairs
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-surrogate-pairs.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --parse-only --validate-utf8 --surrogate-pairs "$@"; }
$ echo -n '\''"\ud800"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 1
$ echo -n '\''"\ud800"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 2
$ echo -n '\''"\ud800"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 3
$ echo -n '\''"\ud800"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 4
$ echo -n '\''"\ud800"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 5
$ echo -n '\''"\ud800"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 6
$ echo -n '\''"\ud800"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 7
$ echo -n '\''"\ud800"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud800"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud800"'\''|json -b 8
$ echo -n '\''"\ud803"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 1
$ echo -n '\''"\ud803"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 2
$ echo -n '\''"\ud803"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 3
$ echo -n '\''"\ud803"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 4
$ echo -n '\''"\ud803"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 5
$ echo -n '\''"\ud803"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 6
$ echo -n '\''"\ud803"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 7
$ echo -n '\''"\ud803"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud803"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud803"'\''|json -b 8
$ echo -n '\''"\ud8bc"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 1
$ echo -n '\''"\ud8bc"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 2
$ echo -n '\''"\ud8bc"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 3
$ echo -n '\''"\ud8bc"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 4
$ echo -n '\''"\ud8bc"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 5
$ echo -n '\''"\ud8bc"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 6
$ echo -n '\''"\ud8bc"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 7
$ echo -n '\''"\ud8bc"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bc"'\''|json -b 8
$ echo -n '\''"\ud8bf"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 1
$ echo -n '\''"\ud8bf"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 2
$ echo -n '\''"\ud8bf"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 3
$ echo -n '\''"\ud8bf"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 4
$ echo -n '\''"\ud8bf"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 5
$ echo -n '\''"\ud8bf"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 6
$ echo -n '\''"\ud8bf"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 7
$ echo -n '\''"\ud8bf"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8bf"'\''|json -b 8
$ echo -n '\''"\ud8c0"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 1
$ echo -n '\''"\ud8c0"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 2
$ echo -n '\''"\ud8c0"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 3
$ echo -n '\''"\ud8c0"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 4
$ echo -n '\''"\ud8c0"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 5
$ echo -n '\''"\ud8c0"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 6
$ echo -n '\''"\ud8c0"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 7
$ echo -n '\''"\ud8c0"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c0"'\''|json -b 8
$ echo -n '\''"\ud8c3"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 1
$ echo -n '\''"\ud8c3"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 2
$ echo -n '\''"\ud8c3"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 3
$ echo -n '\''"\ud8c3"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 4
$ echo -n '\''"\ud8c3"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 5
$ echo -n '\''"\ud8c3"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 6
$ echo -n '\''"\ud8c3"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 7
$ echo -n '\''"\ud8c3"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud8c3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud8c3"'\''|json -b 8
$ echo -n '\''"\ud9bc"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 1
$ echo -n '\''"\ud9bc"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 2
$ echo -n '\''"\ud9bc"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 3
$ echo -n '\''"\ud9bc"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 4
$ echo -n '\''"\ud9bc"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 5
$ echo -n '\''"\ud9bc"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 6
$ echo -n '\''"\ud9bc"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 7
$ echo -n '\''"\ud9bc"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bc"'\''|json -b 8
$ echo -n '\''"\ud9bf"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 1
$ echo -n '\''"\ud9bf"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 2
$ echo -n '\''"\ud9bf"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 3
$ echo -n '\''"\ud9bf"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 4
$ echo -n '\''"\ud9bf"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 5
$ echo -n '\''"\ud9bf"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 6
$ echo -n '\''"\ud9bf"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 7
$ echo -n '\''"\ud9bf"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\ud9bf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\ud9bf"'\''|json -b 8
$ echo -n '\''"\udac0"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 1
$ echo -n '\''"\udac0"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 2
$ echo -n '\''"\udac0"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 3
$ echo -n '\''"\udac0"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 4
$ echo -n '\''"\udac0"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 5
$ echo -n '\''"\udac0"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 6
$ echo -n '\''"\udac0"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 7
$ echo -n '\''"\udac0"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac0"'\''|json -b 8
$ echo -n '\''"\udac3"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 1
$ echo -n '\''"\udac3"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 2
$ echo -n '\''"\udac3"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 3
$ echo -n '\''"\udac3"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 4
$ echo -n '\''"\udac3"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 5
$ echo -n '\''"\udac3"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 6
$ echo -n '\''"\udac3"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 7
$ echo -n '\''"\udac3"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udac3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udac3"'\''|json -b 8
$ echo -n '\''"\udbbc"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 1
$ echo -n '\''"\udbbc"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 2
$ echo -n '\''"\udbbc"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 3
$ echo -n '\''"\udbbc"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 4
$ echo -n '\''"\udbbc"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 5
$ echo -n '\''"\udbbc"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 6
$ echo -n '\''"\udbbc"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 7
$ echo -n '\''"\udbbc"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbc"'\''|json -b 8
$ echo -n '\''"\udbbf"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 1
$ echo -n '\''"\udbbf"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 2
$ echo -n '\''"\udbbf"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 3
$ echo -n '\''"\udbbf"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 4
$ echo -n '\''"\udbbf"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 5
$ echo -n '\''"\udbbf"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 6
$ echo -n '\''"\udbbf"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 7
$ echo -n '\''"\udbbf"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbbf"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbbf"'\''|json -b 8
$ echo -n '\''"\udbc0"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 1
$ echo -n '\''"\udbc0"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 2
$ echo -n '\''"\udbc0"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 3
$ echo -n '\''"\udbc0"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 4
$ echo -n '\''"\udbc0"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 5
$ echo -n '\''"\udbc0"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 6
$ echo -n '\''"\udbc0"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 7
$ echo -n '\''"\udbc0"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc0"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc0"'\''|json -b 8
$ echo -n '\''"\udbc3"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 1
$ echo -n '\''"\udbc3"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 2
$ echo -n '\''"\udbc3"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 3
$ echo -n '\''"\udbc3"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 4
$ echo -n '\''"\udbc3"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 5
$ echo -n '\''"\udbc3"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 6
$ echo -n '\''"\udbc3"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 7
$ echo -n '\''"\udbc3"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbc3"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbc3"'\''|json -b 8
$ echo -n '\''"\udbfc"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 1
$ echo -n '\''"\udbfc"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 2
$ echo -n '\''"\udbfc"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 3
$ echo -n '\''"\udbfc"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 4
$ echo -n '\''"\udbfc"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 5
$ echo -n '\''"\udbfc"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 6
$ echo -n '\''"\udbfc"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 7
$ echo -n '\''"\udbfc"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbfc"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbfc"'\''|json -b 8
$ echo -n '\''"\udbff"'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 1
$ echo -n '\''"\udbff"'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 2
$ echo -n '\''"\udbff"'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 3
$ echo -n '\''"\udbff"'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 4
$ echo -n '\''"\udbff"'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 5
$ echo -n '\''"\udbff"'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 6
$ echo -n '\''"\udbff"'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 7
$ echo -n '\''"\udbff"'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\udbff"
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\udbff"'\''|json -b 8
$ echo -n '\''"\udc00"'\''|json -b 1
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 1
$ echo -n '\''"\udc00"'\''|json -b 2
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 2
$ echo -n '\''"\udc00"'\''|json -b 3
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 3
$ echo -n '\''"\udc00"'\''|json -b 4
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 4
$ echo -n '\''"\udc00"'\''|json -b 5
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 5
$ echo -n '\''"\udc00"'\''|json -b 6
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 6
$ echo -n '\''"\udc00"'\''|json -b 7
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 7
$ echo -n '\''"\udc00"'\''|json -b 8
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc00"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc00"'\''|json -b 8
$ echo -n '\''"\udc3f"'\''|json -b 1
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 1
$ echo -n '\''"\udc3f"'\''|json -b 2
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 2
$ echo -n '\''"\udc3f"'\''|json -b 3
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 3
$ echo -n '\''"\udc3f"'\''|json -b 4
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 4
$ echo -n '\''"\udc3f"'\''|json -b 5
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 5
$ echo -n '\''"\udc3f"'\''|json -b 6
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 6
$ echo -n '\''"\udc3f"'\''|json -b 7
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 7
$ echo -n '\''"\udc3f"'\''|json -b 8
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udc3f"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udc3f"'\''|json -b 8
$ echo -n '\''"\udfc0"'\''|json -b 1
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 1
$ echo -n '\''"\udfc0"'\''|json -b 2
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 2
$ echo -n '\''"\udfc0"'\''|json -b 3
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 3
$ echo -n '\''"\udfc0"'\''|json -b 4
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 4
$ echo -n '\''"\udfc0"'\''|json -b 5
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 5
$ echo -n '\''"\udfc0"'\''|json -b 6
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 6
$ echo -n '\''"\udfc0"'\''|json -b 7
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 7
$ echo -n '\''"\udfc0"'\''|json -b 8
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfc0"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfc0"'\''|json -b 8
$ echo -n '\''"\udfff"'\''|json -b 1
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 1
$ echo -n '\''"\udfff"'\''|json -b 2
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 2
$ echo -n '\''"\udfff"'\''|json -b 3
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 3
$ echo -n '\''"\udfff"'\''|json -b 4
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 4
$ echo -n '\''"\udfff"'\''|json -b 5
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 5
$ echo -n '\''"\udfff"'\''|json -b 6
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 6
$ echo -n '\''"\udfff"'\''|json -b 7
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 7
$ echo -n '\''"\udfff"'\''|json -b 8
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\udfff"
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\udfff"'\''|json -b 8'
) -L string-surrogate-pairs.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --parse-only --validate-utf8 --surrogate-pairs "$@"; }'
json() { json0 --literal-value --parse-only --validate-utf8 --surrogate-pairs "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --parse-only --validate-utf8 --surrogate-pairs "$@"; }'

echo '$ echo -n '\''"\ud800"'\''|json -b 1'
echo -n '"\ud800"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 1'

echo '$ echo -n '\''"\ud800"'\''|json -b 2'
echo -n '"\ud800"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 2'

echo '$ echo -n '\''"\ud800"'\''|json -b 3'
echo -n '"\ud800"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 3'

echo '$ echo -n '\''"\ud800"'\''|json -b 4'
echo -n '"\ud800"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 4'

echo '$ echo -n '\''"\ud800"'\''|json -b 5'
echo -n '"\ud800"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 5'

echo '$ echo -n '\''"\ud800"'\''|json -b 6'
echo -n '"\ud800"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 6'

echo '$ echo -n '\''"\ud800"'\''|json -b 7'
echo -n '"\ud800"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 7'

echo '$ echo -n '\''"\ud800"'\''|json -b 8'
echo -n '"\ud800"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud800"'\''|json -b 8'

echo '$ echo -n '\''"\ud803"'\''|json -b 1'
echo -n '"\ud803"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 1'

echo '$ echo -n '\''"\ud803"'\''|json -b 2'
echo -n '"\ud803"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 2'

echo '$ echo -n '\''"\ud803"'\''|json -b 3'
echo -n '"\ud803"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 3'

echo '$ echo -n '\''"\ud803"'\''|json -b 4'
echo -n '"\ud803"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 4'

echo '$ echo -n '\''"\ud803"'\''|json -b 5'
echo -n '"\ud803"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 5'

echo '$ echo -n '\''"\ud803"'\''|json -b 6'
echo -n '"\ud803"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 6'

echo '$ echo -n '\''"\ud803"'\''|json -b 7'
echo -n '"\ud803"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 7'

echo '$ echo -n '\''"\ud803"'\''|json -b 8'
echo -n '"\ud803"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud803"'\''|json -b 8'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 1'
echo -n '"\ud8bc"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 1'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 2'
echo -n '"\ud8bc"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 2'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 3'
echo -n '"\ud8bc"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 3'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 4'
echo -n '"\ud8bc"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 4'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 5'
echo -n '"\ud8bc"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 5'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 6'
echo -n '"\ud8bc"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 6'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 7'
echo -n '"\ud8bc"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 7'

echo '$ echo -n '\''"\ud8bc"'\''|json -b 8'
echo -n '"\ud8bc"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bc"'\''|json -b 8'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 1'
echo -n '"\ud8bf"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 1'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 2'
echo -n '"\ud8bf"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 2'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 3'
echo -n '"\ud8bf"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 3'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 4'
echo -n '"\ud8bf"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 4'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 5'
echo -n '"\ud8bf"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 5'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 6'
echo -n '"\ud8bf"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 6'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 7'
echo -n '"\ud8bf"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 7'

echo '$ echo -n '\''"\ud8bf"'\''|json -b 8'
echo -n '"\ud8bf"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud8bf"'\''|json -b 8'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 1'
echo -n '"\ud8c0"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 1'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 2'
echo -n '"\ud8c0"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 2'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 3'
echo -n '"\ud8c0"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 3'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 4'
echo -n '"\ud8c0"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 4'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 5'
echo -n '"\ud8c0"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 5'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 6'
echo -n '"\ud8c0"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 6'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 7'
echo -n '"\ud8c0"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 7'

echo '$ echo -n '\''"\ud8c0"'\''|json -b 8'
echo -n '"\ud8c0"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c0"'\''|json -b 8'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 1'
echo -n '"\ud8c3"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 1'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 2'
echo -n '"\ud8c3"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 2'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 3'
echo -n '"\ud8c3"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 3'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 4'
echo -n '"\ud8c3"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 4'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 5'
echo -n '"\ud8c3"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 5'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 6'
echo -n '"\ud8c3"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 6'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 7'
echo -n '"\ud8c3"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 7'

echo '$ echo -n '\''"\ud8c3"'\''|json -b 8'
echo -n '"\ud8c3"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud8c3"'\''|json -b 8'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 1'
echo -n '"\ud9bc"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 1'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 2'
echo -n '"\ud9bc"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 2'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 3'
echo -n '"\ud9bc"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 3'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 4'
echo -n '"\ud9bc"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 4'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 5'
echo -n '"\ud9bc"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 5'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 6'
echo -n '"\ud9bc"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 6'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 7'
echo -n '"\ud9bc"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 7'

echo '$ echo -n '\''"\ud9bc"'\''|json -b 8'
echo -n '"\ud9bc"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bc"'\''|json -b 8'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 1'
echo -n '"\ud9bf"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 1'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 2'
echo -n '"\ud9bf"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 2'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 3'
echo -n '"\ud9bf"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 3'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 4'
echo -n '"\ud9bf"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 4'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 5'
echo -n '"\ud9bf"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 5'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 6'
echo -n '"\ud9bf"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 6'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 7'
echo -n '"\ud9bf"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 7'

echo '$ echo -n '\''"\ud9bf"'\''|json -b 8'
echo -n '"\ud9bf"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\ud9bf"'\''|json -b 8'

echo '$ echo -n '\''"\udac0"'\''|json -b 1'
echo -n '"\udac0"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 1'

echo '$ echo -n '\''"\udac0"'\''|json -b 2'
echo -n '"\udac0"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 2'

echo '$ echo -n '\''"\udac0"'\''|json -b 3'
echo -n '"\udac0"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 3'

echo '$ echo -n '\''"\udac0"'\''|json -b 4'
echo -n '"\udac0"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 4'

echo '$ echo -n '\''"\udac0"'\''|json -b 5'
echo -n '"\udac0"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 5'

echo '$ echo -n '\''"\udac0"'\''|json -b 6'
echo -n '"\udac0"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 6'

echo '$ echo -n '\''"\udac0"'\''|json -b 7'
echo -n '"\udac0"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 7'

echo '$ echo -n '\''"\udac0"'\''|json -b 8'
echo -n '"\udac0"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udac0"'\''|json -b 8'

echo '$ echo -n '\''"\udac3"'\''|json -b 1'
echo -n '"\udac3"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 1'

echo '$ echo -n '\''"\udac3"'\''|json -b 2'
echo -n '"\udac3"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 2'

echo '$ echo -n '\''"\udac3"'\''|json -b 3'
echo -n '"\udac3"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 3'

echo '$ echo -n '\''"\udac3"'\''|json -b 4'
echo -n '"\udac3"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 4'

echo '$ echo -n '\''"\udac3"'\''|json -b 5'
echo -n '"\udac3"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 5'

echo '$ echo -n '\''"\udac3"'\''|json -b 6'
echo -n '"\udac3"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 6'

echo '$ echo -n '\''"\udac3"'\''|json -b 7'
echo -n '"\udac3"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 7'

echo '$ echo -n '\''"\udac3"'\''|json -b 8'
echo -n '"\udac3"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udac3"'\''|json -b 8'

echo '$ echo -n '\''"\udbbc"'\''|json -b 1'
echo -n '"\udbbc"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 1'

echo '$ echo -n '\''"\udbbc"'\''|json -b 2'
echo -n '"\udbbc"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 2'

echo '$ echo -n '\''"\udbbc"'\''|json -b 3'
echo -n '"\udbbc"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 3'

echo '$ echo -n '\''"\udbbc"'\''|json -b 4'
echo -n '"\udbbc"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 4'

echo '$ echo -n '\''"\udbbc"'\''|json -b 5'
echo -n '"\udbbc"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 5'

echo '$ echo -n '\''"\udbbc"'\''|json -b 6'
echo -n '"\udbbc"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 6'

echo '$ echo -n '\''"\udbbc"'\''|json -b 7'
echo -n '"\udbbc"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 7'

echo '$ echo -n '\''"\udbbc"'\''|json -b 8'
echo -n '"\udbbc"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbbc"'\''|json -b 8'

echo '$ echo -n '\''"\udbbf"'\''|json -b 1'
echo -n '"\udbbf"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 1'

echo '$ echo -n '\''"\udbbf"'\''|json -b 2'
echo -n '"\udbbf"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 2'

echo '$ echo -n '\''"\udbbf"'\''|json -b 3'
echo -n '"\udbbf"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 3'

echo '$ echo -n '\''"\udbbf"'\''|json -b 4'
echo -n '"\udbbf"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 4'

echo '$ echo -n '\''"\udbbf"'\''|json -b 5'
echo -n '"\udbbf"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 5'

echo '$ echo -n '\''"\udbbf"'\''|json -b 6'
echo -n '"\udbbf"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 6'

echo '$ echo -n '\''"\udbbf"'\''|json -b 7'
echo -n '"\udbbf"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 7'

echo '$ echo -n '\''"\udbbf"'\''|json -b 8'
echo -n '"\udbbf"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbbf"'\''|json -b 8'

echo '$ echo -n '\''"\udbc0"'\''|json -b 1'
echo -n '"\udbc0"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 1'

echo '$ echo -n '\''"\udbc0"'\''|json -b 2'
echo -n '"\udbc0"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 2'

echo '$ echo -n '\''"\udbc0"'\''|json -b 3'
echo -n '"\udbc0"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 3'

echo '$ echo -n '\''"\udbc0"'\''|json -b 4'
echo -n '"\udbc0"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 4'

echo '$ echo -n '\''"\udbc0"'\''|json -b 5'
echo -n '"\udbc0"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 5'

echo '$ echo -n '\''"\udbc0"'\''|json -b 6'
echo -n '"\udbc0"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 6'

echo '$ echo -n '\''"\udbc0"'\''|json -b 7'
echo -n '"\udbc0"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 7'

echo '$ echo -n '\''"\udbc0"'\''|json -b 8'
echo -n '"\udbc0"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbc0"'\''|json -b 8'

echo '$ echo -n '\''"\udbc3"'\''|json -b 1'
echo -n '"\udbc3"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 1'

echo '$ echo -n '\''"\udbc3"'\''|json -b 2'
echo -n '"\udbc3"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 2'

echo '$ echo -n '\''"\udbc3"'\''|json -b 3'
echo -n '"\udbc3"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 3'

echo '$ echo -n '\''"\udbc3"'\''|json -b 4'
echo -n '"\udbc3"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 4'

echo '$ echo -n '\''"\udbc3"'\''|json -b 5'
echo -n '"\udbc3"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 5'

echo '$ echo -n '\''"\udbc3"'\''|json -b 6'
echo -n '"\udbc3"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 6'

echo '$ echo -n '\''"\udbc3"'\''|json -b 7'
echo -n '"\udbc3"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 7'

echo '$ echo -n '\''"\udbc3"'\''|json -b 8'
echo -n '"\udbc3"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbc3"'\''|json -b 8'

echo '$ echo -n '\''"\udbfc"'\''|json -b 1'
echo -n '"\udbfc"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 1'

echo '$ echo -n '\''"\udbfc"'\''|json -b 2'
echo -n '"\udbfc"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 2'

echo '$ echo -n '\''"\udbfc"'\''|json -b 3'
echo -n '"\udbfc"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 3'

echo '$ echo -n '\''"\udbfc"'\''|json -b 4'
echo -n '"\udbfc"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 4'

echo '$ echo -n '\''"\udbfc"'\''|json -b 5'
echo -n '"\udbfc"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 5'

echo '$ echo -n '\''"\udbfc"'\''|json -b 6'
echo -n '"\udbfc"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 6'

echo '$ echo -n '\''"\udbfc"'\''|json -b 7'
echo -n '"\udbfc"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 7'

echo '$ echo -n '\''"\udbfc"'\''|json -b 8'
echo -n '"\udbfc"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbfc"'\''|json -b 8'

echo '$ echo -n '\''"\udbff"'\''|json -b 1'
echo -n '"\udbff"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 1'

echo '$ echo -n '\''"\udbff"'\''|json -b 2'
echo -n '"\udbff"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 2'

echo '$ echo -n '\''"\udbff"'\''|json -b 3'
echo -n '"\udbff"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 3'

echo '$ echo -n '\''"\udbff"'\''|json -b 4'
echo -n '"\udbff"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 4'

echo '$ echo -n '\''"\udbff"'\''|json -b 5'
echo -n '"\udbff"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 5'

echo '$ echo -n '\''"\udbff"'\''|json -b 6'
echo -n '"\udbff"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 6'

echo '$ echo -n '\''"\udbff"'\''|json -b 7'
echo -n '"\udbff"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 7'

echo '$ echo -n '\''"\udbff"'\''|json -b 8'
echo -n '"\udbff"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udbff"'\''|json -b 8'

echo '$ echo -n '\''"\udc00"'\''|json -b 1'
echo -n '"\udc00"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 1'

echo '$ echo -n '\''"\udc00"'\''|json -b 2'
echo -n '"\udc00"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 2'

echo '$ echo -n '\''"\udc00"'\''|json -b 3'
echo -n '"\udc00"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 3'

echo '$ echo -n '\''"\udc00"'\''|json -b 4'
echo -n '"\udc00"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 4'

echo '$ echo -n '\''"\udc00"'\''|json -b 5'
echo -n '"\udc00"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 5'

echo '$ echo -n '\''"\udc00"'\''|json -b 6'
echo -n '"\udc00"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 6'

echo '$ echo -n '\''"\udc00"'\''|json -b 7'
echo -n '"\udc00"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 7'

echo '$ echo -n '\''"\udc00"'\''|json -b 8'
echo -n '"\udc00"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udc00"'\''|json -b 8'

echo '$ echo -n '\''"\udc3f"'\''|json -b 1'
echo -n '"\udc3f"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 1'

echo '$ echo -n '\''"\udc3f"'\''|json -b 2'
echo -n '"\udc3f"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 2'

echo '$ echo -n '\''"\udc3f"'\''|json -b 3'
echo -n '"\udc3f"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 3'

echo '$ echo -n '\''"\udc3f"'\''|json -b 4'
echo -n '"\udc3f"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 4'

echo '$ echo -n '\''"\udc3f"'\''|json -b 5'
echo -n '"\udc3f"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 5'

echo '$ echo -n '\''"\udc3f"'\''|json -b 6'
echo -n '"\udc3f"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 6'

echo '$ echo -n '\''"\udc3f"'\''|json -b 7'
echo -n '"\udc3f"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 7'

echo '$ echo -n '\''"\udc3f"'\''|json -b 8'
echo -n '"\udc3f"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udc3f"'\''|json -b 8'

echo '$ echo -n '\''"\udfc0"'\''|json -b 1'
echo -n '"\udfc0"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 1'

echo '$ echo -n '\''"\udfc0"'\''|json -b 2'
echo -n '"\udfc0"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 2'

echo '$ echo -n '\''"\udfc0"'\''|json -b 3'
echo -n '"\udfc0"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 3'

echo '$ echo -n '\''"\udfc0"'\''|json -b 4'
echo -n '"\udfc0"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 4'

echo '$ echo -n '\''"\udfc0"'\''|json -b 5'
echo -n '"\udfc0"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 5'

echo '$ echo -n '\''"\udfc0"'\''|json -b 6'
echo -n '"\udfc0"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 6'

echo '$ echo -n '\''"\udfc0"'\''|json -b 7'
echo -n '"\udfc0"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 7'

echo '$ echo -n '\''"\udfc0"'\''|json -b 8'
echo -n '"\udfc0"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udfc0"'\''|json -b 8'

echo '$ echo -n '\''"\udfff"'\''|json -b 1'
echo -n '"\udfff"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 1'

echo '$ echo -n '\''"\udfff"'\''|json -b 2'
echo -n '"\udfff"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 2'

echo '$ echo -n '\''"\udfff"'\''|json -b 3'
echo -n '"\udfff"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 3'

echo '$ echo -n '\''"\udfff"'\''|json -b 4'
echo -n '"\udfff"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 4'

echo '$ echo -n '\''"\udfff"'\''|json -b 5'
echo -n '"\udfff"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 5'

echo '$ echo -n '\''"\udfff"'\''|json -b 6'
echo -n '"\udfff"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 6'

echo '$ echo -n '\''"\udfff"'\''|json -b 7'
echo -n '"\udfff"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 7'

echo '$ echo -n '\''"\udfff"'\''|json -b 8'
echo -n '"\udfff"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\udfff"'\''|json -b 8'
)

