#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string4.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --multi-obj --from-ast-print "$@"; }
$ echo -n '\''""""'\''|json -b 1
[
    "",
    ""
]
$ echo -n '\''""""'\''|json -b 2
[
    "",
    ""
]
$ echo -n '\''""""'\''|json -b 3
[
    "",
    ""
]
$ echo -n '\''""""'\''|json -b 4
[
    "",
    ""
]
$ echo -n '\''"""boo"'\''|json -b 1
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 2
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 3
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 4
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 5
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 6
[
    "",
    "boo"
]
$ echo -n '\''"""boo"'\''|json -b 7
[
    "",
    "boo"
]
$ echo -n '\''"""baz"'\''|json -b 1
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 2
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 3
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 4
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 5
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 6
[
    "",
    "baz"
]
$ echo -n '\''"""baz"'\''|json -b 7
[
    "",
    "baz"
]
$ echo -n '\''"foo"""'\''|json -b 1
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 2
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 3
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 4
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 5
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 6
[
    "foo",
    ""
]
$ echo -n '\''"foo"""'\''|json -b 7
[
    "foo",
    ""
]
$ echo -n '\''"foo""boo"'\''|json -b 1
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 2
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 3
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 4
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 5
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 6
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 7
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 8
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 9
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""boo"'\''|json -b 10
[
    "foo",
    "boo"
]
$ echo -n '\''"foo""baz"'\''|json -b 1
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 2
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 3
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 4
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 5
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 6
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 7
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 8
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 9
[
    "foo",
    "baz"
]
$ echo -n '\''"foo""baz"'\''|json -b 10
[
    "foo",
    "baz"
]
$ echo -n '\''"bar"""'\''|json -b 1
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 2
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 3
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 4
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 5
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 6
[
    "bar",
    ""
]
$ echo -n '\''"bar"""'\''|json -b 7
[
    "bar",
    ""
]
$ echo -n '\''"bar""boo"'\''|json -b 1
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 2
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 3
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 4
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 5
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 6
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 7
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 8
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 9
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""boo"'\''|json -b 10
[
    "bar",
    "boo"
]
$ echo -n '\''"bar""baz"'\''|json -b 1
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 2
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 3
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 4
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 5
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 6
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 7
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 8
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 9
[
    "bar",
    "baz"
]
$ echo -n '\''"bar""baz"'\''|json -b 10
[
    "bar",
    "baz"
]'
) -L string4.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --multi-obj --from-ast-print "$@"; }'
json() { json0 --literal-value --multi-obj --from-ast-print "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --multi-obj --from-ast-print "$@"; }'

echo '$ echo -n '\''""""'\''|json -b 1'
echo -n '""""'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''""""'\''|json -b 1'

echo '$ echo -n '\''""""'\''|json -b 2'
echo -n '""""'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''""""'\''|json -b 2'

echo '$ echo -n '\''""""'\''|json -b 3'
echo -n '""""'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''""""'\''|json -b 3'

echo '$ echo -n '\''""""'\''|json -b 4'
echo -n '""""'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''""""'\''|json -b 4'

echo '$ echo -n '\''"""boo"'\''|json -b 1'
echo -n '"""boo"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 1'

echo '$ echo -n '\''"""boo"'\''|json -b 2'
echo -n '"""boo"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 2'

echo '$ echo -n '\''"""boo"'\''|json -b 3'
echo -n '"""boo"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 3'

echo '$ echo -n '\''"""boo"'\''|json -b 4'
echo -n '"""boo"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 4'

echo '$ echo -n '\''"""boo"'\''|json -b 5'
echo -n '"""boo"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 5'

echo '$ echo -n '\''"""boo"'\''|json -b 6'
echo -n '"""boo"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 6'

echo '$ echo -n '\''"""boo"'\''|json -b 7'
echo -n '"""boo"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"""boo"'\''|json -b 7'

echo '$ echo -n '\''"""baz"'\''|json -b 1'
echo -n '"""baz"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 1'

echo '$ echo -n '\''"""baz"'\''|json -b 2'
echo -n '"""baz"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 2'

echo '$ echo -n '\''"""baz"'\''|json -b 3'
echo -n '"""baz"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 3'

echo '$ echo -n '\''"""baz"'\''|json -b 4'
echo -n '"""baz"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 4'

echo '$ echo -n '\''"""baz"'\''|json -b 5'
echo -n '"""baz"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 5'

echo '$ echo -n '\''"""baz"'\''|json -b 6'
echo -n '"""baz"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 6'

echo '$ echo -n '\''"""baz"'\''|json -b 7'
echo -n '"""baz"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"""baz"'\''|json -b 7'

echo '$ echo -n '\''"foo"""'\''|json -b 1'
echo -n '"foo"""'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 1'

echo '$ echo -n '\''"foo"""'\''|json -b 2'
echo -n '"foo"""'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 2'

echo '$ echo -n '\''"foo"""'\''|json -b 3'
echo -n '"foo"""'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 3'

echo '$ echo -n '\''"foo"""'\''|json -b 4'
echo -n '"foo"""'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 4'

echo '$ echo -n '\''"foo"""'\''|json -b 5'
echo -n '"foo"""'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 5'

echo '$ echo -n '\''"foo"""'\''|json -b 6'
echo -n '"foo"""'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 6'

echo '$ echo -n '\''"foo"""'\''|json -b 7'
echo -n '"foo"""'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"foo"""'\''|json -b 7'

echo '$ echo -n '\''"foo""boo"'\''|json -b 1'
echo -n '"foo""boo"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 1'

echo '$ echo -n '\''"foo""boo"'\''|json -b 2'
echo -n '"foo""boo"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 2'

echo '$ echo -n '\''"foo""boo"'\''|json -b 3'
echo -n '"foo""boo"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 3'

echo '$ echo -n '\''"foo""boo"'\''|json -b 4'
echo -n '"foo""boo"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 4'

echo '$ echo -n '\''"foo""boo"'\''|json -b 5'
echo -n '"foo""boo"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 5'

echo '$ echo -n '\''"foo""boo"'\''|json -b 6'
echo -n '"foo""boo"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 6'

echo '$ echo -n '\''"foo""boo"'\''|json -b 7'
echo -n '"foo""boo"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 7'

echo '$ echo -n '\''"foo""boo"'\''|json -b 8'
echo -n '"foo""boo"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 8'

echo '$ echo -n '\''"foo""boo"'\''|json -b 9'
echo -n '"foo""boo"'|json -b 9 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 9'

echo '$ echo -n '\''"foo""boo"'\''|json -b 10'
echo -n '"foo""boo"'|json -b 10 2>&1 ||
echo 'command failed: echo -n '\''"foo""boo"'\''|json -b 10'

echo '$ echo -n '\''"foo""baz"'\''|json -b 1'
echo -n '"foo""baz"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 1'

echo '$ echo -n '\''"foo""baz"'\''|json -b 2'
echo -n '"foo""baz"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 2'

echo '$ echo -n '\''"foo""baz"'\''|json -b 3'
echo -n '"foo""baz"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 3'

echo '$ echo -n '\''"foo""baz"'\''|json -b 4'
echo -n '"foo""baz"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 4'

echo '$ echo -n '\''"foo""baz"'\''|json -b 5'
echo -n '"foo""baz"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 5'

echo '$ echo -n '\''"foo""baz"'\''|json -b 6'
echo -n '"foo""baz"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 6'

echo '$ echo -n '\''"foo""baz"'\''|json -b 7'
echo -n '"foo""baz"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 7'

echo '$ echo -n '\''"foo""baz"'\''|json -b 8'
echo -n '"foo""baz"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 8'

echo '$ echo -n '\''"foo""baz"'\''|json -b 9'
echo -n '"foo""baz"'|json -b 9 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 9'

echo '$ echo -n '\''"foo""baz"'\''|json -b 10'
echo -n '"foo""baz"'|json -b 10 2>&1 ||
echo 'command failed: echo -n '\''"foo""baz"'\''|json -b 10'

echo '$ echo -n '\''"bar"""'\''|json -b 1'
echo -n '"bar"""'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 1'

echo '$ echo -n '\''"bar"""'\''|json -b 2'
echo -n '"bar"""'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 2'

echo '$ echo -n '\''"bar"""'\''|json -b 3'
echo -n '"bar"""'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 3'

echo '$ echo -n '\''"bar"""'\''|json -b 4'
echo -n '"bar"""'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 4'

echo '$ echo -n '\''"bar"""'\''|json -b 5'
echo -n '"bar"""'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 5'

echo '$ echo -n '\''"bar"""'\''|json -b 6'
echo -n '"bar"""'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 6'

echo '$ echo -n '\''"bar"""'\''|json -b 7'
echo -n '"bar"""'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"bar"""'\''|json -b 7'

echo '$ echo -n '\''"bar""boo"'\''|json -b 1'
echo -n '"bar""boo"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 1'

echo '$ echo -n '\''"bar""boo"'\''|json -b 2'
echo -n '"bar""boo"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 2'

echo '$ echo -n '\''"bar""boo"'\''|json -b 3'
echo -n '"bar""boo"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 3'

echo '$ echo -n '\''"bar""boo"'\''|json -b 4'
echo -n '"bar""boo"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 4'

echo '$ echo -n '\''"bar""boo"'\''|json -b 5'
echo -n '"bar""boo"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 5'

echo '$ echo -n '\''"bar""boo"'\''|json -b 6'
echo -n '"bar""boo"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 6'

echo '$ echo -n '\''"bar""boo"'\''|json -b 7'
echo -n '"bar""boo"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 7'

echo '$ echo -n '\''"bar""boo"'\''|json -b 8'
echo -n '"bar""boo"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 8'

echo '$ echo -n '\''"bar""boo"'\''|json -b 9'
echo -n '"bar""boo"'|json -b 9 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 9'

echo '$ echo -n '\''"bar""boo"'\''|json -b 10'
echo -n '"bar""boo"'|json -b 10 2>&1 ||
echo 'command failed: echo -n '\''"bar""boo"'\''|json -b 10'

echo '$ echo -n '\''"bar""baz"'\''|json -b 1'
echo -n '"bar""baz"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 1'

echo '$ echo -n '\''"bar""baz"'\''|json -b 2'
echo -n '"bar""baz"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 2'

echo '$ echo -n '\''"bar""baz"'\''|json -b 3'
echo -n '"bar""baz"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 3'

echo '$ echo -n '\''"bar""baz"'\''|json -b 4'
echo -n '"bar""baz"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 4'

echo '$ echo -n '\''"bar""baz"'\''|json -b 5'
echo -n '"bar""baz"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 5'

echo '$ echo -n '\''"bar""baz"'\''|json -b 6'
echo -n '"bar""baz"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 6'

echo '$ echo -n '\''"bar""baz"'\''|json -b 7'
echo -n '"bar""baz"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 7'

echo '$ echo -n '\''"bar""baz"'\''|json -b 8'
echo -n '"bar""baz"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 8'

echo '$ echo -n '\''"bar""baz"'\''|json -b 9'
echo -n '"bar""baz"'|json -b 9 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 9'

echo '$ echo -n '\''"bar""baz"'\''|json -b 10'
echo -n '"bar""baz"'|json -b 10 2>&1 ||
echo 'command failed: echo -n '\''"bar""baz"'\''|json -b 10'
)

