#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:rebalance
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L rebalance.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ json() { env LD_LIBRARY_PATH=../lib ../src/json --no-error "$@" || return 0; }
$ test-trie() { local u='\'''\''; [ "$1" == '\''-u'\'' ] && { u='\''u'\''; shift; }; ../lib/test-trie -R|sed -${u:+n}r ${u:+'\''H;$! b;g;s/^\n//;'\''}'\''s/,?"(lo|hi)":null//g'\''${u:+'\'';s/^([^\n]+)\n\1$/\1/;p'\''}|json -Po -m; }
$ print '\'''\'' a|test-trie
{
.   "val": "",
.   "hi": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   }
}
{
.   "sym": "a",
.   "lo": {
.   .   "val": ""
.   },
.   "eq": {
.   .   "val": "a"
.   }
}
$ print a '\'''\''|test-trie -u
{
.   "sym": "a",
.   "lo": {
.   .   "val": ""
.   },
.   "eq": {
.   .   "val": "a"
.   }
}
$ print a b|test-trie
{
.   "sym": "a",
.   "eq": {
.   .   "val": "a"
.   },
.   "hi": {
.   .   "sym": "b",
.   .   "eq": {
.   .   .   "val": "b"
.   .   }
.   }
}
{
.   "sym": "b",
.   "lo": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   },
.   "eq": {
.   .   "val": "b"
.   }
}
$ print b a|test-trie -u
{
.   "sym": "b",
.   "lo": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   },
.   "eq": {
.   .   "val": "b"
.   }
}
$ print a b c|test-trie
{
.   "sym": "a",
.   "eq": {
.   .   "val": "a"
.   },
.   "hi": {
.   .   "sym": "b",
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "b",
.   "lo": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   },
.   "eq": {
.   .   "val": "b"
.   },
.   "hi": {
.   .   "sym": "c",
.   .   "eq": {
.   .   .   "val": "c"
.   .   }
.   }
}
$ print c b a|test-trie
{
.   "sym": "c",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   }
.   },
.   "eq": {
.   .   "val": "c"
.   }
}
{
.   "sym": "b",
.   "lo": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   },
.   "eq": {
.   .   "val": "b"
.   },
.   "hi": {
.   .   "sym": "c",
.   .   "eq": {
.   .   .   "val": "c"
.   .   }
.   }
}
$ print b a c|test-trie -u
{
.   "sym": "b",
.   "lo": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "a"
.   .   }
.   },
.   "eq": {
.   .   "val": "b"
.   },
.   "hi": {
.   .   "sym": "c",
.   .   "eq": {
.   .   .   "val": "c"
.   .   }
.   }
}
$ print a b c d|test-trie
{
.   "sym": "a",
.   "eq": {
.   .   "val": "a"
.   },
.   "hi": {
.   .   "sym": "b",
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "d",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "d"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "c",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   }
.   },
.   "eq": {
.   .   "val": "c"
.   },
.   "hi": {
.   .   "sym": "d",
.   .   "eq": {
.   .   .   "val": "d"
.   .   }
.   }
}
$ print d c b a|test-trie
{
.   "sym": "d",
.   "lo": {
.   .   "sym": "c",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "a"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "b"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "c"
.   .   }
.   },
.   "eq": {
.   .   "val": "d"
.   }
}
{
.   "sym": "c",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   }
.   },
.   "eq": {
.   .   "val": "c"
.   },
.   "hi": {
.   .   "sym": "d",
.   .   "eq": {
.   .   .   "val": "d"
.   .   }
.   }
}
$ print c b a d|test-trie -u
{
.   "sym": "c",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   }
.   },
.   "eq": {
.   .   "val": "c"
.   },
.   "hi": {
.   .   "sym": "d",
.   .   "eq": {
.   .   .   "val": "d"
.   .   }
.   }
}
$ print a b c d e|test-trie
{
.   "sym": "a",
.   "eq": {
.   .   "val": "a"
.   },
.   "hi": {
.   .   "sym": "b",
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "d",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "d"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "e",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "e"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "d",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   }
.   .   }
.   },
.   "eq": {
.   .   "val": "d"
.   },
.   "hi": {
.   .   "sym": "e",
.   .   "eq": {
.   .   .   "val": "e"
.   .   }
.   }
}
$ print e d c b a|test-trie
{
.   "sym": "e",
.   "lo": {
.   .   "sym": "d",
.   .   "lo": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "a"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "b"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "d"
.   .   }
.   },
.   "eq": {
.   .   "val": "e"
.   }
}
{
.   "sym": "d",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   }
.   .   }
.   },
.   "eq": {
.   .   "val": "d"
.   },
.   "hi": {
.   .   "sym": "e",
.   .   "eq": {
.   .   .   "val": "e"
.   .   }
.   }
}
$ print d b c a e|test-trie -u
{
.   "sym": "d",
.   "lo": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "a"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "b"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "c"
.   .   .   }
.   .   }
.   },
.   "eq": {
.   .   "val": "d"
.   },
.   "hi": {
.   .   "sym": "e",
.   .   "eq": {
.   .   .   "val": "e"
.   .   }
.   }
}
$ print x xa|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "val": "x",
.   .   "hi": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "lo": {
.   .   .   "val": "x"
.   .   },
.   .   "eq": {
.   .   .   "val": "xa"
.   .   }
.   }
}
$ print xa x|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "lo": {
.   .   .   "val": "x"
.   .   },
.   .   "eq": {
.   .   .   "val": "xa"
.   .   }
.   }
}
$ print xa xb|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "xa"
.   .   },
.   .   "hi": {
.   .   .   "sym": "b",
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xb"
.   .   }
.   }
}
$ print xb xa|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xb"
.   .   }
.   }
}
$ print xa xb xc|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "xa"
.   .   },
.   .   "hi": {
.   .   .   "sym": "b",
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xb"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "xc"
.   .   .   }
.   .   }
.   }
}
$ print xc xb xa|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "c",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xc"
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xb"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "xc"
.   .   .   }
.   .   }
.   }
}
$ print xb xa xc|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xa"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xb"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "xc"
.   .   .   }
.   .   }
.   }
}
$ print xa xb xc xd|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "xa"
.   .   },
.   .   "hi": {
.   .   .   "sym": "b",
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "d",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xd"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "c",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xc"
.   .   },
.   .   "hi": {
.   .   .   "sym": "d",
.   .   .   "eq": {
.   .   .   .   "val": "xd"
.   .   .   }
.   .   }
.   }
}
$ print xd xc xb xa|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "d",
.   .   "lo": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xa"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xb"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xc"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xd"
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "c",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xc"
.   .   },
.   .   "hi": {
.   .   .   "sym": "d",
.   .   .   "eq": {
.   .   .   .   "val": "xd"
.   .   .   }
.   .   }
.   }
}
$ print xc xb xa xd|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "c",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xc"
.   .   },
.   .   "hi": {
.   .   .   "sym": "d",
.   .   .   "eq": {
.   .   .   .   "val": "xd"
.   .   .   }
.   .   }
.   }
}
$ print xa xb xc xd xe|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "xa"
.   .   },
.   .   "hi": {
.   .   .   "sym": "b",
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "d",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xd"
.   .   .   .   .   },
.   .   .   .   .   "hi": {
.   .   .   .   .   .   "sym": "e",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xe"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "d",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xd"
.   .   },
.   .   "hi": {
.   .   .   "sym": "e",
.   .   .   "eq": {
.   .   .   .   "val": "xe"
.   .   .   }
.   .   }
.   }
}
$ print xe xd xc xb xa|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "e",
.   .   "lo": {
.   .   .   "sym": "d",
.   .   .   "lo": {
.   .   .   .   "sym": "c",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "b",
.   .   .   .   .   "lo": {
.   .   .   .   .   .   "sym": "a",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xa"
.   .   .   .   .   .   }
.   .   .   .   .   },
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xb"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xd"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xe"
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "d",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xd"
.   .   },
.   .   "hi": {
.   .   .   "sym": "e",
.   .   .   "eq": {
.   .   .   .   "val": "xe"
.   .   .   }
.   .   }
.   }
}
$ print xd xb xc xa xe|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "d",
.   .   "lo": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "xd"
.   .   },
.   .   "hi": {
.   .   .   "sym": "e",
.   .   .   "eq": {
.   .   .   .   "val": "xe"
.   .   .   }
.   .   }
.   }
}
$ print xy xya|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "val": "xy",
.   .   .   "hi": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "lo": {
.   .   .   .   "val": "xy"
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   }
.   .   }
.   }
}
$ print xya xy|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "lo": {
.   .   .   .   "val": "xy"
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   }
.   .   }
.   }
}
$ print xya xyb|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "b",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyb"
.   .   .   }
.   .   }
.   }
}
$ print xyb xya|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyb"
.   .   .   }
.   .   }
.   }
}
$ print xya xyb xyc|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "b",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xyc xyb xya|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyc"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xyb xya xyc|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xya"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xya xyb xyc xyd|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "b",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   },
.   .   .   .   .   "hi": {
.   .   .   .   .   .   "sym": "d",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xyd"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyc"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "d",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyd"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xyd xyc xyb xya|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "d",
.   .   .   "lo": {
.   .   .   .   "sym": "c",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "b",
.   .   .   .   .   "lo": {
.   .   .   .   .   .   "sym": "a",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xya"
.   .   .   .   .   .   }
.   .   .   .   .   },
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyb"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyc"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyd"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyc"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "d",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyd"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xyc xyb xya xyd|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "c",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyc"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "d",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyd"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xya xyb xyc xyd xye|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "xya"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "b",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   },
.   .   .   .   .   "hi": {
.   .   .   .   .   .   "sym": "d",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xyd"
.   .   .   .   .   .   },
.   .   .   .   .   .   "hi": {
.   .   .   .   .   .   .   "sym": "e",
.   .   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   .   "val": "xye"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "d",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyd"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "e",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xye"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xye xyd xyc xyb xya|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "e",
.   .   .   "lo": {
.   .   .   .   "sym": "d",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "lo": {
.   .   .   .   .   .   "sym": "b",
.   .   .   .   .   .   "lo": {
.   .   .   .   .   .   .   "sym": "a",
.   .   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   .   "val": "xya"
.   .   .   .   .   .   .   }
.   .   .   .   .   .   },
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "xyb"
.   .   .   .   .   .   }
.   .   .   .   .   },
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyd"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xye"
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "d",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyd"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "e",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xye"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xyd xyb xyc xya xye|test-trie -u
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "d",
.   .   .   "lo": {
.   .   .   .   "sym": "b",
.   .   .   .   "lo": {
.   .   .   .   .   "sym": "a",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xya"
.   .   .   .   .   }
.   .   .   .   },
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xyb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "xyc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xyd"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "e",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xye"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print xa xb xc ya yb yc za zb zc|test-trie
{
.   "sym": "x",
.   "eq": {
.   .   "sym": "a",
.   .   "eq": {
.   .   .   "val": "xa"
.   .   },
.   .   "hi": {
.   .   .   "sym": "b",
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   }
.   },
.   "hi": {
.   .   "sym": "y",
.   .   "eq": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "ya"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "b",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "yb"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "c",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "yc"
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   },
.   .   "hi": {
.   .   .   "sym": "z",
.   .   .   "eq": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "za"
.   .   .   .   },
.   .   .   .   "hi": {
.   .   .   .   .   "sym": "b",
.   .   .   .   .   "eq": {
.   .   .   .   .   .   "val": "zb"
.   .   .   .   .   },
.   .   .   .   .   "hi": {
.   .   .   .   .   .   "sym": "c",
.   .   .   .   .   .   "eq": {
.   .   .   .   .   .   .   "val": "zc"
.   .   .   .   .   .   }
.   .   .   .   .   }
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
{
.   "sym": "y",
.   "lo": {
.   .   "sym": "x",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   }
.   },
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "ya"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "yb"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "yc"
.   .   .   }
.   .   }
.   },
.   "hi": {
.   .   "sym": "z",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "za"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "zb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "zc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}
$ print yb ya yc xb xa xc zb za zc|test-trie -u
{
.   "sym": "y",
.   "lo": {
.   .   "sym": "x",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xa"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "xb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "xc"
.   .   .   .   }
.   .   .   }
.   .   }
.   },
.   "eq": {
.   .   "sym": "b",
.   .   "lo": {
.   .   .   "sym": "a",
.   .   .   "eq": {
.   .   .   .   "val": "ya"
.   .   .   }
.   .   },
.   .   "eq": {
.   .   .   "val": "yb"
.   .   },
.   .   "hi": {
.   .   .   "sym": "c",
.   .   .   "eq": {
.   .   .   .   "val": "yc"
.   .   .   }
.   .   }
.   },
.   "hi": {
.   .   "sym": "z",
.   .   "eq": {
.   .   .   "sym": "b",
.   .   .   "lo": {
.   .   .   .   "sym": "a",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "za"
.   .   .   .   }
.   .   .   },
.   .   .   "eq": {
.   .   .   .   "val": "zb"
.   .   .   },
.   .   .   "hi": {
.   .   .   .   "sym": "c",
.   .   .   .   "eq": {
.   .   .   .   .   "val": "zc"
.   .   .   .   }
.   .   .   }
.   .   }
.   }
}'
) -L rebalance.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { env LD_LIBRARY_PATH=../lib ../src/json --no-error "$@" || return 0; }'
json() { env LD_LIBRARY_PATH=../lib ../src/json --no-error "$@" || return 0; } 2>&1 ||
echo 'command failed: json() { env LD_LIBRARY_PATH=../lib ../src/json --no-error "$@" || return 0; }'

echo '$ test-trie() { local u='\'''\''; [ "$1" == '\''-u'\'' ] && { u='\''u'\''; shift; }; ../lib/test-trie -R|sed -${u:+n}r ${u:+'\''H;$! b;g;s/^\n//;'\''}'\''s/,?"(lo|hi)":null//g'\''${u:+'\'';s/^([^\n]+)\n\1$/\1/;p'\''}|json -Po -m; }'
test-trie() { local u=''; [ "$1" == '-u' ] && { u='u'; shift; }; ../lib/test-trie -R|sed -${u:+n}r ${u:+'H;$! b;g;s/^\n//;'}'s/,?"(lo|hi)":null//g'${u:+';s/^([^\n]+)\n\1$/\1/;p'}|json -Po -m; } 2>&1 ||
echo 'command failed: test-trie() { local u='\'''\''; [ "$1" == '\''-u'\'' ] && { u='\''u'\''; shift; }; ../lib/test-trie -R|sed -${u:+n}r ${u:+'\''H;$! b;g;s/^\n//;'\''}'\''s/,?"(lo|hi)":null//g'\''${u:+'\'';s/^([^\n]+)\n\1$/\1/;p'\''}|json -Po -m; }'

echo '$ print '\'''\'' a|test-trie'
print '' a|test-trie 2>&1 ||
echo 'command failed: print '\'''\'' a|test-trie'

echo '$ print a '\'''\''|test-trie -u'
print a ''|test-trie -u 2>&1 ||
echo 'command failed: print a '\'''\''|test-trie -u'

echo '$ print a b|test-trie'
print a b|test-trie 2>&1 ||
echo 'command failed: print a b|test-trie'

echo '$ print b a|test-trie -u'
print b a|test-trie -u 2>&1 ||
echo 'command failed: print b a|test-trie -u'

echo '$ print a b c|test-trie'
print a b c|test-trie 2>&1 ||
echo 'command failed: print a b c|test-trie'

echo '$ print c b a|test-trie'
print c b a|test-trie 2>&1 ||
echo 'command failed: print c b a|test-trie'

echo '$ print b a c|test-trie -u'
print b a c|test-trie -u 2>&1 ||
echo 'command failed: print b a c|test-trie -u'

echo '$ print a b c d|test-trie'
print a b c d|test-trie 2>&1 ||
echo 'command failed: print a b c d|test-trie'

echo '$ print d c b a|test-trie'
print d c b a|test-trie 2>&1 ||
echo 'command failed: print d c b a|test-trie'

echo '$ print c b a d|test-trie -u'
print c b a d|test-trie -u 2>&1 ||
echo 'command failed: print c b a d|test-trie -u'

echo '$ print a b c d e|test-trie'
print a b c d e|test-trie 2>&1 ||
echo 'command failed: print a b c d e|test-trie'

echo '$ print e d c b a|test-trie'
print e d c b a|test-trie 2>&1 ||
echo 'command failed: print e d c b a|test-trie'

echo '$ print d b c a e|test-trie -u'
print d b c a e|test-trie -u 2>&1 ||
echo 'command failed: print d b c a e|test-trie -u'

echo '$ print x xa|test-trie'
print x xa|test-trie 2>&1 ||
echo 'command failed: print x xa|test-trie'

echo '$ print xa x|test-trie -u'
print xa x|test-trie -u 2>&1 ||
echo 'command failed: print xa x|test-trie -u'

echo '$ print xa xb|test-trie'
print xa xb|test-trie 2>&1 ||
echo 'command failed: print xa xb|test-trie'

echo '$ print xb xa|test-trie -u'
print xb xa|test-trie -u 2>&1 ||
echo 'command failed: print xb xa|test-trie -u'

echo '$ print xa xb xc|test-trie'
print xa xb xc|test-trie 2>&1 ||
echo 'command failed: print xa xb xc|test-trie'

echo '$ print xc xb xa|test-trie'
print xc xb xa|test-trie 2>&1 ||
echo 'command failed: print xc xb xa|test-trie'

echo '$ print xb xa xc|test-trie -u'
print xb xa xc|test-trie -u 2>&1 ||
echo 'command failed: print xb xa xc|test-trie -u'

echo '$ print xa xb xc xd|test-trie'
print xa xb xc xd|test-trie 2>&1 ||
echo 'command failed: print xa xb xc xd|test-trie'

echo '$ print xd xc xb xa|test-trie'
print xd xc xb xa|test-trie 2>&1 ||
echo 'command failed: print xd xc xb xa|test-trie'

echo '$ print xc xb xa xd|test-trie -u'
print xc xb xa xd|test-trie -u 2>&1 ||
echo 'command failed: print xc xb xa xd|test-trie -u'

echo '$ print xa xb xc xd xe|test-trie'
print xa xb xc xd xe|test-trie 2>&1 ||
echo 'command failed: print xa xb xc xd xe|test-trie'

echo '$ print xe xd xc xb xa|test-trie'
print xe xd xc xb xa|test-trie 2>&1 ||
echo 'command failed: print xe xd xc xb xa|test-trie'

echo '$ print xd xb xc xa xe|test-trie -u'
print xd xb xc xa xe|test-trie -u 2>&1 ||
echo 'command failed: print xd xb xc xa xe|test-trie -u'

echo '$ print xy xya|test-trie'
print xy xya|test-trie 2>&1 ||
echo 'command failed: print xy xya|test-trie'

echo '$ print xya xy|test-trie -u'
print xya xy|test-trie -u 2>&1 ||
echo 'command failed: print xya xy|test-trie -u'

echo '$ print xya xyb|test-trie'
print xya xyb|test-trie 2>&1 ||
echo 'command failed: print xya xyb|test-trie'

echo '$ print xyb xya|test-trie -u'
print xyb xya|test-trie -u 2>&1 ||
echo 'command failed: print xyb xya|test-trie -u'

echo '$ print xya xyb xyc|test-trie'
print xya xyb xyc|test-trie 2>&1 ||
echo 'command failed: print xya xyb xyc|test-trie'

echo '$ print xyc xyb xya|test-trie'
print xyc xyb xya|test-trie 2>&1 ||
echo 'command failed: print xyc xyb xya|test-trie'

echo '$ print xyb xya xyc|test-trie -u'
print xyb xya xyc|test-trie -u 2>&1 ||
echo 'command failed: print xyb xya xyc|test-trie -u'

echo '$ print xya xyb xyc xyd|test-trie'
print xya xyb xyc xyd|test-trie 2>&1 ||
echo 'command failed: print xya xyb xyc xyd|test-trie'

echo '$ print xyd xyc xyb xya|test-trie'
print xyd xyc xyb xya|test-trie 2>&1 ||
echo 'command failed: print xyd xyc xyb xya|test-trie'

echo '$ print xyc xyb xya xyd|test-trie -u'
print xyc xyb xya xyd|test-trie -u 2>&1 ||
echo 'command failed: print xyc xyb xya xyd|test-trie -u'

echo '$ print xya xyb xyc xyd xye|test-trie'
print xya xyb xyc xyd xye|test-trie 2>&1 ||
echo 'command failed: print xya xyb xyc xyd xye|test-trie'

echo '$ print xye xyd xyc xyb xya|test-trie'
print xye xyd xyc xyb xya|test-trie 2>&1 ||
echo 'command failed: print xye xyd xyc xyb xya|test-trie'

echo '$ print xyd xyb xyc xya xye|test-trie -u'
print xyd xyb xyc xya xye|test-trie -u 2>&1 ||
echo 'command failed: print xyd xyb xyc xya xye|test-trie -u'

echo '$ print xa xb xc ya yb yc za zb zc|test-trie'
print xa xb xc ya yb yc za zb zc|test-trie 2>&1 ||
echo 'command failed: print xa xb xc ya yb yc za zb zc|test-trie'

echo '$ print yb ya yc xb xa xc zb za zc|test-trie -u'
print yb ya yc xb xa xc zb za zc|test-trie -u 2>&1 ||
echo 'command failed: print yb ya yc xb xa xc zb za zc|test-trie -u'
)

